/*******************************************************
Filename		:  sr2_0_2.sql
Release 		:  STORET Report Module v2.0.2
SIR			:  1485, 1486, 1487, 1488
                     1523, 1524, 1525, 1526, 1527, 1528
Description		:  Add new Physical/Chemical Export Reports (Small, Medium, Large, Giant).
                     Add new Biological Export Reports (Small, Medium, Large, Giant).
                     Add Multi-Taxon Population Census only Export Report.
                     Add Habitat Assessment Export Report (System and User Defined).
                     Create parameter data for report related tables.
                     Call fldset script to create function that provides concatenated field sets.
Author		:  S. Smith
Modified by    	:  S. Smith
Modified date	:  05/13/2003, 07/02/2003, 07/29/2003
Comments		:  
**********************************************************/
set echo off
set pagesize 500
spool sr2_0_2.log
-- Give create procedure and session grants to STORET and STORET1 schemata.
connect system/sto2et@storet
set echo on
grant create procedure to storet1;
grant create session to storet1;
grant create session to storet;
set echo off
disconnect; 

-- Connect storet1/sto2et1@storet and create fldset function
connect storet1/sto2et1@storet
set echo on;
show user
@fldset;
show errors
grant execute on fldset to storuser;

-- Connect storuser/storuser@storet and create fldset synonym
connect storuser/storuser@storet
create synonym fldset for storet1.fldset;


-- Connect to storet to add row to report tables
connect storet/sto2et@storet
show user;
set serveroutput on

--pre statistics
select * from TSRRLIST
where RPT_ID in (27,40,41,42,43,44,45,46,47,48,49);
select * from TSRRPARM
where RPT_ID in (27,40,41,42,43,44,45,46,47,48,49);

-- Data Inserts

-- PhysChem

INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1003, 40, 2, 2, 'Results Physical/Chemical Small Export', 'RSP.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1004, 41, 2, 2, 'Results Physical/Chemical Medium Export', 'RMP.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1005, 42, 2, 2, 'Results Physical/Chemical Large Export', 'RLP.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1006, 43, 2, 2, 'Results Physical/Chemical Giant Export', 'RGP.txt'); 

-- Biological
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1205, 44, 2, 2, 'Results Biological Small Export', 'RSB.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1210, 45, 2, 2, 'Results Biological Medium Export', 'RMB.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1215, 46, 2, 2, 'Results Biological Large Export', 'RLB.txt'); 
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1220, 47, 2, 2, 'Results Biological Giant Export', 'RGB.txt'); 

-- MTPC Only
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1225, 48, 2, 2, 'Results Multi-Taxon Population Census Export', 'MTC.txt'); 

-- Habitat Assessment
INSERT INTO TSRRLIST ( DISP_SEQ, RPT_ID, PT, LVE, TITLE, FNAME ) VALUES ( 
1230, 49, 2, 2, 'Results Habitat Assessment Export', 'HAB.txt'); 

commit;

-- PhysChem
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
40, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
40, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
40, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
40, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
40, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
41, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
41, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
41, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
41, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
41, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
42, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
42, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
42, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
42, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
42, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Activity Date');
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
43, 'Location');

-- Biological
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
44, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
44, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
44, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
44, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
44, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
45, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
45, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
45, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
45, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
45, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
46, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
46, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
46, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
46, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
46, 'Activity Date');

INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Activity Date');
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
47, 'Location');

-- MTPC Only
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Activity Date');
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
48, 'Location');

-- Habitat Assessment
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Organization'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Project'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Station'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Characteristic'); 
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Activity Date');
INSERT INTO TSRRPARM ( RPT_ID, PARAM_NAME ) VALUES ( 
49, 'Location');

commit;


-- Remove old v2.0 all-in-one Result Details export
DELETE FROM TSRRLIST WHERE RPT_ID = '27';
DELETE FROM TSRRPARM WHERE RPT_ID = '27';
commit;

 
-- post statistics
select * from TSRRLIST
where RPT_ID in (27,40,41,42,43,44,45,46,47,48,49);
select * from TSRRPARM
where RPT_ID in (27,40,41,42,43,44,45,46,47,48,49);

-- Revoke create session grant from STORET schema.
connect system/sto2et@storet
revoke create session from storet1;
revoke create session from storet;

DISCONNECT;
spool off;
exit
