-- help system package.
CREATE OR REPLACE PACKAGE srhlp_tree IS

  TYPE rec_tree IS RECORD 
       (help_level 	number,
        help_id 	number,
        help_title 	varchar2(200),
        help_leaf 	varchar2(1),
        father_id 	number,
        sort_id 	number);

  TYPE tab_rec is TABLE OF rec_tree INDEX BY BINARY_INTEGER;

  TYPE related_type is ref cursor;

     --===================
     -- Function Init_Tree
     --====================
     --	
     -- Description
     --		Read the help system hierarchy, sort the hierarchy on the sort_id
     --         for each level and stores it in a table of records.
     --    	This function is called in the When-New-Form-Instance trigger
     --		in the form.
     --
     -- Arguments
     --		p_app_name	Application identifier
     --
     -- Returns
     --		tab_rec		table of record
     --
  FUNCTION init_tree (p_app_name varchar2) return tab_rec;

     --==========================
     -- Procedure Related Topics
     --==========================
     --	
     -- Description
     -- 	Read the help_related table if the cursor is called 
     --		from the button related topics in the form
     --		or read the help_keywords table if the cursor is
     --         called from the index tab page in the form.
     --
     -- Arguments
     --		c_related	Ref Cursor used as data source in the block
     --		p_from		indicates the origin of the call
     --				(RELATED or KEYWORDS)
     --		p_id		Help id to find
     --		p_app		Application name to find
     --		p_key		Keyword to find if the origin is KEYWORDS
     --
  PROCEDURE Choose_Related_topics (c_related In Out related_type,
                                   p_from varchar2,
                                   p_id number,
                                   p_app varchar2,
                                   p_key varchar2);
END;
/
SHOW ERRORS;
CREATE OR REPLACE PACKAGE BODY srhlp_tree IS

  FUNCTION init_tree (p_app_name varchar2) return tab_rec
  is
     Cursor C_tree is
        select level help_level,
               help_id,
               lpad(' ',7*(level-1))||help_title help_title,
               'Y' help_leaf,
               father_id,
               sort_id
        from forms_help
        where app_name=p_app_name
        connect by prior help_id= father_id
        start with father_id is null;

     tab_tree 	tab_rec;
     nb_leaf 	number;
     z 		number;
     bool 	boolean;

  begin
     for r_tree in c_tree loop
       select count(*) into nb_leaf
       from forms_help
       where father_id = r_tree.help_id;
       if nb_leaf > 0
       then
          r_tree.help_leaf := 'N';
       end if;
       -- 
       -- sort by sort_id in each level
       --
       bool := false;
       if tab_tree.count > 0   -- if the table of record is not empty
       then  
         --
         -- Search a place to insert the record
         --
         for i in 1..tab_tree.count loop
             if bool 
             then 
               exit;
             end if;
             if (tab_tree(i).help_id = r_tree.father_id or
                r_tree.father_id is null) 
             then 
                if r_tree.father_id is not null
                then
                    z := i+1;
                else
                    z := i;
                end if;
             --
             -- We've found the father_id in the table of record
             --
                begin
                   --
                   -- For each record until a smaller level
                   --
                   while tab_tree(z).help_level >= r_tree.help_level loop
                       --
                       -- if a smaller sort_id is found
                       --
                       if tab_tree(z).help_level = r_tree.help_level and
                          tab_tree(z).sort_id > r_tree.sort_id
                       then
                          --
                          -- insert the record in the table to sort by sort_id
                          --
                          for j in reverse z..tab_tree.count loop
                             tab_tree(j+1) := tab_tree(j);
                          end loop;  
                           tab_tree(z).help_level := r_tree.help_level;
tab_tree(z).help_id := r_tree.help_id;
tab_tree(z).help_title := r_tree.help_title;
tab_tree(z).help_leaf := r_tree.help_leaf;
tab_tree(z).father_id := r_tree.father_id;
tab_tree(z).sort_id := r_tree.sort_id;
                          bool := true;
                          exit;
                       end if;
                       z := z+1;
                    end loop;
                    if not bool
                    then
                    --
                    -- insert the record in the table (last sort_id for this level)
                    --
                       for j in reverse z..tab_tree.count loop
                           tab_tree(j+1) := tab_tree(j);
                        end loop;  
                         tab_tree(z).help_level := r_tree.help_level;
tab_tree(z).help_id := r_tree.help_id;
tab_tree(z).help_title := r_tree.help_title;
tab_tree(z).help_leaf := r_tree.help_leaf;
tab_tree(z).father_id := r_tree.father_id;
tab_tree(z).sort_id := r_tree.sort_id;                        bool := true;
                     end if;
                exception
                    when no_data_found 
                    then
                       --
                       -- insert at the end of the table of records
                       --
                       tab_tree(tab_tree.count+1) := r_tree;
                       bool := true;
                end;    
             end if; 
          end loop;
          --
          -- If no record found with the  father_id => save at the end of the table
          --
          if not bool
          then
             tab_tree(tab_tree.count+1) := r_tree;
          end if;
       else
          --
          -- First record
          -- 
           tab_tree(1).help_level := r_tree.help_level;
tab_tree(1).help_id := r_tree.help_id;
tab_tree(1).help_title := r_tree.help_title;
tab_tree(1).help_leaf := r_tree.help_leaf;
tab_tree(1).father_id := r_tree.father_id;
tab_tree(1).sort_id := r_tree.sort_id;       end if; 
     end loop;
     return(tab_tree);
  end;


  PROCEDURE Choose_Related_topics (c_related in out related_type,
                                   p_from varchar2,
                                   p_id number,
                                   p_app varchar2,
                                   p_key varchar2) is
  Begin
     if p_from = 'RELATED'
     then
        --
        -- The cursor is called from the button related topics in the form
        --
        Open c_related for
             select help_id_related,app_name_related
             from help_related
             where help_id = p_id 
               and app_name = p_app;
     else
        --
        -- The cursor is called from the index tab page in the form
        --
        Open c_related for
             select help_id help_id_related,app_name app_name_related
             from help_keywords
             where key_name = p_key 
               and app_name = p_app;
     end if;
  end;

end;
/
SHOW ERRORS