CREATE OR REPLACE PACKAGE SIM2_EXPORT_PKG IS
/*
Change Log

1/21/03 - PWH added D_USERID_CODE,D_LAST_UPDT_TS to the get_eisn_number function insert statement.

6/27/02 - SF Changed the cursor CURSOR c_well_on_station in CLEAR_STATION_EXPORT. This is to check
that no wells exist on the station before deleting it. However, a well record CAN be imported with the station. In this case
the well record will not have an export_log _seq. So I changed the last line of the cursor to:
     AND NVL(sw.SSW_EXPORT_SEQ,p_export_log_seq) <> p_export_log_seq;

3/12/02 - SF
Fixed bug where the value being passed to Update_EISN for TSRFQS was the wrong number,
so the EISN Table was not being updated for trip qc records.

6/16/2000 -
1. added GET_NEXT_STAVST_ID to get the next station visit # by selecting the count
   of the ones already existing instead of incrementing a counter

2/18/2002 - Brady
2. added a FOR LOOP to delete ocean location data from TSMOCNLC associated to stations
   that were being deleted from Storet.
*/
   /* import utils by SNG Feb 2000 */

  /* This variable is used throughout the import and export packages. It is used for the user id columns
     in the STRORET tables, we use the columns to check whether the exported records have been updated 
     in STORET */
  v_pkg_ownerid   VARCHAR2(8) := 'SIM201  ';
     
  FUNCTION get_eisn_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) RETURN NUMBER;

  FUNCTION CHK_IF_RESULT_DELETE(P_TSRFDACT_IS_NUMBER IN NUMBER,
                       P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2,p_exp_log_seq NUMBER,
                       P_ACTIVITY_ID IN VARCHAR2 DEFAULT NULL) RETURN VARCHAR2;
  FUNCTION get_tsmorgan_is_number (p_org_id IN VARCHAR2) RETURN NUMBER;

  PROCEDURE CLEAR_STORET_EXPORT (p_export_log_seq IN NUMBER,p_success OUT VARCHAR2);

  PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2);

  FUNCTION GET_EXPORT_LOG_SEQ RETURN NUMBER;

  PROCEDURE CLEAR_STATION_EXPORT (p_export_log_seq IN NUMBER,p_success OUT VARCHAR2);

  FUNCTION CLEAR_EXPORT (p_export_log_seq IN NUMBER) RETURN NUMBER;

  FUNCTION get_file_type(p_path IN VARCHAR2) RETURN VARCHAR2;
  FUNCTION get_file_name(p_path IN VARCHAR2) RETURN VARCHAR2;

END;
/
CREATE OR REPLACE PACKAGE BODY SIM2_EXPORT_PKG as
  v_export_seq  NUMBER(10);

/******************************************************************************************************/
FUNCTION get_eisn_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) RETURN NUMBER IS

  v_is_number           NUMBER(8);

  CURSOR c_get_number(p_table_name IN VARCHAR2, p_org_id IN VARCHAR2) IS
    SELECT IS_NUMBER FROM TSMEISN WHERE TSMEISN_NAME = RPAD(p_table_name,8)
      AND TSMEISN_ORG_ID = RPAD(p_org_id,8)
      FOR UPDATE; -- Locks table while being used

BEGIN
  OPEN c_get_number(p_table_name, p_org_id);
  FETCH c_get_number INTO v_is_number;
    IF c_get_number%NOTFOUND THEN
      v_is_number := 1;
      INSERT INTO TSMEISN(TSMEISN_NAME,TSMEISN_ORG_ID,IS_NUMBER,D_USERID_CODE,D_LAST_UPDT_TS)
      VALUES (p_table_name,p_org_id,v_is_number,USER,SYSDATE);

      COMMIT;
    ELSE
      v_is_number := v_is_number + 1;
      UPDATE tsmeisn
       SET is_number = v_is_number
       WHERE tsmeisn_name = RPAD(p_table_name,8)
         AND tsmeisn_org_id = RPAD(p_org_id,8);

      COMMIT;
    END IF;
  CLOSE c_get_number;

  RETURN v_is_number;

  EXCEPTION
    WHEN OTHERS THEN
      write_error(v_export_seq,SQLERRM||' - in get eisn');
END get_eisn_number;

/******************************************************************************************************/
FUNCTION get_tsmorgan_is_number(
         p_org_id  IN VARCHAR2) 
         RETURN NUMBER 
IS

  v_is_nbr NUMBER(8);

  -- Table of Storet Metadata for ORGANIZATION (TSMORGAN)
  CURSOR c_tsmorgan_is_nbr (p_org_id IN VARCHAR2) IS
  SELECT TSMORGAN_IS_NUMBER 
  FROM   TSMORGAN 
  WHERE  ORG_ID = RPAD(p_org_id,8);

BEGIN

  OPEN  c_tsmorgan_is_nbr (p_org_id);
  FETCH c_tsmorgan_is_nbr INTO v_is_nbr;
  CLOSE c_tsmorgan_is_nbr;

  RETURN v_is_nbr;

EXCEPTION
  WHEN OTHERS THEN
    write_error(
      v_export_seq,
      SQLERRM ||' - in get tsmorgan'
    );
    
END get_tsmorgan_is_number;

/*******************************************************************************************************/
FUNCTION DELETE_RESULT_CHILDREN(
         P_TSRFDACT_IS_NUMBER IN NUMBER,
         P_TSRFDACT_ORG_ID    IN VARCHAR2,
         p_exp_log_seq        IN NUMBER,
         P_ACTIVITY_ID        IN VARCHAR2 DEFAULT NULL)
  RETURN VARCHAR2 IS
 

  CURSOR c_tsrbrg_id(
         P_TSRFDACT_IS_NUMBER IN NUMBER,
         P_TSRFDACT_ORG_ID IN VARCHAR2) IS
  SELECT tsrbrg_is_number, tsrbrg_org_id
  FROM   tsrbrg
  WHERE  TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
  AND    TSRFDACT_ORG_ID    = RPAD(P_TSRFDACT_ORG_ID,8);

  CURSOR c_brg_tsrrsult_id(
         p_tsrbrg_is_number NUMBER,
         p_tsrbrg_org_id    VARCHAR2) IS
  SELECT tsrrsult_is_number,tsrrsult_org_id
  FROM   tsrrsult
  WHERE  tsrbrg_is_number = p_tsrbrg_is_number
  AND    tsrbrg_org_id    = RPAD(p_tsrbrg_org_id,8);

  CURSOR c_act_tsrrsult_id(
         cp_tsrfdact_is_number NUMBER,
         cp_tsrfdact_org_id    VARCHAR2) IS
  SELECT tsrrsult_is_number,tsrrsult_org_id
  FROM   tsrrsult
  WHERE  tsrfdact_is_number = cp_tsrfdact_is_number
  AND    tsrfdact_org_id    = RPAD(cp_tsrfdact_org_id,8);


 BEGIN

   DELETE TSRRLRA
     WHERE TSRRSULT_IS_NUMBER IN(SELECT TSRRSULT_IS_NUMBER 
                                   FROM TSRRSULT
                                   WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER)
       AND TSRRSULT_ORG_ID IN(SELECT TSRRSULT_ORG_ID 
                                   FROM TSRRSULT
                                   WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_ORG_ID);
                                   
   DELETE tsraal WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsreod WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrfafsa WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrfapea WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrfapra WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrfaqsa WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrsmple WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrtnod WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);

   DELETE tsrtod WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);


   -- Remove Biological records
   FOR c_tsrbrg_id_rec IN c_tsrbrg_id(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID) LOOP

     DELETE tsrbrgi WHERE tsrbrg_is_number = c_tsrbrg_id_rec.tsrbrg_is_number
       AND tsrbrg_org_id = RPAD(c_tsrbrg_id_rec.tsrbrg_org_id,8);

     FOR c_brg_tsrrsult_id_rec 
     IN c_brg_tsrrsult_id(
       c_tsrbrg_id_rec.tsrbrg_is_number,
       c_tsrbrg_id_rec.tsrbrg_org_id)
     LOOP

       DELETE tsmgntxt WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
         AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

       DELETE tsrdql WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
         AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

       DELETE tsrrlra WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
        AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

       DELETE tsrcldes WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
        AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

       DELETE tsrrci WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
        AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

       DELETE tsrrqcaf WHERE tsrrsult_is_number = c_brg_tsrrsult_id_rec.tsrrsult_is_number
         AND tsrrsult_org_id = RPAD(c_brg_tsrrsult_id_rec.tsrrsult_org_id,8);

     END LOOP;--c_brg_tsrrsult_id_rec

     DELETE tsrrsult WHERE tsrbrg_is_number = c_tsrbrg_id_rec.tsrbrg_is_number
       AND tsrbrg_org_id = RPAD(c_tsrbrg_id_rec.tsrbrg_org_id,8);

   END LOOP;--c_tsrbrg_id_rec

      
   FOR c_act_tsrrsult_id_rec 
   IN  c_act_tsrrsult_id(
     p_tsrfdact_is_number,
     p_tsrfdact_org_id) 
   LOOP

     DELETE tsmgntxt WHERE tsrrsult_is_number = c_act_tsrrsult_id_rec.tsrrsult_is_number
       AND tsrrsult_org_id = RPAD(c_act_tsrrsult_id_rec.tsrrsult_org_id,8);

     DELETE tsrdql WHERE tsrrsult_is_number = c_act_tsrrsult_id_rec.tsrrsult_is_number
       AND tsrrsult_org_id = RPAD(c_act_tsrrsult_id_rec.tsrrsult_org_id,8);

     DELETE tsrrlra WHERE tsrrsult_is_number = c_act_tsrrsult_id_rec.tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(c_act_tsrrsult_id_rec.tsrrsult_org_id,8);

     DELETE tsrrci
     WHERE  tsrrsult_is_number = c_act_tsrrsult_id_rec.tsrrsult_is_number
     AND    tsrrsult_org_id    = RPAD(c_act_tsrrsult_id_rec.tsrrsult_org_id,8);

     DELETE tsrrqcaf WHERE tsrrsult_is_number = c_act_tsrrsult_id_rec.tsrrsult_is_number
       AND tsrrsult_org_id = RPAD(c_act_tsrrsult_id_rec.tsrrsult_org_id,8);

   END LOOP;-- c_act_tsrrsult_id_rec


   DELETE tsrbrg WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8);
   
   -- jah: remove 'Composite...' child records
   DELETE tsrfdact WHERE tsrfdact0is_number = p_tsrfdact_is_number
    AND tsrfdact0org_id = RPAD(p_tsrfdact_org_id,8);

   -- jah: remove 'Created from Sample' child records
   DELETE tsrfdact WHERE tsrfdact1is_number = p_tsrfdact_is_number
      AND tsrfdact1org_id = RPAD(p_tsrfdact_org_id,8);


   COMMIT;
   RETURN('Y');
 EXCEPTION
  WHEN OTHERS THEN
    write_error(v_export_seq,SQLERRM||' - in DELETE_RESULT_CHILDREN');
    RETURN('N');
END DELETE_RESULT_CHILDREN;
/*****************************************************************************/
FUNCTION chk_if_station_delete(p_sta_is_number NUMBER,p_sta_tsmorgan_org_id VARCHAR2,
                               p_exp_id VARCHAR2,p_export_log_seq NUMBER)
 RETURN VARCHAR2 IS


  v_cnt           NUMBER(10) := 0;
  v_station       VARCHAR2(30);
  v_chk           VARCHAR2(1) := 'Y';
  v_success       VARCHAR2(1);

  e_bad_chk       EXCEPTION;

   -- Table of Storet Metadata for STATioN (TSMSTATN)
   CURSOR c_station(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT identification_cd
     FROM tsmstatn
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   -- Table of Storet Metadata for PIPE (TSMPIPE)    
   CURSOR c_pipe(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                 ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmpipe
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   /* Cursors of tables that are children from table tsmpipe */
   CURSOR c_pipe_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                 ,p_exp_id VARCHAR2) IS
     SELECT tsmpipe_is_number,tsmpipe_org_id
     FROM tsmpipe
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsmalp_pipe_id(P_TSMPIPE_IS_NUMBER IN NUMBER,P_TSMPIPE_ORG_ID IN VARCHAR2
                      ,p_exp_id VARCHAR2) IS
     SELECT tsmalp_is_number,tsmalp_org_id
     FROM tsmalp
     WHERE tsmpipe_is_number = p_tsmpipe_is_number
       AND tsmpipe_org_id = RPAD(p_tsmpipe_org_id,8);
   /* End tables that are children from table tsmpipe */

   CURSOR c_tsmalp(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmalp
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   /* Cursors of tables that are children from table tsmalp */
   CURSOR c_tsmalp_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                      ,p_exp_id VARCHAR2) IS
     SELECT tsmalp_is_number,tsmalp_org_id
     FROM tsmalp
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsmestlc(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                     ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmestlc
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmgll(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmgll
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmocnlc(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                     ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmocnlc
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsraal(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsraal
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8)
       AND D_USERID_CODE != p_exp_id;

      /* Cursor to find child Field Activities */
   CURSOR c_tsraal_id(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                      ,p_exp_id VARCHAR2) IS
     SELECT tsrfdact_is_number,tsrfdact_org_id
     FROM tsraal
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8);
   /* End tables that are children from table tsmalp */

   CURSOR c_tsradl(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsradl
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   /*  Cursors of tables that are children from table tsradl */
   CURSOR c_tsradl_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT tsradl_is_number,tsradl_org_id
     FROM tsradl
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsropprd(P_TSRADL_IS_NUMBER IN NUMBER,P_TSRADL_ORG_ID IN VARCHAR2
                   ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsradl
     WHERE tsradl_is_number = p_tsradl_is_number
       AND tsradl_org_id = RPAD(p_tsradl_org_id,8)
       AND D_USERID_CODE != p_exp_id;
   /* End tables that are children from table tsradl */


   CURSOR c_tsmwell(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmwell
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   /*  Cursors of tables that are children from table tsmwell */
   CURSOR c_tsmwell_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT tsmwell_is_number,tsmwell_org_id
     FROM tsmwell
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsmaddr(p_tsmwell_is_number IN NUMBER,p_tsmwell_org_id IN VARCHAR2
                    ,p_exp_id IN VARCHAR2) IS
     SELECT count(1)
     FROM tsmaddr
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmlog(p_tsmwell_is_number IN NUMBER,p_tsmwell_org_id IN VARCHAR2
                    ,p_exp_id IN VARCHAR2) IS
     SELECT count(1)
     FROM tsmlog
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmpump(p_tsmwell_is_number IN NUMBER,p_tsmwell_org_id IN VARCHAR2
                    ,p_exp_id IN VARCHAR2) IS
     SELECT count(1)
     FROM tsmpump
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmwle(p_tsmwell_is_number IN NUMBER,p_tsmwell_org_id IN VARCHAR2
                    ,p_exp_id IN VARCHAR2) IS
     SELECT count(1)
     FROM tsmwle
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmintvl(P_TSMWELL_IS_NUMBER IN NUMBER,P_TSMWELL_ORG_ID IN VARCHAR2
                     ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmintvl
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmintvl_id(P_TSMWELL_IS_NUMBER IN NUMBER,P_TSMWELL_ORG_ID IN VARCHAR2
                     ,p_exp_id VARCHAR2) IS
     SELECT tsmintvl_is_number,tsmintvl_org_id
     FROM tsmintvl
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8);

   CURSOR c_tsmcsng(p_tsmintvl_is_number IN NUMBER,p_tsmintvl_org_id IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmcsng
     WHERE tsmintvl_is_number = p_tsmintvl_is_number
       AND tsmintvl_org_id = RPAD(p_tsmintvl_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmopng(p_tsmintvl_is_number IN NUMBER,p_tsmintvl_org_id IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmopng
     WHERE tsmintvl_is_number = p_tsmintvl_is_number
       AND tsmintvl_org_id = RPAD(p_tsmintvl_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmfill(p_tsmintvl_is_number IN NUMBER,p_tsmintvl_org_id IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmfill
     WHERE tsmintvl_is_number = p_tsmintvl_is_number
       AND tsmintvl_org_id = RPAD(p_tsmintvl_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmhole(p_tsmintvl_is_number IN NUMBER,p_tsmintvl_org_id IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmhole
     WHERE tsmintvl_is_number = p_tsmintvl_is_number
       AND tsmintvl_org_id = RPAD(p_tsmintvl_org_id,8)
       AND D_USERID_CODE != p_exp_id;

   CURSOR c_tsmigua(p_tsmintvl_is_number IN NUMBER,p_tsmintvl_org_id IN VARCHAR2
                    ,p_exp_id VARCHAR2) IS
     SELECT count(1)
     FROM tsmigua
     WHERE tsmintvl_is_number = p_tsmintvl_is_number
       AND tsmintvl_org_id = RPAD(p_tsmintvl_org_id,8)
       AND D_USERID_CODE != p_exp_id;


BEGIN

  OPEN c_station(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id);
    FETCH c_station INTO v_station;
  CLOSE c_station;

  /* Check if there are any TSMPIPE children */
  OPEN c_pipe(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id);
    FETCH c_pipe INTO v_cnt;
  CLOSE c_pipe;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_pipe_id_rec IN c_pipe_id(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id)
  LOOP
    FOR c_tsmalp_pipe_id_rec IN c_tsmalp_pipe_id(c_pipe_id_rec.TSMPIPE_IS_NUMBER,
                                                 c_pipe_id_rec.TSMPIPE_ORG_ID,p_exp_id)
    LOOP
      OPEN c_tsmestlc(c_tsmalp_pipe_id_rec.TSMALP_IS_NUMBER,c_tsmalp_pipe_id_rec.TSMALP_ORG_ID
                     ,p_exp_id);
        FETCH c_tsmestlc INTO v_cnt;
      CLOSE c_tsmestlc;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmgll(c_tsmalp_pipe_id_rec.TSMALP_IS_NUMBER,c_tsmalp_pipe_id_rec.TSMALP_ORG_ID
                     ,p_exp_id);
        FETCH c_tsmgll INTO v_cnt;
      CLOSE c_tsmgll;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmocnlc(c_tsmalp_pipe_id_rec.TSMALP_IS_NUMBER,c_tsmalp_pipe_id_rec.TSMALP_ORG_ID
                     ,p_exp_id);
        FETCH c_tsmocnlc INTO v_cnt;
      CLOSE c_tsmocnlc;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsraal(c_tsmalp_pipe_id_rec.TSMALP_IS_NUMBER,c_tsmalp_pipe_id_rec.TSMALP_ORG_ID
                     ,p_exp_id);
        FETCH c_tsraal INTO v_cnt;
      CLOSE c_tsraal;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      FOR c_tsraal_id_rec IN c_tsraal_id(c_tsmalp_pipe_id_rec.TSMALP_IS_NUMBER,c_tsmalp_pipe_id_rec.TSMALP_ORG_ID
                                         ,p_exp_id)
      LOOP
        v_success := chk_if_result_delete(c_tsraal_id_rec.tsrfdact_is_number,c_tsraal_id_rec.tsrfdact_org_id,p_exp_id,p_export_log_seq,NULL);
        IF v_success = 'N' THEN
          RAISE e_bad_chk;
        END IF;
      END LOOP; -- c_tsraal_id_rec
    END LOOP; --c_tsmalp_pip_id_rec

  END LOOP; --c_pipe_id_rec

  /* Check if there are any TSMMALP children */
  OPEN c_tsmalp(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id);
    FETCH c_tsmalp INTO v_cnt;
  CLOSE c_tsmalp;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_tsmalp_id_rec IN c_tsmalp_id(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id)
  LOOP

    OPEN c_tsmestlc(c_tsmalp_id_rec.TSMALP_IS_NUMBER,c_tsmalp_id_rec.TSMALP_ORG_ID
                   ,p_exp_id);
      FETCH c_tsmestlc INTO v_cnt;
    CLOSE c_tsmestlc;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmgll(c_tsmalp_id_rec.TSMALP_IS_NUMBER,c_tsmalp_id_rec.TSMALP_ORG_ID
                   ,p_exp_id);
      FETCH c_tsmgll INTO v_cnt;
    CLOSE c_tsmgll;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmocnlc(c_tsmalp_id_rec.TSMALP_IS_NUMBER,c_tsmalp_id_rec.TSMALP_ORG_ID
                   ,p_exp_id);
      FETCH c_tsmocnlc INTO v_cnt;
    CLOSE c_tsmocnlc;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsraal(c_tsmalp_id_rec.TSMALP_IS_NUMBER,c_tsmalp_id_rec.TSMALP_ORG_ID
                   ,p_exp_id);
      FETCH c_tsraal INTO v_cnt;
    CLOSE c_tsraal;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    FOR c_tsraal_id_rec IN c_tsraal_id(c_tsmalp_id_rec.TSMALP_IS_NUMBER,c_tsmalp_id_rec.TSMALP_ORG_ID
                                       ,p_exp_id)
    LOOP
      v_success := chk_if_result_delete(c_tsraal_id_rec.tsrfdact_is_number,c_tsraal_id_rec.tsrfdact_org_id,p_exp_id,p_export_log_seq,NULL);
      IF v_success = 'N' THEN
        RAISE e_bad_chk;
      END IF;
    END LOOP; -- c_tsraal_id_rec
  END LOOP;-- c_tsmalp_id_rec

  /* Check if there are any TSRADL children */
  OPEN c_tsradl(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id);
    FETCH c_tsradl INTO v_cnt;
  CLOSE c_tsradl;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_tsradl_id_rec IN c_tsradl_id(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id)
  LOOP
    OPEN c_tsropprd(c_tsradl_id_rec.TSRADL_IS_NUMBER,c_tsradl_id_rec.TSRADL_ORG_ID,p_exp_id);
      FETCH c_tsropprd INTO v_cnt;
    CLOSE c_tsropprd;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;
  END LOOP;-- c_tsradl_id_rec

  /* Check if there are any TSMWELL children */
  OPEN c_tsmwell(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id);
    FETCH c_tsmwell INTO v_cnt;
  CLOSE c_tsmwell;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_tsmwell_id_rec IN c_tsmwell_id(p_sta_is_number,p_sta_tsmorgan_org_id,p_exp_id)
  LOOP
    OPEN c_tsmaddr(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                   ,p_exp_id);
      FETCH c_tsmaddr INTO v_cnt;
    CLOSE c_tsmaddr;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmlog(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                   ,p_exp_id);
      FETCH c_tsmlog INTO v_cnt;
    CLOSE c_tsmlog;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmpump(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                   ,p_exp_id);
      FETCH c_tsmpump INTO v_cnt;
    CLOSE c_tsmpump;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmwle(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                   ,p_exp_id);
      FETCH c_tsmwle INTO v_cnt;
    CLOSE c_tsmwle;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsmintvl(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                   ,p_exp_id);
      FETCH c_tsmintvl INTO v_cnt;
    CLOSE c_tsmintvl;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    FOR c_tsmintvl_id_rec IN c_tsmintvl_id(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id
                                           ,p_exp_id)
    LOOP

      OPEN c_tsmcsng(c_tsmintvl_id_rec.tsmintvl_is_number,c_tsmintvl_id_rec.tsmintvl_org_id
                     ,p_exp_id);
        FETCH c_tsmcsng INTO v_cnt;
      CLOSE c_tsmcsng;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmfill(c_tsmintvl_id_rec.tsmintvl_is_number,c_tsmintvl_id_rec.tsmintvl_org_id
                     ,p_exp_id);
        FETCH c_tsmfill INTO v_cnt;
      CLOSE c_tsmfill;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmhole(c_tsmintvl_id_rec.tsmintvl_is_number,c_tsmintvl_id_rec.tsmintvl_org_id
                     ,p_exp_id);
        FETCH c_tsmhole INTO v_cnt;
      CLOSE c_tsmhole;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmigua(c_tsmintvl_id_rec.tsmintvl_is_number,c_tsmintvl_id_rec.tsmintvl_org_id
                     ,p_exp_id);
        FETCH c_tsmigua INTO v_cnt;
      CLOSE c_tsmigua;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_tsmopng(c_tsmintvl_id_rec.tsmintvl_is_number,c_tsmintvl_id_rec.tsmintvl_org_id
                     ,p_exp_id);
        FETCH c_tsmopng INTO v_cnt;
      CLOSE c_tsmopng;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

    END LOOP;-- c_tsmintvl_id_rec

  END LOOP;-- c_tsmwell_id_rec

  RETURN(v_chk);
EXCEPTION
    WHEN e_bad_chk THEN
      v_chk := 'N';
      write_error(v_export_seq,'Associated records have been found in STORET that were not migrated by SIM.'||
                  ' Please use the STORET interface to delete Station '||v_station);
      RETURN(v_chk);

    WHEN OTHERS THEN
      write_error(v_export_seq,SQLERRM||' - in chk_if_station_delete');
END chk_if_station_delete;

/******************************************************************************************************/
FUNCTION CHK_IF_RESULT_DELETE(
         P_TSRFDACT_IS_NUMBER  IN NUMBER,
         P_TSRFDACT_ORG_ID     IN VARCHAR2,
         p_exp_id              VARCHAR2,
         p_exp_log_seq         NUMBER,
         P_ACTIVITY_ID         IN VARCHAR2 DEFAULT NULL)
         RETURN VARCHAR2 
  IS

  v_cnt           NUMBER(10)   := 0;
  e_bad_chk       EXCEPTION;
  e_parent        EXCEPTION;
  
  CURSOR c_tsraal(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsraal
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != rpad(p_exp_id,8);

  CURSOR c_tsreod(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsreod
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE = p_exp_id;

  CURSOR c_tsrfafsa(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrfafsa
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  -- Field Activity PErsonnel Association (FAPEA)
  CURSOR c_tsrfapea(
         P_TSRFDACT_IS_NUMBER  IN NUMBER,
         P_TSRFDACT_ORG_ID     IN VARCHAR2,
         p_exp_id              VARCHAR2) IS
  SELECT count(1)
  FROM   tsrfapea
  WHERE  TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
  AND    TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
  AND    D_USERID_CODE != p_exp_id;

  -- Field Activity Cooperating Organization Assocciation (FACOA)
  CURSOR c_tsrfacoa(
         P_TSRFDACT_IS_NUMBER  IN NUMBER,
         P_TSRFDACT_ORG_ID     IN VARCHAR2,
         p_exp_id              VARCHAR2) IS
  SELECT count(1)
  FROM   tsrfacoa
  WHERE  TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
  AND    TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
  AND    D_USERID_CODE != p_exp_id;

  -- Field Activity PRoject Association (FAPRA)
  CURSOR c_tsrfapra(
         P_TSRFDACT_IS_NUMBER  IN NUMBER,
         P_TSRFDACT_ORG_ID     IN VARCHAR2,
         p_exp_id              VARCHAR2) IS
  SELECT count(1)
  FROM   tsrfapra
  WHERE  TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
  AND    TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
  AND    D_USERID_CODE != p_exp_id;

  CURSOR c_tsrfaqsa(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrfaqsa
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  CURSOR c_tsrsmple(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrsmple
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  CURSOR c_tsrtnod(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrtnod
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  CURSOR c_tsrtod(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrtod
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  CURSOR c_tsrbrg(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrbrg
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE != p_exp_id;

  CURSOR c_tsrbrg_id(P_TSRFDACT_IS_NUMBER IN NUMBER,
                  P_TSRFDACT_ORG_ID IN VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT tsrbrg_is_number,tsrbrg_org_id
    FROM tsrbrg
    WHERE TSRFDACT_IS_NUMBER = P_TSRFDACT_IS_NUMBER
      AND TSRFDACT_ORG_ID = RPAD(P_TSRFDACT_ORG_ID,8)
      AND D_USERID_CODE = p_exp_id;

  CURSOR c_brg_tsrbrgi(p_tsrbrg_is_number NUMBER,
                   p_tsrbrg_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrbrgi
    WHERE tsrbrg_is_number = p_tsrbrg_is_number
      AND tsrbrg_org_id = RPAD(p_tsrbrg_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_brg_tsrrsult(p_tsrbrg_is_number NUMBER,
                   p_tsrbrg_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrrsult
    WHERE tsrbrg_is_number = p_tsrbrg_is_number
      AND tsrbrg_org_id = RPAD(p_tsrbrg_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_act_tsrrsult(
         p_tsrfdact_is_number NUMBER,
         p_tsrfdact_org_id VARCHAR2,
         p_exp_id VARCHAR2) IS
  SELECT count(1)
  FROM   tsrrsult
  WHERE  tsrfdact_is_number = p_tsrfdact_is_number
  AND    tsrfdact_org_id = RPAD(p_tsrfdact_org_id,8)
  AND    d_userid_code != p_exp_id;

  CURSOR c_act_tsrrsult_id(
         p_tsrfdact_is_number NUMBER,
         p_tsrfdact_org_id VARCHAR2,
         p_exp_id VARCHAR2) IS
  SELECT tsrrsult_is_number,tsrrsult_org_id
  FROM   tsrrsult
  WHERE  tsrfdact_is_number = p_tsrfdact_is_number
  AND    tsrfdact_org_id = RPAD(p_tsrfdact_org_id,8)
  AND    d_userid_code = p_exp_id;

  CURSOR c_brg_tsrrsult_id(
         p_tsrbrg_is_number NUMBER,
         p_tsrbrg_org_id VARCHAR2,
         p_exp_id VARCHAR2) IS
  SELECT tsrrsult_is_number,tsrrsult_org_id
  FROM   tsrrsult
  WHERE  tsrbrg_is_number = p_tsrbrg_is_number
  AND    tsrbrg_org_id = RPAD(p_tsrbrg_org_id,8)
  AND    d_userid_code = p_exp_id;

-- Need to call these cursors twice once for tsrfdac and for tsrbrg
  CURSOR c_tsmgntxt(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsmgntxt
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrdql(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrdql
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrrlra(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrrlra
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrcldes(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrcldes
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrrci(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrrci
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrrqcaf(p_tsrrsult_is_number NUMBER,
                        p_tsrrsult_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrrqcaf
    WHERE tsrrsult_is_number = p_tsrrsult_is_number
      AND tsrrsult_org_id = RPAD(p_tsrrsult_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_tsrdlin(p_tsrfdact_is_number NUMBER,
                        p_tsrfdact_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT COUNT(1)
      FROM tsrdlin
      WHERE tsrfdact_is_number = p_tsrfdact_is_number
        AND tsrfdact_org_id = RPAD(p_tsrfdact_org_id,8)
        AND d_userid_code != p_exp_id;
                           
-- These cursors are for samples and composite samples

  CURSOR c_samp(p_tsrfdact_is_number NUMBER,
                        p_tsrfdact_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrfdact
    WHERE tsrfdact0is_number = p_tsrfdact_is_number
      AND tsrfdact0org_id = RPAD(p_tsrfdact_org_id,8)
      AND d_userid_code != p_exp_id;

  CURSOR c_comp_samp(p_tsrfdact_is_number NUMBER,
                        p_tsrfdact_org_id VARCHAR2,p_exp_id VARCHAR2) IS
    SELECT count(1)
    FROM tsrfdact
    WHERE tsrfdact1is_number = p_tsrfdact_is_number
      AND tsrfdact1org_id = RPAD(p_tsrfdact_org_id,8)
      AND d_userid_code != p_exp_id;
  
BEGIN

  OPEN c_tsraal(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsraal INTO v_cnt;
  CLOSE c_tsraal;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsreod(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsreod INTO v_cnt;
  CLOSE c_tsreod;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrfafsa(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrfafsa INTO v_cnt;
  CLOSE c_tsrfafsa;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrfapea(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrfapea INTO v_cnt;
  CLOSE c_tsrfapea;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  -- count changes to Field Activity cooperating Organization Association
  OPEN c_tsrfacoa(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
  FETCH c_tsrfacoa INTO v_cnt;
  CLOSE c_tsrfacoa;
  -- did we find any changes?
  IF NVL(v_cnt,0) > 0 THEN
    -- if yes
    -- raise an exception
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrdlin(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrdlin INTO v_cnt;
  CLOSE c_tsrdlin;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;
    
  OPEN c_tsrfapra(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrfapra INTO v_cnt;
  CLOSE c_tsrfapra;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrfaqsa(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrfaqsa INTO v_cnt;
  CLOSE c_tsrfaqsa;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrsmple(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrsmple INTO v_cnt;
  CLOSE c_tsrsmple;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrtnod(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrtnod INTO v_cnt;
  CLOSE c_tsrtnod;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrtod(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrtod INTO v_cnt;
  CLOSE c_tsrtod;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_tsrbrg(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_tsrbrg INTO v_cnt;
  CLOSE c_tsrbrg;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_tsrbrg_id_rec IN c_tsrbrg_id(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id)
    LOOP
      OPEN c_brg_tsrbrgi(c_tsrbrg_id_rec.tsrbrg_is_number,
                         c_tsrbrg_id_rec.tsrbrg_org_id,p_exp_id);
        FETCH c_brg_tsrbrgi INTO v_cnt;
      CLOSE c_brg_tsrbrgi;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      OPEN c_brg_tsrrsult(c_tsrbrg_id_rec.tsrbrg_is_number,
                         c_tsrbrg_id_rec.tsrbrg_org_id,p_exp_id);
        FETCH c_brg_tsrrsult INTO v_cnt;
      CLOSE c_brg_tsrrsult;
      IF NVL(v_cnt,0) > 0 THEN
        RAISE e_bad_chk;
      END IF;

      FOR c_brg_tsrrsult_id_rec IN c_brg_tsrrsult_id(c_tsrbrg_id_rec.tsrbrg_is_number,
                                 c_tsrbrg_id_rec.tsrbrg_org_id,p_exp_id)
        LOOP
          OPEN c_tsmgntxt(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsmgntxt INTO v_cnt;
          CLOSE c_tsmgntxt;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;

          OPEN c_tsrdql(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsrdql INTO v_cnt;
          CLOSE c_tsrdql;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;

          OPEN c_tsrrlra(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsrrlra INTO v_cnt;
          CLOSE c_tsrrlra;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;

          OPEN c_tsrcldes(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsrcldes INTO v_cnt;
          CLOSE c_tsrcldes;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;

          OPEN c_tsrrci(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsrrci INTO v_cnt;
          CLOSE c_tsrrci;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;

          OPEN c_tsrrqcaf(c_brg_tsrrsult_id_rec.tsrrsult_is_number,
                          c_brg_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
            FETCH c_tsrrqcaf INTO v_cnt;
          CLOSE c_tsrrqcaf;
          IF NVL(v_cnt,0) > 0 THEN
            RAISE e_bad_chk;
          END IF;
        END LOOP;
    END LOOP;

  OPEN c_act_tsrrsult(
    P_TSRFDACT_IS_NUMBER,
    P_TSRFDACT_ORG_ID,
    p_exp_id
  );
  FETCH c_act_tsrrsult INTO v_cnt;
  CLOSE c_act_tsrrsult;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  FOR c_act_tsrrsult_id_rec 
  IN c_act_tsrrsult_id(
    p_tsrfdact_is_number,
    p_tsrfdact_org_id,
    p_exp_id)
  LOOP
    OPEN c_tsmgntxt(
      c_act_tsrrsult_id_rec.tsrrsult_is_number,
      c_act_tsrrsult_id_rec.tsrrsult_org_id,
      p_exp_id
    );
    FETCH c_tsmgntxt INTO v_cnt;
    CLOSE c_tsmgntxt;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsrdql(
      c_act_tsrrsult_id_rec.tsrrsult_is_number,
      c_act_tsrrsult_id_rec.tsrrsult_org_id,
      p_exp_id
    );
    FETCH c_tsrdql INTO v_cnt;
    CLOSE c_tsrdql;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsrrlra(c_act_tsrrsult_id_rec.tsrrsult_is_number,
                   c_act_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
    FETCH c_tsrrlra INTO v_cnt;
    CLOSE c_tsrrlra;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsrcldes(c_act_tsrrsult_id_rec.tsrrsult_is_number,
                    c_act_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
      FETCH c_tsrcldes INTO v_cnt;
    CLOSE c_tsrcldes;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsrrci(c_act_tsrrsult_id_rec.tsrrsult_is_number,
                  c_act_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
      FETCH c_tsrrci INTO v_cnt;
    CLOSE c_tsrrci;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;

    OPEN c_tsrrqcaf(c_act_tsrrsult_id_rec.tsrrsult_is_number,
                    c_act_tsrrsult_id_rec.tsrrsult_org_id,p_exp_id);
      FETCH c_tsrrqcaf INTO v_cnt;
    CLOSE c_tsrrqcaf;
    IF NVL(v_cnt,0) > 0 THEN
      RAISE e_bad_chk;
    END IF;
  END LOOP;

  OPEN c_samp(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_samp INTO v_cnt;
  CLOSE c_samp;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  OPEN c_comp_samp(P_TSRFDACT_IS_NUMBER,P_TSRFDACT_ORG_ID,p_exp_id);
    FETCH c_comp_samp INTO v_cnt;
  CLOSE c_comp_samp;
  IF NVL(v_cnt,0) > 0 THEN
    RAISE e_bad_chk;
  END IF;

  -- return 'okay to delete'
  RETURN('Y');

EXCEPTION
 
  -- did we find a record that was not migrated by SIM?
  WHEN e_bad_chk THEN
    -- if yes

    -- Did the calling routine pass an activity id?     
    IF P_ACTIVITY_ID IS NOT NULL THEN
      -- if yes
      -- Output an exception message
      write_error(
        v_export_seq,
        'Associated records have been found in STORET that were not migrated by SIM. ' ||
        'Please use the STORET interface to delete Activity ' || P_ACTIVITY_ID || '.'
      );
    END IF;
      
    -- return 'do not delete'
    RETURN('N');

  WHEN OTHERS THEN
    -- output exception message
    write_error(
      v_export_seq,
      SQLERRM || ' - in Procedure CHK_IF_RESULT_DELETE.');
      
END chk_if_result_delete;

/******************************************************************************************************/
PROCEDURE CLEAR_STORET_EXPORT (
          p_export_log_seq IN NUMBER,
          p_success        OUT VARCHAR2)
  IS 

  v_tsrfdact_is_number  NUMBER(8);
  v_tsrfdact_org_id     VARCHAR2(8);
  v_tsrfqs_is_number    NUMBER(8);
  v_tsrfqs_org_id       VARCHAR2(8);
  v_created_by          NUMBER(1);
  v_visit_is_nbr        NUMBER(8);
  v_visit_org_id        CHAR(8);
  v_trip_is_nbr         NUMBER(8);
  v_trip_org_id         CHAR(8);
  v_dummy_is_nbr        NUMBER(8);
  v_result_cnt          NUMBER(10) := 0;
  v_import_seq          NUMBER(10);
  v_chk_storet_on_del   VARCHAR2(5);
  v_delete_ok           VARCHAR2(1);
  v_exp_id              VARCHAR2(8) := sim2_export_pkg.v_pkg_ownerid;
  v_activity_cnt        NUMBER(10) := 0;
  e_storet_child        EXCEPTION;
  e_sim_child           EXCEPTION;
  e_no_delete           EXCEPTION;

  CURSOR c_fa_export(p_export_log_seq NUMBER) IS
    SELECT FA_SEQ, FA_TSRFDACT_IS_NUMBER TSRFDACT_IS_NUMBER, 
           FA_TSRFDACT_ORG_ID TSRFDACT_ORG_ID, 
           FA_TSRFQS_IS_NUMBER TSRFQS_IS_NUMBER, 
           FA_TSRFQS_ORG_ID TSRFQS_ORG_ID, 
           FA_IMPORT_SEQ, FA_SSV_SEQ, 
           FA_STP_SEQ, FA_ACTIVITY_ID,
           FA_CATEGORY
    FROM   SIM_FIELD_ACTIVITIES 
    WHERE  fa_export_seq = p_export_log_seq;
        
  -- Retrieve a SIM Station Visit record using a record sequence number
  CURSOR c_get_visit_info(p_visit_seq IN NUMBER) IS
  SELECT SSV_CREATED_BY_SIM, SSV_TSRSTVST_IS_NUMBER, SSV_TSRSTVST_ORG_ID
  FROM   SIM_STATION_VISITS 
  WHERE  SSV_SEQ = p_visit_seq;

  -- Retrieve a SIM Trip record using a record sequence number
  CURSOR c_get_trip_info(p_trip_seq IN NUMBER) IS
  SELECT STP_CREATED_BY_SIM, STP_TSRTRIP_IS_NUMBER, STP_TSRTRIP_ORG_ID
  FROM   SIM_TRIPS 
  WHERE  STP_SEQ = p_trip_seq;

  -- Retrieve STORET Field Activities for a given STORET visit
  CURSOR c_check_visit_in_STORET(p_visit_is_nbr IN NUMBER, p_visit_org_id IN VARCHAR2) IS
  SELECT TSRFDACT_IS_NUMBER 
  FROM   TSRFDACT 
  WHERE  TSRSTVST_IS_NUMBER = p_visit_is_nbr
  AND    TSRSTVST_ORG_ID    = RPAD(p_visit_org_id,8);

  CURSOR c_check_trip_in_STORET(p_trip_is_nbr IN NUMBER, p_trip_org_id IN VARCHAR2) IS
     SELECT TSRSTVST_IS_NUMBER FROM TSRSTVST WHERE TSRTRIP_IS_NUMBER = p_trip_is_nbr
       AND TSRTRIP_ORG_ID = RPAD(p_trip_org_id,8);

  CURSOR c_check_trip_qc(p_trip_is_nbr IN NUMBER, p_trip_org_id IN VARCHAR2) IS
     SELECT TSRFQS_IS_NUMBER FROM TSRFQS WHERE TSRTRIP_IS_NUMBER = p_trip_is_nbr
       AND TSRTRIP_ORG_ID = RPAD(p_trip_org_id,8);

  CURSOR c_result_is_nbr (p_org_id VARCHAR2, p_activity_is NUMBER) IS
      SELECT tsrrsult_is_number, tsrrsult_org_id
        FROM tsrrsult
        WHERE tsrfdact_is_number = p_activity_is AND
             tsrfdact_org_id = RPAD(p_org_id,8);

  CURSOR c_brg_result_is_nbr (p_org_id VARCHAR2, p_activity_is NUMBER) IS
      SELECT r.tsrrsult_is_number, r.tsrrsult_org_id, r.tsrbrg_is_number, r.tsrbrg_org_id,
             r.tsrbrgi_is_number, r.tsrbrgi_org_id
        FROM tsrrsult r, tsrbrg b
       WHERE r.tsrbrg_is_number = b.tsrbrg_is_number AND
             r.tsrbrg_org_id = b.tsrbrg_org_id AND
             b.tsrfdact_is_number = p_activity_is AND
             b.tsrfdact_org_id = RPAD(p_org_id,8);

  CURSOR c_qc_result_is_nbr (p_org_id VARCHAR2, p_trip_qc_is NUMBER) IS
      SELECT tsrrsult_is_number, tsrrsult_org_id FROM tsrrsult WHERE
             tsrfqs_is_number = p_trip_qc_is AND
             tsrfqs_org_id = RPAD(p_org_id,8);

  CURSOR c_chk_storet_on_del IS
     SELECT sc_value
     FROM sim_config
     WHERE sc_item = 'CHK_STORET_ON_DEL';

  CURSOR c_result_cnt(p_import_seq IN NUMBER) IS
    SELECT count(rs_import_seq)
    FROM sim_results r, sim_field_activities f
    WHERE r.rs_import_seq = v_import_seq
    AND f.fa_seq = r.rs_fa_seq
    AND f.fa_status = 'A';

  CURSOR c_activity_cnt(p_import_seq IN NUMBER) IS
    SELECT count(fa_import_seq)
    FROM sim_field_activities
    WHERE fa_import_seq = v_import_seq
    AND fa_status = 'A';

  /*
    jah 2-18-04
    Get all STORET children of a given activity that were 
    NOT exported with the given activity. This helps to 
    determine whether removal of the given activity from
    STORET would leave any orphan child activities in STORET.
  */
  CURSOR c_get_storet_children(
      cp_is_number   IN NUMBER,
      cp_org_id      IN VARCHAR2,
      cp_export_seq  IN NUMBER) IS
    SELECT 1
    FROM   TSRFDACT, SIM_FIELD_ACTIVITIES
    WHERE  TSRFDACT0IS_NUMBER    = FA_TSRFDACT_IS_NUMBER(+)
    AND    TSRFDACT0ORG_ID       = FA_TSRFDACT_ORG_ID(+)
    AND    TSRFDACT0IS_NUMBER    IS NOT NULL
    AND    NVL(FA_EXPORT_SEQ,0)  != cp_export_seq
    AND    TSRFDACT_ORG_ID       = RPAD(cp_org_id,8)
    AND    TSRFDACT_IS_NUMBER    = cp_is_number
    UNION
    SELECT 1
    FROM   TSRFDACT, SIM_FIELD_ACTIVITIES
    WHERE  TSRFDACT_IS_NUMBER    = FA_TSRFDACT_IS_NUMBER(+)
    AND    TSRFDACT_ORG_ID       = FA_TSRFDACT_ORG_ID(+)
    AND    TSRFDACT1IS_NUMBER    = cp_is_number
    AND    TSRFDACT1ORG_ID       = RPAD(cp_org_id,8)
    AND    NVL(FA_EXPORT_SEQ,0)  != cp_export_seq;

  r_get_storet_children  c_get_storet_children%ROWTYPE;

  /*
    jah 2-18-04
    Get all SIM children of a given activity that were 
    NOT exported with the given activity. This helps to
    determine whether removal of the given activity from
    STORET would leave any orphan child activities in SIM.
  */

  CURSOR c_get_sim_children(
      cp_is_number  IN NUMBER,
      cp_org_id     IN VARCHAR2,
      cp_export_seq IN NUMBER) IS
    SELECT 1
    FROM   SIM_FIELD_ACTIVITY_PARENT, SIM_FIELD_ACTIVITIES
    WHERE  FAP_FA_SEQ           = FA_SEQ
    AND    FAP_PARENT_IS_NUMBER = cp_is_number
    AND    FAP_PARENT_ORG_ID    = RPAD(cp_org_id,8)
    AND    NVL(FA_EXPORT_SEQ,0) != cp_export_seq;
  
  r_get_sim_children  c_get_sim_children%ROWTYPE;

BEGIN

  OPEN c_chk_storet_on_del;
  FETCH c_chk_storet_on_del INTO v_chk_storet_on_del;
  CLOSE c_chk_storet_on_del;

  IF v_chk_storet_on_del IS NULL OR UPPER(v_chk_storet_on_del) = 'YES' THEN

    -- Loop through all the records in this export
    FOR v_fa_export IN c_fa_export(p_export_log_seq) LOOP

      -- Check for altered STORET child records that were not altered by SIM
      v_delete_ok := chk_if_result_delete(
        v_fa_export.TSRFDACT_IS_NUMBER,
        v_fa_export.TSRFDACT_ORG_ID,
        RPAD(v_exp_id,8),
        p_export_log_seq,
        v_fa_export.fa_activity_id
      );

      -- Did we find any altered STORET child records that were NOT altered by SIM?
      IF v_delete_ok = 'N' THEN
        -- if so
        -- Terminate the un-migrate to avoid deleting child activity records that someone else entered.
        RAISE e_no_delete;
      END IF;
      
      -- jah 2-18-04
      -- Try to find any STORET children of this activity that are NOT part of this export
      OPEN  c_get_storet_children(
        v_fa_export.TSRFDACT_IS_NUMBER, 
        v_fa_export.TSRFDACT_ORG_ID,
        p_export_log_seq);
      FETCH c_get_storet_children INTO r_get_storet_children;
      
      -- jah 2-18-04
      -- Did we find any children in STORET that are NOT part of this export?
      IF (c_get_storet_children%FOUND) THEN
        -- if yes
        -- Terminate the un-migrate because it would leave an orphan child activity in STORET
        RAISE e_storet_child;
      END IF;      
      
      CLOSE c_get_storet_children;
      
      -- jah 2-18-04
      -- Try to find any SIM child records af this activity that are NOT part of this export
      OPEN  c_get_sim_children(
        v_fa_export.TSRFDACT_IS_NUMBER, 
        v_fa_export.TSRFDACT_ORG_ID,
        p_export_log_seq);
      FETCH c_get_sim_children INTO r_get_sim_children;
      
      -- jah 2-18-04
      -- Did we find any SIM children of this activity that are NOT part of this export?
      IF (c_get_sim_children%FOUND) THEN
        -- if yes
        -- Terminate the the un-migrate because it would leave an orphan child activity in SIM.
        RAISE e_sim_child;
      END IF;

      CLOSE c_get_sim_children;
      
    END LOOP;--c_fa_export

  END IF;

  -- Loop through field activity records that have the given export log sequence number
  FOR v_fa_export IN c_fa_export(p_export_log_seq) LOOP

    -- get the IS NUMBER and ORG_ID
    v_tsrfdact_is_number := v_fa_export.tsrfdact_is_number;
    v_tsrfdact_org_id    := v_fa_export.tsrfdact_org_id;

    v_tsrfqs_is_number := v_fa_export.tsrfqs_is_number;
    v_tsrfqs_org_id := v_fa_export.tsrfqs_org_id;

    IF v_tsrfdact_is_number IS NOT NULL THEN
      
      --Delete non-brg results
      FOR v_result_is_nbr 
      IN c_result_is_nbr (v_tsrfdact_org_id, v_tsrfdact_is_number) 
      LOOP

        --Delete the Result Lab Remarks
        DELETE TSRRLRA WHERE 
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

      /* delete the tsrdql for each result*/
        DELETE TSRDQL WHERE
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

      /* delete the tsmgntxt for each result */
        DELETE TSMGNTXT WHERE
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

      /* delete the tsrcldes for each result */
        DELETE TSRCLDES WHERE
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

        -- jah 2-23-04 delete the tsrrci for each non-brg result
        DELETE TSRRCI WHERE
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

      END LOOP;
      COMMIT;

      -- Do the same thing for brg results
      FOR v_brg_result_is_nbr IN c_brg_result_is_nbr (v_tsrfdact_org_id, v_tsrfdact_is_number) LOOP

        /* delete the tsrdql for each result*/
        DELETE TSRDQL WHERE
        TSRRSULT_IS_NUMBER = v_brg_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_brg_result_is_nbr.tsrrsult_org_id,8);

        /* delete the tsmgntxt for each result */
        DELETE TSMGNTXT WHERE
        TSRRSULT_IS_NUMBER = v_brg_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_brg_result_is_nbr.tsrrsult_org_id,8);

        /* delete the tsrbrgi for each result */
        DELETE TSRBRGI WHERE
        TSRBRGI_IS_NUMBER = v_brg_result_is_nbr.tsrbrgi_is_number AND
        TSRBRGI_ORG_ID = RPAD(v_brg_result_is_nbr.tsrbrgi_org_id,8);

        /* delete the tsrbrg for each result */
        DELETE TSRBRG WHERE
        TSRBRG_IS_NUMBER = v_brg_result_is_nbr.tsrbrg_is_number AND
        TSRBRG_ORG_ID = RPAD(v_brg_result_is_nbr.tsrbrg_org_id,8);

        /* delete the tsrrci for each result */
        DELETE TSRRCI WHERE
        TSRRSULT_IS_NUMBER = v_brg_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_brg_result_is_nbr.tsrrsult_org_id,8);

        /* delete the tsrcldes for each result */
        DELETE TSRCLDES WHERE
        TSRRSULT_IS_NUMBER = v_brg_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_brg_result_is_nbr.tsrrsult_org_id,8);

        DELETE TSRRSULT WHERE
        TSRRSULT_IS_NUMBER = v_brg_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_brg_result_is_nbr.tsrrsult_org_id,8);

      END LOOP;
      COMMIT;
      
      -- Delete the Data Lines
      DELETE TSRDLIN WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
              
      /* delete the non-brg results */
      DELETE TSRRSULT WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      -- delete Field Activity PErsonnel Assignment (FAPEA)
      DELETE TSRFAPEA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      -- delete Field Activity Cooperating Organization Assignment (FACOA)
      DELETE TSRFACOA 
      WHERE  TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number 
      AND    TSRFDACT_ORG_ID    = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the sample */
      DELETE TSRSMPLE WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the trawl op detail (tod) */
      DELETE TSRTOD WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the trap/net details (tsrtnod) */
      DELETE TSRTNOD WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the actual location record */
      DELETE TSRAAL WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the field set assmt */
      DELETE TSRFAFSA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete activity, project assignment */
      DELETE TSRFAPRA WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);

      /* delete the activity */
      DELETE TSRFDACT WHERE
      TSRFDACT_IS_NUMBER = v_fa_export.tsrfdact_is_number AND
      TSRFDACT_ORG_ID = RPAD(v_fa_export.tsrfdact_org_id,8);
      
      -- jah 2-17-04
      -- Remove references to this activity in parent activities
      UPDATE TSRFDACT
      SET    TSRFDACT0IS_NUMBER = NULL,
             TSRFDACT0ORG_ID    = NULL
      WHERE  TSRFDACT0IS_NUMBER = v_fa_export.tsrfdact_is_number
      AND    TSRFDACT0ORG_ID    = RPAD(v_fa_export.tsrfdact_org_id,8);

      -- jah 2-17-04
      -- Restore SIM_FIELD_ACTIVITY_PARENT table to pre-migration state
      UPDATE SIM_FIELD_ACTIVITY_PARENT
      SET    FAP_PARENT_IS_NUMBER = NULL,
             FAP_PARENT_ORG_ID = NULL
      WHERE  FAP_PARENT_IS_NUMBER = v_fa_export.tsrfdact_is_number
      AND    FAP_PARENT_ORG_ID    = RPAD(v_fa_export.tsrfdact_org_id,8);

      -- Commit the transactions to the database
      COMMIT;

      /* 
        kms (6/11/01) - delete station visit and trip only if created by
        SIM and there are no other activities associated with them in
        either SIM or STORET.
      */

      OPEN c_get_visit_info(v_fa_export.FA_SSV_SEQ);
      FETCH c_get_visit_info INTO v_created_by,v_visit_is_nbr,v_visit_org_id;
      CLOSE c_get_visit_info;

      /*
        kms - if visit created by SIM, see if there are any other activities
        associated with it and delete if not.  Otherwise, leave the visit.
      */
      
      IF v_created_by = 1 THEN

        /* kms - if visit is not used by any other activities in STORET, delete it from STORET */
        OPEN c_check_visit_in_STORET(v_visit_is_nbr,v_visit_org_id);
        FETCH c_check_visit_in_STORET INTO v_dummy_is_nbr;
        
        -- Do other activities in STORET use this visit number?
        IF c_check_visit_in_STORET%NOTFOUND THEN
          -- if no

          /* delete field set for sta visit */
          DELETE TSRFDSET 
          WHERE  TSRSTVST_IS_NUMBER = v_visit_is_nbr 
          AND    TSRSTVST_ORG_ID = RPAD(v_visit_org_id,8);

          /* kms - delete the station visit */
          DELETE TSRSTVST 
          WHERE  TSRSTVST_IS_NUMBER = v_visit_is_nbr 
          AND    TSRSTVST_ORG_ID = v_visit_org_id;

          /*
            kms - update activities attached to this visit in SIM so they
            are no longer directly associated with a station visit in STORET.
          */
          UPDATE SIM_FIELD_ACTIVITIES
          SET    FA_TSRSTVST_IS_NUMBER = NULL,
                 FA_TSRSTVST_ORG_ID = NULL
          WHERE  FA_SSV_SEQ = v_fa_export.FA_SSV_SEQ;
          
          UPDATE SIM_STATION_VISITS
          SET    SSV_TSRSTVST_IS_NUMBER = NULL,
                 SSV_TSRSTVST_ORG_ID = NULL
          WHERE  SSV_SEQ = v_fa_export.FA_SSV_SEQ;

          /*
            kms - since we know there are no more activities on this station visit, see if there
            are more station visits on the trip and delete if not.  We don't do this when the
            visit was not created by SIM since we know there is at least station visit on it. 
          */
          OPEN c_get_trip_info(v_fa_export.FA_STP_SEQ);
          FETCH c_get_trip_info INTO v_created_by,v_trip_is_nbr,v_trip_org_id;
          CLOSE c_get_trip_info;

          IF v_created_by = 1 THEN

            OPEN c_check_trip_in_STORET(v_trip_is_nbr,v_trip_org_id);
            FETCH c_check_trip_in_STORET INTO v_dummy_is_nbr;
            IF c_check_trip_in_STORET%NOTFOUND THEN

              /*
                kms - see if there are any trip qc samples on this trip 
              */
              OPEN c_check_trip_qc(v_trip_is_nbr,v_trip_org_id);
              FETCH c_check_trip_qc INTO v_dummy_is_nbr;
              IF c_check_trip_qc%NOTFOUND THEN

                /*
                  kms - no other station visits or trip qcs on this trip, delete trip and its associations 
                */
                DELETE TSRTSA WHERE TSRTRIP_IS_NUMBER = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;
                DELETE TSRTPA WHERE TSRTRIP_IS_NUMBER  = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;
                DELETE TSRTRIP WHERE TSRTRIP_IS_NUMBER = v_trip_is_nbr AND TSRTRIP_ORG_ID = v_trip_org_id;

                /* 
                  kms - update all activities in SIM so they are no longer associated with the trip in STORET. 
                */
                UPDATE SIM_FIELD_ACTIVITIES
                SET    FA_TSRTRIP_IS_NUMBER = NULL,
                       FA_TSRTRIP_ORG_ID = NULL
                WHERE  FA_STP_SEQ = v_fa_export.FA_STP_SEQ;

                /*
                  kms - update trip in SIM so it's no longer associated with anything in STORET. 
                */
                UPDATE SIM_TRIPS
                SET    STP_TSRTRIP_IS_NUMBER = NULL,
                       STP_TSRTRIP_ORG_ID = NULL
                WHERE  STP_SEQ = v_fa_export.FA_STP_SEQ;

              END IF;
              CLOSE c_check_trip_qc;
            END IF;
            CLOSE c_check_trip_in_STORET;
          END IF;
        END IF;
        CLOSE c_check_visit_in_STORET;
      END IF;
      COMMIT;

    ELSE
      /* different set of deletes for trip qc data */
      FOR v_result_is_nbr IN c_qc_result_is_nbr (v_tsrfqs_org_id, v_tsrfqs_is_number) LOOP

        /* delete the tsrdql for each result*/
        DELETE TSRDQL WHERE
        TSRRSULT_IS_NUMBER = v_result_is_nbr.tsrrsult_is_number AND
        TSRRSULT_ORG_ID = RPAD(v_result_is_nbr.tsrrsult_org_id,8);

      END LOOP;

      COMMIT;

      /* delete the results */
      DELETE TSRRSULT WHERE
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);

      COMMIT;

      /* delete trip qc, person assignment */
      DELETE TSRFQSPA WHERE
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);

      /* delete the activity */
      DELETE TSRFQS WHERE
      TSRFQS_IS_NUMBER = v_tsrfqs_is_number AND
      TSRFQS_ORG_ID = RPAD(v_tsrfqs_org_id,8);

      COMMIT;

    END IF;

    v_import_seq := v_fa_export.fa_import_seq;
  END LOOP;

  COMMIT;
  
  UPDATE SIM_FIELD_ACTIVITIES
  SET FA_EXPORT_SEQ = NULL, FA_STATUS = 'A'
    WHERE FA_EXPORT_SEQ = p_export_log_seq;

   DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

   /* 06/06/03 SLP - Removed cursor look up to Import Log.  Deriving counts through cursors
                     at the end of the procedure.  */
   -- 12/03/02 SEF - If they deleted some stuff in STORET the counts, or if there werr no results
                   --the counts get all screwed up. So we'll cheat by going back to the beginning.
  /* 4/26/01 SNG - Update the import log with appropriate info */
  /*  06/06/03 SLP - Created new cursors to count the results and
                     activities in SIM in order to return counts to the import log. */
  OPEN c_result_cnt(v_import_seq);
    FETCH c_result_cnt INTO v_result_cnt;
  CLOSE c_result_cnt;

  OPEN c_activity_cnt(v_import_seq);
    FETCH c_activity_cnt INTO v_activity_cnt;
  CLOSE c_activity_cnt;

  UPDATE SIM_IMPORT_LOG
  SET
    SIL_ROWS_READY = v_result_cnt,                  --06/06/03 SLP: (v_rows_imported - v_rows_errors),
    SIL_EXPORTED_ON = NULL,
    SIL_ACTIVITIES_IMPORTED = v_activity_cnt        --06/06/03 SLP: SIL_ACTIVITIES_IMPORTED + v_activity_cnt
  WHERE SIL_SEQ = v_import_seq;
  COMMIT;
  
  -- return success [p_success OUT VARCHAR2]
  p_success := '1';
  
EXCEPTION

  WHEN e_storet_child THEN
    write_error(
      p_export_log_seq,
      ' -- Could not Delete Export -- Child activities in STORET would be orphaned. ' ||
      'To clear this migration, you must first delete all child activities from STORET and SIM.'
    );
    p_success := '0';
    
  WHEN e_sim_child THEN
    write_error(
      p_export_log_seq,
      ' -- Could not Delete Export -- Child activities in SIM would be orphaned. ' ||
      'To clear this migration, you must first delete all child activities from SIM.'
    );
    p_success := '0';

  WHEN e_no_delete THEN
    write_error(
      p_export_log_seq,
      ' -- Could not Delete Export -- Found Child records not created by SIM. '
    );
    p_success := '0';

  WHEN OTHERS THEN
    write_error(p_export_log_seq,SQLERRM||' - Failure in Clear_STORET_Export');
    p_success := '0';

END CLEAR_STORET_EXPORT;

/******************************************************************************************************/
PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2) IS

BEGIN

 INSERT INTO SIM_EXPORT_DETAILS (SED_SEQ , SED_SEL_SEQ, SED_DESC )
   VALUES (SIM_EXPORT_DETAILS_SEQ.NEXTVAL, p_export_seq, p_desc);

 COMMIT;

END WRITE_ERROR;

/******************************************************************************************************/
FUNCTION GET_EXPORT_LOG_SEQ RETURN NUMBER IS

   CURSOR c_export_log_seq IS select SIM_EXPORT_LOG_SEQ.NEXTVAL FROM DUAL;

   v_export_log_seq NUMBER(10);

BEGIN

   OPEN c_export_log_seq;
   FETCH c_export_log_seq INTO v_export_log_seq;
   CLOSE c_export_log_seq;

   RETURN v_export_log_seq;

  EXCEPTION
    WHEN OTHERS THEN
      write_error(v_export_seq,SQLERRM||' - in get export log seq');
END GET_EXPORT_LOG_SEQ;
/************************************************************************************************/
FUNCTION DELETE_STATION_CHILDREN(P_TSMSTATN_IS_NUMBER IN NUMBER,
                       P_TSMSTATN_ORG_ID IN VARCHAR2,p_exp_log_seq NUMBER)
 RETURN VARCHAR2 IS

   v_success       VARCHAR2(1) := 'Y';

   CURSOR c_tsmpipe_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2) IS
     SELECT tsmpipe_is_number,tsmpipe_org_id
     FROM tsmpipe
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsmpipe_tsmalp_id(P_TSMPIPE_IS_NUMBER IN NUMBER,P_TSMPIPE_ORG_ID IN VARCHAR2) IS
     SELECT tsmalp_is_number,tsmalp_org_id
     FROM tsmalp
     WHERE tsmpipe_is_number = p_tsmpipe_is_number
       AND tsmpipe_org_id = RPAD(p_tsmpipe_org_id,8);

   CURSOR c_tsmalp_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2) IS
     SELECT tsmalp_is_number,tsmalp_org_id
     FROM tsmalp
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsradl_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2) IS
     SELECT tsradl_is_number,tsradl_org_id
     FROM tsradl
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_tsmwell_id(P_TSMSTATN_IS_NUMBER IN NUMBER,P_TSMSTATN_ORG_ID IN VARCHAR2) IS
     SELECT tsmwell_is_number,tsmwell_org_id
     FROM tsmwell
     WHERE tsmstatn_is_number = p_tsmstatn_is_number
       AND tsmstatn_org_id = RPAD(p_tsmstatn_org_id,8);

   CURSOR c_interval_id(P_TSMWELL_IS_NUMBER IN NUMBER,P_TSMWELL_ORG_ID IN VARCHAR2) IS
     SELECT tsmintvl_is_number,tsmintvl_org_id,type_code
     FROM tsmintvl
     WHERE tsmwell_is_number = p_tsmwell_is_number
       AND tsmwell_org_id = RPAD(p_tsmwell_org_id,8);

   CURSOR c_tsraal_id(P_TSMALP_IS_NUMBER IN NUMBER,P_TSMALP_ORG_ID IN VARCHAR2
                      ,p_exp_log_seq NUMBER) IS
     SELECT tsrfdact_is_number,tsrfdact_org_id
     FROM tsraal
     WHERE tsmalp_is_number = p_tsmalp_is_number
       AND tsmalp_org_id = RPAD(p_tsmalp_org_id,8);


 BEGIN

  /* Delete the tsmpipe child and child records of tsmpipe */
  FOR c_tsmpipe_id_rec IN c_tsmpipe_id(P_TSMSTATN_IS_NUMBER,P_TSMSTATN_ORG_ID)
  LOOP
    FOR c_tsmpipe_tsmalp_id_rec IN c_tsmpipe_tsmalp_id(c_tsmpipe_id_rec.tsmpipe_is_number,
                                                       c_tsmpipe_id_rec.tsmpipe_org_id)
    LOOP
      DELETE tsmestlc WHERE tsmalp_is_number = c_tsmpipe_tsmalp_id_rec.tsmalp_is_number
        AND tsmalp_org_id = RPAD(c_tsmpipe_tsmalp_id_rec.tsmalp_org_id,8);

      DELETE tsmgll WHERE tsmalp_is_number = c_tsmpipe_tsmalp_id_rec.tsmalp_is_number
        AND tsmalp_org_id = RPAD(c_tsmpipe_tsmalp_id_rec.tsmalp_org_id,8);

      DELETE tsmocnlc WHERE tsmalp_is_number = c_tsmpipe_tsmalp_id_rec.tsmalp_is_number
        AND tsmalp_org_id = RPAD(c_tsmpipe_tsmalp_id_rec.tsmalp_org_id,8);

      FOR c_tsraal_id_rec IN c_tsraal_id(c_tsmpipe_tsmalp_id_rec.tsmalp_is_number,c_tsmpipe_tsmalp_id_rec.tsmalp_is_number,
                                         p_exp_log_seq)
      LOOP
        v_success := delete_result_children(c_tsraal_id_rec.tsrfdact_is_number,c_tsraal_id_rec.tsrfdact_org_id,
                               p_exp_log_seq,NULL);
      END LOOP; -- c_tsraal_id_rec
    END LOOP; --c_tsmpipe_tsmalp_id_rec
  END LOOP;--c_tsmpipe_id_rec

   DELETE tsmpipe WHERE tsmstatn_is_number = P_TSMSTATN_IS_NUMBER
     AND tsmstatn_org_id = RPAD(P_TSMSTATN_ORG_ID,8);
  /* End tsmpipe delete */


-- Delete the TSMALP table and children
   FOR c_tsmalp_id_rec IN c_tsmalp_id(P_TSMSTATN_IS_NUMBER,P_TSMSTATN_ORG_ID)
   LOOP
     DELETE tsmestlc WHERE tsmalp_is_number = c_tsmalp_id_rec.tsmalp_is_number
       AND tsmalp_org_id = RPAD(c_tsmalp_id_rec.tsmalp_org_id,8);

     DELETE tsmgll WHERE tsmalp_is_number = c_tsmalp_id_rec.tsmalp_is_number
       AND tsmalp_org_id = RPAD(c_tsmalp_id_rec.tsmalp_org_id,8);

     DELETE tsmocnlc WHERE tsmalp_is_number = c_tsmalp_id_rec.tsmalp_is_number
       AND tsmalp_org_id = RPAD(c_tsmalp_id_rec.tsmalp_org_id,8);

     FOR c_tsraal_id_rec IN c_tsraal_id(c_tsmalp_id_rec.tsmalp_is_number,c_tsmalp_id_rec.tsmalp_is_number,
                                        p_exp_log_seq)
     LOOP
       v_success := delete_result_children(c_tsraal_id_rec.tsrfdact_is_number,c_tsraal_id_rec.tsrfdact_org_id,
                              p_exp_log_seq,NULL);

     END LOOP; -- c_tsraal_id_rec
   END LOOP;--c_tsmalp_id_rec

   DELETE tsmalp WHERE tsmstatn_is_number = P_TSMSTATN_IS_NUMBER
     AND tsmstatn_org_id = RPAD(P_TSMSTATN_ORG_ID,8);
   /* End tsmalp delete */


-- Delete the TSRADL table and children
   FOR c_tsradl_id_rec IN c_tsradl_id(P_TSMSTATN_IS_NUMBER,P_TSMSTATN_ORG_ID)
   LOOP
     DELETE tsropprd WHERE tsradl_is_number = c_tsradl_id_rec.tsradl_is_number
       AND tsradl_org_id = RPAD(c_tsradl_id_rec.tsradl_org_id,8);
   END LOOP;--c_tsradl_id_rec

   DELETE tsradl WHERE tsmstatn_is_number = P_TSMSTATN_IS_NUMBER
       AND tsmstatn_org_id = RPAD(P_TSMSTATN_ORG_ID,8);
   /* End tsradl delete */


-- Delete the tsmwell table and children
   FOR c_tsmwell_id_rec IN c_tsmwell_id(P_TSMSTATN_IS_NUMBER,P_TSMSTATN_ORG_ID)
   LOOP
     DELETE tsmaddr WHERE tsmwell_is_number = c_tsmwell_id_rec.tsmwell_is_number
       AND tsmwell_org_id = RPAD(c_tsmwell_id_rec.tsmwell_org_id,8);

     DELETE tsmlog WHERE tsmwell_is_number = c_tsmwell_id_rec.tsmwell_is_number
       AND tsmwell_org_id = RPAD(c_tsmwell_id_rec.tsmwell_org_id,8);

     DELETE tsmpump WHERE tsmwell_is_number = c_tsmwell_id_rec.tsmwell_is_number
       AND tsmwell_org_id = RPAD(c_tsmwell_id_rec.tsmwell_org_id,8);

     DELETE tsmwle WHERE tsmwell_is_number = c_tsmwell_id_rec.tsmwell_is_number
       AND tsmwell_org_id = RPAD(c_tsmwell_id_rec.tsmwell_org_id,8);

-- Delete the tsmintvl children
     FOR c_interval_id_rec IN c_interval_id(c_tsmwell_id_rec.tsmwell_is_number,c_tsmwell_id_rec.tsmwell_org_id)
     LOOP
       DELETE tsmcsng WHERE tsmintvl_is_number = c_interval_id_rec.tsmintvl_is_number
           AND tsmintvl_org_id = RPAD(c_interval_id_rec.tsmintvl_org_id,8);
       DELETE tsmfill WHERE tsmintvl_is_number = c_interval_id_rec.tsmintvl_is_number
           AND tsmintvl_org_id = RPAD(c_interval_id_rec.tsmintvl_org_id,8);
       DELETE tsmhole WHERE tsmintvl_is_number = c_interval_id_rec.tsmintvl_is_number
           AND tsmintvl_org_id = RPAD(c_interval_id_rec.tsmintvl_org_id,8);
       DELETE tsmigua WHERE tsmintvl_is_number = c_interval_id_rec.tsmintvl_is_number
           AND tsmintvl_org_id = RPAD(c_interval_id_rec.tsmintvl_org_id,8);
       DELETE tsmopng WHERE tsmintvl_is_number = c_interval_id_rec.tsmintvl_is_number
           AND tsmintvl_org_id = RPAD(c_interval_id_rec.tsmintvl_org_id,8);
     END LOOP;--c_interval_id_rec

     DELETE tsmintvl WHERE tsmwell_is_number = c_tsmwell_id_rec.tsmwell_is_number
       AND tsmwell_org_id = RPAD(c_tsmwell_id_rec.tsmwell_org_id,8);


   END LOOP;--c_tsmwell_id_rec

   DELETE tsmwell WHERE tsmstatn_is_number = P_TSMSTATN_IS_NUMBER
       AND tsmstatn_org_id = RPAD(P_TSMSTATN_ORG_ID,8);
   /* End tsmwell delete */

   /* Delete Facility record*/
   DELETE tsmfclty WHERE tsmstatn_is_number = P_TSMSTATN_IS_NUMBER
       AND tsmstatn_org_id = RPAD(P_TSMSTATN_ORG_ID,8);

   COMMIT;
   RETURN('Y');
 EXCEPTION
  WHEN OTHERS THEN
    write_error(v_export_seq,SQLERRM||' - in DELETE_STATION_CHILDREN');
    RETURN('N');

END DELETE_STATION_CHILDREN;
/******************************************************************************************************/
PROCEDURE clear_station_export (p_export_log_seq IN NUMBER,p_success OUT VARCHAR2) IS

   CURSOR c_export_org (p_export_log_seq IN NUMBER) IS
     SELECT sel_org_id FROM sim_export_log WHERE sel_seq = p_export_log_seq;

   CURSOR c_stations (p_export_log_seq IN NUMBER) IS
     SELECT sta_is_number, sta_tsmorgan_org_id, sta_import_seq
     FROM sim_stations WHERE sta_export_seq = p_export_log_seq;

   CURSOR c_abs_loc_point (p_sta_is_number IN NUMBER, p_org_id IN VARCHAR2) IS
     SELECT tsmalp_is_number, tsmalp_org_id
     FROM tsmalp WHERE tsmstatn0is_number = p_sta_is_number
                 AND   tsmstatn0org_id    = RPAD(p_org_id, 8);

   CURSOR c_statn_visit (p_export_log_seq IN NUMBER) IS
     SELECT s.sta_name FROM sim_stations s, tsrstvst v
     WHERE s.sta_is_number = v.tsmstatn_is_number
     AND   rpad(s.sta_tsmorgan_org_id,8) = v.tsmstatn_org_id
     AND   s.sta_export_seq = p_export_log_seq;

   CURSOR c_well_on_station (p_export_log_seq IN NUMBER) IS
     SELECT w.NAME
     FROM TSMWELL w, TSMSTATN s, SIM_STATIONS ss, SIM_STATION_WELLS sw
     WHERE w.TSMSTATN_IS_NUMBER = s.TSMSTATN_IS_NUMBER
     AND w.TSMSTATN_ORG_ID = s.TSMSTATN_ORG_ID
     AND ss.STA_IS_NUMBER = s.TSMSTATN_IS_NUMBER
     AND ss.STA_ORG_ID = s.tsmstatn_org_id
     AND ss.STA_EXPORT_SEQ = p_export_log_seq
     AND sw.SSW_STA_SEQ = ss.STA_SEQ
     AND NVL(sw.SSW_EXPORT_SEQ,p_export_log_seq) <> p_export_log_seq;

   CURSOR c_tsmalp_id(p_export_log_seq NUMBER) IS
     SELECT type_code,sta_name
     FROM tsmalp,sim_stations ss
     WHERE tsmstatn_is_number = ss.sta_is_number
       AND tsmstatn_org_id = RPAD(ss.sta_org_id,8)
       AND ss.sta_export_seq = p_export_log_seq;

   CURSOR c_well (p_station_is_nbr IN NUMBER) IS
     SELECT tsmwell_is_number, tsmwell_org_id FROM tsmwell
     WHERE tsmstatn_is_number = p_station_is_nbr;

   CURSOR c_chk_storet_on_del IS
     SELECT sc_value
     FROM sim_config
     WHERE sc_item = 'CHK_STORET_ON_DEL';

   v_org_id               VARCHAR2(8);
   v_station_cnt          NUMBER(10)  := 0;
   v_import_seq           NUMBER(10);
   v_station              VARCHAR2(60);
   v_well_on_station      VARCHAR2(60);
   v_station_child_delete VARCHAR2(1);
   e_VisitsFound          EXCEPTION;
   v_chk_storet_on_del    VARCHAR2(5);
   v_delete_ok            VARCHAR2(1);
   v_exp_id               VARCHAR2(80) := sim2_export_pkg.v_pkg_ownerid;

   e_no_delete            EXCEPTION;
   e_child_delete_error   EXCEPTION;

BEGIN

  /* bka - Check to make sure that no stations from this migration already have visits assigned to them in STORET */
  OPEN c_statn_visit(p_export_log_seq);
    FETCH c_statn_visit INTO v_station;
    IF c_statn_visit%FOUND THEN
      WRITE_ERROR(p_export_log_seq,
        'Error: Station '||v_station||' has station visits assigned to it.  This migration cannot be removed from STORET');
      RAISE e_VisitsFound;
    END IF;
  CLOSE c_statn_visit;

  OPEN c_well_on_station(p_export_log_seq);
    FETCH c_well_on_station INTO v_well_on_station;
    IF c_well_on_station%FOUND THEN
      WRITE_ERROR(p_export_log_seq,
        'Error: Station has at least one well, '||rtrim(v_well_on_station)||', assigned to it. Please remove WELLS migration from STORET first.');
      RAISE e_VisitsFound;
    END IF;
  CLOSE c_well_on_station;

  FOR c_tsmalp_id_rec IN c_tsmalp_id(p_export_log_seq)
  LOOP
    IF c_tsmalp_id_rec.type_code <> '*POINT OF RECORD' THEN
      WRITE_ERROR(p_export_log_seq,
        'Error: Station '||c_tsmalp_id_rec.sta_name||' has at least one Location other than *POINT OF RECORD, assigned to it. Please remove Location migration from STORET first.');
      RAISE e_VisitsFound;
    END IF;
  END LOOP;

  OPEN c_chk_storet_on_del;
    FETCH c_chk_storet_on_del INTO v_chk_storet_on_del;
  CLOSE c_chk_storet_on_del;

  IF v_chk_storet_on_del IS NULL OR UPPER(v_chk_storet_on_del) = 'YES' THEN
    /* Check if there are any child records that have not been exported by SIM */
    FOR v_stations IN c_stations(p_export_log_seq) LOOP
      v_delete_ok := chk_if_station_delete(v_stations.sta_is_number,
                            v_stations.sta_tsmorgan_org_id,v_exp_id,p_export_log_seq);

      IF v_delete_ok = 'N' THEN
        RAISE e_no_delete;
      END IF;
    END LOOP; -- v_stations
  END IF;

  /* Get the org id, so can pass to seq update process */
  OPEN c_export_org(p_export_log_seq);
    FETCH c_export_org INTO v_org_id;
  CLOSE c_export_org;

  FOR v_stations IN c_stations(p_export_log_seq) LOOP

      v_station_child_delete := DELETE_STATION_CHILDREN(v_stations.sta_is_number,
                              v_stations.sta_tsmorgan_org_id,p_export_log_seq);


      IF v_station_child_delete = 'N' THEN
        RAISE e_child_delete_error;
      END IF;

    FOR v_well IN c_well(v_stations.sta_is_number) LOOP

      DELETE TSMWELL WHERE TSMWELL_IS_NUMBER = v_well.TSMWELL_IS_NUMBER
                       AND TSMWELL_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);

      UPDATE SIM_STATION_WELLS
        SET SSW_STATUS = 'A', SSW_IS_NUMBER = NULL, SSW_ORG_ID = NULL
        WHERE SSW_IS_NUMBER = v_well.TSMWELL_IS_NUMBER
        AND SSW_ORG_ID = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);

    END LOOP;

    /* delete ocean, lake, and estuary location data associated with migrated stations */
    FOR v_abs_loc_point IN c_abs_loc_point(v_stations.sta_is_number, v_stations.sta_tsmorgan_org_id) LOOP
      DELETE TSMOCNLC WHERE TSMALP_ORG_ID    = RPAD(V_ABS_LOC_POINT.TSMALP_ORG_ID, 8)
                        AND TSMALP_IS_NUMBER = V_ABS_LOC_POINT.TSMALP_IS_NUMBER;
      DELETE TSMESTLC WHERE TSMALP_ORG_ID    = RPAD(V_ABS_LOC_POINT.TSMALP_ORG_ID, 8)
                        AND TSMALP_IS_NUMBER = V_ABS_LOC_POINT.TSMALP_IS_NUMBER;
      DELETE TSMGLL WHERE TSMALP_ORG_ID    = RPAD(V_ABS_LOC_POINT.TSMALP_ORG_ID, 8)
                        AND TSMALP_IS_NUMBER = V_ABS_LOC_POINT.TSMALP_IS_NUMBER;

    END LOOP;

    DELETE TSMALP   WHERE TSMSTATN0ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8)
                      AND TSMSTATN0IS_NUMBER = V_STATIONS.STA_IS_NUMBER;
    DELETE TSMSTATN WHERE TSMSTATN_IS_NUMBER = V_STATIONS.STA_IS_NUMBER
                      AND TSMSTATN_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);
    DELETE TSMPSA   WHERE TSMSTATN_IS_NUMBER = V_STATIONS.STA_IS_NUMBER
                      AND TSMSTATN_ORG_ID    = RPAD(V_STATIONS.STA_TSMORGAN_ORG_ID, 8);

    /* get the import seq from the first record, use for changing the count
       of records that have been exported in the import log SNG 4/26/01*/
    IF v_station_cnt = 0 THEN
       v_import_seq := v_stations.sta_import_seq;
    END IF;

    v_station_cnt := v_station_cnt + 1;

    COMMIT;

  END LOOP;

  UPDATE SIM_STATIONS
    SET STA_EXPORT_SEQ = NULL, STA_STATUS = 'A', STA_IS_NUMBER = NULL
    WHERE STA_EXPORT_SEQ = p_export_log_seq;


  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE  SIM_IMPORT_LOG
    SET   SIL_ROWS_READY  = SIL_ROWS_READY + v_station_cnt,
          SIL_EXPORTED_ON = NULL
    WHERE SIL_SEQ = v_import_seq;

  COMMIT;
  p_success := '1';
EXCEPTION
  WHEN e_VisitsFound THEN
    p_success := '0';
    RAISE;
  WHEN OTHERS THEN
    WRITE_ERROR(p_export_log_seq,SQLERRM||' - in Clear_station_export');
    p_success := '0';

END CLEAR_STATION_EXPORT;

/******************************************************************************************************/
PROCEDURE clear_well_export (p_export_log_seq IN NUMBER) IS

   CURSOR c_export_org (p_export_log_seq IN NUMBER) IS
     SELECT sel_org_id FROM sim_export_log WHERE sel_seq = p_export_log_seq;

   CURSOR c_well (p_export_log_seq IN NUMBER) IS
     SELECT ssw_seq, ssw_is_number, ssw_org_id, ssw_import_seq FROM sim_station_wells
     WHERE  ssw_export_seq = p_export_log_seq;

   v_org_id      VARCHAR2(8);
   v_well_cnt    NUMBER(10)  := 0;
   v_import_seq  NUMBER(10);
   v_well        VARCHAR2(60);
   e_VisitsFound EXCEPTION;

BEGIN

  /* Get the org id, so can pass to seq update process */
  OPEN c_export_org(p_export_log_seq);
    FETCH c_export_org INTO v_org_id;
  CLOSE c_export_org;

  FOR v_well IN c_well(p_export_log_seq) LOOP
    DELETE TSMALP WHERE TSMWELL_IS_NUMBER = v_well.SSW_IS_NUMBER
                   AND TSMWELL_ORG_ID    = RPAD(v_well.SSW_ORG_ID, 8);
    DELETE TSMWELL WHERE TSMWELL_IS_NUMBER = v_well.SSW_IS_NUMBER
                   AND TSMWELL_ORG_ID    = RPAD(v_well.SSW_ORG_ID, 8);

    UPDATE SIM_STATION_WELLS
        SET SSW_STATUS = 'A', SSW_IS_NUMBER = NULL, SSW_ORG_ID = NULL
        WHERE SSW_IS_NUMBER = v_well.SSW_IS_NUMBER
        AND SSW_ORG_ID = RPAD(V_well.SSW_ORG_ID, 8);

    UPDATE SIM_STATION_LOCATIONS
        SET STL_TSMWELL_IS_NUMBER = NULL,
        STL_TSMWELL_ORG_ID = NULL
        WHERE STL_SSW_SEQ = v_well.SSW_SEQ;

    /* get the import seq from the first record, use for changing the count
       of records that have been exported in the import log SNG 4/26/01*/
    IF v_well_cnt = 0 THEN
       v_import_seq := v_well.ssw_import_seq;
    END IF;

    v_well_cnt := v_well_cnt + 1;
    IF v_well_cnt = 100 THEN
      COMMIT;
    END IF;
  END LOOP;


  UPDATE SIM_STATION_WELLS
    SET SSW_EXPORT_SEQ = NULL, SSW_STATUS = 'A', SSW_IS_NUMBER = NULL
    WHERE SSW_EXPORT_SEQ = p_export_log_seq;


  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE  SIM_IMPORT_LOG
     SET  SIL_ROWS_READY  = SIL_ROWS_READY + v_well_cnt,
          SIL_EXPORTED_ON = NULL
    WHERE SIL_SEQ = v_import_seq;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    WRITE_ERROR(p_export_log_seq,SQLERRM||' - in Clear_well_export');

END CLEAR_WELL_EXPORT;

/******************************************************************************************************/
PROCEDURE clear_location_export (p_export_log_seq IN NUMBER) IS

   CURSOR c_export_org (p_export_log_seq IN NUMBER) IS
     SELECT sel_org_id FROM sim_export_log WHERE sel_seq = p_export_log_seq;

   CURSOR c_location (p_export_log_seq IN NUMBER) IS
     SELECT stl_seq, stl_is_number, stl_org_id, stl_import_seq FROM sim_station_locations
     WHERE  stl_status = 'E'
     AND stl_export_seq = p_export_log_seq;

   v_org_id          VARCHAR2(8);
   v_location_cnt    NUMBER(10)  := 0;
   v_import_seq      NUMBER(10);

BEGIN

  /* Get the org id, so can pass to seq update process */
  OPEN c_export_org(p_export_log_seq);
    FETCH c_export_org INTO v_org_id;
  CLOSE c_export_org;

  FOR v_location IN c_location(p_export_log_seq) LOOP

    DELETE TSMALP WHERE TSMALP_IS_NUMBER = v_location.stl_IS_NUMBER
                   AND TSMALP_ORG_ID    = RPAD(v_location.Stl_ORG_ID, 8);

    UPDATE SIM_STATION_LOCATIONS
        SET STL_IS_NUMBER = NULL,
        STL_ORG_ID = NULL
        WHERE STL_SEQ = v_location.Stl_SEQ;

    /* get the import seq from the first record, use for changing the count
       of records that have been exported in the import log SNG 4/26/01*/
    IF v_location_cnt = 0 THEN
       v_import_seq := v_location.stl_import_seq;
    END IF;

    v_location_cnt := v_location_cnt + 1;
    IF v_location_cnt = 100 THEN
      COMMIT;
    END IF;
  END LOOP;


  UPDATE SIM_STATION_LOCATIONS
    SET STL_EXPORT_SEQ = NULL, STL_STATUS = 'A'
    WHERE STL_EXPORT_SEQ = p_export_log_seq;


  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE  SIM_IMPORT_LOG
     SET  SIL_ROWS_READY  = SIL_ROWS_READY + v_location_cnt,
          SIL_EXPORTED_ON = NULL
    WHERE SIL_SEQ = v_import_seq;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    WRITE_ERROR(p_export_log_seq,SQLERRM||' - in Clear_location_export');

END CLEAR_LOCATION_EXPORT;

/******************************************************************************************************/
PROCEDURE clear_project_export (p_export_log_seq IN NUMBER) IS

   v_tsmproj_org_id    VARCHAR2(8);
   v_project_cnt       NUMBER(10) := 0;
   v_import_seq        NUMBER(10);

   CURSOR c_project_export(p_export_log_seq NUMBER) IS
      SELECT SPJ_TSMPROJ_IS_NUMBER TSMPROJ_IS_NUMBER,
       SPJ_TSMPROJ_ORG_ID TSMPROJ_ORG_ID,
       spj_import_seq
      FROM SIM_PROJECTS WHERE SPJ_EXPORT_SEQ = p_export_log_seq;


BEGIN

  FOR v_project_export IN c_project_export(p_export_log_seq) LOOP

    v_tsmproj_org_id := v_project_export.tsmproj_org_id;

    /* delete the tsmgntxt for each project record */
    DELETE TSMGNTXT WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    /* delete project, station association */
    DELETE TSMPSA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    /* delete project, person association */
    DELETE TSMPPA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    /* delete project, person, role association */
    DELETE TSMPPRA WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    /* delete the project */
    DELETE TSMPROJ WHERE
      TSMPROJ_IS_NUMBER = v_project_export.tsmproj_is_number AND
      TSMPROJ_ORG_ID = RPAD(v_project_export.tsmproj_org_id,8);

    COMMIT;

    /* get the import seq from the first record, use for changing the count
       of records that have been exported in the import log sng 4/26/01*/
    IF v_project_cnt = 0 THEN
      v_import_seq := v_project_export.spj_import_seq;
    END IF;

    v_project_cnt := v_project_cnt + 1;

  END LOOP;

  UPDATE SIM_PROJECTS
    SET SPJ_EXPORT_SEQ = NULL, SPJ_STATUS = 'A'
    WHERE SPJ_EXPORT_SEQ = p_export_log_seq;


  DELETE SIM_EXPORT_DETAILS WHERE SED_SEL_SEQ = p_export_log_seq;
  DELETE SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

  /* update the import log with appropriate info sng 4/26/01 */
  UPDATE SIM_IMPORT_LOG
  SET
  SIL_ROWS_READY = SIL_ROWS_READY + v_project_cnt,
  SIL_EXPORTED_ON = NULL
  WHERE SIL_SEQ = v_import_seq;


  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    WRITE_ERROR(p_export_log_seq,SQLERRM||' - in Clear_project_export');
END clear_project_export;

/******************************************************************************************************/
FUNCTION CLEAR_EXPORT (p_export_log_seq IN NUMBER) RETURN NUMBER IS

   CURSOR c_export (p_export_log_seq IN NUMBER) IS
       SELECT SEL_EXPORT_TYPE FROM SIM_EXPORT_LOG WHERE SEL_SEQ = p_export_log_seq;

   v_export_type VARCHAR2(4);
   v_success     VARCHAR2(1) := 1;

BEGIN
   v_export_seq := p_export_log_seq;

   OPEN c_export (p_export_log_seq);
   FETCH c_export INTO v_export_type;
   CLOSE c_export;

   IF v_export_type = 'S' OR v_export_type = 'WS' THEN
     CLEAR_STATION_EXPORT(p_export_log_seq,v_success);
   ELSIF v_export_type = 'W' THEN
     CLEAR_WELL_EXPORT(p_export_log_seq);
   ELSIF v_export_type = 'L' THEN
     CLEAR_LOCATION_EXPORT(p_export_log_seq);
   ELSIF v_export_type = 'P' THEN
     CLEAR_PROJECT_EXPORT(p_export_log_seq);
   ELSIF (v_export_type = 'R') 
     OR (v_export_type = 'B') 
     OR (v_export_type = 'XR') 
     OR (v_export_type = 'WR') THEN
     CLEAR_STORET_EXPORT(P_EXPORT_LOG_SEQ,v_success);
   END IF;

   RETURN (v_success);

EXCEPTION
  WHEN OTHERS THEN
    WRITE_ERROR(
      p_export_log_seq,
      SQLERRM || ' - in CLEAR_EXPORT.'
    );
    RETURN 0;

END CLEAR_EXPORT;

/******************************************************************************************************/
FUNCTION get_file_type(p_path IN VARCHAR2) RETURN VARCHAR2 IS

BEGIN

  IF p_path IS NULL then
    return null;
  END IF;
  
  RETURN upper(substr(p_path, length(p_path) - 2));

END get_file_type;

/******************************************************************************************************/
FUNCTION get_file_name(p_path IN VARCHAR2) RETURN VARCHAR2 IS

BEGIN

  IF p_path IS NULL then
    return null;
  END IF;

  RETURN upper(substr(p_path, 1, length(p_path) - 4));
 
END get_file_name;

/******************************************************************************************************/

END SIM2_EXPORT_PKG;
/
