CREATE OR REPLACE PACKAGE SIM_INTERFACE_EXTRAS_PKG IS

  -- Author  : TERRYJ
  -- Created : 9/24/2003 7:24:33 AM
  -- Purpose : This will contain code used by SIM's Client Server Interface
  
  TYPE T_STORET_PK_TYPE IS RECORD(
    IS_NUMBER NUMBER(12),
    ORG_ID    VARCHAR2(8));
      
  -- Public function and procedure declarations
  FUNCTION column_value_max_length(p_col IN VARCHAR2,
                                   p_tab IN VARCHAR2) RETURN NUMBER;
                                   
  FUNCTION RETURN_TRANS (p_sic_seq IN NUMBER,p_st_is_number IN NUMBER,
                         p_st_org_id IN VARCHAR2,p_org_id IN VARCHAR2) RETURN VARCHAR2;
                         
  FUNCTION RETURN_TRANS_PK (p_sic_seq IN NUMBER,p_st_code IN VARCHAR2
                            ,p_org_id IN VARCHAR2) RETURN T_STORET_PK_TYPE;
                            
  FUNCTION CHECK_TRANS_CODE (p_sic_seq IN NUMBER,p_st_code IN VARCHAR2,
                             p_org_id IN VARCHAR2) RETURN VARCHAR2;                            

END SIM_INTERFACE_EXTRAS_PKG;
/
CREATE OR REPLACE PACKAGE BODY SIM_INTERFACE_EXTRAS_PKG IS

  -- Function and procedure implementations

FUNCTION column_value_max_length(p_col IN VARCHAR2,
                                 p_tab IN VARCHAR2)
 RETURN NUMBER IS
  /*  Purpose : This function returns the length of the longest 
  		value for the table and column passed in.  
  */

  v_tab          VARCHAR2(80) := p_tab;
  v_col          VARCHAR2(80) := p_col;
  v_len          NUMBER;
  
  TYPE LEN_CURSOR_TYPE IS REF CURSOR;
  len_cursor           len_cursor_type;
  v_select_txt    VARCHAR2(200);
           
        
BEGIN
     v_select_txt := 'SELECT MAX(LENGTH('||v_col||')) FROM '
		                 ||v_tab;
     OPEN len_cursor FOR v_select_txt;
     FETCH len_cursor INTO v_len;
	   CLOSE len_cursor;
     v_len := (v_len / 14) + .25;

  RETURN(v_len);
END column_value_max_length;
/***********************************************************************/
FUNCTION RETURN_TRANS (p_sic_seq IN NUMBER,p_st_is_number IN NUMBER,p_st_org_id IN VARCHAR2,p_org_id IN VARCHAR2)
  RETURN VARCHAR2 IS

  v_sic_seq          NUMBER(10) := p_sic_seq;
  v_table_name       VARCHAR2(80);
  v_column_name      VARCHAR2(80);
  v_converted_item   VARCHAR2(80);
  v_comma_pos        NUMBER(10);   
  v_dyna_cursor      VARCHAR2(500);  
  v_st_is_number     NUMBER(12)  := p_st_is_number;
  v_st_org_id        VARCHAR2(8)  := p_st_org_id;  
  v_org_id           VARCHAR2(8) := p_org_id;
  v_constraint       VARCHAR2(254);
  v_org_restrict     NUMBER(1);
  
  TYPE SORT_CURSOR_TYPE IS REF CURSOR;
  sort_cursor            sort_cursor_type;  
  
  CURSOR c_imp_cols(p_seq NUMBER) IS
    SELECT sic_storet_tab,sic_storet_col,sic_storet_constraint,sic_org_restricted
      FROM sim_imp_cols
      WHERE sic_seq = p_seq;  
      
BEGIN

  IF v_st_is_number IS NOT NULL THEN
    OPEN c_imp_cols(v_sic_seq);
      FETCH c_imp_cols INTO v_table_name,v_column_name,v_constraint,v_org_restrict;
    CLOSE c_imp_cols;    

    v_comma_pos := INSTR(v_column_name,',');
    IF v_comma_pos > 0 THEN
      v_column_name := SUBSTR(v_column_name,1,INSTR(v_column_name,',')-1);  
    END IF;
    
	  IF v_org_restrict IS NOT NULL AND v_constraint IS NOT NULL THEN
      v_constraint := ' AND '||v_constraint||' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_org_restrict IS NOT NULL THEN
	    v_constraint := ' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_constraint IS NOT NULL THEN
	    v_constraint := ' AND '||v_constraint;
	  END IF; 
        
    IF v_table_name = 'TSMPERSN' THEN
      /*The Personnel name needs to have the last and first name conncatinated */
      v_dyna_cursor := 'SELECT '||v_column_name||'||'' ''||FIRST_NAME'||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_table_name||'_IS_NUMBER = '||v_st_is_number||
                       ' AND '||v_table_name||'_ORG_ID = '''||v_st_org_id||''''||v_constraint; 
    ELSE                              
      v_dyna_cursor := 'SELECT '||v_column_name||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_table_name||'_IS_NUMBER = '||v_st_is_number||
                       ' AND '||v_table_name||'_ORG_ID = '''||v_st_org_id||''''||v_constraint;  
    END IF;     

    OPEN sort_cursor FOR v_dyna_cursor;
      FETCH sort_cursor INTO v_converted_item;
    CLOSE sort_cursor;   
  END IF;
                    
  RETURN(v_converted_item);
END RETURN_TRANS;
/***********************************************************************/
FUNCTION RETURN_TRANS_PK (p_sic_seq IN NUMBER,p_st_code IN VARCHAR2,p_org_id IN VARCHAR2)
  RETURN T_STORET_PK_TYPE IS

  v_sic_seq          NUMBER(10) := p_sic_seq;
  v_table_name       VARCHAR2(80);
  v_column_name      VARCHAR2(80);
  v_comma_pos        NUMBER(10);   
  v_dyna_cursor      VARCHAR2(500);  
  v_storet_pk        SIM_INTERFACE_EXTRAS_PKG.T_STORET_PK_TYPE;  
  v_constraint       VARCHAR2(254);
  v_org_restrict     NUMBER(1);
  v_org_id           VARCHAR2(8) := p_org_id;  
  
  TYPE SORT_CURSOR_TYPE IS REF CURSOR;
  sort_cursor            sort_cursor_type;  
  
  CURSOR c_imp_cols(p_seq NUMBER) IS
    SELECT sic_storet_tab,sic_storet_col,sic_storet_constraint,sic_org_restricted
      FROM sim_imp_cols
      WHERE sic_seq = p_seq;  
      
BEGIN

  IF p_st_code IS NOT NULL THEN
    OPEN c_imp_cols(v_sic_seq);
      FETCH c_imp_cols INTO v_table_name,v_column_name,v_constraint,v_org_restrict;
    CLOSE c_imp_cols;    

    v_comma_pos := INSTR(v_column_name,',');
    IF v_comma_pos > 0 THEN
      v_column_name := SUBSTR(v_column_name,1,INSTR(v_column_name,',')-1);  
    END IF;
    
	  IF v_org_restrict IS NOT NULL AND v_constraint IS NOT NULL THEN
      v_constraint := ' AND '||v_constraint||' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_org_restrict IS NOT NULL THEN
	    v_constraint := ' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_constraint IS NOT NULL THEN
	    v_constraint := ' AND '||v_constraint;
	  END IF; 
        
    IF v_table_name = 'TSMPERSN' THEN
      /*The Personnel name needs to have the last and first name conncatinated */
      v_dyna_cursor := 'SELECT '||v_table_name||'_IS_NUMBER, '||v_table_name||'_ORG_ID '||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_column_name||'||'' ''||FIRST_NAME = '''||p_st_code||''''||v_constraint;
    ELSE                              
      v_dyna_cursor := 'SELECT '||v_table_name||'_IS_NUMBER, '||v_table_name||'_ORG_ID '||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_column_name||' = '''||p_st_code||''''||v_constraint;  
    END IF;     
              
    OPEN sort_cursor FOR v_dyna_cursor;
      FETCH sort_cursor INTO v_storet_pk.is_number,v_storet_pk.org_id;
    CLOSE sort_cursor;   
  END IF;
                    
  RETURN(v_storet_pk);
END RETURN_TRANS_PK;
/***********************************************************************/
FUNCTION CHECK_TRANS_CODE (p_sic_seq IN NUMBER,p_st_code IN VARCHAR2,p_org_id IN VARCHAR2)
  RETURN VARCHAR2 IS

  v_sic_seq          NUMBER(10) := p_sic_seq;
  v_table_name       VARCHAR2(80);
  v_column_name      VARCHAR2(80);
  v_converted_item   VARCHAR2(80);
  v_comma_pos        NUMBER(10);   
  v_dyna_cursor      VARCHAR2(500);  
  v_constraint       VARCHAR2(254);
  v_org_restrict     NUMBER(1);
  v_org_id           VARCHAR2(8) := p_org_id;

  TYPE SORT_CURSOR_TYPE IS REF CURSOR;
  sort_cursor            sort_cursor_type;  
  
  CURSOR c_imp_cols(p_seq NUMBER) IS
    SELECT sic_storet_tab,sic_storet_col,sic_storet_constraint,sic_org_restricted
      FROM sim_imp_cols
      WHERE sic_seq = p_seq;  
    
BEGIN
  
  IF p_st_code IS NOT NULL THEN
    OPEN c_imp_cols(v_sic_seq);
      FETCH c_imp_cols INTO v_table_name,v_column_name,v_constraint,v_org_restrict;
    CLOSE c_imp_cols;    

    v_comma_pos := INSTR(v_column_name,',');
    IF v_comma_pos > 0 THEN
      v_column_name := SUBSTR(v_column_name,1,INSTR(v_column_name,',')-1);  
    END IF;

	  IF v_org_restrict IS NOT NULL AND v_constraint IS NOT NULL THEN
      v_constraint := ' AND '||v_constraint||' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_org_restrict IS NOT NULL THEN
	    v_constraint := ' AND '||v_table_name||'_ORG_ID = RPAD('''||v_org_id||''',8)';
	  ELSIF v_constraint IS NOT NULL THEN
	    v_constraint := ' AND '||v_constraint;
	  END IF;     
                      
    IF v_constraint IS NOT NULL THEN                      
      v_dyna_cursor := 'SELECT DISTINCT '||v_column_name||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_column_name||' = '''||p_st_code||''''||v_constraint;
    ELSE
      v_dyna_cursor := 'SELECT DISTINCT '||v_column_name||
                       ' FROM '||v_table_name||
                       ' WHERE '||v_column_name||' = '''||p_st_code||''''||v_constraint;                       
    END IF;
    
            
    OPEN sort_cursor FOR v_dyna_cursor;
      FETCH sort_cursor INTO v_converted_item;
    CLOSE sort_cursor;   
  END IF;
               
  RETURN(v_converted_item);
END CHECK_TRANS_CODE;
/**************************************************************************************/
END SIM_INTERFACE_EXTRAS_PKG;
/
