CREATE OR REPLACE VIEW sim_field_activities_vw AS
SELECT stp.stp_trip_id,
       sta.identification_cd sta_id,
       sta.NAME sta_name,
       ssv.ssv_id,
       decode(fa.fa_status, 'A', 'Approved', 'N', 'Not Ready', 'E', 'Migrated', 'Unknown') fa_status_name,
       fa.*
  FROM sim_field_activities fa,
       sim_trips stp,
       sim_station_visits ssv,
       tsmstatn sta
 WHERE fa.fa_tsmstatn_is_number = sta.tsmstatn_is_number (+)
   AND fa.fa_tsmstatn_org_id = sta.tsmstatn_org_id (+)
   AND fa.fa_stp_seq = stp.stp_seq (+)
   AND fa.fa_ssv_seq = ssv.ssv_seq (+);
