CREATE OR REPLACE PACKAGE sim_lib_pkg IS

/*----------------------------------------------------------------------------------------
  Procedures, Functions, Constants, etc. for the entire SIM application
 ----------------------------------------------------------------------------------------*/

/****************************************************************************************
 *                                   PUBLIC CONSTANTS                                   *
 ****************************************************************************************/
  c_cfg_build_number            CONSTANT sim_config.sc_item%TYPE := '*BUILD_NUMBER';
  c_cfg_websim_build_number     CONSTANT sim_config.sc_item%TYPE := '*WEBSIM_BUILD_NUMBER';
  c_cfg_db_os_windows           CONSTANT sim_config.sc_item%TYPE := 'DB_OS_WINDOWS';
  c_cfg_dflt_org                CONSTANT sim_config.sc_item%TYPE := 'DFLT_ORG';
  c_cfg_document_import_path    CONSTANT sim_config.sc_item%TYPE := 'DOCUMENT_IMPORT_PATH';
  c_cfg_do_pre_check            CONSTANT sim_config.sc_item%TYPE := 'DO_PRE_CHECK';
  c_cfg_storet_help_path        CONSTANT sim_config.sc_item%TYPE := 'STORET_HELP_PATH';
  c_cfg_websim_allow_view_data  CONSTANT sim_config.sc_item%TYPE := 'WEBSIM_ALLOW_VIEW_DATA';
  c_cfg_websim_dad              CONSTANT sim_config.sc_item%TYPE := 'WEBSIM_DAD';
  c_cfg_websim_demo             CONSTANT sim_config.sc_item%TYPE := 'WEBSIM_DEMO';
  c_cfg_websim_import_path      CONSTANT sim_config.sc_item%TYPE := 'WEBSIM_IMPORT_PATH';
  c_cfg_websim_v_dir_root       CONSTANT sim_config.sc_item%TYPE := 'WEBSIM_V_DIR_ROOT';
  c_cfg_web_service_ipc_path    CONSTANT sim_config.sc_item%TYPE := 'WEB_SERVICE_IPC_PATH';
  c_cfg_web_service_out_path    CONSTANT sim_config.sc_item%TYPE := 'WEB_SERVICE_OUT_PATH';
  c_cfg_unzip_command_line      CONSTANT sim_config.sc_item%TYPE := 'UNZIP_COMMAND_LINE';
  c_cfg_external_file_upload    CONSTANT sim_config.sc_item%TYPE := 'EXTERNAL_FILE_UPLOAD';

  c_selt_import_file            CONSTANT sim_event_log_type.selt_seq%TYPE := 1;
  c_selt_delete_import	        CONSTANT sim_event_log_type.selt_seq%TYPE := 2;
  c_selt_export_error_lines     CONSTANT sim_event_log_type.selt_seq%TYPE := 3;
  c_selt_migrate                CONSTANT sim_event_log_type.selt_seq%TYPE := 4;
  c_selt_delete_migration       CONSTANT sim_event_log_type.selt_seq%TYPE := 5;
  c_selt_process_delete_file    CONSTANT sim_event_log_type.selt_seq%TYPE := 6;
  c_selt_copy_configuration     CONSTANT sim_event_log_type.selt_seq%TYPE := 7;
  c_selt_load_configuration     CONSTANT sim_event_log_type.selt_seq%TYPE := 8;
  c_selt_app_error              CONSTANT sim_event_log_type.selt_seq%TYPE := 9;

  c_seldt_message               CONSTANT sim_event_log_details_type.seldt_seq%TYPE := 1;
  c_seldt_warning               CONSTANT sim_event_log_details_type.seldt_seq%TYPE := 2;
  c_seldt_error                 CONSTANT sim_event_log_details_type.seldt_seq%TYPE := 3;  

/****************************************************************************************
 *                                      PUBLIC TYPES                                    *
 ****************************************************************************************/  
  -- index-by table used by the parse_to_table function
  TYPE t_varchar_table IS TABLE OF VARCHAR2(4000) INDEX BY BINARY_INTEGER;
  -- generic ref cursor useful for dynamic sql
  TYPE t_ref_cur IS REF CURSOR;

/****************************************************************************************
 *                                    PUBLIC VARIABLES                                  *
 ****************************************************************************************/

/****************************************************************************************
 *                             PUBLIC PROCEDURES AND FUNCTIONS                          *
 ****************************************************************************************/
  FUNCTION get_websim_unzip_cmd (
    p_src_zip IN VARCHAR2,
    p_dest_dir IN VARCHAR2) 
    RETURN VARCHAR2;
  
  FUNCTION get_config_value (
    p_config_item_name IN VARCHAR2) 
    RETURN VARCHAR2;

  FUNCTION get_websim_import_path 
    RETURN VARCHAR2;

  FUNCTION get_document_import_path 
    RETURN VARCHAR2;
  
  FUNCTION get_session_var (
    p_context IN VARCHAR2,
    p_name    IN VARCHAR2) 
    RETURN VARCHAR2;
    
  PROCEDURE set_session_var (
    p_context IN VARCHAR2,
    p_name    IN VARCHAR2,
    p_value   IN VARCHAR2);
  
  PROCEDURE delete_session_var (
    p_context IN VARCHAR2,
    p_name    IN VARCHAR2);
  
  FUNCTION parse_to_table (
    p_source_string IN VARCHAR2,
    p_delimiter     IN VARCHAR2,
    p_min_elements  IN NUMBER := 1) 
    RETURN t_varchar_table;
  
END sim_lib_pkg;
/
