/****************************************************************************************
  Used in the Order By property of a block in act2_l to sort the activities by station id
 ****************************************************************************************/
CREATE OR REPLACE FUNCTION sim_station_sort (
  p_station_is_nbr IN sim_field_activities.fa_tsmstatn_is_number%TYPE,
  p_org_id         IN sim_field_activities.fa_tsmstatn_org_id%TYPE)

  RETURN VARCHAR2 IS

  v_identification_cd   tsmstatn.identification_cd%TYPE;

BEGIN
  SELECT identification_cd
    INTO v_identification_cd 
    FROM tsmstatn
    WHERE tsmstatn_is_number = p_station_is_nbr
      AND tsmstatn_org_id = rpad(p_org_id, 8);
  RETURN v_identification_cd;
END;
/
