PROMPT Dropping Old Synonyms for User
SET SERVEROUTPUT ON SIZE 20000;
BEGIN
  FOR rec IN (SELECT s.owner || '.' || s.synonym_name syn FROM SYS.all_synonyms s WHERE s.owner = UPPER('&&STORUSER_USER') AND s.table_owner LIKE '%SIM%') LOOP 
    BEGIN
      EXECUTE IMMEDIATE 'DROP SYNONYM ' || rec.syn;
    EXCEPTION 
      WHEN OTHERS THEN 
        dbms_output.put_line(SQLERRM);
    END;
  END LOOP;
END;
/

PROMPT Granting Privileges to User
GRANT &&SIM_ROLE TO &&STORUSER_USER;

PROMPT Creating Synonymns for User
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_CPORG FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_CPORG;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_CPORG_SEQ FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_CPORG_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_LOC_SEQ FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_LOC_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_PERSONNEL FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_PERSONNEL;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_PERSONNEL_SEQ FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_PERSONNEL_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_PROJECTS FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_PROJECTS;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTIVITY_PROJECTS_SEQ FOR &&SIM_APP_SCHEMA..SIM_ACTIVITY_PROJECTS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_ACTUAL_ACTIVITY_LOC FOR &&SIM_APP_SCHEMA..SIM_ACTUAL_ACTIVITY_LOC;
CREATE SYNONYM &&STORUSER_USER..SIM_BIO_RESULTS_GRP FOR &&SIM_APP_SCHEMA..SIM_BIO_RESULTS_GRP;
CREATE SYNONYM &&STORUSER_USER..SIM_BIO_RESULTS_GRP_INDIVIDUAL FOR &&SIM_APP_SCHEMA..SIM_BIO_RESULTS_GRP_INDIVIDUAL;
CREATE SYNONYM &&STORUSER_USER..SIM_BRGI_SEQ FOR &&SIM_APP_SCHEMA..SIM_BRGI_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_BRG_SEQ FOR &&SIM_APP_SCHEMA..SIM_BRG_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_CHARACTERISTIC_USGS_CODES FOR &&SIM_APP_SCHEMA..SIM_CHARACTERISTIC_USGS_CODES;
CREATE SYNONYM &&STORUSER_USER..SIM_COMMIT FOR &&SIM_APP_SCHEMA..SIM_COMMIT;
CREATE SYNONYM &&STORUSER_USER..SIM_CONFIG FOR &&SIM_APP_SCHEMA..SIM_CONFIG;
CREATE SYNONYM &&STORUSER_USER..SIM_ESTUARY_LOC FOR &&SIM_APP_SCHEMA..SIM_ESTUARY_LOC;
CREATE SYNONYM &&STORUSER_USER..SIM_ESTUARY_LOC_SEQ FOR &&SIM_APP_SCHEMA..SIM_ESTUARY_LOC_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_DETAILS FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_DETAILS_SEQ FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_DETAILS_TYPE FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS_TYPE;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_LINES FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_LINES;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_LINES_SEQ FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_LINES_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_PKG FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_SEQ FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_EVENT_LOG_TYPE FOR &&SIM_APP_SCHEMA..SIM_EVENT_LOG_TYPE;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_LOCATION_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_LOCATION_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_LOG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_LOG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_PROJECT_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_PROJECT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_RESULT_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_RESULT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_STATION_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_STATION_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_STORET_IDS FOR &&SIM_APP_SCHEMA..SIM_EXPORT_STORET_IDS;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_STORET_IDS_SEQ FOR &&SIM_APP_SCHEMA..SIM_EXPORT_STORET_IDS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_EXPORT_WELL_PKG FOR &&SIM_APP_SCHEMA..SIM_EXPORT_WELL_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_FIELD_ACTIVITIES FOR &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES;
CREATE SYNONYM &&STORUSER_USER..SIM_FIELD_ACTIVITIES_SEQ FOR &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_FIELD_ACTIVITY_PARENT FOR &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITY_PARENT;
CREATE SYNONYM &&STORUSER_USER..SIM_FIELD_ACTIVITY_PARENT_SEQ FOR &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITY_PARENT_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_GREAT_LAKE FOR &&SIM_APP_SCHEMA..SIM_GREAT_LAKE;
CREATE SYNONYM &&STORUSER_USER..SIM_GREAT_LAKE_SEQ FOR &&SIM_APP_SCHEMA..SIM_GREAT_LAKE_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_HELP FOR &&SIM_APP_SCHEMA..SIM_HELP;
CREATE SYNONYM &&STORUSER_USER..SIM_HLP_SEQ FOR &&SIM_APP_SCHEMA..SIM_HLP_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_LOCATIONS_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_LOCATIONS_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_LOG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_LOG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_LOG_SEQ FOR &&SIM_APP_SCHEMA..SIM_IMPORT_LOG_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_PROJECT_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_PROJECT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_RESULT_CHECKS FOR &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_CHECKS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_RESULT_EXTRAS FOR &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_EXTRAS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_RESULT_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_STATION_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_STATION_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_WELLS_PKG FOR &&SIM_APP_SCHEMA..SIM_IMPORT_WELLS_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_ALLOW_VALUES FOR &&SIM_APP_SCHEMA..SIM_IMP_ALLOW_VALUES;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_DETS FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_DETS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_DETS_SEQ FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_DETS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_INSTRS FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_INSTRS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_INSTRS_SEQ FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_INSTRS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_SEQ FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_COLS FOR &&SIM_APP_SCHEMA..SIM_IMP_COLS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_DEFS FOR &&SIM_APP_SCHEMA..SIM_IMP_DEFS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_FMTS FOR &&SIM_APP_SCHEMA..SIM_IMP_FMTS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_FMT_CHOICES FOR &&SIM_APP_SCHEMA..SIM_IMP_FMT_CHOICES;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_INSTRS FOR &&SIM_APP_SCHEMA..SIM_IMP_INSTRS;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_INSTR_CHOICES FOR &&SIM_APP_SCHEMA..SIM_IMP_INSTR_CHOICES;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_LINES FOR &&SIM_APP_SCHEMA..SIM_IMP_LINES;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_LINES_SEQ FOR &&SIM_APP_SCHEMA..SIM_IMP_LINES_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_INTERFACE_EXTRAS_PKG FOR &&SIM_APP_SCHEMA..SIM_INTERFACE_EXTRAS_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_LIB_PKG FOR &&SIM_APP_SCHEMA..SIM_LIB_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_MANAGE_CONFIG_PKG FOR &&SIM_APP_SCHEMA..SIM_MANAGE_CONFIG_PKG;
CREATE SYNONYM &&STORUSER_USER..SIM_OCEAN FOR &&SIM_APP_SCHEMA..SIM_OCEAN;
CREATE SYNONYM &&STORUSER_USER..SIM_OCEAN_SEQ FOR &&SIM_APP_SCHEMA..SIM_OCEAN_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_PROJECTS FOR &&SIM_APP_SCHEMA..SIM_PROJECTS;
CREATE SYNONYM &&STORUSER_USER..SIM_PROJECTS_SEQ FOR &&SIM_APP_SCHEMA..SIM_PROJECTS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_RESULTS FOR &&SIM_APP_SCHEMA..SIM_RESULTS;
CREATE SYNONYM &&STORUSER_USER..SIM_RESULTS_SEQ FOR &&SIM_APP_SCHEMA..SIM_RESULTS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_RESULT_CLASS_INDICATOR FOR &&SIM_APP_SCHEMA..SIM_RESULT_CLASS_INDICATOR;
CREATE SYNONYM &&STORUSER_USER..SIM_RESULT_CLASS_INDICATOR_SEQ FOR &&SIM_APP_SCHEMA..SIM_RESULT_CLASS_INDICATOR_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_RESULT_LAB_REMARKS FOR &&SIM_APP_SCHEMA..SIM_RESULT_LAB_REMARKS;
CREATE SYNONYM &&STORUSER_USER..SIM_SAMPLE FOR &&SIM_APP_SCHEMA..SIM_SAMPLE;
CREATE SYNONYM &&STORUSER_USER..SIM_SAMPLE_SEQ FOR &&SIM_APP_SCHEMA..SIM_SAMPLE_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_SESSION_VARS FOR &&SIM_APP_SCHEMA..SIM_SESSION_VARS;
CREATE SYNONYM &&STORUSER_USER..SIM_SRLR_SEQ FOR &&SIM_APP_SCHEMA..SIM_SRLR_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_STATIONS FOR &&SIM_APP_SCHEMA..SIM_STATIONS;
CREATE SYNONYM &&STORUSER_USER..SIM_STATIONS_SEQ FOR &&SIM_APP_SCHEMA..SIM_STATIONS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_LOCATIONS FOR &&SIM_APP_SCHEMA..SIM_STATION_LOCATIONS;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_LOCATIONS_SEQ FOR &&SIM_APP_SCHEMA..SIM_STATION_LOCATIONS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_SORT FOR &&SIM_APP_SCHEMA..SIM_STATION_SORT;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_VISITS FOR &&SIM_APP_SCHEMA..SIM_STATION_VISITS;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_VISITS_SEQ FOR &&SIM_APP_SCHEMA..SIM_STATION_VISITS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_WELLS FOR &&SIM_APP_SCHEMA..SIM_STATION_WELLS;
CREATE SYNONYM &&STORUSER_USER..SIM_STATION_WELLS_SEQ FOR &&SIM_APP_SCHEMA..SIM_STATION_WELLS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_TRANSLATIONS FOR &&SIM_APP_SCHEMA..SIM_TRANSLATIONS;
CREATE SYNONYM &&STORUSER_USER..SIM_TRANSLATIONS_SEQ FOR &&SIM_APP_SCHEMA..SIM_TRANSLATIONS_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_TRAP_NET FOR &&SIM_APP_SCHEMA..SIM_TRAP_NET;
CREATE SYNONYM &&STORUSER_USER..SIM_TRAP_NET_SEQ FOR &&SIM_APP_SCHEMA..SIM_TRAP_NET_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_TRAWL_OPS_DET FOR &&SIM_APP_SCHEMA..SIM_TRAWL_OPS_DET;
CREATE SYNONYM &&STORUSER_USER..SIM_TRAWL_OPS_DET_SEQ FOR &&SIM_APP_SCHEMA..SIM_TRAWL_OPS_DET_SEQ;
CREATE SYNONYM &&STORUSER_USER..SIM_TRIPS FOR &&SIM_APP_SCHEMA..SIM_TRIPS;
CREATE SYNONYM &&STORUSER_USER..SIM_TRIPS_SEQ FOR &&SIM_APP_SCHEMA..SIM_TRIPS_SEQ;

CREATE SYNONYM &&STORUSER_USER..SIM_FIELD_ACTIVITIES_VW FOR &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES_VW;
CREATE SYNONYM &&STORUSER_USER..SIM_IMPORT_LOG_VW FOR &&SIM_APP_SCHEMA..SIM_IMPORT_LOG_VW;
CREATE SYNONYM &&STORUSER_USER..SIM_IMP_CFG_VW FOR &&SIM_APP_SCHEMA..SIM_IMP_CFG_VW;
CREATE SYNONYM &&STORUSER_USER..SIM_TRANSLATIONS_VW FOR &&SIM_APP_SCHEMA..SIM_TRANSLATIONS_VW;
