prompt
prompt Creating index IANLPRGS1
prompt ===========================
prompt
create index IANLPRGS1 on &&STORET1_USER..TSRANLPR (PROCEDURE_ID)
  tablespace &&DATA_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_DEFS
prompt ===========================
prompt
create table SIM_IMP_DEFS
(
  SID_SEQ         NUMBER(10) not null,
  SID_TYPE_CODE   VARCHAR2(4) not null,
  SID_TYPE        VARCHAR2(30) not null,
  SID_DESC        VARCHAR2(80) not null,
  SID_ACTION_CODE VARCHAR2(1) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_DEFS
  add constraint SID_PK primary key (SID_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_DEFS
  add constraint SID_ACTION_CHK
  check (sid_action_code in ('I','U','D'));

prompt
prompt Creating table SIM_IMP_CFG
prompt ==========================
prompt
create table SIM_IMP_CFG
(
  SICC_SEQ                NUMBER(10) not null,
  SICC_SID_SEQ            NUMBER(10) not null,
  SICC_NAME               VARCHAR2(80) not null,
  SICC_DESC               VARCHAR2(80),
  SICC_DELIMITER          CHAR(1),
  SICC_TSMORGAN_ORG_ID    CHAR(8) not null,
  SICC_TSMORGAN_IS_NUMBER NUMBER(12) not null,
  SICC_UPDATED_ON         DATE,
  SICC_UPDATED_BY         VARCHAR2(80),
  SICC_PROTECTED          CHAR(1) default 'N'
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG
  add constraint SIM_IMPORT_CONFIG_PK primary key (SICC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG
  add constraint SICC_SID_SEQ foreign key (SICC_SID_SEQ)
  references SIM_IMP_DEFS (SID_SEQ);
alter table SIM_IMP_CFG
  add constraint AVCON_1017432113_SICC__000
  check (SICC_DELIMITER IN ('~', '|', ',',chr(009)));
create index SICC_SID_SEQ_IDX on SIM_IMP_CFG (SICC_SID_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMPORT_LOG
prompt =============================
prompt
create table SIM_IMPORT_LOG
(
  SIL_SEQ                 NUMBER(10) not null,
  SIL_SICC_SEQ            NUMBER(10) not null,
  SIL_TSMORGAN_IS_NUMBER  NUMBER(12),
  SIL_TSMORGAN_ORG_ID     CHAR(8),
  SIL_LAB_ID              VARCHAR2(20),
  SIL_IMPORT_TYPE         VARCHAR2(4),
  SIL_IMPORT_ON           DATE,
  SIL_IMPORTED_BY         VARCHAR2(80),
  SIL_IMPORT_FILE         VARCHAR2(265),
  SIL_ACTIVITIES_IMPORTED NUMBER(10),
  SIL_ROWS_IMPORTED       NUMBER(10),
  SIL_ROWS_ERRORS         NUMBER(10),
  SIL_ROWS_READY          NUMBER(10),
  SIL_DELETED_ON          DATE,
  SIL_DELETED_BY          VARCHAR2(80),
  SIL_EXPORTED_ON         DATE,
  SIL_EXPORTED_BY         VARCHAR2(80),
  SIL_DELETED_STORET_ON   DATE,
  SIL_DELETED_STORET_BY   VARCHAR2(80),
  SIL_PRE_CHECK_FLAG      NUMBER(1)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMPORT_LOG
  add constraint SIM_IMPORT_LOG_PK primary key (SIL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMPORT_LOG
  add constraint SIL_SICC_FK foreign key (SIL_SICC_SEQ)
  references SIM_IMP_CFG (SICC_SEQ);
alter table SIM_IMPORT_LOG
  add constraint AVCON_1017432113_SIL_I_000
  check (SIL_IMPORT_TYPE IN ('B', 'G', 'C', 'P', 'R', 'S', 'W', 'L', 'I', 'XR', 'WR','WS'));
create index SIL_SICC_SEQ_FK on SIM_IMPORT_LOG (SIL_SICC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_TRIPS
prompt ========================
prompt
create table SIM_TRIPS
(
  STP_SEQ                NUMBER(10) not null,
  STP_TRIP_ID            VARCHAR2(15),
  STP_TRIP_NAME          VARCHAR2(60),
  STP_START_DATE         DATE,
  STP_END_DATE           DATE,
  STP_TSRTRIP_IS_NUMBER  NUMBER(8),
  STP_TSRTRIP_ORG_ID     CHAR(8),
  STP_TSMORGAN_IS_NUMBER NUMBER(12),
  STP_TSMORGAN_ORG_ID    CHAR(8),
  STP_CREATED_BY_SIM     NUMBER(1),
  STP_IMPORT_SEQ         NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRIPS
  add constraint STP_PK primary key (STP_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRIPS
  add constraint STP_SIL_FK foreign key (STP_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_TRIPS
  add constraint AVCON_1017432113_STP_C_000
  check (STP_CREATED_BY_SIM IN (0, 1));
create index STP_TRIP_ID_IDX on SIM_TRIPS (STP_TRIP_ID)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_STATION_VISITS
prompt =================================
prompt
create table SIM_STATION_VISITS
(
  SSV_SEQ                NUMBER(10) not null,
  SSV_ID                 VARCHAR2(8),
  SSV_STP_SEQ            NUMBER(10) not null,
  SSV_START_DATE         DATE,
  SSV_START_TIME         DATE,
  SSV_END_DATE           DATE,
  SSV_END_TIME           DATE,
  SSV_TSMSTATN_IS_NUMBER NUMBER(12),
  SSV_TSMSTATN_ORG_ID    CHAR(8),
  SSV_TSRSTVST_IS_NUMBER NUMBER(12),
  SSV_TSRSTVST_ORG_ID    CHAR(8),
  SSV_TSMORGAN_IS_NUMBER NUMBER(12),
  SSV_TSMORGAN_ORG_ID    CHAR(8),
  SSV_CREATED_BY_SIM     NUMBER(1),
  SSV_ARRIVAL_TIME_ZONE  VARCHAR2(3),
  SSV_COMMENT            VARCHAR2(254),
  SSV_DOCUMENT           VARCHAR2(256),
  SSV_IMPORT_SEQ         NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_VISITS
  add constraint SST_PK primary key (SSV_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_VISITS
  add constraint SST_STP_FK foreign key (SSV_STP_SEQ)
  references SIM_TRIPS (STP_SEQ);
alter table SIM_STATION_VISITS
  add constraint SSV_SIL_FK foreign key (SSV_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_STATION_VISITS
  add constraint AVCON_1017432113_SSV_C_000
  check (SSV_CREATED_BY_SIM IN (0, 1));
create index SSV_STP_SEQ_IDX on SIM_STATION_VISITS (SSV_STP_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SSV_TSRSTVST_IDX on SIM_STATION_VISITS (SSV_TSRSTVST_ORG_ID, SSV_TSRSTVST_IS_NUMBER)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_EXPORT_LOG
prompt =============================
prompt
create table SIM_EXPORT_LOG
(
  SEL_SEQ          NUMBER(10) not null,
  SEL_ORG_ID       VARCHAR2(20),
  SEL_EXPORT_TYPE  VARCHAR2(4),
  SEL_FILENAME     VARCHAR2(240),
  SEL_EXPORTED_BY  VARCHAR2(20),
  SEL_EXPORTED_ON  DATE,
  SEL_CLEARED_ON   DATE,
  SEL_CLEARED_BY   VARCHAR2(20),
  SEL_ACTIVITY_CNT NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_EXPORT_LOG
  add constraint SIM_EXPORT_LOG_PK primary key (SEL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_FIELD_ACTIVITIES
prompt ===================================
prompt
create table SIM_FIELD_ACTIVITIES
(
  FA_SEQ                       NUMBER(10) not null,
  FA_ACTIVITY_ID               CHAR(12),
  FA_ACTIVITY_COMMENTS         VARCHAR2(254),
  FA_STP_SEQ                   NUMBER(10),
  FA_SSV_SEQ                   NUMBER(10),
  FA_STVST_COMMENTS            VARCHAR2(4000),
  FA_TYPE_NAME                 VARCHAR2(13),
  FA_CATEGORY                  VARCHAR2(30),
  FA_MEDIUM                    VARCHAR2(20),
  FA_INTENT                    VARCHAR2(20),
  FA_REPLICATE_NBR             VARCHAR2(3),
  FA_FDSET_ID                  VARCHAR2(10),
  FA_FDSET_NAME                VARCHAR2(30),
  FA_START_DATE                DATE,
  FA_START_TIME                DATE,
  FA_START_TIME_ZONE           VARCHAR2(3),
  FA_STOP_DATE                 DATE,
  FA_STOP_TIME                 DATE,
  FA_STOP_TIME_ZONE            VARCHAR2(3),
  FA_DEPTH_UOM                 VARCHAR2(3),
  FA_DEPTH_REF_POINT           VARCHAR2(30),
  FA_UPDEPTH                   NUMBER(13,5),
  FA_LOWDEPTH                  NUMBER(13,5),
  FA_DEPTH_ZONE                VARCHAR2(15),
  FA_DEPTH_RANGE_UOM           VARCHAR2(3),
  FA_REL_DEPTH                 VARCHAR2(15),
  FA_THERMO                    VARCHAR2(1),
  FA_HALO                      VARCHAR2(1),
  FA_PYCNO                     VARCHAR2(1),
  FA_DEPTH                     VARCHAR2(8),
  FA_TSRMATRX_IS_NUMBER        NUMBER(12),
  FA_TSRMATRX_ORG_ID           CHAR(8),
  FA_TSROPPRD_ORG_ID           CHAR(8),
  FA_TSROPPRD_IS_NUMBER        NUMBER(12),
  FA_QC_INDICATOR              CHAR(1),
  FA_CHAIN_OF_CUSTODY_ID       VARCHAR2(30),
  FA_SPECIES_NUMBER            VARCHAR2(8),
  FA_TSMORGAN_IS_NUMBER        NUMBER(12),
  FA_TSMORGAN_ORG_ID           CHAR(8),
  FA_TSRTRIP_IS_NUMBER         NUMBER(12),
  FA_TSRTRIP_ORG_ID            CHAR(8),
  FA_TSRSTVST_IS_NUMBER        NUMBER(12),
  FA_TSRSTVST_ORG_ID           CHAR(8),
  FA_TSMSTATN_IS_NUMBER        NUMBER(12),
  FA_TSMSTATN_ORG_ID           CHAR(8),
  FA_TSRSDP_IS_NUMBER          NUMBER(12),
  FA_TSRSDP_ORG_ID             CHAR(8),
  FA_TSRFLDPR_IS_NUMBER        NUMBER(12),
  FA_TSRFLDPR_ORG_ID           CHAR(8),
  FA_TSRFLDGR_IS_NUMBER        NUMBER(12),
  FA_TSRFLDGR_ORG_ID           CHAR(8),
  FA_TSRGRCFG_IS_NUMBER        NUMBER(12),
  FA_TSRGRCFG_ORG_ID           CHAR(8),
  FA_TSRLAB_IS_NUMBER          NUMBER(12),
  FA_TSRLAB_ORG_ID             CHAR(8),
  FA_TSROLSPA_IS_NUMBER        NUMBER(12),
  FA_TSROLSPA_ORG_ID           CHAR(8),
  FA_TSRFQS_IS_NUMBER          NUMBER(12),
  FA_TSRFQS_ORG_ID             CHAR(8),
  FA_TSMPRMVL_COMMUNITY_IS_NBR NUMBER(12),
  FA_TSMPRMVL_COMMUNITY_ORG_ID VARCHAR2(8),
  FA_TSRBIOPT_IS_NUMBER        NUMBER(12),
  FA_TSRBIOPT_ORG_ID           CHAR(8),
  FA_TSRCHAR_IS_NUMBER         NUMBER(12),
  FA_TSRCHAR_ORG_ID            CHAR(8),
  FA_TSRFDACT_IS_NUMBER        NUMBER(12),
  FA_TSRFDACT_ORG_ID           CHAR(8),
  FA_STATUS                    VARCHAR2(1),
  FA_IMPORT_SEQ                NUMBER(10),
  FA_IMPORT_LINE_NO            NUMBER(10),
  FA_EXPORT_SEQ                NUMBER(10),
  FA_APPROVED_BY               VARCHAR2(20),
  FA_APPROVED_ON               DATE,
  FA_CHAR_GROUP                VARCHAR2(10),
  FA_DOCUMENT                  VARCHAR2(256)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_FIELD_ACTIVITIES
  add constraint FA_PK primary key (FA_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_FIELD_ACTIVITIES
  add constraint FA_EXPORT_SEQ_FK foreign key (FA_EXPORT_SEQ)
  references SIM_EXPORT_LOG (SEL_SEQ);
alter table SIM_FIELD_ACTIVITIES
  add constraint FA_IMPORT_SEQ_FK foreign key (FA_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_FIELD_ACTIVITIES
  add constraint FA_SSV_FK foreign key (FA_SSV_SEQ)
  references SIM_STATION_VISITS (SSV_SEQ);
alter table SIM_FIELD_ACTIVITIES
  add constraint FA_STP_FK foreign key (FA_STP_SEQ)
  references SIM_TRIPS (STP_SEQ);
alter table SIM_FIELD_ACTIVITIES
  add constraint AVCON_1017432113_FA_ST_000
  check (FA_STATUS IN ('N', 'A', 'E'));
create index FA_ACTIVITY_ID_IDX on SIM_FIELD_ACTIVITIES (FA_ACTIVITY_ID)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_EXPORT_SEQ_IDX on SIM_FIELD_ACTIVITIES (FA_EXPORT_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_IMPORT_SEQ_IDX on SIM_FIELD_ACTIVITIES (FA_IMPORT_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_SSV_SEQ_IDX on SIM_FIELD_ACTIVITIES (FA_SSV_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_START_DATE_IDX on SIM_FIELD_ACTIVITIES (FA_START_DATE)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_STP_SEQ_IDX on SIM_FIELD_ACTIVITIES (FA_STP_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_TSMORGAN_IDX on SIM_FIELD_ACTIVITIES (FA_TSMORGAN_ORG_ID, FA_TSMORGAN_IS_NUMBER)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index FA_TSRTRIP_IDX on SIM_FIELD_ACTIVITIES (FA_TSRTRIP_ORG_ID, FA_TSRTRIP_IS_NUMBER)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_ACTIVITY_CPORG
prompt =================================
prompt
create table SIM_ACTIVITY_CPORG
(
  SAC_SEQ                NUMBER(10) not null,
  SAC_FA_SEQ             NUMBER(10) not null,
  SAC_TSMCPORG_IS_NUMBER NUMBER(12),
  SAC_TSMCPORG_ORG_ID    CHAR(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_CPORG
  add constraint SAC_SEQ_PK primary key (SAC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_CPORG
  add constraint SAC_FA_SEQ_FK foreign key (SAC_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SAC_FA_SEQ_IDX on SIM_ACTIVITY_CPORG (SAC_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_ACTIVITY_PERSONNEL
prompt =====================================
prompt
create table SIM_ACTIVITY_PERSONNEL
(
  SAP_SEQ                NUMBER(10) not null,
  SAP_FA_SEQ             NUMBER(10) not null,
  SAP_TSMPERSN_IS_NUMBER NUMBER(12),
  SAP_TSMPERSN_ORG_ID    CHAR(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_PERSONNEL
  add constraint SIM_ACTIVITY_PERSONNEL_PK primary key (SAP_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_PERSONNEL
  add constraint SIM_ACT_PERSN_FA_FK foreign key (SAP_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SIM_ACT_PERSN_FA_IDX on SIM_ACTIVITY_PERSONNEL (SAP_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_ACTIVITY_PROJECTS
prompt ====================================
prompt
create table SIM_ACTIVITY_PROJECTS
(
  SAPJ_SEQ               NUMBER(10) not null,
  SAPJ_FA_SEQ            NUMBER(10) not null,
  SAPJ_TSMPROJ_IS_NUMBER NUMBER(12),
  SAPJ_TSMPROJ_ORG_ID    CHAR(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_PROJECTS
  add constraint SIM_ACTIVITY_PROJECTS_PK primary key (SAPJ_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTIVITY_PROJECTS
  add constraint SAT_FA_FK foreign key (SAPJ_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SIM_ACTIVITY_PROJ_FA_IDX on SIM_ACTIVITY_PROJECTS (SAPJ_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_ACTUAL_ACTIVITY_LOC
prompt ======================================
prompt
create table SIM_ACTUAL_ACTIVITY_LOC
(
  AAL_SEQ                NUMBER(10) not null,
  AAL_FA_SEQ             NUMBER(10) not null,
  AAL_STL_SEQ            NUMBER(10),
  AAL_TSRFDACT_IS_NUMBER NUMBER(12),
  AAL_TSRFDACT_ORG_ID    VARCHAR2(8),
  AAL_TSMALP_IS_NUMBER   NUMBER(12),
  AAL_TSMALP_ORG_ID      VARCHAR2(8),
  AAL_TSRAAL_TYPE_NAME   VARCHAR2(15),
  AAL_BOTTOM_DEPTH_MSR   NUMBER(7,2),
  AAL_BOTTOM_DEPTH_UOM   VARCHAR2(3),
  AAL_ADDTNL_LOC_INFO    VARCHAR2(254)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTUAL_ACTIVITY_LOC
  add constraint AAL_PK primary key (AAL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ACTUAL_ACTIVITY_LOC
  add constraint AAL_FA_FK foreign key (AAL_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SIM_ACTUAL_ACTIVITY_LOC_IDX on SIM_ACTUAL_ACTIVITY_LOC (AAL_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_BIO_RESULTS_GRP
prompt ==================================
prompt
create table SIM_BIO_RESULTS_GRP
(
  BRG_SEQ                     NUMBER(10) not null,
  BRG_FA_SEQ                  NUMBER(10) not null,
  BRG_ID_CODE                 VARCHAR2(8),
  BRG_TYPE                    VARCHAR2(32),
  BRG_FREQ_ANALYSIS           CHAR(1),
  BRG_SPECIES_NUMBER          VARCHAR2(8),
  BRG_SUMMARY_GRP_COUNT       NUMBER(8),
  BRG_VALUE_TYPE_NAME         VARCHAR2(10),
  BRG_DESCRIPTION_TEXT        VARCHAR2(1999),
  BRG_TSRBRG_IS_NUMBER        NUMBER(12),
  BRG_TSRBRG_ORG_ID           CHAR(8),
  BRG_TSRFDACT_IS_NUMBER      NUMBER(12),
  BRG_TSRFDACT_ORG_ID         CHAR(8),
  BRG_TSRCHAR_IS_NUMBER       NUMBER(12),
  BRG_TSRCHAR_ORG_ID          VARCHAR2(8),
  BRG_TSRCPV_LIFESTAGE_IS_NBR NUMBER(12),
  BRG_TSRCPV_LIFESTAGE_ORG_ID CHAR(8),
  BRG_TSRCPV_SEX_IS_NUMBER    NUMBER(12),
  BRG_TSRCPV_SEX_ORG_ID       CHAR(8),
  BRG_IMPORT_SEQ              NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_BIO_RESULTS_GRP
  add constraint BRG_PK primary key (BRG_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_BIO_RESULTS_GRP
  add constraint BRG_FA_FK foreign key (BRG_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
alter table SIM_BIO_RESULTS_GRP
  add constraint BRG_SIL_FK foreign key (BRG_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
create index BRG_FA_SEQ_IDX on SIM_BIO_RESULTS_GRP (BRG_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index BRG_ID_CODE_IDX on SIM_BIO_RESULTS_GRP (BRG_ID_CODE)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_BIO_RESULTS_GRP_INDIVIDUAL
prompt =============================================
prompt
create table SIM_BIO_RESULTS_GRP_INDIVIDUAL
(
  BRGI_SEQ               NUMBER(10) not null,
  BRGI_FA_SEQ            NUMBER(10) not null,
  BRGI_BRG_SEQ           NUMBER(10) not null,
  BRGI_INDIVIDUAL_NUMBER NUMBER(8) not null,
  BRGI_TSRBRG_IS_NUMBER  NUMBER(12),
  BRGI_TSRBRG_ORG_ID     CHAR(8),
  BRGI_TSRBRGI_IS_NUMBER NUMBER(12),
  BRGI_TSRBRGI_ORG_ID    CHAR(8),
  BRGI_IMPORT_SEQ        NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_BIO_RESULTS_GRP_INDIVIDUAL
  add constraint BRGI_PK primary key (BRGI_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_BIO_RESULTS_GRP_INDIVIDUAL
  add constraint BRGI_BRG_FK foreign key (BRGI_BRG_SEQ)
  references SIM_BIO_RESULTS_GRP (BRG_SEQ);
alter table SIM_BIO_RESULTS_GRP_INDIVIDUAL
  add constraint BRGI_FA_FK foreign key (BRGI_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
alter table SIM_BIO_RESULTS_GRP_INDIVIDUAL
  add constraint SIM_IMPORT_LOG foreign key (BRGI_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
create index SIM_BRGI_BRG_SEQ_IDX on SIM_BIO_RESULTS_GRP_INDIVIDUAL (BRGI_BRG_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SIM_BRGI_FA_SEQ_IDX on SIM_BIO_RESULTS_GRP_INDIVIDUAL (BRGI_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_CHARACTERISTIC_USGS_CODES
prompt ============================================
prompt
create table SIM_CHARACTERISTIC_USGS_CODES
(
  CCD_SEQ          NUMBER(10) not null,
  CCD_CODE         VARCHAR2(2) not null,
  CCD_DISPLAY_NAME VARCHAR2(60) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_CHARACTERISTIC_USGS_CODES
  add constraint SIM_CCD_PK primary key (CCD_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_CONFIG
prompt =========================
prompt
create table SIM_CONFIG
(
  SC_ITEM  VARCHAR2(30) not null,
  SC_VALUE VARCHAR2(100),
  SC_DESC  VARCHAR2(240) not null,
  SC_TYPE  VARCHAR2(2) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_CONFIG
  add constraint SIM_CONFIG_PK primary key (SC_ITEM)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_STATION_WELLS
prompt ================================
prompt
create table SIM_STATION_WELLS
(
  SSW_SEQ                     NUMBER(10) not null,
  SSW_STA_SEQ                 NUMBER(10),
  SSW_WELL_STATUS             VARCHAR2(9),
  SSW_IS_NUMBER               NUMBER(12),
  SSW_ORG_ID                  CHAR(8),
  SSW_NAME                    VARCHAR2(40) not null,
  SSW_WELL_NO                 VARCHAR2(15) not null,
  SSW_WELL_USE                VARCHAR2(30),
  SSW_DEVELOP_METHOD          VARCHAR2(20),
  SSW_WELL_CONST_METH         VARCHAR2(20),
  SSW_WATER_USE               VARCHAR2(19),
  SSW_GRADIENT_TYPE           VARCHAR2(13),
  SSW_DEPTH_COMPLETION        NUMBER(8,3),
  SSW_DEPTH_COMPLETION_UNIT   CHAR(3),
  SSW_DEPTH_HOLE              NUMBER(8,3),
  SSW_DEPTH_HOLE_UNIT         CHAR(3),
  SSW_WELL_HEIGHT             NUMBER(8,3),
  SSW_WELL_HEIGHT_UNIT        CHAR(3),
  SSW_CASING_HEIGHT           NUMBER(8,3),
  SSW_CASING_HEIGHT_UNIT      CHAR(3),
  SSW_DISINFECTED             CHAR(1),
  SSW_CONST_START_DATE        DATE,
  SSW_CONST_END_DATE          DATE,
  SSW_INIT_PUMP_DUR           NUMBER(4,1),
  SSW_INIT_PUMP_DUR_UNIT      VARCHAR2(10),
  SSW_INIT_PUMP_RATE          NUMBER(4),
  SSW_INIT_PUMP_RATE_UNIT     VARCHAR2(10),
  SSW_NATURAL_FLOW            CHAR(1),
  SSW_INIT_BOREHOLE_DIAM      NUMBER(5,2),
  SSW_INIT_BOREHOLE_DIAM_UNIT CHAR(3),
  SSW_PROTECTION_AREA         VARCHAR2(40),
  SSW_DEPTH_TO_BEDROCK        NUMBER(8,3),
  SSW_DEPTH_BEDROCK_UNIT      VARCHAR2(3),
  SSW_DEPTH_OF_UNCON_MTL      NUMBER(8,3),
  SSW_DEPTH_UNCONS_UNIT       VARCHAR2(3),
  SSW_TSMSTATN_IS_NUMBER      NUMBER(12),
  SSW_TSMSTATN_ORG_ID         CHAR(8),
  SSW_STATUS                  VARCHAR2(1),
  SSW_IMPORT_SEQ              NUMBER(10),
  SSW_EXPORT_SEQ              NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_WELLS
  add constraint SSW_PK primary key (SSW_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_WELLS
  add constraint SSW_SIL_FK foreign key (SSW_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
create index SSW_STA_SEQ_IDX on SIM_STATION_WELLS (SSW_STA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_STATIONS
prompt ===========================
prompt
create table SIM_STATIONS
(
  STA_SEQ                NUMBER(10) not null,
  STA_IS_NUMBER          NUMBER(12),
  STA_ORG_ID             CHAR(8),
  STA_ID                 VARCHAR2(15) not null,
  STA_NAME               VARCHAR2(60),
  STA_ESTAB_DATE         DATE,
  STA_DESC               VARCHAR2(4000),
  STA_TSMORGAN_ORG_ID    VARCHAR2(8) not null,
  STA_TSMORGAN_IS_NUMBER NUMBER(12) not null,
  STA_TSMVSTC_IS_NUMBER  NUMBER(12),
  STA_TSMVSTC_ORG_ID     CHAR(8),
  STA_STATUS             VARCHAR2(1),
  STA_EXPORT_SEQ         NUMBER(10),
  STA_IMPORT_SEQ         NUMBER(10),
  STA_EPA_KEY_ID         VARCHAR2(36),
  STA_ZID_REL            CHAR(2),
  STA_INFLUENCE_AREA     VARCHAR2(120),
  STA_TRAVEL_DIR         VARCHAR2(1999),
  STA_WATER_DEPTH        NUMBER(8,3),
  STA_WATER_DEPTH_UNIT   CHAR(2),
  STA_ECOREGION          VARCHAR2(60),
  STA_DOCUMENT           VARCHAR2(256)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATIONS
  add constraint STA_PK primary key (STA_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATIONS
  add constraint STA_SIL_FK foreign key (STA_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_STATIONS
  add constraint AVCON_1017432113_STA_S_000
  check (STA_STATUS IN ('A', 'N', 'E', 'U'));
create index STA_IMPORT_SEQ_IDX on SIM_STATIONS (STA_IMPORT_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_STATION_LOCATIONS
prompt ====================================
prompt
create table SIM_STATION_LOCATIONS
(
  STL_SEQ                  NUMBER(10) not null,
  STL_STA_SEQ              NUMBER(10),
  STL_IS_NUMBER            NUMBER(12),
  STL_ORG_ID               CHAR(8),
  STL_SSW_SEQ              NUMBER(10),
  STL_TYPE_CODE            VARCHAR2(16),
  STL_SEQUENCE_NUMBER      NUMBER(4),
  STL_POINT_NAME           VARCHAR2(30),
  STL_ELEV_DATUM           VARCHAR2(12),
  STL_ELEV_METHOD          VARCHAR2(12),
  STL_ELEV_MSR_DATE        DATE,
  STL_ELEVATION_MSR        NUMBER(9,4),
  STL_ELEVATION_UNIT       VARCHAR2(3),
  STL_GEOPOS_DATUM         VARCHAR2(12),
  STL_GEOPOS_METHOD        VARCHAR2(12),
  STL_GPS_SCALE            VARCHAR2(20),
  STL_LAT_DIR              VARCHAR2(1),
  STL_LAT_DEGREES          NUMBER(2),
  STL_LAT_MINUTES          NUMBER(2),
  STL_LAT_SECONDS          NUMBER(6,4),
  STL_LAT_DEC_DEGREES      NUMBER(9,7),
  STL_LONG_DIR             VARCHAR2(1),
  STL_LONG_DEGREES         NUMBER(3),
  STL_LONG_MINUTES         NUMBER(2),
  STL_LONG_SECONDS         NUMBER(6,4),
  STL_LONG_DEC_DEGREES     NUMBER(10,7),
  STL_LAT_LONG_MSR_DATE    DATE,
  STL_LATLONG_ACCURCY      NUMBER(6,4),
  STL_LATLONG_ACCURCY_UNIT VARCHAR2(2),
  STL_TSMRRR_IS_NUMBER     NUMBER(12),
  STL_TSMRRR_ORG_ID        CHAR(8),
  STL_TSMFHU_IS_NUMBER     NUMBER(12),
  STL_TSMFHU_ORG_ID        CHAR(8),
  STL_TSMSTATN0IS_NUMBER   NUMBER(10),
  STL_TSMSTATN0ORG_ID      CHAR(8),
  STL_TSMWELL_IS_NUMBER    NUMBER(12),
  STL_TSMWELL_ORG_ID       CHAR(8),
  STL_TSMGEOPA_IS_NUMBER   NUMBER(12),
  STL_TSMGEOPA_ORG_ID      CHAR(8),
  STL_LAT_DEC_MINUTES      NUMBER(6,4),
  STL_LONG_DEC_MINUTES     NUMBER(8,4),
  STL_TSMPIPE_IS_NUMBER    NUMBER(12),
  STL_TSMPIPE_ORG_ID       CHAR(8),
  STL_TSMSTATN1ORG_ID      CHAR(8),
  STL_TSMSTATN1IS_NUMBER   NUMBER(12),
  STL_TSMGEOPA0IS_NUMBER   NUMBER(12),
  STL_TSMGEOPA0ORG_ID      CHAR(8),
  STL_TSMNAL_CD            CHAR(5),
  STL_TSMNAL_STATE         CHAR(2),
  STL_NRCS                 CHAR(8),
  STL_STATUS               VARCHAR2(1),
  STL_IMPORT_SEQ           NUMBER(10),
  STL_EXPORT_SEQ           NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_LOCATIONS
  add constraint STL_PK primary key (STL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_STATION_LOCATIONS
  add constraint STL_SIL_FK foreign key (STL_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_STATION_LOCATIONS
  add constraint STL_SSW_FK foreign key (STL_SSW_SEQ)
  references SIM_STATION_WELLS (SSW_SEQ);
alter table SIM_STATION_LOCATIONS
  add constraint STL_STA_SEQ_FK foreign key (STL_STA_SEQ)
  references SIM_STATIONS (STA_SEQ);
create index STL_STA_SEQ_IDX on SIM_STATION_LOCATIONS (STL_STA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_ESTUARY_LOC
prompt ==============================
prompt
create table SIM_ESTUARY_LOC
(
  SEL_SEQ                NUMBER(10) not null,
  SEL_TSMALP_IS_NUMBER   NUMBER(12),
  SEL_TSMALP_ORG_ID      CHAR(8),
  SEL_OTHER_ESTUARY      VARCHAR2(30),
  SEL_ADD_LOC_NAME       VARCHAR2(30),
  SEL_SHORE_DIST         NUMBER(6,2),
  SEL_SHORE_DIST_UNIT    CHAR(3),
  SEL_REF_PT             VARCHAR2(30),
  SEL_TSMESTRY_ORG_ID    CHAR(8),
  SEL_TSMESTRY_IS_NUMBER NUMBER(12),
  SEL_STL_SEQ            NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ESTUARY_LOC
  add constraint SEL_PK primary key (SEL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_ESTUARY_LOC
  add constraint SEL_STL_FK foreign key (SEL_STL_SEQ)
  references SIM_STATION_LOCATIONS (STL_SEQ) on delete cascade;

prompt
prompt Creating table SIM_EVENT_LOG_TYPE
prompt =================================
prompt
create table SIM_EVENT_LOG_TYPE
(
  SELT_SEQ  NUMBER(10) not null,
  SELT_NAME VARCHAR2(30) not null,
  constraint SIM_EVENT_LOG_TYPE_PK primary key (SELT_SEQ)
)
organization index;

prompt
prompt Creating table SIM_EVENT_LOG
prompt ============================
prompt
create table SIM_EVENT_LOG
(
  SEVL_SEQ             NUMBER(10) not null,
  SEVL_SELT_SEQ        NUMBER(10) not null,
  SEVL_TSMORGAN_ORG_ID CHAR(8),
  SEVL_REF_SEQ         NUMBER(10),
  SEVL_SID_SEQ         NUMBER(10),
  SEVL_USER_ID         VARCHAR2(30) not null,
  SEVL_START           DATE default SYSDATE not null,
  SEVL_STOP            DATE
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
comment on column SIM_EVENT_LOG.SEVL_SEQ
  is 'Event Log ID';
comment on column SIM_EVENT_LOG.SEVL_SELT_SEQ
  is 'Event Log Type ID';
comment on column SIM_EVENT_LOG.SEVL_TSMORGAN_ORG_ID
  is 'STORET Organization ID';
comment on column SIM_EVENT_LOG.SEVL_REF_SEQ
  is 'Import Log ID, Export Log ID, Import Configuration ID';
comment on column SIM_EVENT_LOG.SEVL_SID_SEQ
  is 'Import Definition ID';
comment on column SIM_EVENT_LOG.SEVL_USER_ID
  is 'User Name';
comment on column SIM_EVENT_LOG.SEVL_START
  is 'Start Date and Time';
comment on column SIM_EVENT_LOG.SEVL_STOP
  is 'End Date and Time';
alter table SIM_EVENT_LOG
  add constraint SIM_EVENT_LOG_PK primary key (SEVL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_EVENT_LOG
  add constraint SEVL_SELT_FK foreign key (SEVL_SELT_SEQ)
  references SIM_EVENT_LOG_TYPE (SELT_SEQ);

prompt
prompt Creating table SIM_EVENT_LOG_DETAILS_TYPE
prompt =========================================
prompt
create table SIM_EVENT_LOG_DETAILS_TYPE
(
  SELDT_SEQ  NUMBER(10) not null,
  SELDT_NAME VARCHAR2(30) not null,
  constraint SIM_EVENT_LOG_DETAILS_TYPE_PK primary key (SELDT_SEQ)
)
organization index;

prompt
prompt Creating table SIM_EVENT_LOG_DETAILS
prompt ====================================
prompt
create table SIM_EVENT_LOG_DETAILS
(
  SELD_SEQ       NUMBER(10) not null,
  SELD_SEVL_SEQ  NUMBER(10) not null,
  SELD_SELDT_SEQ NUMBER(10) not null,
  SELD_CONTEXT   VARCHAR2(100),
  SELD_MESSAGE   VARCHAR2(4000) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 5
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 256K
    minextents 1
    maxextents unlimited
  );
comment on column SIM_EVENT_LOG_DETAILS.SELD_SEVL_SEQ
  is 'Event Log ID';
comment on column SIM_EVENT_LOG_DETAILS.SELD_SELDT_SEQ
  is 'Event Log Detail Type ID';
comment on column SIM_EVENT_LOG_DETAILS.SELD_CONTEXT
  is 'Context (Line #, Package/Procedure/Form Name, etc)';
alter table SIM_EVENT_LOG_DETAILS
  add constraint SIM_EVENT_LOG_DETAILS_PK primary key (SELD_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_EVENT_LOG_DETAILS
  add constraint SELD_SELDT_FK foreign key (SELD_SELDT_SEQ)
  references SIM_EVENT_LOG_DETAILS_TYPE (SELDT_SEQ);
alter table SIM_EVENT_LOG_DETAILS
  add constraint SELD_SEVL_FK foreign key (SELD_SEVL_SEQ)
  references sim_event_log (SEVL_SEQ) on delete cascade;
create index SELD_SEVL_SEQ_IDX on SIM_EVENT_LOG_DETAILS (SELD_SEVL_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 1
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
  
prompt
prompt Creating table SIM_EVENT_LOG_LINES
prompt ==================================
prompt
create table SIM_EVENT_LOG_LINES
(
  SELL_SEQ       NUMBER(10) not null,
  SELL_SEVL_SEQ  NUMBER(10) not null,
  SELL_LINE_TEXT VARCHAR2(4000) not null,
  SELL_LINE_NO   NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 2
  pctused 90
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
comment on table SIM_EVENT_LOG_LINES
  is 'Table to hold the individual lines from a file being read from disk';
alter table SIM_EVENT_LOG_LINES
  add constraint SELL_PK primary key (SELL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_EVENT_LOG_LINES
  add constraint SELL_SEVL_FK foreign key (SELL_SEVL_SEQ)
  references SIM_EVENT_LOG (SEVL_SEQ) on delete cascade;

prompt
prompt Creating table SIM_EXPORT_STORET_IDS
prompt ====================================
prompt
create table SIM_EXPORT_STORET_IDS
(
  SESI_SEQ        NUMBER(10) not null,
  SESI_SEL_SEQ    NUMBER(10) not null,
  SESI_TABLE_NAME VARCHAR2(30) not null,
  SESI_ORG_ID     CHAR(8) not null,
  SESI_IS_NUMBER  NUMBER(12) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 2
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
comment on table SIM_EXPORT_STORET_IDS
  is 'Holds STORET IDs relating to a migration/export';
comment on column SIM_EXPORT_STORET_IDS.SESI_SEL_SEQ
  is 'Export Log ID';
comment on column SIM_EXPORT_STORET_IDS.SESI_TABLE_NAME
  is 'STORET Table Name';
comment on column SIM_EXPORT_STORET_IDS.SESI_ORG_ID
  is 'STORET ORG_ID';
comment on column SIM_EXPORT_STORET_IDS.SESI_IS_NUMBER
  is 'STORET IS_NUMBER';
alter table SIM_EXPORT_STORET_IDS
  add constraint SIM_EXPORT_STORET_IDS_PK primary key (SESI_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_EXPORT_STORET_IDS
  add constraint SESI_SEL_FK foreign key (SESI_SEL_SEQ)
  references SIM_EXPORT_LOG (SEL_SEQ);

prompt
prompt Creating table SIM_FIELD_ACTIVITY_PARENT
prompt ========================================
prompt
create table SIM_FIELD_ACTIVITY_PARENT
(
  FAP_SEQ              NUMBER(10) not null,
  FAP_FA_SEQ           NUMBER(10) not null,
  FAP_PARENT_FA_SEQ    NUMBER(10),
  FAP_PARENT_IS_NUMBER NUMBER(12),
  FAP_PARENT_ORG_ID    CHAR(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_FIELD_ACTIVITY_PARENT
  add constraint FAP_SEQ_PK primary key (FAP_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_FIELD_ACTIVITY_PARENT
  add constraint FAP_FA_SEQ_FK foreign key (FAP_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
alter table SIM_FIELD_ACTIVITY_PARENT
  add constraint FAP_PARENT_FA_SEQ_FK foreign key (FAP_PARENT_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SIM_FAP_FA_SEQ_IDX on SIM_FIELD_ACTIVITY_PARENT (FAP_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SIM_FAP_PARENT_FA_SEQ_IDX on SIM_FIELD_ACTIVITY_PARENT (FAP_PARENT_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_GREAT_LAKE
prompt =============================
prompt
create table SIM_GREAT_LAKE
(
  SGL_SEQ              NUMBER(10) not null,
  SGL_STL_SEQ          NUMBER(10) not null,
  SGL_TSMALP_IS_NUMBER NUMBER(12),
  SGL_TSMALP_ORG_ID    CHAR(8),
  SGL_LAKE_NAME        VARCHAR2(15),
  SGL_ADD_LAKE_NAME    VARCHAR2(30),
  SGL_SHORE_DIST       NUMBER(6,2),
  SGL_SHORE_DIST_UNIT  VARCHAR2(3),
  SGL_REF_PT           VARCHAR2(30)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_GREAT_LAKE
  add constraint SGL_PK primary key (SGL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_HELP
prompt =======================
prompt
create table SIM_HELP
(
  HLP_SEQ       NUMBER(10) not null,
  HLP_FORM      VARCHAR2(30) not null,
  HLP_BLOCK     VARCHAR2(30),
  HLP_ITEM      VARCHAR2(50),
  HLP_TITLE     VARCHAR2(100) not null,
  HLP_USER_HELP VARCHAR2(4000),
  HLP_UI        VARCHAR2(10) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
-- Create/Recreate primary, unique and foreign key constraints
alter table SIM_HELP
  add constraint HLP_PK primary key (HLP_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_FMTS
prompt ===========================
prompt
create table SIM_IMP_FMTS
(
  SIF_SEQ  NUMBER(10) not null,
  SIF_FMT  VARCHAR2(80) not null,
  SIF_DESC VARCHAR2(80) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_FMTS
  add constraint SIM_IMP_FMTS_PK primary key (SIF_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_COLS
prompt ===========================
prompt
create table SIM_IMP_COLS
(
  SIC_SEQ               NUMBER(10) not null,
  SIC_SID_SEQ           NUMBER(10) not null,
  SIC_NAME              VARCHAR2(80) not null,
  SIC_DESC              VARCHAR2(80),
  SIC_REQ_IN_STORET     VARCHAR2(1),
  SIC_REQ_IN_IMPORT     VARCHAR2(1),
  SIC_DFLT_POS          NUMBER(10),
  SIC_MAX_LEN           NUMBER(10),
  SIC_FORMAT_OPTION     VARCHAR2(1),
  SIC_SIF_SEQ           NUMBER(10),
  SIC_STORET_TAB        VARCHAR2(80),
  SIC_STORET_COL        VARCHAR2(80),
  SIC_STORET_CONSTRAINT VARCHAR2(254),
  SIC_ORG_RESTRICTED    VARCHAR2(1),
  SIC_PROC_ORDER        NUMBER(3)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_COLS
  add constraint SIC_PK primary key (SIC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_COLS
  add constraint SIC_SID_FK foreign key (SIC_SID_SEQ)
  references SIM_IMP_DEFS (SID_SEQ);
alter table SIM_IMP_COLS
  add constraint SIC_SIF_FK foreign key (SIC_SIF_SEQ)
  references SIM_IMP_FMTS (SIF_SEQ);
alter table SIM_IMP_COLS
  add constraint AVCON_1017432113_SIC_F_000
  check (SIC_FORMAT_OPTION IN ('1', '2', '3', '4'));
create index SIC_NAME_IDX on SIM_IMP_COLS (SIC_NAME)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SIC_SID_SEQ_IDX on SIM_IMP_COLS (SIC_SID_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SIC_SIF_SEQ_IDX on SIM_IMP_COLS (SIC_SIF_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_ALLOW_VALUES
prompt ===================================
prompt
create table SIM_IMP_ALLOW_VALUES
(
  SIA_SEQ     NUMBER(10) not null,
  SIA_SIC_SEQ NUMBER(10) not null,
  SIA_ITEM    VARCHAR2(80),
  SIA_DESC    VARCHAR2(80)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_ALLOW_VALUES
  add constraint SIM_IMP_ALLOW_VALUES_PK primary key (SIA_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_ALLOW_VALUES
  add constraint SIA_SIC_SEQ_FK foreign key (SIA_SIC_SEQ)
  references SIM_IMP_COLS (SIC_SEQ);
create index SIA_SIC_SEQ_IDX on SIM_IMP_ALLOW_VALUES (SIA_SIC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_FMT_CHOICES
prompt ==================================
prompt
create table SIM_IMP_FMT_CHOICES
(
  SIFC_SEQ        NUMBER(10) not null,
  SIFC_SIF_SEQ    NUMBER(10) not null,
  SIFC_FMT_CHOICE VARCHAR2(80)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_FMT_CHOICES
  add constraint SIM_IMP_FMT_CHOICES_PK primary key (SIFC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_FMT_CHOICES
  add constraint SIFC_SIF_FK foreign key (SIFC_SIF_SEQ)
  references SIM_IMP_FMTS (SIF_SEQ);
create index SIFC_SIF_SEQ_IDX on SIM_IMP_FMT_CHOICES (SIFC_SIF_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_CFG_DETS
prompt ===============================
prompt
create table SIM_IMP_CFG_DETS
(
  SICDT_SEQ      NUMBER(10) not null,
  SICDT_SIC_SEQ  NUMBER(10) not null,
  SICDT_SICC_SEQ NUMBER(10) not null,
  SICDT_SIFC_SEQ NUMBER(10),
  SICDT_POS      NUMBER(4,1),
  SICDT_INCLUDED VARCHAR2(1),
  SICDT_DEFAULT  VARCHAR2(80),
  SICDT_GENERATE VARCHAR2(1)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG_DETS
  add constraint SIM_IMPORT_CONFIG_DET_PK primary key (SICDT_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG_DETS
  add constraint SICDT_SICC_SEQ_FK foreign key (SICDT_SICC_SEQ)
  references SIM_IMP_CFG (SICC_SEQ);
alter table SIM_IMP_CFG_DETS
  add constraint SICDT_SIC_FK foreign key (SICDT_SIC_SEQ)
  references SIM_IMP_COLS (SIC_SEQ);
alter table SIM_IMP_CFG_DETS
  add constraint SICDT_SIFC_SEQ_FK foreign key (SICDT_SIFC_SEQ)
  references SIM_IMP_FMT_CHOICES (SIFC_SEQ);
alter table SIM_IMP_CFG_DETS
  add constraint AVCON_1017432113_SICDT_000
  check (SICDT_INCLUDED IN ('1'));
alter table SIM_IMP_CFG_DETS
  add constraint SICDT_GENERATE_CHECK
  check (SICDT_GENERATE IN ('1'));
create index SICDT_SICC_SEQ_IDX on SIM_IMP_CFG_DETS (SICDT_SICC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SICDT_SIC_SEQ_IDX on SIM_IMP_CFG_DETS (SICDT_SIC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SICDT_SIFC_SEQ_IDX on SIM_IMP_CFG_DETS (SICDT_SIFC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_INSTRS
prompt =============================
prompt
create table SIM_IMP_INSTRS
(
  SII_SEQ     NUMBER(10) not null,
  SII_SID_SEQ NUMBER(10) not null,
  SII_CODE    VARCHAR2(12) not null,
  SII_DESC    VARCHAR2(80)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_INSTRS
  add constraint SIM_IMP_INSTR_PK primary key (SII_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_INSTRS
  add constraint SII_SID_SEQ_FK foreign key (SII_SID_SEQ)
  references SIM_IMP_DEFS (SID_SEQ);
create index SII_SID_SEQ_IDX on SIM_IMP_INSTRS (SII_SID_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_INSTR_CHOICES
prompt ====================================
prompt
create table SIM_IMP_INSTR_CHOICES
(
  SIIC_SEQ       NUMBER(10) not null,
  SIIC_SII_SEQ   NUMBER(10) not null,
  SIIC_CHOICE    VARCHAR2(80) not null,
  SIIC_CODE      VARCHAR2(15) not null,
  SIIC_DFLT_FLAG VARCHAR2(1)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_INSTR_CHOICES
  add constraint SIM_IMP_INSTR_CHOICES_PK primary key (SIIC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_INSTR_CHOICES
  add constraint SIIC_SII_SEQ_FK foreign key (SIIC_SII_SEQ)
  references SIM_IMP_INSTRS (SII_SEQ);
alter table SIM_IMP_INSTR_CHOICES
  add constraint AVCON_1017432113_SIIC__000
  check (SIIC_DFLT_FLAG IN ('1'));
create index SIIC_SII_SEQ_IDX on SIM_IMP_INSTR_CHOICES (SIIC_SII_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_CFG_INSTRS
prompt =================================
prompt
create table SIM_IMP_CFG_INSTRS
(
  SICI_SEQ      NUMBER(10) not null,
  SICI_SICC_SEQ NUMBER(10) not null,
  SICI_SII_SEQ  NUMBER(10) not null,
  SICI_SIIC_SEQ NUMBER(10) not null
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG_INSTRS
  add constraint SIM_IMP_CFG_INSTRS_PK primary key (SICI_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_CFG_INSTRS
  add constraint SICI_SICC_SEQ_FK foreign key (SICI_SICC_SEQ)
  references SIM_IMP_CFG (SICC_SEQ);
alter table SIM_IMP_CFG_INSTRS
  add constraint SICI_SIIC_SEQ_FK foreign key (SICI_SIIC_SEQ)
  references SIM_IMP_INSTR_CHOICES (SIIC_SEQ);
alter table SIM_IMP_CFG_INSTRS
  add constraint SICI_SII_SEQ_FK foreign key (SICI_SII_SEQ)
  references SIM_IMP_INSTRS (SII_SEQ);
create index SICI_SICC_SEQ_IDX on SIM_IMP_CFG_INSTRS (SICI_SICC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SICI_SIIC_SEQ_IDX on SIM_IMP_CFG_INSTRS (SICI_SIIC_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index SICI_SII_SEQ_IDX on SIM_IMP_CFG_INSTRS (SICI_SII_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_IMP_LINES
prompt ============================
prompt
create table SIM_IMP_LINES
(
  SIPL_SEQ       NUMBER(10) not null,
  SIPL_SIL_SEQ   NUMBER(10),
  SIPL_LINE_TEXT LONG,
  SIPL_LINE_NO   NUMBER(10),
  SIPL_SPJ_SEQ   NUMBER(10),
  SIPL_STA_SEQ   NUMBER(10),
  SIPL_FA_SEQ    NUMBER(10),
  SIPL_RS_SEQ    NUMBER(10),
  SIPL_AC_SEQ    NUMBER(10),
  SIPL_SSW_SEQ   NUMBER(10),
  SIPL_STL_SEQ   NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_LINES
  add constraint SIM_IMP_LINES_PK primary key (SIPL_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_IMP_LINES
  add constraint SIPL_SIL_FK foreign key (SIPL_SIL_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ) on delete cascade;
create index SIPL_SIL_SEQ_IDX on SIM_IMP_LINES (SIPL_SIL_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_OCEAN
prompt ========================
prompt
create table SIM_OCEAN
(
  SOC_SEQ               NUMBER(10) not null,
  SOC_STL_SEQ           NUMBER(10),
  SOC_NAME              VARCHAR2(14),
  SOC_ADDITIONAL_LOC    VARCHAR2(30),
  SOC_SHORE_RELATION    VARCHAR2(10),
  SOC_SHORE_DISTANCE    NUMBER(6,2),
  SOC_SHORE_DIST_UNIT   VARCHAR2(3),
  SOC_REFERENCE_PT      VARCHAR2(30),
  SOC_LORAN_C_READING_1 VARCHAR2(14),
  SOC_LORAN_C_READING_2 VARCHAR2(14),
  SOC_BOTTOM_TOPOGRAPHY VARCHAR2(254),
  SOC_TSMALP_IS_NUMBER  NUMBER(12),
  SOC_TSMALP_ORG_ID     CHAR(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_OCEAN
  add constraint SOC_PK primary key (SOC_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_OCEAN
  add constraint SOC_STL_FK foreign key (SOC_STL_SEQ)
  references SIM_STATION_LOCATIONS (STL_SEQ) on delete cascade;

prompt
prompt Creating table SIM_PROJECTS
prompt ===========================
prompt
create table SIM_PROJECTS
(
  SPJ_SEQ                NUMBER(10) not null,
  SPJ_ORG_ID             CHAR(8),
  SPJ_ID                 VARCHAR2(8),
  SPJ_NAME               VARCHAR2(60),
  SPJ_START_DATE         DATE,
  SPJ_DURATION           VARCHAR2(15),
  SPJ_PURPOSE            VARCHAR2(4000),
  SPJ_CONTACT            VARCHAR2(4000),
  SPJ_STATUS             CHAR(1),
  SPJ_TSMORGAN_IS_NUMBER NUMBER(12),
  SPJ_TSMPROJ_IS_NUMBER  NUMBER(12),
  SPJ_TSMPROJ_ORG_ID     CHAR(8),
  SPJ_EXPORT_SEQ         NUMBER(10),
  SPJ_IMPORT_SEQ         NUMBER(10),
  SPJ_TSRCITN_IS_NUMBER  NUMBER(12),
  SPJ_TSRCITN_ORG_ID     VARCHAR2(8),
  SPJ_DOCUMENT           VARCHAR2(256)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_PROJECTS
  add constraint SPJ_PK primary key (SPJ_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_PROJECTS
  add constraint SPJ_SIL_FK foreign key (SPJ_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
alter table SIM_PROJECTS
  add constraint AVCON_1017432113_SPJ_S_000
  check (SPJ_STATUS IN ('E', 'A', 'N'));

prompt
prompt Creating table SIM_RESULTS
prompt ==========================
prompt
create table SIM_RESULTS
(
  RS_SEQ                         NUMBER(10) not null,
  RS_AC_SEQ                      NUMBER(10),
  RS_FA_SEQ                      NUMBER(10) not null,
  RS_BRG_SEQ                     NUMBER(10),
  RS_BRGI_SEQ                    NUMBER(10),
  RS_TSRBRG_IS_NUMBER            NUMBER(12),
  RS_TSRBRG_ORG_ID               CHAR(8),
  RS_TSRBRGI_IS_NUMBER           NUMBER(12),
  RS_TSRBRGI_ORG_ID              CHAR(8),
  RS_TSRCHAR_IS_NUMBER           NUMBER(12),
  RS_TSRCHAR_ORG_ID              CHAR(8),
  RS_TSRCHAR0IS_NUMBER           NUMBER(12),
  RS_TSRCHAR0ORG_ID              CHAR(8),
  RS_TSRUOM_IS_NBR               NUMBER(12),
  RS_TSRUOM_ORG_ID               VARCHAR2(8),
  RS_TSRCHGRP_IS_NUMBER          NUMBER(12),
  RS_TSRCHGRP_ORG_ID             CHAR(8),
  RS_TSRCHDEF_IS_NUMBER          NUMBER(12),
  RS_TSRCHDEF_ORG_ID             CHAR(8),
  RS_TSRHCSC_IS_NUMBER           NUMBER(12),
  RS_TSRHCSC_ORG_ID              CHAR(8),
  RS_TSRLAB_IS_NUMBER            NUMBER(12),
  RS_TSRLAB_ORG_ID               CHAR(8),
  RS_RESULT                      VARCHAR2(15),
  RS_COMMENT                     VARCHAR2(4000),
  RS_VALUE_STATUS                CHAR(1),
  RS_FRACTION                    VARCHAR2(40),
  RS_VALUE_TYPE                  VARCHAR2(10),
  RS_STAT_TYPE                   VARCHAR2(18),
  RS_DETECT_LIMIT                VARCHAR2(12),
  RS_DET_LIMIT_UOM_NBR           NUMBER(12),
  RS_DET_LIMIT_UOM_ORG           CHAR(8),
  RS_DETECT_COMMENT              VARCHAR2(254),
  RS_LAB_BATCH_ID                VARCHAR2(12),
  RS_LAB_CERT                    VARCHAR2(1),
  RS_TSRANLPR_IS_NUMBER          NUMBER(12),
  RS_TSRANLPR_ORG_ID             VARCHAR2(8),
  RS_TSRLSPP_IS_NUMBER           NUMBER(12),
  RS_TSRLSPP_ORG_ID              CHAR(8),
  RS_ANALYSIS_DATE               DATE,
  RS_ANALYSIS_TIME               DATE,
  RS_ANALYSIS_TIME_ZONE          VARCHAR2(3),
  RS_UPPER_QUANT_LIMIT           VARCHAR2(12),
  RS_LOWER_QUANT_LIMIT           VARCHAR2(12),
  RS_DURATION_BASIS              VARCHAR2(10),
  RS_TEMP_BASIS                  VARCHAR2(8),
  RS_WEIGHT_BASIS                VARCHAR2(12),
  RS_PRECISION                   VARCHAR2(12),
  RS_CONF_LEVEL                  VARCHAR2(8),
  RS_TROPHIC_LEVEL               VARCHAR2(4),
  RS_FNCTIONAL_FEED_GRP          VARCHAR2(6),
  RS_TAXON_POLLUTION             VARCHAR2(4),
  RS_IMPORT_LINE_NO              NUMBER(10),
  RS_LOWER_RANGE_VALUE           NUMBER(13,5),
  RS_UPPER_RANGE_VALUE           NUMBER(13,5),
  RS_REPL_ANALYSIS_NUM           NUMBER(2),
  RS_DOCUMENT                    VARCHAR2(256),
  RS_TSRDLIN_ORG_ID              VARCHAR2(8),
  RS_TSRDLIN_IS_NUMBER           NUMBER(12),
  RS_FRACTION_TSMPRMVL_IS_NUMBER NUMBER(12),
  RS_FRACTION_TSMPRMVL_ORG_ID    VARCHAR2(8),
  RS_HABIT_TSMPRMVL0IS_NUMBER    NUMBER(12),
  RS_HABIT_TSMPRMVL0ORG_ID       VARCHAR2(8),
  RS_VOLT_TSMPRMVL1IS_NUMBER     NUMBER(12),
  RS_VOLT_TSMPRMVL1ORG_ID        VARCHAR2(8),
  RS_D_ASSND_SEQ_NUM             NUMBER(5),
  RS_BIAS                        VARCHAR2(12),
  RS_CONF_LVL_CORR_BIAS          CHAR(1),
  RS_SPECIES_NUMBER              VARCHAR2(8),
  RS_REF_PT_FROM_NAME            VARCHAR2(20),
  RS_REF_PT_TO_NAME              VARCHAR2(20),
  RS_DILUTION_IND_CODE           CHAR(1),
  RS_RECOVERY_IND_CODE           CHAR(1),
  RS_CORRECTION_IND_CD           CHAR(1),
  RS_CELL_TYPE_NM                VARCHAR2(11),
  RS_CELL_SHAPE_TYPE_NM          VARCHAR2(18),
  RS_IMPORT_SEQ                  NUMBER(10),
  RS_DATA_LINE_NUMBER            NUMBER(8),
  RS_DATA_LINE_NAME              VARCHAR2(25)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULTS
  add constraint RS_PK primary key (RS_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULTS
  add constraint RS_FA_SEQ_FK foreign key (RS_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
alter table SIM_RESULTS
  add constraint RS_SIL_FK foreign key (RS_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
create index RS_FA_SEQ_IDX on SIM_RESULTS (RS_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
create index RS_IMPORT_SEQ_IDX on SIM_RESULTS (RS_IMPORT_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );


prompt
prompt Creating table SIM_RESULT_CLASS_INDICATOR
prompt =========================================
prompt
create table SIM_RESULT_CLASS_INDICATOR
(
  RCI_SEQ                 NUMBER(10) not null,
  RCI_FA_SEQ              NUMBER(10) not null,
  RCI_BRG_SEQ             NUMBER(10),
  RCI_RS_SEQ              NUMBER(10) not null,
  RCI_TSRRSULT_IS_NUMBER  NUMBER(12),
  RCI_TSRRSULT_ORG_ID     CHAR(8),
  RCI_LOWER_BND_AMT       NUMBER(7,2),
  RCI_UPPER_BND_AMT       NUMBER(7,2),
  RCI_TSRUOM_IS_NUMBER    NUMBER(12),
  RCI_TSRUOM_ORG_ID       CHAR(8),
  RCI_PARTICLE_SIZE_BASIS VARCHAR2(40),
  RCI_PRIMARY_CLASS_IND   VARCHAR2(12),
  RCI_SECOND_CLASS_IND    VARCHAR2(12),
  RCI_IMPORT_SEQ          NUMBER(10)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULT_CLASS_INDICATOR
  add constraint RCI_PK primary key (RCI_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULT_CLASS_INDICATOR
  add constraint RCI_BRG_FK foreign key (RCI_BRG_SEQ)
  references SIM_BIO_RESULTS_GRP (BRG_SEQ);
alter table SIM_RESULT_CLASS_INDICATOR
  add constraint RCI_FA_FK foreign key (RCI_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
alter table SIM_RESULT_CLASS_INDICATOR
  add constraint RCI_RS_FK foreign key (RCI_RS_SEQ)
  references SIM_RESULTS (RS_SEQ);
alter table SIM_RESULT_CLASS_INDICATOR
  add constraint RCI_SIL_FK foreign key (RCI_IMPORT_SEQ)
  references SIM_IMPORT_LOG (SIL_SEQ);
create index RCI_RS_IDX on SIM_RESULT_CLASS_INDICATOR (RCI_RS_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
  
prompt
prompt Creating table SIM_RESULT_LAB_REMARKS
prompt =====================================
prompt
create table SIM_RESULT_LAB_REMARKS
(
  SRLR_SEQ                NUMBER(10) not null,
  SRLR_RS_SEQ             NUMBER(10) not null,
  SRLR_TSRLBRMK_IS_NUMBER NUMBER(12),
  SRLR_TSRLBRMK_ORG_ID    VARCHAR2(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULT_LAB_REMARKS
  add constraint SRLR_PK primary key (SRLR_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_RESULT_LAB_REMARKS
  add constraint SRLR_RS_FK foreign key (SRLR_RS_SEQ)
  references SIM_RESULTS (RS_SEQ);

prompt
prompt Creating table SIM_SAMPLE
prompt =========================
prompt
create table SIM_SAMPLE
(
  SS_SEQ                NUMBER(10) not null,
  SS_FA_SEQ             NUMBER(10) not null,
  SS_TSRFDACT_IS_NUMBER NUMBER(12),
  SS_TSRFDACT_ORG_ID    CHAR(8),
  SS_DURATION_TIME      NUMBER(3),
  SS_DURATION_UNIT      VARCHAR2(10),
  SS_TOTAL_VOLUME_MSR   NUMBER(7,2),
  SS_TOTAL_VOL_UOM      VARCHAR2(3),
  SS_TOTAL_WEIGHT_MSR   NUMBER(7,2),
  SS_TOTAL_WT_UOM       VARCHAR2(3),
  SS_DATA_FILE_NAME_LOC VARCHAR2(60),
  SS_CONTAINER_TYPE_NM  VARCHAR2(32),
  SS_CONTAINER_COLOR    VARCHAR2(10),
  SS_CONTAINER_SIZE_MSR NUMBER(6,2),
  SS_CONTAINER_SIZE_UN  VARCHAR2(3),
  SS_TEMP_PRESERVN_TYPE VARCHAR2(25),
  SS_PARENT_IND_CODE    VARCHAR2(1),
  SS_GEAR_DEPLOYMENT    VARCHAR2(1999),
  SS_TRANSPORT_STORAGE  VARCHAR2(1999),
  SS_PRESRV_STRGE_PRCDR VARCHAR2(1999)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_SAMPLE
  add constraint SS_PK primary key (SS_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_SAMPLE
  add constraint SSE_FA_FK foreign key (SS_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
create index SIM_SAMPLE_IDX on SIM_SAMPLE (SS_FA_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_TRANSLATIONS
prompt ===============================
prompt
create table SIM_TRANSLATIONS
(
  ST_SEQ            NUMBER(10) not null,
  ST_SICDT_SEQ      NUMBER(10) not null,
  ST_USER_CODE      VARCHAR2(80),
  ST_STORET_CODE    VARCHAR2(80),
  ST_CHAR_IS_NUMBER NUMBER(12),
  ST_IS_NUMBER      NUMBER(12),
  ST_ORG_ID         VARCHAR2(8),
  ST_TABLE_NAME     VARCHAR2(8)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRANSLATIONS
  add constraint ST_PK primary key (ST_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRANSLATIONS
  add constraint ST_SICDT_SEQ_FK foreign key (ST_SICDT_SEQ)
  references SIM_IMP_CFG_DETS (SICDT_SEQ);
create index ST_SICDT_SEQ_IDX on SIM_TRANSLATIONS (ST_SICDT_SEQ)
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table SIM_TRAP_NET
prompt ===========================
prompt
create table SIM_TRAP_NET
(
  STN_SEQ                NUMBER(10) not null,
  STN_FA_SEQ             NUMBER(10) not null,
  STN_TSRFDACT_IS_NUMBER NUMBER(12),
  STN_TSRFDACT_ORG_ID    CHAR(8),
  STN_SAMPLING_DUR       NUMBER(4,2),
  STN_SAMPLING_DUR_UNIT  VARCHAR2(10),
  STN_ORIENT_TO_CUR      VARCHAR2(15),
  STN_REL_CURRENT        NUMBER(3),
  STN_REL_WIND           NUMBER(3),
  STN_COMMENT            VARCHAR2(254)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRAP_NET
  add constraint STN_PK primary key (STN_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRAP_NET
  add constraint STN_FA_FK foreign key (STN_FA_SEQ)
  references sim_field_activities (FA_SEQ);
  
prompt
prompt Creating table SIM_TRAWL_OPS_DET
prompt ================================
prompt
create table SIM_TRAWL_OPS_DET
(
  TOD_SEQ                 NUMBER(10) not null,
  TOD_FA_SEQ              NUMBER(10) not null,
  TOD_TSRFDACT_IS_NUMBER  NUMBER(12),
  TOD_TSRFDACT_ORG_ID     VARCHAR2(8),
  TOD_FISHED_DURATION     NUMBER(4,2),
  TOD_FISHED_DUR_UOM      VARCHAR2(10),
  TOD_BOAT_SPEED_MSR      NUMBER(3,1),
  TOD_BOAT_SPEED_UOM      VARCHAR2(10),
  TOD_FISHED_DISTANCE     NUMBER(5,2),
  TOD_FISHED_DISTANCE_UOM VARCHAR2(3),
  TOD_REL_CURRENT_DIR     NUMBER(3),
  TOD_REL_WIND_DIR        NUMBER(3),
  TOD_COMMENT_TEXT        VARCHAR2(254)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRAWL_OPS_DET
  add constraint TOD_PK primary key (TOD_SEQ)
  using index
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
alter table SIM_TRAWL_OPS_DET
  add constraint TOD_FA_FK foreign key (TOD_FA_SEQ)
  references SIM_FIELD_ACTIVITIES (FA_SEQ);
  
-- Create table
create table SIM_SESSION_VARS
(
  SSV_USER      VARCHAR2(30) not null,
  SSV_CONTEXT   VARCHAR2(30) not null,
  SSV_TIMESTAMP DATE,
  SSV_NAME      VARCHAR2(30) not null,
  SSV_VALUE     VARCHAR2(300)
)
tablespace &&DATA_TABLESPACE
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 16K
    minextents 1
    maxextents unlimited
  );
-- Add comments to the table 
comment on table SIM_SESSION_VARS
  is 'Application-level variables persistent throughout an application session.';
-- Create/Recreate primary, unique and foreign key constraints 
alter table SIM_SESSION_VARS
  add constraint SSV_PK primary key (SSV_USER, SSV_CONTEXT, SSV_NAME)
  using index 
  tablespace &&INDEX_TABLESPACE
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );  

