SPOOL SETUP_SIM_1.LOG
SET VERIFY OFF
SET SERVEROUTPUT ON SIZE 10000;
SET SQLBLANKLINES ON

@@..\CONFIG.SQL

CONNECT &&DBA_USER/&&DBA_PASSWORD@&&DATABASE

PROMPT Creating Tablespaces (if requested in config.bat)
BEGIN
	IF UPPER('&&CREATE_SIM_TABLESPACES')='YES' THEN
    BEGIN
			EXECUTE IMMEDIATE 'CREATE TABLESPACE &&INDEX_TABLESPACE '
				|| 'DATAFILE ''&&INDEX_TABLESPACE_DATA_FILE'' SIZE 100M '
				|| 'DEFAULT STORAGE (INITIAL 32K NEXT 64K MAXEXTENTS UNLIMITED)';
			DBMS_OUTPUT.PUT_LINE('&&INDEX_TABLESPACE Tablespace created.');
		EXCEPTION
			WHEN OTHERS THEN
				DBMS_OUTPUT.PUT_LINE(SQLERRM);
		END;
		BEGIN
 			EXECUTE IMMEDIATE 'CREATE TABLESPACE &&DATA_TABLESPACE '
 				|| 'DATAFILE ''&&DATA_TABLESPACE_DATA_FILE'' SIZE 200M '
 				|| 'DEFAULT STORAGE (INITIAL 64K NEXT 128K MAXEXTENTS UNLIMITED)';
 			DBMS_OUTPUT.PUT_LINE('&&DATA_TABLESPACE Tablespace created.');
 		EXCEPTION
			WHEN OTHERS THEN
				DBMS_OUTPUT.PUT_LINE(SQLERRM);
		END;
 	END IF;
  BEGIN
    EXECUTE IMMEDIATE 'ALTER SYSTEM SET UTL_FILE_DIR = ''*'' SCOPE = SPFILE';
  EXCEPTION
    WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE('UTL_FILE_DIR could not be set.  See your Install Guide for assistance.');
  END;
END;
/

PROMPT Creating SIM User
CREATE USER &&SIM_APP_SCHEMA IDENTIFIED BY &&SIM_PASSWORD
  DEFAULT TABLESPACE &&DATA_TABLESPACE
  TEMPORARY TABLESPACE &&TEMP_TABLESPACE
QUOTA UNLIMITED ON &&DATA_TABLESPACE
QUOTA UNLIMITED ON &&INDEX_TABLESPACE;

GRANT CONNECT TO &&SIM_APP_SCHEMA;
GRANT CREATE ANY DIRECTORY TO &&SIM_APP_SCHEMA;
GRANT CREATE ANY INDEX TO &&SIM_APP_SCHEMA;
GRANT CREATE PROCEDURE TO &&SIM_APP_SCHEMA;
GRANT DROP ANY DIRECTORY TO &&SIM_APP_SCHEMA;

prompt Creating SIM role
CREATE ROLE &&SIM_ROLE;

GRANT CONNECT TO &&STORET_USER;
GRANT CONNECT TO &&STORET1_USER;

PROMPT Connecting to STORET Schema
CONNECT &&STORET_USER/&&STORET_PASSWORD@&&DATABASE
SET VERIFY OFF

PROMPT Granting STORET privileges to SIM
GRANT SELECT ON &&STORET_USER..APP_HELP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..FORMS_HELP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..HELP_KEYWORDS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..HELP_RELATED TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMERMSG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMESTRY TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMFHU TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMGEOPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMGEOUN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMLTHUN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMMAD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMNAICS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMNAL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMPRMVL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMPROLE TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMPSR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMRRR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMSIC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSMVSTC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRANLEQ TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRBIOPT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCALT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCHALS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCHAR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCHTYP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCPV TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRCTCA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRFLDGR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRLBRMK TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRMATRX TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRPROJSQ TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRRLIST TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRRPARM TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT ON &&STORET_USER..TSRUOM TO &&SIM_APP_SCHEMA WITH GRANT OPTION;

PROMPT Connecting to STORET1 Schema
CONNECT &&STORET1_USER/&&STORET1_PASSWORD@&&DATABASE
SET VERIFY OFF

GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMADDR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMALP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMBLOB TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMCHKPT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMCPORG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMCSNG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMEADDR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMEISN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMERS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMESTLC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMFCLTY TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMFILL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMFNA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMFSA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMGLL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMGNTXT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMHOLE TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMIGUA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMINTVL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMLOG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMOCNLC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMOPNG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMORGAN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPCOA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPERSN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPIPE TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPMGRD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPMTCT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPPRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPROGM TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPROJ TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPRPRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPSA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPSRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPSW TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMPUMP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMRFLBL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMSCTS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMSOI TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMSPRNG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMSTATN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMTBINF TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMUOA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMUSER TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMVSC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMWELL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSMWLE TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRAAL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRADL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRANLPR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRBRG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRBRGI TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCCGA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCHDEF TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCHGRP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCITN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCLDES TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRCPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRDLIN TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRDQL TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSREOD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFACOA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFAFSA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFAPEA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFAPRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFAQSA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFDACT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFDSET TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFLDPR TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFQS TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFQSDP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRFQSPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRGRCFG TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRHCSC TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRLAB TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRLSPP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSROAPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSROAPCA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSROLSPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSROPPRD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRPOPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRRCI TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRRLRA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRRQCAF TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRRSULT TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRSDP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRSMPLE TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRSTVST TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRTNOD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRTOD TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRTPA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRTRIP TO &&SIM_APP_SCHEMA WITH GRANT OPTION;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&STORET1_USER..TSRTSA TO &&SIM_APP_SCHEMA WITH GRANT OPTION;

PROMPT Connecting to SIM Schema
CONNECT &&SIM_APP_SCHEMA/&&SIM_PASSWORD@&&DATABASE
SET VERIFY OFF

PROMPT Creating tables
@@CREATE_TABLES.SQL

PROMPT Creating sequences
@@CREATE_SEQUENCES.SQL

PROMPT Creating synonyms
@@CREATE_SYNONYMS.SQL

SPOOL SETUP_SIM_2.LOG

SET DEFINE OFF

PROMPT Creating procedures, packages, and views
PROMPT
PROMPT SIM_FIELD_ACTIVITIES_VW
@@..\..\DBObjects\SIM_FIELD_ACTIVITIES_VW.SQL
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_LOG_VW
@@..\..\DBObjects\SIM_IMPORT_LOG_VW.SQL
SHOW ERRORS
PROMPT
PROMPT SIM_IMP_CFG_VW
@@..\..\DBObjects\SIM_IMP_CFG_VW.SQL
SHOW ERRORS
PROMPT
PROMPT SIM_TRANSLATIONS_VW
@@..\..\DBObjects\SIM_TRANSLATIONS_VW.SQL
SHOW ERRORS

PROMPT SIM_LIB_PKG (spec)
@@..\..\DBObjects\SIM_LIB_PKG.SPC
SHOW ERRORS
PROMPT
PROMPT SIM_EVENT_LOG_PKG
@@..\..\DBObjects\SIM_EVENT_LOG_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_LIB_PKG (body)
@@..\..\DBObjects\SIM_LIB_PKG.BDY
SHOW ERRORS
PROMPT
PROMPT SIM_COMMIT
@@..\..\DBObjects\SIM_COMMIT.PRC
SHOW ERRORS
PROMPT
PROMPT SIM_STATION_SORT
@@..\..\DBObjects\SIM_STATION_SORT.FNC
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_PKG
@@..\..\DBObjects\SIM_IMPORT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_PKG
@@..\..\DBObjects\SIM_EXPORT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_INTERFACE_EXTRAS_PKG
@@..\..\DBObjects\SIM_INTERFACE_EXTRAS_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_MANAGE_CONFIG_PKG
@@..\..\DBObjects\SIM_MANAGE_CONFIG_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_PROJECT_PKG
@@..\..\DBObjects\SIM_IMPORT_PROJECT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_STATION_PKG
@@..\..\DBObjects\SIM_IMPORT_STATION_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_LOCATIONS_PKG
@@..\..\DBObjects\SIM_IMPORT_LOCATIONS_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_WELLS_PKG
@@..\..\DBObjects\SIM_IMPORT_WELLS_PKG.PCK
SHOW ERRORS

SPOOL SETUP_SIM_3.LOG

PROMPT
PROMPT SIM_IMPORT_RESULT_EXTRAS
@@..\..\DBObjects\SIM_IMPORT_RESULT_EXTRAS.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_RESULT_CHECKS
@@..\..\DBObjects\SIM_IMPORT_RESULT_CHECKS.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_IMPORT_RESULT_PKG
@@..\..\DBObjects\SIM_IMPORT_RESULT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_LOCATION_PKG
@@..\..\DBObjects\SIM_EXPORT_LOCATION_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_PROJECT_PKG
@@..\..\DBObjects\SIM_EXPORT_PROJECT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_RESULT_PKG
@@..\..\DBObjects\SIM_EXPORT_RESULT_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_STATION_PKG
@@..\..\DBObjects\SIM_EXPORT_STATION_PKG.PCK
SHOW ERRORS
PROMPT
PROMPT SIM_EXPORT_WELL_PKG
@@..\..\DBObjects\SIM_EXPORT_WELL_PKG.PCK
SHOW ERRORS
PROMPT

SET DEFINE ON

SPOOL SETUP_SIM_4.LOG

prompt Loading Lookup Tables
@@LOAD_LOOKUP_TABLES.SQL

prompt Loading Example Import Configurations
@@LOAD_EXAMPLE_CONFIGURATIONS.SQL

prompt Updating GPS coordinate columns in STORET
@@UPDATE_DECIMAL_COORD.SQL

prompt Updating missing UOM in STORET
@@UPDATE_UOM.SQL

prompt Granting privileges to SIM role
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_CPORG_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_LOC_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_PERSONNEL_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_PROJECTS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_BRGI_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_BRG_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_ESTUARY_LOC_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_LINES_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EXPORT_STORET_IDS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITY_PARENT_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_GREAT_LAKE_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_HLP_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMPORT_LOG_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_DETS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_INSTRS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_LINES_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_OCEAN_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_PROJECTS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_RESULTS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_RESULT_CLASS_INDICATOR_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_SAMPLE_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_SRLR_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_STATIONS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_STATION_LOCATIONS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_STATION_VISITS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_STATION_WELLS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_TRANSLATIONS_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_TRAP_NET_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_TRAWL_OPS_DET_SEQ TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_TRIPS_SEQ TO &&SIM_ROLE;

GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_CHARACTERISTIC_USGS_CODES TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS_TYPE TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_TYPE TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_HELP TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_ALLOW_VALUES TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_COLS TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_DEFS TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_FMTS TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_FMT_CHOICES TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_INSTRS TO &&SIM_ROLE;
GRANT SELECT ON &&SIM_APP_SCHEMA..SIM_IMP_INSTR_CHOICES TO &&SIM_ROLE;

GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_CPORG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_PERSONNEL TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_ACTIVITY_PROJECTS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_ACTUAL_ACTIVITY_LOC TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_BIO_RESULTS_GRP TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_BIO_RESULTS_GRP_INDIVIDUAL TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_CONFIG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_ESTUARY_LOC TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_DETAILS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_LINES TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_EXPORT_LOG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_EXPORT_STORET_IDS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITY_PARENT TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_GREAT_LAKE TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMPORT_LOG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMP_CFG TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_DETS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_INSTRS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMP_LINES TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_OCEAN TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_PROJECTS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_RESULTS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_RESULT_CLASS_INDICATOR TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_RESULT_LAB_REMARKS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_SAMPLE TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_SESSION_VARS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_STATIONS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_STATION_LOCATIONS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_STATION_VISITS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_STATION_WELLS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_TRANSLATIONS TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_TRAP_NET TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_TRAWL_OPS_DET TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_TRIPS TO &&SIM_ROLE;

GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_FIELD_ACTIVITIES_VW TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMPORT_LOG_VW TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_IMP_CFG_VW TO &&SIM_ROLE;
GRANT SELECT, INSERT, UPDATE, DELETE ON &&SIM_APP_SCHEMA..SIM_TRANSLATIONS_VW TO &&SIM_ROLE;

GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_COMMIT TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EVENT_LOG_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_LOCATION_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_PROJECT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_RESULT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_STATION_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_EXPORT_WELL_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_LOCATIONS_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_PROJECT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_CHECKS TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_EXTRAS TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_RESULT_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_STATION_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_IMPORT_WELLS_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_INTERFACE_EXTRAS_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_LIB_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_MANAGE_CONFIG_PKG TO &&SIM_ROLE;
GRANT EXECUTE ON &&SIM_APP_SCHEMA..SIM_STATION_SORT TO &&SIM_ROLE;

CONNECT &&DBA_USER/&&DBA_PASSWORD@&&DATABASE
SET VERIFY OFF

@@CREATE_SIM_SYNONYMS_FOR_STORUSER.SQL
SPOOL OFF

REVOKE CONNECT FROM &&STORET_USER;
REVOKE CONNECT FROM &&STORET1_USER;

SPOOL DONE_SETUP_SIM.LOG
PROMPT SIM Setup Completed
SPOOL OFF
QUIT
