<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:template match="/">
    <xsl:for-each select="//TripDetail">
      <xsl:variable name="trip_string">
      <xsl:value-of select="TripIdentifier"/>|<xsl/>
      <xsl:value-of select="TripStartDate"/>|<xsl/>
      <xsl:value-of select="TripStopDate"/>|<xsl/>
      <xsl:value-of select="TripName"/>|<xsl/>
      </xsl:variable>
      <xsl:for-each select="StationVisitDetail">
        <xsl:variable name="station_string">
        <xsl:value-of select="VisitIdentifier"/>|<xsl/>
        <xsl:value-of select="VisitArrivalDate"/>|<xsl/>
        <xsl:value-of select="StationIdentifier"/>|<xsl/>
        <xsl:value-of select="VisitCommentStationConditionText"/>|<xsl/>
        </xsl:variable>
        <xsl:for-each select="FieldActivityDetail">
          <xsl:variable name="activity_string">
          <xsl:value-of select="ActivityIdentifier"/>|<xsl/>
          <xsl:variable name="v_count" select="count(ProjectIdentifier)"></xsl:variable>
          <xsl:for-each select="ProjectIdentifier">
            <xsl:value-of select="text()"/>
            <xsl:if test="$v_count - position() > 0">\</xsl:if>
          </xsl:for-each><xsl>|</xsl>
          <xsl:value-of select="ActivityQCIndicator"/>|<xsl/>
          <xsl:value-of select="ActivityCategoryCode"/>|<xsl/>
          <xsl:value-of select="ActivityMediumCode"/>|<xsl/>
          <xsl:value-of select="SampledMatrixName"/>|<xsl/>
          <xsl:value-of select="ActivityReplicateNumberValue"/>|<xsl/>
          <xsl:if test="not(ActivityStartDateTimeDetail)">|||</xsl:if>
          <xsl:for-each select="ActivityStartDateTimeDetail"><xsl/>
            <xsl:value-of select="Date"/>|<xsl/>
            <xsl:if test="not(TimeDetail)">||</xsl:if>
            <xsl:for-each select="TimeDetail">
              <xsl:value-of select="Time"/>|<xsl/>
              <xsl:value-of select="TimeZoneCode"/>|<xsl/>
            </xsl:for-each>
          </xsl:for-each>
          <xsl:if test="not(ActivityEndDateTimeDetail)">|||</xsl:if>
          <xsl:for-each select="ActivityEndDateTimeDetail">
            <xsl:value-of select="Date"/>|<xsl/>
            <xsl:if test="not(TimeDetail)">||</xsl:if>
            <xsl:for-each select="TimeDetail">
              <xsl:value-of select="Time"/>|<xsl/>
              <xsl:value-of select="TimeZoneCode"/>|<xsl/>
            </xsl:for-each>
          </xsl:for-each>
          <xsl:value-of select="ActivityCommentText"/>|<xsl/>
          <xsl:value-of select="SampleCollectionProcedureIdentifier"/>|<xsl/>
          <xsl:value-of select="SampleCollectionProcedureCommentText"/>|<xsl/>
          <xsl:value-of select="SampleTransportStorageIdentifier"/>|<xsl/>
          <xsl:value-of select="SampleTransportStorageCommentText"/>|<xsl/>
          <xsl:value-of select="ActivityDepthMeasure"/>|<xsl/>
          <xsl:value-of select="ActivityDepthUnitCode"/>|<xsl/>
          <xsl:value-of select="RelativeDepthIndicatorCode"/>|<xsl/>
          <xsl:value-of select="DepthMeasureReferencePointText"/>|<xsl/>
          </xsl:variable>
          <xsl:for-each select="ResultDetail">
            <xsl:variable name="result_string">
            <xsl:value-of select="CharacteristicName"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultValueText"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultValueUnitCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultSampleFractionCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultStatisticTypeCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultValueTypeCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultTemperatureBasisCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultDurationBasisCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultWeightBasisCode"/>|<xsl/>
            <xsl:value-of select="CharacteristicResultCommentText"/>|<xsl/>
            <xsl:if test="not(CharacteristicResultFieldLabAnalyticalDetail)">||</xsl:if>
            <xsl:for-each select="CharacteristicResultFieldLabAnalyticalDetail">
              <xsl:value-of select="CharacteristicResultFieldLabAnalyticalProcedureIdentifier"/>|<xsl/>
              <xsl:value-of select="CharacteristicResultFieldLabAnalyticalSourceAcronym"/>|<xsl/>
            </xsl:for-each>
            <xsl:if test="not(LaboratoryDetail)">|||||||</xsl:if>
            <xsl:for-each select="LaboratoryDetail">
            <xsl:value-of select="LaboratoryIdentifier"/>|<xsl/>
            <xsl:value-of select="LaboratoryBatchIdentifier"/>|<xsl/>
            <xsl:value-of select="LaboratoryCertificationIndicator"/>|<xsl/>
            <xsl:if test="not(LaboratoryAnalysisDateTimeDetail)">|||</xsl:if>
            <xsl:for-each select="LaboratoryAnalysisDateTimeDetail">
              <xsl:value-of select="Date"/>|<xsl/>
              <xsl:if test="not(TimeDetail)">||</xsl:if>
              <xsl:for-each select="TimeDetail">
                <xsl:value-of select="Time"/>|<xsl/>
                <xsl:value-of select="TimeZoneCode"/>|<xsl/>
              </xsl:for-each>
            </xsl:for-each>
            <xsl:if test="not(LaboratoryResultDetectionLimitDetail)">|</xsl:if>
            <xsl:for-each select="LaboratoryResultDetectionLimitDetail">
              <xsl:value-of select="LaboratoryResultDetectionLimitText"/>|<xsl/>
              <xsl:value-of select="LaboratoryResultDetectionLimitUnitCode"/>
            </xsl:for-each>
          </xsl:for-each>
          </xsl:variable>
          <xsl:value-of select="$trip_string"/>
          <xsl:value-of select="$station_string"/>
          <xsl:value-of select="$activity_string"/>
          <xsl:value-of select="$result_string"/>
          <xsl:text disable-output-escaping="yes">
          	<![CDATA[
]]>
          </xsl:text>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:for-each>
    </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
