/*******************************************************
Filename		:  	DW_char_alias_popup.sql
Release 		:  	c2.0
SIR			:  	1437
Description		:  	Displays a list of available Characteristics that match the
				users search criteria and allows the user to select one 
				or more Characteristics. The values are returned to
				the Station Selection Criteria page.
Author			:  	Joseph Wilson
Date			: 	March 13, 2003
				April 14, 2003 -- added column names to alias list box
				April 16, 2003 -- added column names to standard name list box
				May 29, 2003 -- added ORDER BY clauses to CURSORs -JW
				June 3, 2003 -- order by search_name instead of display_name -JW
				June 10, 2003 -- removed hard coded schema references -JW
				June 11, 2003 -- added func to only return first 60 chars of alias name -JW
                        Aug 8, 2003 -- converted char alias to uppercase in WHERE clause. -C Tsang
Comments		:  	Uses the passback() function in the DW_storet.js file
				Modified to allow char alias searches.
				Check screen width.
**********************************************************/
SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_CHAR_ALIAS_POPUP (v_CharString char, taxon_filter char, as_char_alias_type number) 
AS 

v_CharStringCap varchar2(20) := UPPER(v_CharString);
script_path varchar2(1000);

-- query by search name and retrieve display name
CURSOR c_CharList IS
	SELECT display_name, pk_isn
		FROM DI_CHARACTERISTIC
		WHERE search_name like v_CharStringCap||'%'
		AND type_code <> 'T'
		ORDER BY search_name;

CURSOR c_CharAliasList IS
	SELECT display_name, char_alias, ch.pk_isn
		FROM DI_CHARACTERISTIC ch, LU_CHAR_ALIAS ca
		WHERE ch.pk_isn = fk_characteristic
		AND UPPER(char_alias) like v_CharStringCap||'%'
		AND fk_char_alias_type = as_char_alias_type
		AND type_code <> 'T'
		ORDER BY char_alias;

CURSOR c_CharListTaxon IS
	SELECT display_name, pk_isn
		FROM DI_CHARACTERISTIC
		WHERE search_name like v_CharStringCap||'%'
		ORDER BY search_name;

CURSOR c_CharAliasListTaxon IS
	SELECT display_name, char_alias, ch.pk_isn
		FROM DI_CHARACTERISTIC ch, LU_CHAR_ALIAS
		WHERE ch.pk_isn = fk_characteristic
		AND UPPER(char_alias) like v_CharStringCap||'%'
		AND fk_char_alias_type = as_char_alias_type
		ORDER BY char_alias;

BEGIN
script_path := DW_glob_var.lv_script_path;
htp.htmlOpen;
htp.headOpen;
htp.print('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
htp.title( 'STORET: Characteristic Search Results');
htp.print('<SCRIPT LANGUAGE="JavaScript1.2" SRC='||script_path||'>');
htp.print( '</SCRIPT>' );
htp.print('<basefont face="Arial, Helvetica, sans-serif" size="2">');
htp.headClose;
-- use char cursor if default STORET names is chosen, else use char alias cursors
IF as_char_alias_type = 0 THEN
	htp.bodyOpen( 'onload="document.forms[0].as_county.selectedIndex = -1"');
	htp.print( '<b>Select One or More Characteristics</b>' );
	htp.PRINT('<form name="select_char">');
	--htp.print('<FONT face="Courier">');
	--htp.formSelectOpen( cname => 'as_char', nsize => '10', cattributes => 'multiple');

htp.print('<FONT style="font-size: 9pt; font-family: Courier New, Courier, monospace">');
htp.formSelectOpen('as_char', nsize => '10', cattributes => 'tabindex=1 multiple style="font-size: 8pt; font-family: Courier New, Courier, monospace"');
htp.formSelectOption('Characteristic Name', cattributes => 'value=0');
htp.FormSelectOption('________________________________________________________',cattributes => 'value=0'); 

	IF taxon_filter = 'ON' THEN
		FOR cv_char IN c_CharList LOOP
			HTP.FormSelectOption(cv_char.display_name,cattributes => 'value ='||cv_char.pk_isn);
		END LOOP;
	ELSE
		FOR cv_char IN c_CharListTaxon LOOP
			HTP.FormSelectOption(cv_char.display_name,cattributes => 'value ='||cv_char.pk_isn);
		END LOOP;
	END IF;
ELSE
-- for char alias searches, display options in two columns.  the first column contains the
-- default STORET display char name.  The second contains the alias name.

	htp.print('<BODY onload=adjust_width_n(document.forms[0].as_char,"~","60~60","None","N");>');
	htp.print( '<b>Select One or More Characteristics</b>' );
	htp.PRINT('<form name="select_char">');
	htp.print('<FONT style="font-size: 9pt; font-family: Courier New, Courier, monospace">');
	--htp.print('<SELECT NAME="as_char" SIZE="10" multiple style="font-size: 8pt; font-family: Courier New, Courier, monospace">');
htp.formSelectOpen('as_char', nsize => '10', cattributes => 'tabindex=1 multiple style="font-size: 8pt; font-family: Courier New, Courier, monospace"');
htp.formSelectOption('Characteristic Name~Characteristic Alias Name', cattributes => 'value=0');
htp.FormSelectOption('________________________________________________________________________________________________________________________',cattributes => 'value=0'); 


	IF taxon_filter = 'ON' THEN
		FOR cv_char IN c_CharAliasList LOOP
			HTP.FormSelectOption(cv_char.display_name||'~'||substr(cv_char.char_alias,0,60),cattributes => 'value ='||cv_char.pk_isn);
		END LOOP;
	ELSE
		FOR cv_char IN c_CharAliasListTaxon LOOP
			HTP.FormSelectOption(cv_char.display_name||'~'||substr(cv_char.char_alias,0,60),cattributes => 'value ='||cv_char.pk_isn);
		END LOOP;
	END IF;
END IF;
HTP.FormSelectClose;
htp.print('</font><br><font face="Arial"><INPUT TYPE="button" VALUE="Select" onclick="passback(''CHAR_ALIAS'')"> <INPUT TYPE="button" VALUE="Cancel" onclick="Close_Onclick()"></font>' );
htp.formclose;
htp.bodyClose;
htp.htmlClose;
END;
/
SHOW ERRORS;