/*******************************************************
Filename		:  	DW_station_hub_custom.sql
Release 		:  	STORET c2.0
SIR			:  	1370
Description		:  	Gatekeeper procedure that produces a shell HTML page
				and calls the procedure to generate a report or view a list
				of stations based on the user selection.
Author		:  	Joseph Wilson
Date			: 	November 11, 2002; December 5, 2002
                        April 30, 2003 Pass '8' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459  
                        08/15/2003 - Removed 'BETA' from the page title. -CT
Comments		:  	Displays a link to the report file created by the report generating
				procedure.  The View Station List path was disabled on 12/4.
**********************************************************/

CREATE OR REPLACE PROCEDURE DW_Station_Hub_Custom
(v_FromStmt		IN	VARCHAR2,
v_WhereStmt		IN 	VARCHAR2,
v_StationCount		IN 	VARCHAR2,
v_Columns 		owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--
--The out_file variable will contain the entire URL of the file created within 
--the called download procedures.
--
out_file	  	varchar2(200);

BEGIN
/**
IF report_type = 'LIST' THEN
	page_title :='BETA - View Station List';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
	htp.print(page_title||' - You have requested to view a list of available stations');
	DW_STN_LIST(v_FromStmt,v_WhereStmt);
	htp.print('</center>');
	htp.Br;
	htp.Br;
	--bottom_of_page('Download Site Description Short',16);
	DW_bottom_of_page();
ELSE
**/
	page_title :='Download Site Descriptions';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
	IF report_type = 'CUSTOM' THEN
		htp.print(page_title||' - You have requested to download a custom site description');
		DW_station_download_custom(v_FromStmt,v_WhereStmt,v_Columns,'NONE',out_file);
/**
	ELSIF report_type = 'LONG' THEN
		htp.print(page_title||' - You have requested to download a long site description');
		WH_station_download_long(v_FromStmt,v_WhereStmt,'NONE',out_file);
	ELSE
		htp.print(page_title||' - You have requested to download a short site description');
		WH_station_download_short(v_FromStmt,v_WhereStmt,'NONE',out_file);
**/
	END IF;
	htp.Br;
	htp.Br;
	htp.Br;
	htp.anchor(out_file,htf.bold('Download your file now...'));
	htp.print('</center>');
	--bottom_of_page('Download Site Description Short',16);
	DW_bottom_of_page(8);
--END IF;
END;
/
show errors