/*******************************************************
Filename		:  FA_HABITAT_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1496
Description		:  Adds additional data element to the FA_HABITAT_RESULT fact table.
Author			:  Bill Nash
Date			:  7/08/2003
Comments		:  Created based on Regular Results
			:  8-18-2003 -- 1496 TIR 1 added units to detection_limit -WN
**********************************************************/
spool FA_HABITAT_RESULT_data2.log

connect storetw/storetw@storet.sdc
set serveroutput on
set time on

--CHAR user defined 
UPDATE FA_HABITAT_RESULT RE SET (CHARACTERISTIC_NAME, HABITAT_CLASS_NAME) =
	(SELECT hcsc.CHARACTERSTC_NAME, ch.NAME	
	FROM storet1.TSRHCSC  HCSC,
           storet1.TSRCHGRP CH
	WHERE re.FK_HCSC = HCSC.TSRHCSC_IS_NUMBER
	AND re.organization_id = HCSC.TSRHCSC_ORG_ID
      AND HCSC.TSRCHGRP_IS_NUMBER = CH.TSRCHGRP_IS_NUMBER
      AND HCSC.TSRCHGRP_ORG_ID = CH.TSRCHGRP_ORG_ID);
commit;

--CHAR system defined (overlay user defined)
UPDATE FA_HABITAT_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME	
	FROM storet.TSRCHAR CHR
	WHERE re.FK_CHAR = CHR.TSRCHAR_IS_NUMBER
	AND CHR.TSRCHAR_ORG_ID = 'ZZZZZZZZ')
   where fk_hcsc is null ;
commit;
--trip and station visit info
UPDATE FA_HABITAT_RESULT RE 
SET (STATION_ID,STATION_NAME,TRIP_ID,TRIP_NAME,STATION_VISIT_ID,TSMSTATN_IS_NUMBER,
     VISIT_START_DATE_TIME,VISIT_START_TIME_ZONE,VISIT_STOP_DATE_TIME,VISIT_STOP_TIME_ZONE) =
(SELECT st.STATION_ID,st.STATION_NAME,st.TRIP_ID,st.TRIP_NAME,st.STATION_VISIT_ID,st.TSMSTATN_IS_NUMBER,
	st.VISIT_START_DATE_TIME,st.VISIT_START_TIME_ZONE,st.VISIT_STOP_DATE_TIME,st.VISIT_STOP_TIME_ZONE	
  	from hbstatninfo_temp st
  	WHERE re.TSRSTVST_IS_NUMBER = ST.TSRSTVST_IS_NUMBER
	AND re.ORGANIZATION_ID = ST.TSRSTVST_ORG_ID);
commit;

--STATION and STATION LOCATION INFO
update FA_HABITAT_RESULT re set (fk_station,
		re.fk_org, 
		re.fk_db_cat,
		re.fk_geo_county,
		re.fk_geo_state,
		re.fk_mad_hdatum,
		re.fk_mad_hmethod,
		re.stn_latitude,
		re.stn_longitude,
		re.hydrologic_unit_code,
		re.sgo_indicator)=
	(select st.pk_isn,
		st.fk_org,
		st.fk_db_cat,
		st.fk_geo_county,
		st.fk_geo_state,
		st.fk_mad_hdatum,
		st.fk_mad_hmethod,
		st.latitude,
		st.longitude,
		st.hydrologic_unit_code,
		st.sgo_indicator
	from fa_station st
	where st.organization_id = re.organization_id
	and st.station_is_number = re.tsmstatn_is_number
	and st.location_point_type = '*POINT OF RECORD');
commit;

--RESULT UOM
UPDATE FA_HABITAT_RESULT RE SET RESULT_UNIT =
	(SELECT RSLTUOM.SHORT_FORM_NAME
	FROM storet.TSRUOM RSLTUOM
	WHERE re.TSRUOM_IS_NUMBER = RSLTUOM.TSRUOM_IS_NUMBER
  	AND RSLTUOM.TSRUOM_ORG_ID = 'ZZZZZZZZ');
commit;


--activity attributes
update FA_HABITAT_RESULT RE
set (LOCATION_POINT_TYPE    ,
POINT_SEQUENCE_NUMBER  ,
WELL_NUMBER            ,
PIPE_NUMBER            ,
ACTIVITY_LATITUDE      ,
ACTIVITY_LONGITUDE     ,
FK_ACT_MAD_HDATUM      ,
FK_ACT_MAD_HMETHOD     ,
activity_isn		,
POINT_NAME			,
MAP_SCALE) =  
(select b.LOCATION_POINT_TYPE    ,
b.POINT_SEQUENCE_NUMBER  ,
b.WELL_NUMBER            ,
b.PIPE_NUMBER            ,
b.ACTIVITY_LATITUDE      ,
b.ACTIVITY_LONGITUDE     ,
b.FK_ACT_MAD_HDATUM      ,
b.FK_ACT_MAD_HMETHOD     ,
b.activity_isn		,
b.POINT_NAME			,
b.MAP_SCALE
from hbfdact_temp2 b
where re.activity_is_number = b.activity_is_number
and  re.organization_id = b.organization_id);
commit;

--ANALYTICAL PROCEDURE
UPDATE FA_HABITAT_RESULT RE SET (ANALYTICAL_PROCEDURE_SOURCE,ANALYTICAL_PROCEDURE_ID) =
	(SELECT ANLPR.SOURCE_ACR,
		ANLPR.PROCEDURE_ID	
	FROM storet1.TSRANLPR ANLPR
	WHERE re.TSRANLPR_IS_NUMBER = ANLPR.TSRANLPR_IS_NUMBER
	AND re.TSRANLPR_ORG_ID = ANLPR.TSRANLPR_ORG_ID);
commit;

/**  following code removed from regular results
--SAMPLE PREP
UPDATE FA_HABITAT_RESULT RE SET (SAMPLE_PREP_SOURCE,SAMPLE_PREP_NAME) =
	(SELECT LSPP.SOURCE_ACR,
		LSPP.NAME
	FROM storet1.TSRLSPP LSPP
	WHERE re.TSRLSPP_IS_NUMBER = LSPP.TSRLSPP_IS_NUMBER
	AND re.TSRLSPP_ORG_ID = LSPP.TSRLSPP_ORG_ID);
commit;
**/

--LAB
UPDATE FA_HABITAT_RESULT RE SET (LAB_ID,LAB_NAME) =
	(SELECT LAB.ID_CODE,
		LAB.NAME
	FROM storet1.TSRLAB LAB
	WHERE re.TSRLAB_IS_NUMBER = LAB.TSRLAB_IS_NUMBER
	AND re.ORGANIZATION_ID= LAB.TSRLAB_ORG_ID);
commit;

--QUANT LIMITS
UPDATE FA_HABITAT_RESULT RE SET (LOWER_QUANTITATION_LIMIT,UPPER_QUANTITATION_LIMIT,DETECTION_LIMIT,
	DETECTION_LIMIT_DESCRIPTION) =
	(SELECT DQL.MIN_QUANT_LIMIT,
		DQL.MAX_QUANT_LIMIT,
		DQL.MIN_DETECT_LIMIT||' '||UOM.SHORT_FORM_NAME,
		DQL.DESCRIPTION_TEXT
	FROM storet1.TSRDQL DQL, storet.TSRUOM UOM
 	WHERE re.RESULT_IS_NUMBER = DQL.TSRRSULT_IS_NUMBER
 		AND re.ORGANIZATION_ID = DQL.TSRRSULT_ORG_ID
 		AND DQL.TSRUOM_IS_NUMBER = UOM.TSRUOM_IS_NUMBER
 		AND DQL.TSRUOM_ORG_ID = UOM.TSRUOM_ORG_ID);
commit;

--FK_DATE
update FA_HABITAT_RESULT re set fk_date_act_start = (
	select da.pk_isn from di_date da
	where TO_CHAR(re.activity_start_date_time,'DD-MON-YYYY') = da.full_date);
commit;
/** no field_procedure_id for habitat 
--** new Activity Elements section **
--FIELD PROCEDURE
update FA_HABITAT_RESULT re
set (field_procedure_id) = (
	select id_code
	from storet1.TSRFLDPR fldpr
	where re.tsrfldpr_is_number = fldpr.tsrfldpr_is_number
	and re.ORGANIZATION_ID = fldpr.tsrfldpr_org_id);
commit;
**/
/** removed sample data fro regular results 
--SAMPLE
update FA_HABITAT_RESULT re
set (container_type,container_color,temperature_presrvtn_type,presrvtn_storage_procedure) = (
	select container_type_nm,container_color,temp_preservn_type,presrv_strge_prcdr
	from storet1.tsrsmple smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
**/
/**  no gear data for habitat
--GEAR CONFIG
update FA_HABITAT_RESULT re
set (gear_config_id) = (
	select id_code
	from storet1.tsrgrcfg grcfg
	where re.tsrgrcfg_is_number = grcfg.tsrgrcfg_is_number
	and re.ORGANIZATION_ID = grcfg.tsrgrcfg_org_id);
commit;

--FIELD GEAR ID
update FA_HABITAT_RESULT re
set (field_gear_id) = (
	select id_code
	from storet.tsrfldgr fldgr
	where re.tsrfldgr_is_number = fldgr.tsrfldgr_is_number);
commit;
**/
/** no activity matrix for habitat
--ACTIVITY MATRIX
update FA_HABITAT_RESULT re
set (re.activity_matrix) = (
	select matrx.name
	from storet.tsrmatrx matrx
	where re.tsrmatrx_is_number = matrx.tsrmatrx_is_number);
commit;
**/
--GNTXT FIELDS
update FA_HABITAT_RESULT re
set (re.result_comment) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='RSLTCMNT');
commit;

update FA_HABITAT_RESULT re
set (re.text_result) = (
	select description_text
	from storet1.tsmgntxt gntxt
	where gntxt.tsrrsult_org_id = re.organization_id
		AND gntxt.tsrrsult_is_number = re.result_is_number
		AND gntxt.description_name ='DESCRIPT');
commit;

-- Lab Remarks
update FA_HABITAT_RESULT a
set a.LAB_REMARK= (select b.lbrmk from hblbrmk_temp b
       where b.tsrrsult_is_number = a.result_is_number
           and b.tsrrsult_org_id = a.organization_id);
commit;

-- FIELD SET
update FA_HABITAT_RESULT a
set a.field_set= (select b.field_set from hbfieldset_temp b
       where a.activity_isn = b.activity_isn);
commit;

-- SIMPLE FRACTION TYPE
update FA_HABITAT_RESULT re
set (SAMPLE_FRACTION_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = re.tsmprmvl_is_number 
           and b.field_name = 'SMPL_FRAC_TYPE_NM'
           and b.table_name = 'TSRRSULT')
WHERE re.TSMPRMVL_IS_NUMBER IS NOT NULL;
commit;
--
--EPA registry num
update FA_HABITAT_RESULT re
set EPA_REG_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;
--
spool off