/*******************************************************
Filename		:  FA_REGULAR_RESULT_data1.sql
Release 		:  c2.0
SIR			:  1497
Description		:  Migrate data from the TSRRSULT and TSRFACT tables to
			   the FA_REGULAR_RESULT fact table.
Author			:  Joseph Wilson
				7-01-2003 --changed names from CHEM to REGULAR; added new 2.0 columns and removed outdated -JW
				7-03-2003 -- updated dates to single date/time values -JW
				7-15-2003 -- added TSMPRMVL_IS_NUMBER; added medium type Other -JW
				7-21-2003 -- removed activity_community
				7-30-2003 -- updated date logic -JW
				8-26-2003 -- updated time logic -JW
				8-28-2003 -- increased sequence cache size to 1000 -JW
Date			:  2/28/2003
Comments		:  Added columns that use to be in the DI_ACTIVITY table
**********************************************************/
set echo off;
SET SERVEROUTPUT ON
spool FA_REGULAR_RESULT_data1.log
connect storetw/storetw@storet.sdc
show user;
set serveroutput on
set echo off

-- create sequence for pk_isn

drop sequence seq_FA_REGULAR_RESULT;

create sequence seq_FA_REGULAR_RESULT
start with 1 increment by 1 nomaxvalue nocycle cache 1000;

set serveroutput on
DECLARE

cursor orgs is
	select organization_id
	from di_org
	order by organization_id;

BEGIN

FOR v_org in orgs loop

INSERT INTO FA_REGULAR_RESULT (pk_isn,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ACTIVITY_MEDIUM,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	TSRCHAR_ORG_ID,
	TSRUOM_IS_NUMBER,
	TSRUOM_ORG_ID,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
	BIAS,
	CONF_LVL_CORR_BIAS, 
	TSMPRMVL_IS_NUMBER, 
--activity elements
	ACTIVITY_START_DATE_TIME,
	--ACTIVITY_START_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	REPLICATE_NUMBER,       
 	ACTIVITY_TYPE,          
 	ACTIVITY_CATEGORY,      
 	ACTIVITY_INTENT,        
 	--ACTIVITY_COMMUNITY, 7/21/2003
	ACTIVITY_STOP_DATE_TIME,     
	--ACTIVITY_STOP_TIME,     
	ACT_STOP_TIME_ZONE,     
	ACTIVITY_REL_DEPTH,     
	ACTIVITY_DEPTH,         
	ACTIVITY_DEPTH_UNIT,    
	ACTIVITY_UPPER_DEPTH,   
	ACTIVITY_LOWER_DEPTH,  
	UPR_LWR_DEPTH_UNIT,
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
	TSRMATRX_IS_NUMBER
)
SELECT
      seq_FA_REGULAR_RESULT.nextval,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
	TO_DATE(DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),

	--TO_DATE(to_char(rsult.analysis_date,'DD-MON-YYYY')||to_char(rsult.analysis_time,'HH24:MI:SS'),'DD-MON-YYYYHH24:MI:SS'), 	
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,	
	FDACT.MEDIUM_TYPE_NAME,	
	RSULT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRCHAR_ORG_ID,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRUOM_ORG_ID,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
	RSULT.BIAS,
	RSULT.CONF_LVL_CORR_BIAS,
	RSULT.TSMPRMVL_IS_NUMBER,
--activity elements
	TO_DATE(DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),
	--TO_DATE(to_char(FDACT.START_DATE,'DD-MON-YYYY')||to_char(FDACT.START_TIME,'HH24:MI:SS'),'DD-MON-YYYYHH24:MI:SS'), 
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.REPLICATE_NUMBER,       
 	FDACT.TYPE_NAME,          
 	FDACT.CATEGORY_TYPE_NAME,      
 	FDACT.INTENT_TYPE_NAME,        
 	--FDACT.COMMUNITY_NAME,     7/21/2003	
	TO_DATE(DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),
	--TO_DATE(to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||to_char(FDACT.STOP_TIME,'HH24:MI:SS'),'DD-MON-YYYYHH24:MI:SS'), 
	FDACT.STOP_TIME_ZONE,     
	FDACT.RELTV_DEPTH_NAME,     
	FDACT.DEPTH_TO_ACTIVITY,         
	FDACT.DEPTH_TO_ACT_UN_CD,    
	FDACT.UPPER_DEPTH_TO_ACT,   
	FDACT.LOWER_DEPTH_TO_ACT,  
	FDACT.DEPTH_MSR_UNT_CD,
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
	FDACT.TSRMATRX_IS_NUMBER
FROM storet1.TSRRSULT RSULT, storet1.TSRFDACT FDACT
WHERE RSULT.TSRFDACT_IS_NUMBER = FDACT.TSRFDACT_IS_NUMBER
	AND RSULT.TSRFDACT_ORG_ID = FDACT.TSRFDACT_ORG_ID
      AND RSULT.value_status ='F'
	AND fdact.medium_type_name in ('Air','Sediment','Soil','Water','Other')
	AND fdact.type_name <> 'Data Logger'
	AND fdact.category_type_name <> '%Habitat%'
	AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;
end loop;
commit;
end;
/
commit;

/** moved to pdl script
alter table FA_REGULAR_RESULT
add constraint pk_regular_result primary key (pk_isn)
using index
tablespace storetindx
storage(initial 2m next 1m);
--storage(initial 10m next 5m);
**/

spool off;