/*******************************************************
Filename		:  	FA_REGULAR_RESULT_tab.sql
Release 		:  	c2.0
SIR			:  	1497
Description		:  	Creates the FA_REGULAR_RESULT table.
Author			:  	Joseph Wilson
Date			:  	2/28/2003
Comments		:  	Added columns that use to be in the DI_ACTIVITY table.  Commented out
			   	Biological data fields.  Increased extent size -3/28
			   	Add 6 cols relate to visit date, time and zone which come from the storet1.tsrstvst. 04-10-03
        	         	05/12/03- Updated for V2.0. -C Tsang
			   	07/01/03 - commented out old columns, addednew v2.0 columns, updated name -jw
				07/03/03 - changed CHARACTERISTIC_NAME to VARCHAR2(60); updated dates to single date/time values -JW
				07/07/03 - added char alias name columns; updated fk_char size -JW
				07/10/03 - updated detection_limit to varchar2(25) -JW
				07/11/03 - updated result_unit to char(10) -JW
				07/14/03 - updated field_set to varchar2(130); added TSMPRMVL_IS_NUMBER -JW
				07/21/03 - SGO updated, sample pres elements updated, dropped community_sampled -JW
                        	07/23/03 - added portable data logger column. -C Tsang
**********************************************************/
spool FA_REGULAR_RESULT_table.log

connect storetw/storetw@storet.sdc

drop table FA_REGULAR_RESULT;
--add default values for bio elements, etc?
CREATE TABLE FA_REGULAR_RESULT (
pk_isn 							number not null,
ORGANIZATION_ID 					CHAR(8),
STATION_ID                      			CHAR(15),
STATION_NAME                                       	VARCHAR2(60),
ACTIVITY_START_DATE_TIME                               	DATE,
--ACTIVITY_START_TIME                                	DATE,
ACT_START_TIME_ZONE                                	CHAR(3),
TRIP_ID                                            	CHAR(15),
TRIP_NAME						VARCHAR2(60),
STATION_VISIT_ID                                   	CHAR(3),
CHARACTERISTIC_NAME                                	VARCHAR2(60),
RESULT_VALUE                                       	NUMBER,
RESULT_UNIT                                        	CHAR(10),
RESULT_VALUE_TEXT                                  	CHAR(15),
SAMPLE_FRACTION_TYPE                               	VARCHAR2(15),
RESULT_VALUE_TYPE                                  	CHAR(10),
STATISTIC_TYPE                                     	CHAR(18),
RESULT_VALUE_STATUS                                	CHAR(1),
WEIGHT_BASIS_TYPE                                  	CHAR(12),
TEMPERATURE_BASIS_LEVEL                            	CHAR(8),
DURATION_BASIS                                     	CHAR(10),
--FEEDING_GROUP                                      	CHAR(6) DEFAULT 'N/A',
--POLLUTION_TOLERANCE                                	CHAR(4) DEFAULT 'N/A',
--TROPHIC_LEVEL                                      	CHAR(4) DEFAULT 'N/A',
--CELL_SHAPE                                         	VARCHAR2(18) DEFAULT 'N/A',
--CELL_FORM                                          	VARCHAR2(11) DEFAULT 'N/A',
--SAMPLE_PREP_SOURCE                                 	CHAR(12),
--SAMPLE_PREP_NAME                                   	VARCHAR2(120),
ANALYTICAL_PROCEDURE_SOURCE                        	CHAR(12),
ANALYTICAL_PROCEDURE_ID                            	CHAR(15),
--ANALYTICAL_PROCEDURE_NAME                          	VARCHAR2(120),
LAB_ID                                             	CHAR(8),
LAB_NAME                                           	VARCHAR2(60),
LAB_CERTIFIED                                      	CHAR(1),
LAB_BATCH_ID                                       	CHAR(12),
ANALYSIS_DATE_TIME                                     	DATE,
--ANALYSIS_TIME                                      	DATE,
ANALYSIS_TIME_ZONE                                 	CHAR(3),
LOWER_QUANTITATION_LIMIT                           	CHAR(12),
UPPER_QUANTITATION_LIMIT                           	CHAR(12),
DETECTION_LIMIT                                    	VARCHAR2(25),
DETECTION_LIMIT_DESCRIPTION                        	VARCHAR2(254),
LAB_REMARK                                         	VARCHAR2(40),  --check size
DISTANCE_MEASURE_FROM                              	VARCHAR2(20),
DISTANCE_MEASURE_TO                                	VARCHAR2(20),
PARTICLE_SIZE                                      	VARCHAR2(40),
REPLICATE_ANALYSIS_COUNT                           	NUMBER,
PRECISION                                          	CHAR(12),
CONFIDENCE_LEVEL                                   	CHAR(8),
DILUTION_INDICATOR                                 	CHAR(1),
RECOVERY_INDICATOR                                 	CHAR(1),
CORRECTION_INDICATOR                               	CHAR(1),
--BIO_GROUP_ID                                       	CHAR(8) DEFAULT 'N/A',
--BIO_GROUP_TYPE                                     	VARCHAR2(32) DEFAULT 'N/A',
--BIO_GROUP_SUBJECT_TXN                              	VARCHAR2(69) DEFAULT 'N/A',
--PHYS_BIO_INDICATOR                                 	CHAR(1) DEFAULT 'N/A',
--GROUP_DESCRIPTOR_SEX                               	CHAR(15) DEFAULT 'N/A',
--GROUP_DESCRIPTOR_LIFESTAGE                         	VARCHAR2(25) DEFAULT 'N/A',
--INDIVIDUAL_NUMBER                                  	NUMBER DEFAULT to_number(null),
--COMMON_CLASS_DESCRIPTOR                            	VARCHAR2(60)  DEFAULT 'N/A',
--PRIMARY_CLASS_DESCRIPTOR                           	VARCHAR2(12)  DEFAULT 'N/A',
--SECONDARY_CLASS_DESCRIPTOR                         	VARCHAR2(12)  DEFAULT 'N/A',
--LOWER_BOUND_AMOUNT                                 	NUMBER DEFAULT to_number(null),
--UPPER_BOUND_AMOUNT                                 	NUMBER DEFAULT to_number(null),
--BIO_RCI_UNITS                                      	VARCHAR2(10) DEFAULT 'N/A',
--NUMBER_IN_GROUP                                    	NUMBER DEFAULT to_number(null),
--BIO_GROUP_COUNT_TYPE                               	VARCHAR2(10) DEFAULT 'N/A',
STN_LATITUDE                                       	NUMBER,
STN_LONGITUDE                                      	NUMBER,
HYDROLOGIC_UNIT_CODE                               	CHAR(8),
RESULT_IS_NUMBER                                   	NUMBER,
ACTIVITY_MEDIUM						VARCHAR2(20),
FK_STATION                                         	NUMBER(12),
--FK_ACTIVITY                                        	NUMBER(12),
FK_ORG                                             	NUMBER(12),
FK_DB_CAT                                          	NUMBER(12),
FK_GEO_COUNTY                                      	NUMBER(12),
FK_GEO_STATE                                       	NUMBER(12),
FK_MAD_HDATUM                                      	NUMBER(12),
FK_MAD_HMETHOD                                     	NUMBER(12),
FK_DATE_ACT_START                                  	NUMBER(12),
FK_ACT_MEDIUM                                      	NUMBER(12),
FK_ACT_MATRIX                                      	NUMBER(12),
ACTIVITY_IS_NUMBER 					NUMBER(12),  --RSULT.TSRFDACT_IS_NUMBER
-- TSRFDACT_ORG_ID					CHAR(8),  4/17/2003
FK_CHAR							NUMBER(12),  --RSULT.TSRCHAR_IS_NUMBER
TSRCHAR_ORG_ID						CHAR(8),
TSRUOM_IS_NUMBER					NUMBER(12),
TSRUOM_ORG_ID						CHAR(8),
TSRANLPR_IS_NUMBER					NUMBER(12),
TSRANLPR_ORG_ID						CHAR(8),
TSRLSPP_IS_NUMBER					NUMBER(12),
TSRLSPP_ORG_ID						CHAR(8),
TSRLAB_IS_NUMBER					NUMBER(12),
--TSRLAB_ORG_ID						CHAR(8), 4/17/2003
TSRSTVST_IS_NUMBER					NUMBER(12),
--TSRSTVST_ORG_ID					CHAR(8), 4/17/2003
TSMSTATN_IS_NUMBER					NUMBER(12),
--start of ACT elements
ACTIVITY_ID                  	                   	CHAR(12),
REPLICATE_NUMBER                	           	NUMBER(3),
ACTIVITY_TYPE                                      	CHAR(13),
ACTIVITY_CATEGORY                                  	VARCHAR2(30),
ACTIVITY_INTENT                                    	VARCHAR2(20),
--ACTIVITY_COMMUNITY                                 	VARCHAR2(30), 7/21/2003
--ACTIVITY_SUBJECT_TAXON                             	VARCHAR2(69),
--BIOPART_NAME                                       	VARCHAR2(30),
--HORIZONTAL_DATUM                                   	VARCHAR2(254),
--GEOPOSITIONING_METHOD                              	VARCHAR2(254),
LOCATION_POINT_TYPE                                	CHAR(16),
POINT_SEQUENCE_NUMBER                              	NUMBER(5),
WELL_NUMBER                                        	CHAR(15),
PIPE_NUMBER                                        	CHAR(15),
ACTIVITY_STOP_DATE_TIME                                	DATE,
--ACTIVITY_STOP_TIME                                 	DATE,
ACT_STOP_TIME_ZONE                                 	CHAR(3),
ACTIVITY_REL_DEPTH                                 	CHAR(15),
ACTIVITY_DEPTH                                     	CHAR(8),
ACTIVITY_DEPTH_UNIT                                	CHAR(3),
ACTIVITY_UPPER_DEPTH                               	CHAR(8),
ACTIVITY_LOWER_DEPTH                               	CHAR(8),
UPR_LWR_DEPTH_UNIT                                 	CHAR(3),
FIELD_PROCEDURE_ID                                 	CHAR(10),
--FIELD_PROCEDURE_NAME                               	VARCHAR2(60),
GEAR_CONFIG_ID                                     	CHAR(10),
--GEAR_CONFIG_NAME                                   	VARCHAR2(30),
--CONTAINER_TYPE                                     	VARCHAR2(32),
--CONTAINER_COLOR                                   	VARCHAR2(10),
--TEMPERATURE_PRESRVTN_TYPE                         	VARCHAR2(25),
--PRESRVTN_STORAGE_PROCEDURE                         	VARCHAR2(1999),
ACTIVITY_LATITUDE                                  	NUMBER,
ACTIVITY_LONGITUDE                                 	NUMBER,
tsrfldpr_is_number					NUMBER(12),
--tsrfldpr_org_id					CHAR(8),  04/18/2003
tsrgrcfg_is_number					NUMBER(12),
--tsrgrcfg_org_id					CHAR(8), 04/18/2003
STD_VALUE                                       	NUMBER,
STD_UNIT                                        	VARCHAR2(10),
fk_act_mad_hdatum                          		number(12),
fk_act_mad_hmethod                         		number(12),
activity_isn 						number,
VISIT_START_DATE_TIME					DATE,
--VISIT_START_TIME					DATE,
VISIT_START_TIME_ZONE					CHAR(3),
VISIT_STOP_DATE_TIME					DATE,
--VISIT_STOP_TIME					DATE,
VISIT_STOP_TIME_ZONE					CHAR(3),
--new data elements added 7-01-2003
activity_matrix						VARCHAR2(25),
FIELD_SET						VARCHAR2(130),
POINT_NAME						VARCHAR2(30),
SGO_INDICATOR						CHAR(1),
MAP_SCALE						VARCHAR2(20),
FIELD_GEAR_ID						CHAR(10),
--SAMPLE_PRES_ID					CHAR(10), 07/21/2003
BIAS							CHAR(12),
CONF_LVL_CORR_BIAS					CHAR(1),
TSRFLDGR_IS_NUMBER					NUMBER(12),
TSRMATRX_IS_NUMBER					NUMBER(12),
RESULT_COMMENT						VARCHAR2(4000),
TEXT_RESULT						VARCHAR2(4000),
CAS_NUMBER						VARCHAR2(500),
EPA_REG_NUMBER						VARCHAR2(500),
ITIS_NUMBER						VARCHAR2(500),
TSMPRMVL_IS_NUMBER 					NUMBER(12),
container_desc 						varchar2(60),
TEMP_PRESERVN_TYPE 					varchar2(25),
presrv_strge_prcdr 					varchar2(256),
portable_data_logger                            varchar2(34)
) tablespace STORETDATA
storage(initial 512M next 512M)
nologging
pctfree 50;
--storage(initial 300M next 300M minextents 2 maxextents 200)

spool off;