/*******************************************************
Filename		:  statn_types_tables.sql
Release 		:  c2.0
SIR			:  1364, 1481
Description		:  Station types dimension tables and related objects.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  11/26/2002 - Dropped lu_geo_country table and its associations. G.Thadkamalla.
			:  07/17/2003 Add SGO_indicator and change new order. Thieu.
			:  07/21/2003 Update FA_STATION with SGO Indicator from Station Type. WN. 
		tir 1	:  08/20/2003 Decode for 'Waste sewer' had a capital 'S' for Sewer which was incorrect  WN. 
**********************************************************/
--connect storetw/storetw@storet.sdc
connect storetw/storetw@storet.sdc
set echo on;
spool  statn_types_tables.log

drop sequence seq_statn_types;
create sequence seq_statn_types 
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_statn_types;
CREATE TABLE di_statn_types
(PK_ISN           NUMBER(12,0),
 PRIMARY_TYPE     VARCHAR2(30) NOT NULL,
 SECONDARY_TYPE   VARCHAR2(30),
 SORT_ORDER       NUMBER,
 SGO_INDICATOR    CHAR(1));


alter table di_statn_types
add constraint pk_statn_types primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial  100K next 100K)
nologging;


set serveroutput on
declare
cursor c1 is select distinct primary_type,secondary_type from fa_station sd;

begin
for c1_var in c1 loop

insert into di_statn_types (pk_isn,primary_type,secondary_type,sort_order,SGO_INDICATOR)
values(seq_statn_types.nextval,c1_var.primary_type,c1_var.secondary_type,
decode(c1_var.primary_type,
'River/Stream',1,
'Estuary',8,
'Lake',2,
'Well',4,
'Facility',5,
'Ocean',7,
'Canal',10,
'Spring',11,
'Wetland',13,
'Reservoir',15,
'Landfill',19,
'Land',17,
'Mine/mine discharge',24,
'Storm sewer',21,
'Channelized stream',9,
'Gallery',25,
'Land runoff',18,
'Riverine impoundment',16,
'Cave',12,
'CERCLA Superfnd Site',6,
'Combined sewer',23,
'Constructed Wetland',14,
'Great Lake',3,
'Waste Pit',20,
'Waste sewer',22
,null),
decode(c1_var.primary_type,
'River/Stream','S',
'Estuary','S',
'Lake','S',
'Well','G',
'Facility','O',
'Ocean','S',
'Canal','S',
'Spring','G',
'Wetland','S',
'Reservoir','S',
'Landfill','O',
'Land','O',
'Mine/mine discharge','O',
'Storm sewer','O',
'Channelized stream','S',
'Gallery','G',
'Land runoff','O',
'Riverine impoundment','S',
'Cave','G',
'CERCLA Superfnd Site','O',
'Combined sewer','O',
'Constructed Wetland','S',
'Great Lake','S',
'Waste Pit','O',
'Waste sewer','O'
,null));

end loop;
commit;
end;
/

create index istatn_type01 on di_statn_types(primary_type,secondary_type)
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

create index istatn_type02 on di_statn_types(sort_order)
tablespace STORETINDX
storage (initial 96K next 96K)
nologging;

-- add fk to fa_station

alter table fa_station
add (fk_statn_types number(12,0));

--update fks in fa_station

declare
cursor c1 is select pk_isn fk_statn_types, PRIMARY_TYPE, SECONDARY_TYPE 
from di_statn_types ;

begin
for c1_var in c1 loop
update fa_station 
set fk_statn_types = c1_var.fk_statn_types
where PRIMARY_TYPE = c1_var.PRIMARY_TYPE
  and SECONDARY_TYPE = c1_var.SECONDARY_TYPE;
end loop;
commit;

end;
/
--SGO Indicator update FA_STATION
UPDATE FA_STATION RE SET SGO_INDICATOR =
	(SELECT SGO.SGO_INDICATOR
	FROM di_statn_types SGO
	WHERE re.fk_statn_types = SGO.pk_isn );
commit;

--fks in fa_station
alter table fa_station
add constraint fk_sd_statn_types foreign key (fk_statn_types) references di_statn_types(pk_isn);

--indexes on fks in fa_station
create index isd_sd_fk_statn_types on fa_station(fk_statn_types)
tablespace STORETINDX
storage (initial 512K next 512K)
nologging;

spool off;