set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_050000 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2013.01.01'
,p_release=>'5.0.4.00.12'
,p_default_workspace_id=>12614826271127960
,p_default_application_id=>271
,p_default_owner=>'STORETDASHTRIBAL_APEX'
);
end;
/
prompt --application/set_environment
 
prompt APPLICATION 271 - STORETDASH_TRIBAL
--
-- Application Export:
--   Application:     271
--   Name:            STORETDASH_TRIBAL
--   Date and Time:   14:56 Friday June 29, 2018
--   Exported By:     ADMIN
--   Flashback:       0
--   Export Type:     Application Export
--   Version:         5.0.4.00.12
--   Instance ID:     69314666475274
--

-- Application Statistics:
--   Pages:                      8
--     Items:                   74
--     Computations:            23
--     Processes:                6
--     Regions:                 73
--     Buttons:                  9
--     Dynamic Actions:          2
--   Shared Components:
--     Logic:
--       Items:                  1
--     Navigation:
--       Breadcrumbs:            4
--         Entries:             22
--       NavBar Entries:         1
--     Security:
--       Authentication:         3
--     User Interface:
--       Themes:                 2
--       Templates:
--         Page:                18
--         Region:              24
--         Label:               11
--         List:                29
--         Popup LOV:            2
--         Calendar:             3
--         Breadcrumb:           4
--         Button:               6
--         Report:              10
--     Globalization:
--     Reports:
--   Supporting Objects:  Included

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/ui_types
begin
null;
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_display_id=>nvl(wwv_flow_application_install.get_application_id,271)
,p_owner=>nvl(wwv_flow_application_install.get_schema,'STORETDASHTRIBAL_APEX')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'STORETDASH_TRIBAL')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'STORETDASHTRIBAL')
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20180629145416'
,p_bookmark_checksum_function=>'MD5'
,p_max_session_length_sec=>28800
,p_flow_language=>'en'
,p_flow_language_derived_from=>'FLOW_PRIMARY_LANGUAGE'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(1344882791693709281)
,p_application_tab_set=>0
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=> nvl(wwv_flow_application_install.get_proxy,'')
,p_flow_version=>'release 1.0'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_deep_linking=>'Y'
,p_runtime_api_usage=>'T:O:W'
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'P'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_last_updated_by=>'ADMIN'
,p_last_upd_yyyymmddhh24miss=>'20180629145416'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists
begin
null;
end;
/
prompt --application/shared_components/files
begin
null;
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(117286200099564)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(1341330648760618087)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
);
end;
/
prompt --application/shared_components/security/authorizations
begin
null;
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_api.create_icon_bar_item(
 p_id=>wwv_flow_api.id(1344883101658709281)
,p_icon_sequence=>200
,p_icon_subtext=>'Logout'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_icon_height=>32
,p_icon_width=>32
,p_icon_height2=>24
,p_icon_width2=>24
,p_nav_entry_is_feedback_yn=>'N'
,p_icon_bar_disp_cond_type=>'CURRENT_LOOK_IS_1'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(1342817958401004880)
,p_name=>'F102_X_BREADCRUMB'
,p_protection_level=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs
begin
null;
end;
/
prompt --application/shared_components/navigation/trees
begin
null;
end;
/
prompt --application/pages/page_groups
begin
null;
end;
/
prompt --application/comments
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb2
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(1342821980583230815)
,p_name=>'Breadcrumb2'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342822364784235723)
,p_parent_id=>0
,p_short_name=>'Dashboard'
,p_long_name=>'Dashboard'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342822583484241166)
,p_parent_id=>wwv_flow_api.id(1342822364784235723)
,p_short_name=>'Annual Data Submission by EPA Region'
,p_long_name=>'Annual Data Submission by EPA Region'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342822759374243648)
,p_parent_id=>wwv_flow_api.id(1342822583484241166)
,p_short_name=>'Annual Data Submission by State'
,p_long_name=>'Annual Data Submission by State'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342822967339245892)
,p_parent_id=>wwv_flow_api.id(1342822759374243648)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342823175304248187)
,p_parent_id=>wwv_flow_api.id(1342822967339245892)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342823389849252402)
,p_parent_id=>wwv_flow_api.id(1342822967339245892)
,p_short_name=>'Top 10 Substances for Past 5 Years By State'
,p_long_name=>'Top 10 Substances for Past 5 Years By State'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb3
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(1342822084046231829)
,p_name=>'Breadcrumb3'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342823673703257227)
,p_parent_id=>0
,p_short_name=>'Dashboard'
,p_long_name=>'Dashboard'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342823879591258957)
,p_parent_id=>wwv_flow_api.id(1342823673703257227)
,p_short_name=>'Annual Data Submission by State'
,p_long_name=>'Annual Data Submission by State'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342824086170260861)
,p_parent_id=>wwv_flow_api.id(1342823879591258957)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342824260328262806)
,p_parent_id=>wwv_flow_api.id(1342824086170260861)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342824470371265692)
,p_parent_id=>wwv_flow_api.id(1342824086170260861)
,p_short_name=>'Top 10 Substances for Past 5 Years By State'
,p_long_name=>'Top 10 Substances for Past 5 Years By State'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb4
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(1342822186816232588)
,p_name=>'Breadcrumb4'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342824683185269460)
,p_parent_id=>0
,p_short_name=>'Dashboard'
,p_long_name=>'Dashboard'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342824889418271254)
,p_parent_id=>wwv_flow_api.id(1342824683185269460)
,p_short_name=>'State Profile'
,p_long_name=>'State Profile'
,p_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342825062884273061)
,p_parent_id=>wwv_flow_api.id(1342824889418271254)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342825269810274999)
,p_parent_id=>wwv_flow_api.id(1342824889418271254)
,p_short_name=>'Top 10 Substances for Past 5 Years By State'
,p_long_name=>'Top 10 Substances for Past 5 Years By State'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(1344884213975709290)
,p_name=>' Breadcrumb'
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342681884008561419)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Annual Data Submission by EPA Region'
,p_long_name=>'Annual Data Submission by EPA Region'
,p_link=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::'
,p_page_id=>5
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342709971504360891)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Data Owners Contribution'
,p_long_name=>'Data Owners Contribution'
,p_link=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::'
,p_page_id=>9
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342721860314286611)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Top 10 Substances for Past 5 Years By State'
,p_link=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::'
,p_page_id=>10
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Dashboard'
,p_link=>'f?p=&FLOW_ID.:1:&SESSION.'
,p_page_id=>1
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342728088018505422)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Annual Data Submission by State'
,p_link=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::'
,p_page_id=>3
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1342792962145586783)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'State Profile'
,p_link=>'f?p=&FLOW_ID.:7:&SESSION.'
,p_page_id=>7
);
wwv_flow_api.create_menu_option(
 p_id=>wwv_flow_api.id(1343455970431021753)
,p_parent_id=>wwv_flow_api.id(1342724564766349037)
,p_short_name=>'Data Owners Contribution by Tribes'
,p_long_name=>'Data Owners Contribution by Tribes'
,p_link=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::'
,p_page_id=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/page
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1342680081717082356)
,p_theme_id=>101
,p_name=>'Blank'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<title>#TITLE#</title>',
'</head>',
'<body #ONLOAD#>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>'#BODY#'
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#<a name="END"></a>#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344882111434709273)
,p_theme_id=>101
,p_name=>'basic wide'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="en">',
'<!-- EPA Template, OneEPA Web, 17 November 2010 -->',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta charset="utf-8" />',
'<meta http-equiv="X-UA-Compatible" content="IE=8" />',
'<title>#TITLE#</title>',
'<meta name="DC.description" content="" />',
'<meta name="keywords" content="" />',
'<meta name="DC.title" content="" />',
'<meta name="DC.type" content="" />',
'<meta name="DC.Subject.epachannel" content="" />',
'<meta name="DC.Subject.epabrm" content="" />',
'<meta name="DC.Subject.epacat" content="" />',
'<meta name="DC.Subject.epaect" content="" />',
'<meta name="DC.Subject.epaemt" content="" />',
'',
'<meta name="DC.Subject.epahealth" content="" />',
'<meta name="DC.Subject.epaindustry" content="" />',
'<meta name="DC.Subject.epaopt" content="" />',
'<meta name="DC.Subject.epappt" content="" />',
'<meta name="DC.Subject.eparat" content="" />',
'<meta name="DC.Subject.eparegulation" content="" />',
'<meta name="DC.Subject.eparit" content="" />',
'<meta name="DC.Subject.epasubstance" content="" />',
'<meta name="DC.audience" content="" />',
'<meta name="DC.coverage" content="" />',
'<meta name="DC.date.created" content="" />',
'<meta name="DC.date.modified" content="" />',
'<meta name="DC.date.archivedate" content="" />',
'<meta name="DC.creator" content="US EPA" />',
'<meta name="DC.language" content="en" />',
'<meta name="viewport" content="width=device-width; initial-scale=1.0"/>',
'',
'<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />',
'<!--RSS Feeds -->',
'<link rel="meta" href="http://www.epa.gov/labels.rdf" type="application/rdf+xml" title="ICRA labels" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&location=Headquarters" />',
'<link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'',
'<!-- ALL PAGE STYLES BELOW THIS LINE -->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#template4_fix.css" type="text/css" />',
'<!--link rel="stylesheet" href="css/local.css" /-->',
'<link rel="stylesheet" href="#WORKSPACE_IMAGES#epa.css" />',
'<!--[if IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie7.css"/><![endif]-->',
'<!--[if lt IE 7]><link rel="stylesheet" href="#WORKSPACE_IMAGES#ie6.css"/><![endif]-->',
'',
'<style type="text/css"> ',
'div.left_box{float:left;width:65%;position:relative;padding-right:1%;}',
'div.right_box{float:right;width:30%;position:relative;}',
'div.box_wrapper{width:100%;position:relative;}',
'ul.dhtmlSubMenu{z-index:9999;}',
'.multi_selectlist{display:block;border:1px solid #ddd;padding:5px;}',
'.multi_selectlist:focus{border:1px solid #666;}',
'.text_field{display:block;border:1px solid #ddd;padding:5px;}',
'.text_field:focus{border:1px solid #666;}',
'.button_field{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:120px;}',
'.button_field_auto{display:block;background:#369;border:#ddd;color:#fff;cursor:pointer;font-weight:bold;margin:10px 0;padding:5px;width:auto;}',
'</style>',
'',
'</head>',
'<body class="basic wide" #ONLOAD#>'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'<p id="sitewidec"></p>',
'<p class="skip">Jump to <a href="#main" title="Jump to main content">main content</a> or <a href="#areanav" title="Jump to area navigation.">area navigation</a>.</p>',
'',
'<div id="header">',
'  <p><a href="http://www.epa.gov/" title="US EPA Home Page"><img src="https://ofmpub.epa.gov/WATERSHTML/oneepa/print-epa-logo.gif" alt="US Environmental Protection Agency logo" /></a></p>',
'  <form id="EPAsearch" method="get" action="http://nlquery.epa.gov/epasearch/epasearch">',
'    <fieldset>',
'      <ol>',
'        <li id="azindex"><a href="http://www.epa.gov/epahome/quickfinder.htm" title="Alphabetical list of top EPA topics">A-Z Index</a></li>',
'        <li><a href="http://www.epa.gov/search.html" title="Advanced search with additional filters">Advanced Search</a></li>',
'        <li>',
'',
'          <fieldset id="search">',
'            <legend>What are you looking for?</legend>',
'            <input name="querytext" id="searchbox" value=""/>',
'            <button id="searchbutton" type="submit" title="Search">Search</button>',
'          </fieldset>',
'        </li>',
'      </ol>',
'      <input type="hidden" name="fld" value="" />',
'',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="epafiles_default.xsl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </fieldset>',
'  </form><!-- /search -->',
'  <ul>',
'',
'    <li id="learn"><a href="http://www.epa.gov/gateway/learn/" title="Learn the Issues">Learn the Issues</a></li>',
'    <li id="scitech"><a href="http://www.epa.gov/gateway/science/" title="Science and Technology">Science &amp; Technology</a></li>',
'    <li id="laws"><a href="http://www.epa.gov/lawsregs/" title="Laws and Regulations">Laws &amp; Regulations</a></li>',
'    <li id="about"><a href="http://www.epa.gov/aboutepa/" title="About EPA">About EPA</a></li>',
'  </ul><!-- /IA Buckets -->',
'',
'</div><!-- /header -->',
'<div id="content">',
'  <div id="area">',
'    <p><a href="http://www.epa.gov/storet/contact.html">Contact Us</a></p>',
'<p>STORET - #TITLE#</p>',
'   <!-- <p>STORET</p>-->',
'  </div><!-- /area -->',
'  <div id="page">',
'    <div id="main">',
'      <ul id="breadcrumbs">',
'',
'        <li class="first"><b>You are here:</b> <a href="http://www.epa.gov/">EPA Home</a></li>',
'       <li><a href="http://www.epa.gov/water/">Water</a></li>',
'       <li><a href="http://www.epa.gov/owow/">Wetlands, Oceans, & Watersheds</a></li>',
'       <li><a href="http://www.epa.gov/owow/monitoring/">Monitoring and Assessing Water Quality</a></li>',
'       <li><a href="http://www.epa.gov/storet/index.html">STORET</a></li>',
'        <li>Data Warehouse</li>',
'      </ul>',
'<!--googleon: index-->',
' ',
'#REGION_POSITION_06# ',
'',
'#FORM_OPEN#',
'',
'',
'#REGION_POSITION_01# <br><br>',
'',
'<table width="100%" summary="" height="70%" cellspacing="0" cellpadding="0" border="0">',
'  <tr>',
'',
'    <td>',
'    <div align="center">',
'      #GLOBAL_NOTIFICATION##NOTIFICATION_MESSAGE##SUCCESS_MESSAGE#     ',
'    </div>',
'    #BODY##REGION_POSITION_02##REGION_POSITION_04#',
'    </td>',
'    <td align="right" valign="top">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" width="15" height="3" alt="" />',
'    </td>',
'    <td class="t15RightBar" align="right" valign="top">',
'      #REGION_POSITION_03#',
'    </td>',
'  </tr>',
'</table>',
'',
'',
'			<p class="pagetop"><a href="#content">Top of Page</a></p>',
'<!--googleoff: index-->',
'    </div><!-- /main -->',
'',
'    <div id="areanav">',
'      <h4 class="skip">Area Navigation</h4>',
'      <ul>',
'        <li class="separator"><a href="#">Area Home</a><hr /></li>',
'        <li><a href="#">Subarea Home</a></li>',
'        <li><a href="#">Basic Information</a></li>',
'        <li><a href="#">Where You Live</a></li>',
'',
'        <li><a href="#">Recent Additions</a></li>',
'        <li><a href="#">Area sidebar links go here</a></li>',
'        <li><a href="#">Link #7</a></li>',
'        <li><a href="#">Link #8</a></li>',
'      </ul>',
'    </div><!-- /area-nav -->',
'  </div><!-- /page -->',
'',
'</div><!-- /content -->'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'<div id="footer">',
'  <ul id="goodies">',
'    <li id="rss-news"><a href="http://www.epa.gov/newsroom/rssfeeds.htm">News Feeds</a></li>',
'    <li id="podcasts"><a href="http://www.epa.gov/epahome/podcasts.htm">Podcasts</a></li>',
'    <li id="mobile"><a href="http://m.epa.gov/">EPA Mobile</a></li>',
'    <li id="email-news"><a href="http://www.epa.gov/newsroom/email_signups.htm">News by Email</a></li>',
'    <li id="widgets"><a href="http://www.epa.gov/widgets/">Widgets</a></li>',
'',
'  </ul>',
'  <ul id="globalfooter">',
'    <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'    <li><a href="http://www.epa.gov/epahome/usenotice.htm">Privacy and Security Notice</a></li>',
'    <li class="last"><a href="http://www.epa.gov/epahome/comments.htm">Contact Us</a></li>',
'  </ul>',
'  <p id="seal">The Seal of the United States Environmental Protection Agency</p>',
'',
'</div><!-- /footer -->',
'<p class="skip"><a href="#content" title="Jump to main content.">Jump to main content.</a></p>',
'<script src="#WORKSPACE_IMAGES#jquery.js"></script>',
'<script src="#WORKSPACE_IMAGES#epa-core-v4.js"></script>',
'<!-- ALL SCRIPTS BELOW THIS LINE -->',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>'width="100%" summary=""'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344894911269168313)
,p_theme_id=>2
,p_name=>'Login'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="login">',
'  <div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'  <div id="login-main">#REGION_POSITION_02##BODY##REGION_POSITION_03#</div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0"'
,p_theme_class_id=>6
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
,p_template_comment=>'18'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344895116595168315)
,p_theme_id=>2
,p_name=>'No Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344895392256168317)
,p_theme_id=>2
,p_name=>'No Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344895690211168317)
,p_theme_id=>2
,p_name=>'No Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344896003094168317)
,p_theme_id=>2
,p_name=>'No Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        &nbsp;',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344896294151168317)
,p_theme_id=>2
,p_name=>'One Level Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>16
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
end;
/
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344896590078168317)
,p_theme_id=>2
,p_name=>'One Level Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>16
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344896900894168317)
,p_theme_id=>2
,p_name=>'One Level Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>8
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344897204509168317)
,p_theme_id=>2
,p_name=>'One Level Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="navbar-link">#TEXT#</a></div>'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344897515547168318)
,p_theme_id=>2
,p_name=>'Popup'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/theme_4_0.css" type="text/css" />',
'</head>',
'<body #ONLOAD#>#FORM_OPEN#'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">',
'<tr>',
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>',
'<td valign="top">#REGION_POSITION_03#<br /></td>',
'</tr>',
'</table>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE##DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>'<div class="t1success" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'
,p_notification_message=>'<div class="t1notification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>4
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344897797046168318)
,p_theme_id=>2
,p_name=>'Printer Friendly'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
'  <link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'  <link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'  #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-sidebar">#REGION_POSITION_02#</td>     ',
'        <td class="tbl-main" width="100%">#BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>5
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
,p_template_comment=>'3'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344898091059168319)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Left Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col-sb-left">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="main-sb-left">',
'      #BODY##REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
''))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>18
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344898388374168319)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Left and Right Sidebar (fixed-width / DIV left and optional table-based right)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="three-col">',
'    <div id="left-sidebar">#REGION_POSITION_02#</div>',
'    <div id="two-col-tbl">',
'      <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'        <tbody>',
'          <tr>',
'            <td class="tbl-main" width="100%">#BODY#</td>',
'            <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'          </tr>',
'        </tbody>',
'      </table>',
'    </div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_02'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>18
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344898703973168319)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Right Sidebar (fixed-width / DIV based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <div id="two-col">',
'    <div id="sidebar">#REGION_POSITION_03#</div>     ',
'    <div id="main">#REGION_POSITION_02##BODY#</div>',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>2
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1344899014927168319)
,p_theme_id=>2
,p_name=>'Two Level Tabs - Right Sidebar (optional / table-based)'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">',
'<head>',
'  <title>#TITLE#</title>',
' #APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'  <link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css" />',
'  <!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie.css" type="text/css" /><![endif]-->',
'  <!--[if IE 6]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie6.css" type="text/css" /><![endif]-->',
'  <!--[if IE 7]><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0_ie7.css" type="text/css" /><![endif]-->',
'</head>',
'<body #ONLOAD#>',
'<!--[if lte IE 6]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'#FORM_OPEN#',
''))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="header2">',
'  <div id="logo"><a href="#HOME_LINK#">#LOGO##REGION_POSITION_06#</a></div>',
'  #REGION_POSITION_07#',
'  <div id="navbar">',
'    #NAVIGATION_BAR#',
'    <div class="app-user">#WELCOME_USER#</div>',
'    #REGION_POSITION_08#',
'  </div>',
'  <div id="parent-tabs">',
'    <div class="tab-holder">#PARENT_TAB_CELLS#</div>',
'  </div>',
'</div>',
'<div id="tabs">',
'  <div class="frame">',
'    <div class="bg">',
'      <div class="tab-holder">',
'        #TAB_CELLS#',
'      </div>',
'    </div>',
'  </div>',
'</div>',
'<div id="topbar">#REGION_POSITION_01##REGION_POSITION_04#</div>',
'<div id="messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div id="body">',
'  <table class="tbl-body" cellspacing="0" cellpadding="0" border="0" summary="">',
'    <tbody>',
'      <tr>',
'        <td class="tbl-main" width="100%">#REGION_POSITION_02##BODY#</td>',
'        <td class="tbl-sidebar">#REGION_POSITION_03#</td>     ',
'      </tr>',
'    </tbody>',
'  </table>',
'</div>'))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div id="footer"><div class="content">',
'  #REGION_POSITION_05#',
'  <div id="customize">#CUSTOMIZE#</div>&nbsp;',
'</div></div>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="success" id="success-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''success-message'')" style="float:right;" class="remove-message" alt="" />',
'  #SUCCESS_MESSAGE#',
'</div>'))
,p_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<span>#TAB_LABEL#</span>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_non_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="#TAB_STATUS#"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>'))
,p_top_current_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="current"><div>',
'#TAB_LABEL##TAB_INLINE_EDIT#',
'</div></div>',
'',
''))
,p_top_non_curr_tab=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="noncurrent"><div>',
'<a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
'</div></div>',
'',
'',
'',
'',
''))
,p_notification_message=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="notification" id="notification-message">',
'  <img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''notification-message'')"  style="float:right;" class="remove-message" alt="" />#MESSAGE#',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<div class="navbar-entry"><a href="#LINK#" class="t1NavigationBar">#TEXT#</a></div>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>2
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
end;
/
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(1345307212827406606)
,p_theme_id=>101
,p_name=>'Basic'
,p_is_popup=>false
,p_header_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="en">',
'<!-- EPA Template, OneEPA Web, 17 November 2010 -->',
'<head>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta charset="utf-8" />',
'<meta http-equiv="X-UA-Compatible" content="IE=8" />',
'<title>#TITLE#</title>',
'<meta name="DC.description" content="" />',
'<meta name="keywords" content="" />',
'<meta name="DC.title" content="" />',
'<meta name="DC.type" content="" />',
'<meta name="DC.Subject.epachannel" content="" />',
'<meta name="DC.Subject.epabrm" content="" />',
'<meta name="DC.Subject.epacat" content="" />',
'<meta name="DC.Subject.epaect" content="" />',
'<meta name="DC.Subject.epaemt" content="" />',
'',
'<meta name="DC.Subject.epahealth" content="" />',
'<meta name="DC.Subject.epaindustry" content="" />',
'<meta name="DC.Subject.epaopt" content="" />',
'<meta name="DC.Subject.epappt" content="" />',
'<meta name="DC.Subject.eparat" content="" />',
'<meta name="DC.Subject.eparegulation" content="" />',
'<meta name="DC.Subject.eparit" content="" />',
'<meta name="DC.Subject.epasubstance" content="" />',
'<meta name="DC.audience" content="" />',
'<meta name="DC.coverage" content="" />',
'<meta name="DC.date.created" content="" />',
'<meta name="DC.date.modified" content="" />',
'<meta name="DC.date.archivedate" content="" />',
'<meta name="DC.creator" content="US EPA" />',
'<meta name="DC.language" content="en" />',
'<meta name="viewport" content="width=device-width; initial-scale=1.0"/>',
'',
'<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />',
'<link rel="meta" href="http://www.epa.gov/labels.rdf" type="application/rdf+xml" title="ICRA labels" />',
'<!--RSS Feeds -->',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov News" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSRecentNews" />',
'<link rel="alternate" type="application/atom+xml" title="EPA.gov Headquarters Press Releases" href="http://yosemite.epa.gov/opa/admpress.nsf/RSSByLocation?open&location=Headquarters" />',
'<link rel="alternate" type="application/atom+xml" title="Greenversations, EPA''s Blog" href="http://blog.epa.gov/blog/feed/" />',
'',
'<!-- ALL PAGE STYLES BELOW THIS LINE -->',
'<!--link rel="stylesheet" href="css/local.css" /-->',
'<link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/epa.css" />',
'<!--[if IE 7]><link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/ie7.css"/><![endif]-->',
'<!--[if lt IE 7]><link rel="stylesheet" href="http://www.epa.gov/epafiles/templates/webcms/css/ie6.css"/><![endif]-->',
'</head>',
'<body class="basic" #ONLOAD#>'))
,p_box=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--googleoff: index-->',
'<p id="sitewidec"></p>',
'<p class="skip">Jump to <a href="#main" title="Jump to main content">main content</a> or <a href="#areanav" title="Jump to area navigation.">area navigation</a>.</p>',
'',
'<div id="header">',
'  <p><a href="http://www.epa.gov/" title="US EPA Home Page"><img src="http://www.epa.gov/epafiles/templates/webcms/css/i/print-epa-logo.gif" alt="US Environmental Protection Agency logo" /></a></p>',
'  <form id="EPAsearch" method="get" action="http://nlquery.epa.gov/epasearch/epasearch">',
'    <fieldset>',
'      <ol>',
'        <li id="azindex"><a href="http://www.epa.gov/epahome/quickfinder.htm" title="Alphabetical list of top EPA topics">A-Z Index</a></li>',
'        <li><a href="http://www.epa.gov/search.html" title="Advanced search with additional filters">Advanced Search</a></li>',
'        <li>',
'',
'          <fieldset id="search">',
'            <legend>What are you looking for?</legend>',
'            <input name="querytext" id="searchbox" value=""/>',
'            <button id="searchbutton" type="submit" title="Search">Search</button>',
'          </fieldset>',
'        </li>',
'      </ol>',
'      <input type="hidden" name="fld" value="" />',
'',
'      <input type="hidden" name="areaname" value="" />',
'      <input type="hidden" name="areacontacts" value="" />',
'      <input type="hidden" name="areasearchurl" value="" />',
'      <input type="hidden" name="typeofsearch" value="epa" />',
'      <input type="hidden" name="result_template" value="epafiles_default.xsl" />',
'      <input type="hidden" name="filter" value="sample4filt.hts" />',
'    </fieldset>',
'  </form><!-- /search -->',
'  <ul>',
'',
'    <li id="learn"><a href="http://www.epa.gov/gateway/learn/" title="Learn the Issues">Learn the Issues</a></li>',
'    <li id="scitech"><a href="http://www.epa.gov/gateway/science/" title="Science and Technology">Science &amp; Technology</a></li>',
'    <li id="laws"><a href="http://www.epa.gov/lawsregs/" title="Laws and Regulations">Laws &amp; Regulations</a></li>',
'    <li id="about"><a href="http://www.epa.gov/aboutepa/" title="About EPA">About EPA</a></li>',
'  </ul><!-- /IA Buckets -->',
'',
'</div><!-- /header -->',
'#FORM_OPEN#',
'<div id="content">',
'  <div id="area">',
'    <p><a href="#">Contact Us</a></p>',
'    <p>{Area Name}</p>',
'  </div><!-- /area -->',
'  <div id="page">',
'    <div id="main">',
'      <ul id="breadcrumbs">',
'',
'        <li class="first"><b>You are here:</b> <a href="http://www.epa.gov/">EPA Home</a></li>',
'        <li>{Page Title}</li>',
'      </ul>',
'<!--googleon: index-->',
'      <h1>{Page title goes here}</h1>',
'   ',
'#BODY#',
'			<p class="pagetop"><a href="#content">Top of Page</a></p>',
'',
'<!--googleoff: index-->',
''))
,p_footer_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' #FORM_CLOSE#',
' <p id="areafooter">{Area footer content goes here}</p>',
'    </div><!-- /main -->',
'    <div id="areanav">',
'',
'      <h4 class="skip">Area Navigation</h4>',
'      <ul>',
'        <li class="separator"><a href="#">Area Home</a><hr /></li>',
'        <li><a href="#">Subarea Home</a></li>',
'        <li><a href="#">Basic Information</a></li>',
'        <li><a href="#">Where You Live</a></li>',
'',
'        <li><a href="#">Recent Additions</a></li>',
'        <li><a href="#">Area sidebar links go here</a></li>',
'        <li><a href="#">Link #7</a></li>',
'        <li><a href="#">Link #8</a></li>',
'      </ul>',
'    </div><!-- /area-nav -->',
'  </div><!-- /page -->',
'',
'</div><!-- /content -->',
'<div id="footer">',
'  <ul id="goodies">',
'    <li id="rss-news"><a href="http://www.epa.gov/newsroom/rssfeeds.htm">News Feeds</a></li>',
'    <li id="podcasts"><a href="http://www.epa.gov/epahome/podcasts.htm">Podcasts</a></li>',
'    <li id="mobile"><a href="http://m.epa.gov/">EPA Mobile</a></li>',
'    <li id="email-news"><a href="http://www.epa.gov/newsroom/email_signups.htm">News by Email</a></li>',
'    <li id="widgets"><a href="http://www.epa.gov/widgets/">Widgets</a></li>',
'',
'  </ul>',
'  <ul id="globalfooter">',
'    <li><a href="http://www.epa.gov/">EPA Home</a></li>',
'    <li><a href="http://www.epa.gov/epahome/usenotice.htm">Privacy and Security Notice</a></li>',
'    <li class="last"><a href="#">Contact Us</a></li>',
'  </ul>',
'  <p id="seal">The Seal of the United States Environmental Protection Agency</p>',
'',
'</div><!-- /footer -->',
'<p class="skip"><a href="#content" title="Jump to main content.">Jump to main content.</a></p>',
'<script src="http://www.epa.gov/epafiles/js/third-party/jquery.js"></script>',
'<script src="http://www.epa.gov/epafiles/js/epa-core-v4.js"></script>',
'<!-- ALL SCRIPTS BELOW THIS LINE -->',
'',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_theme_class_id=>9
,p_grid_type=>'TABLE'
,p_translate_this_template=>'N'
);
null;
end;
/
prompt --application/shared_components/user_interface/templates/button
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(118702805099913)
,p_template_name=>'HTML button (legacy - APEX 5 migration)'
,p_template=>' <input type="button" value="#LABEL#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_hot_template=>' <input type="button" value="#LABEL#" onclick="#JAVASCRIPT#" id="#BUTTON_ID#" class="#BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES#/>'
,p_translate_this_template=>'N'
,p_theme_class_id=>13
,p_theme_id=>101
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(1344882614637709277)
,p_template_name=>'Button'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table class="t15Button" cellspacing="0" cellpadding="0" border="0"  summary=""><tr>',
'<td class="t15L"><img src="#IMAGE_PREFIX#themes/theme_15/button-l.gif" alt="" /></td>',
'<td class="t15C" style="vertical-align:top"><a href="#LINK#">#LABEL#</a></td>',
'<td class="t15R"><img src="#IMAGE_PREFIX#themes/theme_15/button-r.gif" alt="" /></td>',
'</tr></table>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(1344899306992168319)
,p_template_name=>'Button'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-gray" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(1344899489069168320)
,p_template_name=>'Button, Alternative 1'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(1344899714289168320)
,p_template_name=>'Button, Alternative 2'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt2" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>5
,p_template_comment=>'XP Square FFFFFF'
,p_theme_id=>2
);
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(1344899915416168320)
,p_template_name=>'Button, Alternative 3'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#LABEL#" onclick="#LINK#" class="button-alt3" type="button">',
'  <span>#LABEL#</span>',
'</button>'))
,p_translate_this_template=>'N'
,p_theme_class_id=>2
,p_template_comment=>'Standard Button'
,p_theme_id=>2
);
end;
/
prompt --application/shared_components/user_interface/templates/region
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344882219587709275)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'<div class="rc-content-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'<div class="rc-content-main">#BODY#<div class="clear"></div></div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div> '))
,p_page_plug_template_name=>'Reports Region'
,p_theme_id=>101
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344882292122709276)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region float-left-100pct" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title"><strong>#TITLE#</strong></div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'<div class="rc-content-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'<div class="rc-content-main">#BODY#<div class="clear"></div></div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region 100% Width'
,p_theme_id=>101
,p_theme_class_id=>13
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344900089381168320)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">#TITLE#</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Borderless Region'
,p_theme_id=>2
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Use this region template when you want to contain content without a border.',
'',
'TITLE=YES',
'BUTTONS=YES',
'100% WIDTH=NO'))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344900419738168321)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="bracketed-region brackets" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bk-top">',
'    <div class="bk-top-r">',
'      <div class="bk-title">#TITLE#</div>',
'      <div class="bk-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'    </div>',
'  </div>',
'  <div class="bk-body">#BODY#</div>',
'  <div class="bk-bottom">',
'    <div class="bk-bottom-r">&nbsp;</div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Bracketed Region'
,p_theme_id=>2
,p_theme_class_id=>18
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'Use this region template when you want to contain content with a bracket UI.',
'',
'TITLE=YES',
'BUTTONS=YES',
'100% WIDTH=NO'))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344900694149168321)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="breadcrumb-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div>#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Breadcrumb Region'
,p_theme_id=>2
,p_theme_class_id=>6
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344900987971168321)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">#TITLE#</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Button Region with Title'
,p_theme_id=>2
,p_theme_class_id=>4
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344901316910168321)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">&nbsp;</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Button Region without Title'
,p_theme_id=>2
,p_theme_class_id=>17
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344901616993168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Chart Region'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>30
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344901917269168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Form Region'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>8
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344902208451168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="hide-show-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="hide-show-top">',
'    <div class="hide-show-title">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_2/rollup_plus_dgray.gif'',''#IMAGE_PREFIX#themes/theme_2/rollup_minus_dgr'
||'ay.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_2/rollup_plus_dgray.gif" ',
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></div>',
'    <div class="hide-show-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="hide" id="region#REGION_SEQUENCE_ID#">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Hide and Show Region'
,p_theme_id=>2
,p_theme_class_id=>1
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Gray Head, white body'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344902513854168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r">',
'    <div class="rc-content-main">',
'      <div class="rc-image"><img src="#IMAGE_PREFIX#themes/theme_2/images/report_icon.png" alt="" /></div>',
'      <div class="rc-content">#BODY#</div>',
'    </div>',
'  </div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'List Region with Icon'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>29
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344902816842168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="navigation-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div>',
'    <h3>#TITLE#</h3>',
'    #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Navigation Region'
,p_theme_id=>2
,p_theme_class_id=>5
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344903092456168322)
,p_layout=>'TABLE'
,p_template=>'<div class="navigation-region-alt" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>'Navigation Region, Alternative 1'
,p_theme_id=>2
,p_theme_class_id=>16
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344903416229168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Region without Buttons and Titles'
,p_theme_id=>2
,p_theme_class_id=>19
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344903697901168322)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="borderless-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="bl-top">',
'    <div class="bl-title">&nbsp;</div>',
'    <div class="bl-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div>',
'  <div class="bl-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>'Region without Title'
,p_theme_id=>2
,p_theme_class_id=>11
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344903995580168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table class="apex_finderbar" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'<tbody>',
'<tr>',
'<td class="apex_finderbar_left_top" valign="top"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8" alt=""  class="spacer" alt="" /></td>',
'<td class="apex_finderbar_middle" rowspan="3" valign="middle"><img src="#IMAGE_PREFIX#htmldb/builder/builder_find.png" /></td>',
'<td class="apex_finderbar_middle" rowspan="3" valign="middle" style="">#BODY#</td>',
'<td class="apex_finderbar_left" rowspan="3" width="10"><br /></td>',
'<td class="apex_finderbar_buttons" rowspan="3" valign="middle" nowrap="nowrap"><span class="apex_close">#CLOSE#</span><span>#EDIT##CHANGE##DELETE##CREATE##CREATE2##COPY##PREVIOUS##NEXT##EXPAND##HELP#</span></td>',
'</tr>',
'<tr><td class="apex_finderbar_left_middle"><br /></td></tr>',
'<tr>',
'<td class="apex_finderbar_left_bottom" valign="bottom"><img src="#IMAGE_PREFIX#1px_trans.gif" width="10" height="8"  class="spacer" alt="" /></td>',
'</tr>',
'</tbody>',
'</table>'))
,p_page_plug_template_name=>'Report Filter - Single Row'
,p_theme_id=>2
,p_theme_class_id=>31
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344904298378168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344904619660168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region float-left-100pct" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region 100% Width'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>13
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344904894725168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-gray-top"><div class="rc-gray-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Reports Region, Alternative 1'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>2
,p_theme_class_id=>10
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344905205408168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="sidebar-region" id="#REGION_STATIC_ID#">',
'  <h3>#TITLE#</h3>',
'  <div class="box">',
'    <div class="frame"><div class="content">#BODY#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Sidebar Region'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
,p_template_comment=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0">',
'        <tr>',
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>',
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>',
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#FF0000" height="16">',
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">',
'              <tr>',
'                <td align=middle valign="top">',
'                  <div align="center">',
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">',
'                      <b>#TITLE# </b></font></div>',
'                </td>',
'              </tr>',
'            </table>',
'          </td>',
'        </tr>',
'</table>',
'<table border="0" cellpadding="0" cellspacing="0">',
'   <tr>',
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />',
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">',
'              <tr>',
'                <td colspan="2">',
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">',
'                    <tr>',
'                      <td>&nbsp;</td>',
'                      <td valign="top" width="106">',
'                        <P><FONT face="arial, helvetica" size="1">',
'                            #BODY#',
'                           </font>',
'                        </P>',
'                      </td>',
'                    </tr>',
'                  </table>',
'            </table>',
'          </td>',
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'      </table>',
'      <table border="0" cellpadding="0" cellspacing="0">',
'        <tr>',
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>',
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>',
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'        <tr>',
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>',
'        </tr>',
'</table>',
''))
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344905518323168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="sidebar-region-alt" id="#REGION_STATIC_ID#">',
'  <h3>#TITLE#</h3>',
'  <div class="box">',
'    <div class="frame"><div class="content">#BODY#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Sidebar Region, Alternative 1'
,p_plug_table_bgcolor=>'#f7f7e7'
,p_theme_id=>2
,p_theme_class_id=>3
,p_plug_heading_bgcolor=>'#f7f7e7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344905791601168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:100%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'      <div style="float:left">#BODY#</div>',
'      <div style="float:right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</div>',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Top Bar'
,p_theme_id=>2
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344906107401168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Region'
,p_theme_id=>2
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(1344906405716168323)
,p_layout=>'TABLE'
,p_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title">#TITLE#</div>',
'    <div class="rc-buttons">#CLOSE##PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##EXPAND##COPY##HELP#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content-main">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Region with Icon'
,p_theme_id=>2
,p_theme_class_id=>20
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344890517717160766)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt3" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_name=>'Copy of Button List'
,p_theme_id=>101
,p_theme_class_id=>6
,p_list_template_before_rows=>'<div class="button-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344890700217160769)
,p_list_template_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of DHTML Tree'
,p_theme_id=>101
,p_theme_class_id=>23
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344891019482160769)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Hierarchical Expanding'
,p_theme_id=>101
,p_theme_class_id=>22
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344891288320160771)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Copy of Horizontal Images with Label List'
,p_theme_id=>101
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="horizontal-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344891619293160772)
,p_list_template_current=>'<a href="#LINK#" class="current">#TEXT#</a>'
,p_list_template_noncurrent=>'<a href="#LINK#">#TEXT#</a>'
,p_list_template_name=>'Copy of Horizontal Links List'
,p_theme_id=>101
,p_theme_class_id=>3
,p_list_template_before_rows=>'<div class="horizontal-links-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344891911439160772)
,p_list_template_current=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Pull Down Menu'
,p_theme_id=>101
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_1/images/menu-small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" />',
'</li>'))
,p_item_templ_noncurr_w_child=>'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_1/images/menu-small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344892212955160772)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a><'
||'/div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  "/></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a>'
||'</div>'
,p_list_template_name=>'Copy of Pull Down Menu with Image'
,p_theme_id=>101
,p_theme_class_id=>21
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt="" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(thi'
||'s,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_item_templ_noncurr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(th'
||'is,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344892498624160772)
,p_list_template_current=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#" class="htmldbButtonListCurrent" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td><a href="#LINK#" onclick="qF(this,''#LINK#'');return false;" id="#A01#"  class="htmldbButtonList" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Copy of Region Display Selector'
,p_theme_id=>101
,p_theme_class_id=>16
,p_list_template_before_rows=>'<table class="htmldbButtonList" summary="" border="0" cellpadding="0" cellspacing="3" id="ql"><tr>'
,p_list_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tr></table><script type="text/javascript">',
'apex.jQuery(document).ready(function(){propTest();});',
'</script>'))
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344892793154160772)
,p_list_template_current=>'<li class="active"><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_name=>'Copy of Tabbed Navigation List'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul class="tabbed-navigation-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344893116644160773)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Copy of Vertical Images List'
,p_theme_id=>101
,p_theme_class_id=>5
,p_list_template_before_rows=>'<div class="vertical-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344893407134160773)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Ordered List'
,p_theme_id=>101
,p_theme_class_id=>2
,p_list_template_before_rows=>'<ol class="vertical-ordered-List">'
,p_list_template_after_rows=>'</ol>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344893694918160773)
,p_list_template_current=>'<li class="active"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Sidebar List'
,p_theme_id=>101
,p_theme_class_id=>19
,p_list_template_before_rows=>'<ul class="vertical-sidebar-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344894004218160773)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Unordered List with Bullets'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-with-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344894311097160773)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Vertical Unordered List without Bullets'
,p_theme_id=>101
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-without-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344894587919160773)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="non-current"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Copy of Wizard Progress List'
,p_theme_id=>101
,p_theme_class_id=>17
,p_list_template_before_rows=>'<div class="wizard-progress-list"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_between_items=>'<li class="progress-indicator">&nbsp;</li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344906695543168323)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-alt1" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<button value="#TEXT#" onclick="#LINK#" class="button-gray" type="button">',
'  <span>#TEXT#</span>',
'</button>'))
,p_list_template_name=>'Button List'
,p_theme_id=>2
,p_theme_class_id=>6
,p_list_template_before_rows=>'<div class="button-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344907011001168324)
,p_list_template_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'DHTML Tree'
,p_theme_id=>2
,p_theme_class_id=>23
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344907319175168324)
,p_list_template_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Hierarchical Expanding'
,p_theme_id=>2
,p_theme_class_id=>22
,p_list_template_before_rows=>'<ul class="dhtmlTree">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_list_item_noncurrent=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_item_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_curr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344907619821168324)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Horizontal Images with Label List'
,p_theme_id=>2
,p_theme_class_id=>4
,p_list_template_before_rows=>'<div class="horizontal-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344907899248168324)
,p_list_template_current=>'<a href="#LINK#" class="current">#TEXT#</a>'
,p_list_template_noncurrent=>'<a href="#LINK#">#TEXT#</a>'
,p_list_template_name=>'Horizontal Links List'
,p_theme_id=>2
,p_theme_class_id=>3
,p_list_template_before_rows=>'<div class="horizontal-links-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344908210584168325)
,p_list_template_current=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Pull Down Menu'
,p_theme_id=>2
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">'
,p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" />',
'</li>'))
,p_item_templ_noncurr_w_child=>'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>'
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344908491680168325)
,p_list_template_current=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a><'
||'/div>'
,p_list_template_noncurrent=>'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  "/></a><img src="#IMAGE_PREFIX#menu/drop_down_nochild.png" width="20" height="128" alt="" /><a href="#LINK#" class="dhtmlBottom">#TEXT#</a>'
||'</div>'
,p_list_template_name=>'Pull Down Menu with Image'
,p_theme_id=>2
,p_theme_class_id=>21
,p_list_template_before_rows=>'<div class="dhtmlMenuLG">'
,p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>'
,p_before_sub_list=>'<ul id="S#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt="" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(thi'
||'s,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_item_templ_noncurr_w_child=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="dhtmlMenuItem"><a href="#LINK#" id="#LIST_ITEM_ID#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR#  /></a><img src="#IMAGE_PREFIX#menu/drop_down.png" width="20" height="128" alt=""  class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom3(th'
||'is,''S#LIST_ITEM_ID#'',''#LIST_ITEM_ID#'',false)" />',
'<a href="#LINK#" class="dhtmlBottom">#TEXT#</a>',
'</div>'))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" /></a></li>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344908818097168325)
,p_list_template_current=>'<li class="active"><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#"><span>#TEXT#</span></a></li>'
,p_list_template_name=>'Tabbed Navigation List'
,p_theme_id=>2
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul class="tabbed-navigation-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344909112809168325)
,p_list_template_current=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item-current">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_noncurrent=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="list-item">',
'  <div class="list-item-image"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></div>',
'  <div class="list-item-label"><a href="#LINK#" class="current">#TEXT#</a></div>',
'</div>'))
,p_list_template_name=>'Vertical Images List'
,p_theme_id=>2
,p_theme_class_id=>5
,p_list_template_before_rows=>'<div class="vertical-images-list">'
,p_list_template_after_rows=>'</div>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344909414309168325)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Ordered List'
,p_theme_id=>2
,p_theme_class_id=>2
,p_list_template_before_rows=>'<ol class="vertical-ordered-List">'
,p_list_template_after_rows=>'</ol>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344909700949168325)
,p_list_template_current=>'<li class="active"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Sidebar List'
,p_theme_id=>2
,p_theme_class_id=>19
,p_list_template_before_rows=>'<ul class="vertical-sidebar-list">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344909993428168325)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List with Bullets'
,p_theme_id=>2
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-with-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344910318988168325)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Vertical Unordered List without Bullets'
,p_theme_id=>2
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="vertical-unordered-list-without-bullets">'
,p_list_template_after_rows=>'</ul>'
);
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(1344910595262168325)
,p_list_template_current=>'<li class="current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="non-current"><a href="#LINK#">#TEXT#</a></li>'
,p_list_template_name=>'Wizard Progress List'
,p_theme_id=>2
,p_theme_class_id=>17
,p_list_template_before_rows=>'<div class="wizard-progress-list"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_between_items=>'<li class="progress-indicator">&nbsp;</li>'
);
end;
/
prompt --application/shared_components/user_interface/templates/report
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344882392473709276)
,p_row_template_name=>'Standard'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' <table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="report-standard">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' </table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_4/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_4/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344882392473709276)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344882489292709277)
,p_row_template_name=>'Standard, Alternating Row Colors'
,p_row_template1=>'<td class="data"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template2=>'<td class="dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#<tr><td>',
'<table border="0" cellpadding="0" cellspacing="0" class="report-standard-alternatingrowcolors" summary="" >'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_4/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_theme_id=>101
,p_theme_class_id=>5
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344882489292709277)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344910914579168325)
,p_row_template_name=>'Borderless Report'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#<tr>',
'<td><table class="report-borderless" cellpadding="0" border="0" cellspacing="0" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344910914579168325)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344911390387168327)
,p_row_template_name=>'Fixed Column Headers'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data" #COLUMN_WIDTH#><p #COLUMN_WIDTH#>#COLUMN_VALUE#</p></td>'
,p_row_template2=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data-alt" #COLUMN_WIDTH#><p #COLUMN_WIDTH#>#COLUMN_VALUE#</p></td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#',
'<tr>',
'<td><div class="fixed-header-report"><table cellpadding="0" border="0" cellspacing="0" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tbody></table></div><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<thead>',
''))
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</thead>',
'<tbody>',
''))
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344911390387168327)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344911892046168327)
,p_row_template_name=>'Horizontal Border'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" cellspacing="0" border="0" class="report-standard" summary="">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>',
''))
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344911892046168327)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344912408287168327)
,p_row_template_name=>'One Column Unordered List'
,p_row_template1=>'<li>#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">',
'#TOP_PAGINATION#',
'<tr><td><ul class="t1OneColumnUnorderedList">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_theme_id=>2
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344912408287168327)
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344912909442168327)
,p_row_template_name=>'Standard'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="data">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellpadding="0" border="0" cellspacing="0" summary="" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#">#TOP_PAGINATION#',
'<tr>',
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="report-standard">'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="header">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_next_page_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344912909442168327)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344913397007168327)
,p_row_template_name=>'Standard, Alternating Row Colors'
,p_row_template1=>'<td class="data"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template2=>'<td class="dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table border="0" cellpadding="0" cellspacing="0" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" class="report-holder">#TOP_PAGINATION#<tr><td>',
'<table border="0" cellpadding="0" cellspacing="0" class="report-standard-alternatingrowcolors" summary="" >'))
,p_row_template_after_rows=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table><div class="CSV">#EXTERNAL_LINK##CSV_LINK#</div></td>',
'</tr>',
'#PAGINATION#',
'</table>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th class="header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'ODD_ROW_NUMBERS'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'ODD_ROW_NUMBERS'
,p_next_page_template=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_next.gif" alt="Next"></a>',
''))
,p_previous_page_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>'
,p_next_set_template=>'<a href="#LINK#" class="pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_next.gif" alt="Next"></a>'
,p_previous_set_template=>'<a href="#LINK#" class="pagination"><img src="#IMAGE_PREFIX#themes/theme_2/images/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>'
,p_row_style_checked=>'#ccc'
,p_theme_id=>2
,p_theme_class_id=>5
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(1344913397007168327)
,p_row_template_before_first=>'<tr #HIGHLIGHT_ROW#>'
,p_row_template_after_last=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</tr>',
''))
);
exception when others then null;
end;
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344913912793168327)
,p_row_template_name=>'Two Column Portlet'
,p_row_template1=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="report-row">',
'  <div class="report-col-hdr">#1#</div>',
'  <div class="report-col-val">#2#</div>',
'</div>'))
,p_row_template_before_rows=>'<div class="two-col-report-portlet" #REPORT_ATTRIBUTES# id="#REGION_ID#">'
,p_row_template_after_rows=>'</div>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>2
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(1344914190142168327)
,p_row_template_name=>'Value Attribute Pairs'
,p_row_template1=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<div class="report-row">',
'  <div class="report-col-hdr">#COLUMN_HEADER#</div>',
'  <div class="report-col-val">#COLUMN_VALUE#</div>',
'</div>'))
,p_row_template_before_rows=>'<div class="two-col-report-portlet">'
,p_row_template_after_rows=>'</div>'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>2
,p_theme_class_id=>6
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1342858762101977367)
,p_template_name=>'Optional with Spacing'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'&nbsp;&nbsp;&nbsp;</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344889998324155113)
,p_template_name=>'Copy of No Label'
,p_template_body1=>'<span class="no-label">'
,p_template_body2=>'</span>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344890112294155113)
,p_template_name=>'Copy of Optional'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344890201601155113)
,p_template_name=>'Copy of Optional with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="optional-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344890317971155113)
,p_template_name=>'Copy of Required'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><span class="required">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344890417431155113)
,p_template_name=>'Copy of Required with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><a class="required-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSI'
||'ON.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344914498827168327)
,p_template_name=>'No Label'
,p_template_body1=>'<span class="no-label">'
,p_template_body2=>'</span>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>13
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344914617611168328)
,p_template_name=>'Optional'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><span class="optional">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>3
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344914718137168328)
,p_template_name=>'Optional with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><a class="optional-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344914812585168328)
,p_template_name=>'Required'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_2/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><span class="required">'
,p_template_body2=>'</span></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(1344914913064168328)
,p_template_name=>'Required with help'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_2/images/required.gif" alt="#VALUE_REQUIRED#" tabindex="999" /><a class="required-w-help" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSI'
||'ON.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_before_label=>'<div class="t1InlineError">'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(1344889815508150678)
,p_name=>'Copy of Breadcrumb Menu'
,p_before_first=>'<div id="breadcrumbs"><ul id="breadcrumbs">'
,p_current_page_option=>'<li class="current">#NAME#</li>'
,p_non_current_page_option=>'<li class="noncurrent"><a href="#LINK#">#NAME#</a></li>'
,p_between_levels=>'&nbsp;'
,p_after_last=>'</ul></div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(1344889889231150679)
,p_name=>'Copy of Hierarchical Menu'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(1344915006183168328)
,p_name=>'Breadcrumb Menu'
,p_before_first=>'<div id="breadcrumbs"><ul class="breadcrumb-list">'
,p_current_page_option=>'<li class="current">#NAME#</li>'
,p_non_current_page_option=>'<li class="noncurrent"><a href="#LINK#">#NAME#</a></li>'
,p_between_levels=>'<li class="separator">&nbsp;</li>'
,p_after_last=>'</ul></div>'
,p_max_levels=>12
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
);
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(1344915091019168328)
,p_name=>'Hierarchical Menu'
,p_before_first=>'<ul class="t1HierarchicalMenu">'
,p_current_page_option=>'<li class="t1current">#NAME#</li>'
,p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>11
,p_start_with_node=>'CHILD_MENU'
,p_theme_id=>2
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(1344889602780128018)
,p_popup_icon=>'#IMAGE_PREFIX#list.gif'
,p_popup_icon_attr=>'width=13 height=13'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css>',
'',
'</head>'))
,p_page_body_attr=>'bgcolor=white OnLoad=first_field()'
,p_before_field_text=>' '
,p_page_heading_text=>'<link rel=stylesheet href=#IMAGE_PREFIX#platform2.css type=text/css><style>a:link { color:#336699; text-decoration:none; padding:2px;} a:visited { color:#336699; text-decoration:none;} a:hover { color:red; text-decoration:underline;} body { font-fami'
||'ly:arial; background-color:#ffffff;} </style>'
,p_page_footer_text=>'</center></td></tr></table>'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next'
,p_prev_button_text=>'Previous'
,p_after_field_text=>'</div><br />'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'Row(s) #FIRST_ROW# - #LAST_ROW#'
,p_result_rows_per_pg=>10
,p_translate_this_template=>'N'
);
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(1344915817023168330)
,p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif'
,p_popup_icon_attr=>'width="18" height="18" alt="Popup Lov"'
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#APEX_JAVASCRIPT#',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_2/css/theme_4_0.css" type="text/css">',
'',
'',
'</head>'))
,p_page_body_attr=>'onload="first_field()" style="margin:0;"'
,p_before_field_text=>'<div class="popup-head">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_find_button_text=>'Search'
,p_close_button_text=>'Close'
,p_next_button_text=>'Next >'
,p_prev_button_text=>'< Previous'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'400'
,p_height=>'450'
,p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>500
,p_before_result_set=>'<div class="popup-body">'
,p_theme_id=>2
,p_theme_class_id=>1
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(1344915187939168328)
,p_cal_template_name=>'Calendar'
,p_day_of_week_format=>'<th class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="WeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="0" summary="0" class="DayCalendar">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarHolder"> ',
' <tr>',
'   <td class="MonthTitle">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th class="DayOfWeek">#IDAY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="Calendar">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="Day" valign="top">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="Today">'
,p_cust_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="NonDay" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="WeekendDay">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="WeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="0" class="WeekCalendar">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'75'
,p_cust_week_day_width_per=>'14'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>1
);
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(1344915411518168329)
,p_cal_template_name=>'Calendar, Alternative 1'
,p_day_of_week_format=>'<th valign="bottom" class="DayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="MonthTitle">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="CalendarAlternative1">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_day_open_format=>'<td class="Day" valign="top" height="100" height="100">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="Today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="WeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="NonDay" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="WeekCalendarAlternative1">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#IDAY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="DayCalendarAlternative1Holder"> <tr><td class="MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="4" summary="0" class="DayCalendarAlternative1">'
,p_daily_month_close_format=>'</table></td> </tr> </table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0" summary="" class="CalendarAlternative1Holder"> ',
' <tr>',
'   <td class="MonthTitle">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th valign="bottom" class="DayOfWeek">#IDAY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="CalendarAlternative1">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>',
''))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="DayTitle">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="Day" valign="top" height="100" height="100">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="Today">'
,p_cust_nonday_title_format=>'<div class="NonDayTitle">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="NonDay" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="WeekendDayTitle">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="WeekendDay">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="4" cellpadding="0" border="0" summary="" class="WeekCalendarAlternative1Holder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#IDAY#<br>#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="4" summary="0" class="WeekCalendarAlternative1">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'100'
,p_cust_week_day_width_pix=>'100'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>2
);
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(1344915605755168330)
,p_cal_template_name=>'Small Calendar'
,p_day_of_week_format=>'<th class="day-of-week">#DY#</th>'
,p_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="small-calendar-holder"> ',
' <tr>',
'   <td class="month-title">#IMONTH# #YYYY#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="" class="small-calendar">'
,p_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_day_title_format=>'<div class="day-title">#DD#</div>'
,p_day_open_format=>'<td class="day" valign="top">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td valign="top" class="today">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="weekend-day-title">#DD#</div>'
,p_weekend_open_format=>'<td valign="top" class="weekend-day">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="non-day-title">#DD#</div>'
,p_nonday_open_format=>'<td class="non-day" valign="top">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallWeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_weekly_day_of_week_format=>'<th class="DayOfWeek">#DY#<br />#MM#/#DD#</th>'
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="SmallWeekCalendar">'
,p_weekly_month_close_format=>'</table></td></tr></table>'
,p_weekly_day_open_format=>'<td class="Day" valign="top">'
,p_weekly_day_close_format=>'<br /></td>'
,p_weekly_today_open_format=>'<td class="t1Today" valign="top">'
,p_weekly_weekend_open_format=>'<td valign="top" class="NonDay">'
,p_weekly_weekend_close_format=>'<br /></td>'
,p_weekly_time_open_format=>'<th class="Hour">'
,p_weekly_time_close_format=>'<br /></th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th class="DayOfWeek">#DY# #DD#/#MM#</th>'
,p_daily_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallDayCalendarHolder"> <tr> <td class="MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>',
''))
,p_daily_month_open_format=>'<table border="0" cellpadding="2" cellspacing="1" summary="0" class="SmallDayCalendar">'
,p_daily_month_close_format=>'</table></td></tr></table>'
,p_daily_day_open_format=>'<td valign="top" class="Day">'
,p_daily_day_close_format=>'<br /></td>'
,p_daily_today_open_format=>'<td valign="top" class="Today">'
,p_daily_time_open_format=>'<th class="Hour">'
,p_daily_time_close_format=>'<br /></th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="small-calendar-holder"> ',
' <tr>',
'   <td class="month-title">#WTITLE#</td>',
' </tr>',
' <tr>',
' <td>'))
,p_cust_day_of_week_format=>'<th class="day-of-week">#DY#</th>'
,p_cust_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="" class="small-calendar">'
,p_cust_month_close_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</table></td>',
'</tr>',
'</table>'))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<div class="day-title">#DD#</div>'
,p_cust_day_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="day" valign="top">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="today">'
,p_cust_nonday_title_format=>'<div class="non-day-title">#DD#</div>'
,p_cust_nonday_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" class="non-day" valign="top">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<div class="weekend-day-title">#DD#</div>'
,p_cust_weekend_open_format=>'<td style="#COL_HEIGHT_PIX# #COL_HEIGHT_PER#" valign="top" class="weekend-day">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th class="Hour">'
,p_cust_time_close_format=>'<br /></th>'
,p_cust_wk_month_title_format=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="2" cellpadding="0" border="0" summary="" class="SmallWeekCalendarHolder">',
'<tr>',
'<td class="MonthTitle" id="test">#WTITLE#</td>',
'</tr>',
'<tr>',
'<td>'))
,p_cust_wk_day_of_week_format=>'<th class="DayOfWeek">#DY#<br />#MM#/#DD#</th>'
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="2" summary="0" class="SmallWeekCalendar">'
,p_cust_wk_month_close_format=>'</table></td></tr></table>'
,p_cust_wk_day_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="Day" valign="top">'
,p_cust_wk_day_close_format=>'<br /></td>'
,p_cust_wk_today_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" class="t1Today" valign="top">'
,p_cust_wk_weekend_open_format=>'<td style="#COL_WIDTH_PIX# #COL_WIDTH_PER#" valign="top" class="NonDay">'
,p_cust_wk_weekend_close_format=>'<br /></td>'
,p_cust_month_day_height_pix=>'14'
,p_cust_month_day_height_per=>'14'
,p_cust_week_day_width_pix=>'40'
,p_cust_week_day_width_per=>'14'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>2
,p_theme_class_id=>3
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(1344882690274709279)
,p_theme_id=>101
,p_theme_name=>'oneEPA'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_error_template=>wwv_flow_api.id(1344882111434709273)
,p_printer_friendly_template=>wwv_flow_api.id(1344882111434709273)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(101),'')
,p_css_file_urls=>'#IMAGE_PREFIX#legacy_ui/css/5.0#MIN#.css?v=#APEX_VERSION#'
);
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(1344916004701168331)
,p_theme_id=>2
,p_theme_name=>'Builder Blue'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_api.id(1344897204509168317)
,p_error_template=>wwv_flow_api.id(1344897204509168317)
,p_printer_friendly_template=>wwv_flow_api.id(1344897797046168318)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_api.id(1344894911269168313)
,p_default_button_template=>wwv_flow_api.id(1344899306992168319)
,p_default_region_template=>wwv_flow_api.id(1344904298378168323)
,p_default_chart_template=>wwv_flow_api.id(1344901616993168322)
,p_default_form_template=>wwv_flow_api.id(1344901917269168322)
,p_default_reportr_template=>wwv_flow_api.id(1344904298378168323)
,p_default_tabform_template=>wwv_flow_api.id(1344904298378168323)
,p_default_wizard_template=>wwv_flow_api.id(1344906107401168323)
,p_default_menur_template=>wwv_flow_api.id(1344900694149168321)
,p_default_listr_template=>wwv_flow_api.id(1344902513854168322)
,p_default_report_template=>wwv_flow_api.id(1344912909442168327)
,p_default_label_template=>wwv_flow_api.id(1344914718137168328)
,p_default_menu_template=>wwv_flow_api.id(1344915006183168328)
,p_default_calendar_template=>wwv_flow_api.id(1344915187939168328)
,p_default_list_template=>wwv_flow_api.id(1344909993428168325)
,p_default_option_label=>wwv_flow_api.id(1344914718137168328)
,p_default_required_label=>wwv_flow_api.id(1344914913064168328)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(2),'')
,p_css_file_urls=>'#IMAGE_PREFIX#legacy_ui/css/5.0#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_options
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
null;
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/globalization/translations
begin
null;
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts
begin
null;
end;
/
prompt --application/shared_components/security/authentications
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(1344882791693709281)
,p_name=>'Application Express'
,p_scheme_type=>'NATIVE_APEX_ACCOUNTS'
,p_attribute_15=>'3552433650091224'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=&APP_ID.:101:&SESSION.'
,p_logout_url=>'f?p=&APP_ID.:1'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use internal Application Express account credentials and login page in this application.'
);
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(1344882910158709281)
,p_name=>'DATABASE'
,p_scheme_type=>'NATIVE_DAD'
,p_attribute_15=>'3552552115091224'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use database authentication (user identified by DAD).'
);
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(1344883017669709281)
,p_name=>'DATABASE ACCOUNT'
,p_scheme_type=>'NATIVE_DB_ACCOUNTS'
,p_attribute_15=>'3552659626091224'
,p_invalid_session_type=>'URL'
,p_invalid_session_url=>'f?p=&APP_ID.:101:&SESSION.'
,p_logout_url=>'f?p=&APP_ID.:1'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_comments=>'Use database account credentials.'
);
end;
/
prompt --application/ui_types
begin
null;
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(1341394875874886529)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>101
,p_home_url=>'f?p=&APP_ID.:1:&SESSION.'
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>true
,p_include_jquery_migrate=>true
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_api.create_page(
 p_id=>1
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Dashboard'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130529120250'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342724258197349036)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_when_condition=>'F102_X_BREADCRUMB'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342918767033117347)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342919276645139009)
,p_plug_name=>'Total Warehouse Results'
,p_parent_plug_id=>wwv_flow_api.id(1342918767033117347)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342919478740139015)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Warehouse Records'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589120696520958'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:Circle:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>#NO_DATA_MESSAGE#</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedVertical" name="chart_1589120696520958"> ',
'      <chart_settings>',
'        <title text_align="Center" position="Top" >',
'          <text>Total Warehouse Records Added in the Past 5 Years</text>',
'          <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="left" enabled="false">',
'            <scale mode="Normal" />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'            <minor_grid enabled="False"/>            ',
'          </x_axis>          ',
'        </axes>',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'        <line_series>',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Center">',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <line_style>',
'					   <line enabled="true" thickness="1" opacity="1" />',
'          </line_style>',
'          <marker_settings enabled="True" >',
'            <marker type="Circle" />',
'          </marker_settings>',
'        </line_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343423579216469540)
,p_chart_id=>wwv_flow_api.id(1342919478740139015)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       act_start_year_date as label, ',
'       sum(result_count) as value  from state_year a, table(pkg_dynamic_list.get_years()) dt',
' where dt.column_value = a.act_start_year_date',
' group by act_start_year_date',
' order by 2'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342919767735193205)
,p_plug_name=>'Total Records By Type'
,p_parent_plug_id=>wwv_flow_api.id(1342918767033117347)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:1:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_column_width=>'width="50%"'
,p_plug_header=>'<center>'
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342919960156193208)
,p_default_chart_type=>'3DColumn'
,p_chart_title=>'Total Records By Type'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1589602112575151'
,p_chart_width=>500
,p_chart_height=>350
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'#B9E2F4,#63A9D5,#4E77A7'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for found.</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>Total Warehouse Records by Type</text>',
'           <font family="Tahoma" size="12" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342920080422193210)
,p_chart_id=>wwv_flow_api.id(1342919960156193208)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null as link,',
'       ''Biological'' as label,',
'       sum(biological_count) as value ',
'  from state_year',
' union',
'select null as link,',
'       ''Habitat'' as label,',
'       sum(habitat_count) as value ',
'  from state_year',
' union',
'select null as link,',
'       ''Physical/Chemical'' as label,',
'       sum(regular_count) as value ',
'  from state_year',
''))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343467962292736805)
,p_plug_name=>'Report and Link Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>18
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>Welcome to the STORET Dashboard.  This site enables quick views into the STORET water quality data holdings as submitted by federal, state, and tribal agencies, watershed groups, universities, and industry.</p>',
'',
'<p>Select a view of interest using the buttons below.</p>',
''))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342724673566362950)
,p_plug_name=>'STORET Dashboard'
,p_parent_plug_id=>wwv_flow_api.id(1343467962292736805)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>23
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<center>',
'<font family="Tahoma"><b>Dashboard Reports</b></font>',
'<br><br>',
'<table>',
'',
'<tr><td align="center" width="150"><input type="button" value="By Region" onclick="javascript:window.location.href=''f?p=&APP_ID.:5:&SESSION.:::5::''" class="button_field"><br><br>',
'</td>',
'<td align="center" width="150">',
'<input type="button" value="By State" onclick="javascript:window.location.href=''f?p=&APP_ID.:3:&SESSION.:::3::''" class="button_field"><br><br>',
'</td></tr>',
'',
'<tr><td align="center"><input type="button" value="By Tribes" onclick="javascript:window.location.href=''f?p=&APP_ID.:12:&SESSION.:::12::''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="State Profile" onclick="javascript:window.location.href=''f?p=&APP_ID.:7:&SESSION.:::7::''" class="button_field"><br><br></td>',
'</tr>',
'',
'<tr>',
'<td align="center"><input type="button" value="All Orgs" onclick="javascript:window.location.href=''f?p=&APP_ID.:9:&SESSION.:::9::''" class="button_field"><br><br></td>',
'<td align="center"><input type="button" value="Top 10" onclick="javascript:window.location.href=''f?p=&APP_ID.:10:&SESSION.:::10::''" class="button_field"><br><br></td>',
'</tr>',
'',
'</table>',
'</center>',
'',
'',
'',
'',
'<!--',
'<center>',
'<font family="Tahoma"><b>Dashboard Reports</b></font>',
'<br><br>',
'<table><tr><td align="left">',
'<a href="f?p=&APP_ID.:5:&SESSION.:::5::">Annual Data Submission by EPA Region</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:3:&SESSION.:::3::">Annual Data Submission by State',
'</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:7:&SESSION.:::7::">State Profile</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:9:&SESSION.:::9::">Data Owners Contribution</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:12:&SESSION.:::12::">Data Owners Contribution by Tribes</a><br>',
'</td></tr>',
'<tr><td align="left">',
'<a href="f?p=&APP_ID.:10:&SESSION.:::10::">Top 10 Substances for Recent 5 Years by State</a><br>',
'</td></tr></table>',
'</center>',
'-->'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343425688270728024)
,p_plug_name=>'Top Characteristics'
,p_parent_plug_id=>wwv_flow_api.id(1343467962292736805)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>1
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select display_name,',
'       result_count',
'  from ( select display_name,',
'                sum(regular_count) as result_count,',
'                dense_rank() over (order by sum(regular_count) desc) rnk',
'           from state_char_year',
'          group by display_name )',
' where rnk <= 10',
' order by rnk'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_column_width=>'valign="middle" width="50%"'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_plug_header=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<center><font family="Tahoma"><b>Top 10 Warehouse Characteristics</b></font>',
''))
,p_plug_footer=>'</center>'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1343425767899728024)
,p_name=>'Top Characteristics'
,p_max_row_count=>'1000000'
,p_max_row_count_message=>'The maximum row count for this report is #MAX_ROW_COUNT# rows.  Please apply a filter to reduce the number of records in your query.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_saving=>'N'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_show_search_textbox=>'N'
,p_show_actions_menu=>'N'
,p_report_list_mode=>'NONE'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_select_columns=>'N'
,p_show_rows_per_page=>'N'
,p_show_filter=>'N'
,p_show_sort=>'N'
,p_show_control_break=>'N'
,p_show_highlight=>'N'
,p_show_computation=>'N'
,p_show_aggregate=>'N'
,p_show_chart=>'N'
,p_show_group_by=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_show_reset=>'N'
,p_show_download=>'N'
,p_show_help=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2095409856109967
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343425970135728030)
,p_db_column_name=>'DISPLAY_NAME'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Characteristic'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'DISPLAY_NAME'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343426087443728033)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'999G999G999G999G999G990'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(1343426188962728226)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'20959'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'DISPLAY_NAME:RESULT_COUNT'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342818180565011274)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'1'
);
end;
/
prompt --application/pages/page_00003
begin
wwv_flow_api.create_page(
 p_id=>3
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Annual Data Submission by State'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Annual Data Submission by State'
,p_step_sub_title=>'Yearly Submission Completion by State'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>'<script src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js" type="text/javascript"></script>'
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130529120519'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342726665877505414)
,p_plug_name=>'Yearly Submission Completion By State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'BEGIN',
'',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'             ',
'   -- Create HTML table with div holders for the dynamic charts ',
'                      ',
'   htp.p(''<table cellspacing="20" cellpadding="0" border="0">'');',
'   ',
'   FOR c IN (',
'      select state_postal_code,',
'             rownum as idx',
'        from ( select st.state_postal_code',
'                 from di_geo_state st',
'                where country_code = ''US''',
'                  and ( epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'                order by st.state_name )',
'   )',
'   LOOP',
'   ',
'      IF c.idx MOD 3 = 1',
'      THEN      ',
'         htp.p(''<tr>'');      ',
'      END IF;',
'   ',
'      htp.p(''<td><div id="my_rchart_'' || c.state_postal_code || ''"></div></td>'');',
'   ',
'      IF c.idx MOD 3 = 0',
'      THEN      ',
'         htp.p(''</tr>'');',
'      END IF;',
'      ',
'      l_idx := c.idx;',
'   ',
'   END LOOP;   ',
'   ',
'   IF l_idx MOD 3 > 0 THEN',
'',
'      FOR i IN l_idx + 1 .. l_idx + 3',
'      LOOP',
'',
'          IF i MOD 3 = 0',
'          THEN          ',
'             htp.p(''<td></td>'');',
'             htp.p(''</tr>'');',
'             exit;          ',
'          ELSE          ',
'             htp.p(''<td></td>'');',
'          END IF;',
'',
'      END LOOP; ',
'',
'   END IF;   ',
'',
'   htp.p(''</table>'');',
'   ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'      select state_postal_code,',
'             rownum as idx',
'        from ( select st.state_postal_code',
'                 from di_geo_state st',
'                where country_code = ''US''',
'                  and ( epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'                order by st.state_name )',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.state_postal_code || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.state_postal_code || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.state_postal_code || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.state_postal_code || ''.write("my_rchart_'' || c.state_postal_code || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR c IN (',
'',
'      select st.pk_isn,',
'             st.state_postal_code,',
'             st.state_name,',
'             nvl(x.total_count,0) as val,',
'             nvl(z.avg_5_yr,1) as max1,',
'             nvl(z.avg_5_yr,0) as max0',
'        from di_geo_state st,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      fk_gen_geo_state, ',
'                      avg(result_count) as avg_5_yr,',
'                      avg(regular_count) as avg_5_yr_reg,',
'                      avg(habitat_count) as avg_5_yr_hab,',
'                      avg(biological_count) as avg_5_yr_bio                ',
'                 from state_year a, table(pkg_dynamic_list.get_years(:P3_X_YEAR - 1,5)) dt                ',
'                where dt.column_value = a.act_start_year_date',
'                group by fk_gen_geo_state ) z,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      fk_gen_geo_state,',
'                      biological_count,',
'                      habitat_count,',
'                      regular_count,',
'                      result_count as total_count,',
'                      dt.column_value as activity_year',
'                 from state_year a,',
'                      table(pkg_dynamic_list.get_years(:P3_X_YEAR,1)) dt',
'                where dt.column_value = a.act_start_year_date ) x',
'       where st.pk_isn = z.fk_gen_geo_state (+)',
'         and st.pk_isn = x.fk_gen_geo_state (+)',
'         and st.country_code = ''US''',
'                  and ( st.epa_region_code = :P3_X_EPA_REGION or :P3_X_EPA_REGION = ''0'' )',
'       order by st.state_name',
'',
'   )',
'   LOOP',
'',
'      IF c.max1 > c.val THEN',
'         l_max := c.max1;',
'      ELSE',
'         l_max := c.val;',
'      END IF;   ',
'',
'      l_chart_scale := l_max / 4000;',
'      l_chart_value := c.val / 1000;',
'      l_chart_max := l_max / 1000;',
'      l_chart_pa := l_max / 3000;',
'      l_chart_ag := 2 * l_max / 3000;',
'      l_chart_title := c.state_name; ',
'      l_chart_plabel := ''In '' || :P3_X_YEAR || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'      l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'      l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="yes" size="10"/></lab'
||'el></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'|| l_chart_title ||',
'''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:7:&SESSION.:::7:P7_X_GEN_GEO_STATE,P7_X_YEAR:''',
'|| c.pk_isn || '','' || :P3_X_YEAR ||',
'''" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_'
||'angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'        || l_chart_max || ',
'        ''" major_interval="'' ',
'        || l_chart_scale || ',
'        ''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'        || l_chart_pa || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'        || l_chart_pa || ',
'        ''" end="'' ',
'        || l_chart_ag || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'        || l_chart_ag || ',
'        ''" end="'' ',
'        || l_chart_max || ',
'        ''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="C'
||'enter"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><key co'
||'lor="#FDFDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'        || l_chart_value || ',
'        ''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'        || l_chart_plabel || ',
'        '']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:7:&SESSION.:::7:P7_X_GEN_GEO_STATE,P7_X_YEAR:''',
'|| c.pk_isn || '','' || :P3_X_YEAR ||',
'''" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6"'
||' highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gradient></fill>'
||'<border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></effects></cap'
||'></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'|| l_chart_label || ',
''']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'      htp.p(''',
'        c_'' || c.state_postal_code || ''.setData('''''' || l_XML || ''''''); '');',
'',
'   END LOOP;',
'',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P3_X_EPA_REGION'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342726885256505419)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within an EPA Region in the selected year by State. The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five year average. The reco'
||'rds represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.</p>',
'<p>Select a year and a Region using the dropdown menu. To view the organizations which submit data within the state, click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342727661332505420)
,p_plug_name=>'Yearly Submission Completion by State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342729287745565756)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342825360937281908)
,p_plug_name=>'Breadcrumb2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342821980583230815)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) > 0'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342727486693505420)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1342726885256505419)
,p_button_name=>'P3_GO'
,p_button_static_id=>'P3_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342727275398505420)
,p_name=>'P3_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342726885256505419)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342730178750638789)
,p_name=>'P3_X_EPA_REGION'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(1342726885256505419)
,p_prompt=>'<strong>Select EPA Region:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select epa_region_name,',
'       epa_region_code',
'  from di_epa_region',
' order by pk_isn'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342775061065527775)
,p_name=>'P3_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(1342726885256505419)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342819580321143673)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 4 - bitand(nvl(:F102_X_BREADCRUMB,1),4),7)'
);
end;
/
prompt --application/pages/page_00005
begin
wwv_flow_api.create_page(
 p_id=>5
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Annual Data Submission by EPA Region'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Annual Data Submission by EPA Region'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<!--<script src="#IMAGE_PREFIX#flashchart/anychart_5/js/AnyChart.js" type="text/javascript"></script>-->',
'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'))
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130529120539'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342681569352561418)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_when_condition=>'F102_X_BREADCRUMB'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342684058456671828)
,p_plug_name=>'Yearly Submission Completion by Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'BEGIN',
'    ',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   -- Create HTML table with div holders for the dynamic charts ',
'                   ',
'   htp.p(''<table cellspacing="20" cellpadding="0" border="0">'');   ',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'   ',
'      IF c.idx MOD 3 = 1',
'      THEN      ',
'         htp.p(''<tr>'');      ',
'      END IF;',
'   ',
'      htp.p(''<td><div id="my_rchart_'' || c.epa_region_code || ''"></div></td>'');',
'   ',
'      IF c.idx MOD 3 = 0',
'      THEN      ',
'         htp.p(''</tr>'');      ',
'      END IF;',
'      ',
'      l_idx := c.idx;',
'   ',
'   END LOOP;',
'   ',
'   IF l_idx MOD 3 > 0 THEN',
'',
'      FOR i IN l_idx + 1 .. l_idx + 3',
'      LOOP',
'',
'          IF i MOD 3 = 0',
'          THEN          ',
'             htp.p(''<td></td>'');',
'             htp.p(''</tr>'');',
'             exit;          ',
'          ELSE          ',
'             htp.p(''<td></td>'');',
'          END IF;',
'',
'      END LOOP; ',
'',
'   END IF;   ',
'   ',
'   htp.p(''</table>'');',
'   ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select epa_region_code,',
'             rownum idx',
'        from ( select st.epa_region_code',
'                 from di_epa_region st',
'                order by st.pk_isn )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.epa_region_code || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.epa_region_code || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.epa_region_code || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.epa_region_code || ''.write("my_rchart_'' || c.epa_region_code || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'   ',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR c IN (',
'',
'      select st.epa_region_code,',
'             st.epa_region_name,',
'             nvl(x.total_count,0) as val,',
'             nvl(z.avg_5_yr,1) as max1,',
'             nvl(z.avg_5_yr,0) as max0',
'        from di_epa_region st,',
'             ( SELECT epa_region_code,',
'                   AVG (sum_5_yr) AS avg_5_yr,',
'                   AVG (sum_5_yr_reg) AS avg_5_yr_reg,',
'                   AVG (sum_5_yr_hab) AS avg_5_yr_hab,',
'                   AVG (sum_5_yr_bio) AS avg_5_yr_bio',
'              FROM ( SELECT /*+ DYNAMIC_SAMPLING(dt 5) */',
'                            b.epa_region_code,',
'                            dt.column_value AS yr,',
'                            SUM (result_count) AS sum_5_yr,',
'                            SUM (regular_count) AS sum_5_yr_reg,',
'                            SUM (habitat_count) AS sum_5_yr_hab,',
'                            SUM (biological_count) AS sum_5_yr_bio',
'                       FROM state_year a,',
'                            di_geo_state b,',
'                            TABLE (pkg_dynamic_list.get_years(:P5_X_YEAR - 1,5)) dt',
'                      WHERE     dt.column_value = a.act_start_year_date',
'                            AND a.fk_gen_geo_state = b.pk_isn',
'                   GROUP BY b.epa_region_code, dt.column_value )',
'             GROUP BY epa_region_code ) z,',
'             ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                      b.epa_region_code,',
'                      sum(biological_count) as biological_count,',
'                      sum(habitat_count) as habitat_count,',
'                      sum(regular_count) as regular_count,',
'                      sum(result_count) as total_count,',
'                      dt.column_value as activity_year',
'                 from state_year a,',
'                      di_geo_state b,',
'                      table(pkg_dynamic_list.get_years(:P5_X_YEAR,1)) dt',
'                where dt.column_value = a.act_start_year_date',
'                  and a.fk_gen_geo_state = b.pk_isn',
'                group by b.epa_region_code, dt.column_value ) x',
'       where st.epa_region_code = z.epa_region_code (+)',
'         and st.epa_region_code = x.epa_region_code (+)',
'       order by st.pk_isn',
'',
'   )',
'   LOOP',
'   ',
'      IF c.max1 > c.val THEN',
'         l_max := c.max1;',
'      ELSE',
'         l_max := c.val;',
'      END IF;   ',
'',
'      l_chart_scale := l_max / 4000;',
'      l_chart_value := c.val / 1000;',
'      l_chart_max := l_max / 1000;',
'      l_chart_pa := l_max / 3000;',
'      l_chart_ag := 2 * l_max / 3000;',
'      l_chart_title := c.epa_region_name; ',
'      l_chart_plabel := ''In '' || :P5_X_YEAR || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'      l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'      l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="True" size="10"/></la'
||'bel></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'|| l_chart_title ||',
'''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:3:&SESSION.:::3:P3_X_EPA_REGION,P3_X_YEAR:''',
'|| c.epa_region_code || '','' || :P5_X_YEAR ||',
'''" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radius="37" start_'
||'angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'|| l_chart_max || ',
'''" major_interval="'' ',
'|| l_chart_scale || ',
'''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'|| l_chart_pa || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_pa || ',
'''" end="'' ',
'|| l_chart_ag || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'|| l_chart_ag || ',
'''" end="'' ',
'|| l_chart_max || ',
'''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halign="Center"/>'
||'<font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><key color="#FD'
||'FDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'|| l_chart_value || ',
'''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'|| l_chart_plabel || ',
''']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:3:&SESSION.:::3:P3_X_EPA_REGION,P3_X_YEAR:''',
'|| c.epa_region_code || '','' || :P5_X_YEAR ||',
'''" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6"'
||' highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gradient></fill>'
||'<border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></effects></cap'
||'></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'|| l_chart_label || ',
''']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'      htp.p(''',
'        c_'' || c.epa_region_code || ''.setData('''''' || l_XML || ''''''); '');',
'',
'   END LOOP;',
'',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
' '))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342772987704839675)
,p_plug_name=>'Select Year'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within an EPA Region in the selected year (default to the current year). The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five y'
||'ear average. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.</p>',
'<p>Select a year using the dropdown menu. To view the states within the Region,',
'click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342773786843877316)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1342772987704839675)
,p_button_name=>'P5_GO'
,p_button_static_id=>'P5_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342773368704862580)
,p_name=>'P5_X_YEAR'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342772987704839675)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342773678878874983)
,p_name=>'P5_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342772987704839675)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342819161611062508)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 2 - bitand(nvl(:F102_X_BREADCRUMB,1),2),3)'
);
end;
/
prompt --application/pages/page_00007
begin
wwv_flow_api.create_page(
 p_id=>7
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'State Profile'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: State Profile'
,p_step_sub_title=>'State Profile'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_html_page_header=>'<script type="text/javascript" src="#IMAGE_PREFIX#flashchart/anychart_6/js/AnyChart.js"></script>'
,p_javascript_code_onload=>'updateChartData();'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130529120614'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342788963629586765)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the amount of data available within a state by the selected year. The number of records submitted in the selected year is compared to the number of records submitted to STORET over a five year average. The figures also displa'
||'y the number of records submitted by results categories.  The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups.<'
||'/p>',
'<p>Select a year and a state using the dropdown menu. To view the ',
'organizations which submit data within the state, click on the figure.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342792560015586770)
,p_plug_name=>'State Profile'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342801385872820497)
,p_plug_name=>'Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>15
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<br>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342818766628026141)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342827479038343915)
,p_plug_name=>'Breadcrumb2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342821980583230815)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) > 0 AND bitand(:F102_X_BREADCRUMB,4) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342827684233345456)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342822084046231829)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342830888518706280)
,p_plug_name=>'Chart Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>25
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' ',
'DECLARE',
'   l_chart_scale    NUMBER;',
'   l_chart_value    NUMBER;',
'   l_chart_max      NUMBER;',
'   l_chart_pa       NUMBER;',
'   l_chart_ag       NUMBER;',
'   l_chart_title    VARCHAR2(1000);',
'   l_chart_label    VARCHAR2(1000);',
'   l_chart_plabel   VARCHAR2(1000);',
'   l_image_prefix   VARCHAR2(300);',
'   l_host           VARCHAR2(4000);',
'   l_XML            VARCHAR2(32767);',
'   l_idx            NUMBER;',
'   l_max            NUMBER;',
'   l_year           NUMBER;',
'BEGIN',
'',
'   l_image_prefix := V(''IMAGE_PREFIX'');',
'   l_host := OWA_UTIL.get_cgi_env (''REQUEST_PROTOCOL'') || ''://''  ',
'          || OWA_UTIL.get_cgi_env (''HTTP_HOST'')        || '':''  ',
'          || OWA_UTIL.get_cgi_env (''SERVER_PORT'')      || ''/''  ',
'          || REPLACE(OWA_UTIL.get_cgi_env (''SCRIPT_NAME''),''/'','''') || ''/'';',
'',
'   l_year := :P7_X_YEAR;',
'             ',
'   -- Create HTML table with div holders for the dynamic charts ',
'',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr><td><center>'');',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 2) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 1) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 2) || ''"></div></td></tr></table><br>'');   ',
'   ',
'   htp.p(''<table cellspacing="0" cellpadding="0" border="0"><tr>'');',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 3) || ''"></div></td>'');   ',
'   htp.p(''<td><div id="my_rchart_'' || to_char(l_year - 4) || ''"></div></td></tr><tr>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 3) || ''"></div></td>'');',
'   htp.p(''<td><div id="my_rchart_d'' || to_char(l_year - 4) || ''"></div></td></tr></table>'');',
'   htp.p(''</center></td></tr></table>'');',
'                      ',
'   -- Create chart objects with JavaScript ',
'',
'   htp.p(''<script type="text/javascript" language="javascript">'');',
'   FOR c IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P7_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'      htp.p(''',
'        var c_'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "250";   ',
'        } ',
'        with(c_'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_'' || c.yr || ''.write("my_rchart_'' || c.yr || ''"); '');',
'',
'      htp.p(''',
'        var c_d'' || c.yr || '' = new AnyChart("'' || l_image_prefix || ''flashchart/anychart_6/swf/OracleAnyChart.swf"); ',
'        with(c_d'' || c.yr || '') {     ',
'            width = "300";     ',
'            height = "200";   ',
'        } ',
'        with(c_d'' || c.yr || ''.messages) {     ',
'            init = "Initializing..."; ',
'            loadingXML = "Loading data...";     ',
'            loadingResources = "Loading resources..."; ',
'            loadingTemplates = "Loading templates...";     ',
'            noData = "No data found."; ',
'            waitingForData = "Loading data. Please wait.";   ',
'        } ',
'        c_d'' || c.yr || ''.write("my_rchart_d'' || c.yr || ''"); '');',
'   END LOOP;',
'   htp.p(''</script>'');',
'   ',
'   -- Create JavaScript function to generate the chart data XML and load it',
'',
'   htp.p(''<script type="text/javascript" language="javascript">',
'      function updateChartData() { '');       ',
'',
'   FOR yr IN (',
'',
'      select yr,',
'             rownum as idx',
'        from ( select a.column_value as yr',
'                 from table(pkg_dynamic_list.get_years(:P7_X_YEAR,5)) a',
'                order by yr desc )',
'',
'   )',
'   LOOP',
'',
'       FOR c IN (',
'',
'          select st.state_name,',
'                 nvl(x.total_count,0) as val,',
'                 nvl(z.avg_5_yr,1) as max1,',
'                 nvl(z.avg_5_yr,0) as max0,                 ',
'                 nvl(x.biological_count,0) as bcnt,',
'                 nvl(x.habitat_count,0) as hcnt,',
'                 nvl(x.regular_count,0) as rcnt',
'            from di_geo_state st,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_gen_geo_state, ',
'                          avg(result_count) as avg_5_yr,',
'                          avg(regular_count) as avg_5_yr_reg,',
'                          avg(habitat_count) as avg_5_yr_hab,',
'                          avg(biological_count) as avg_5_yr_bio                ',
'                     from state_year a, table(pkg_dynamic_list.get_years(yr.yr - 1,5)) dt                ',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'                    group by fk_gen_geo_state ) z,',
'                 ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                          fk_gen_geo_state,',
'                          biological_count,',
'                          habitat_count,',
'                          regular_count,',
'                          result_count as total_count,',
'                          dt.column_value as activity_year',
'                     from state_year a,',
'                          table(pkg_dynamic_list.get_years(yr.yr,1)) dt',
'                    where dt.column_value = a.act_start_year_date',
'                      and fk_gen_geo_state = :P7_X_GEN_GEO_STATE ) x',
'           where st.pk_isn = z.fk_gen_geo_state (+)',
'             and st.pk_isn = x.fk_gen_geo_state (+)',
'             and st.country_code = ''US''',
'             and st.pk_isn = :P7_X_GEN_GEO_STATE',
'',
'       )',
'       LOOP',
'',
'          IF c.max1 > c.val THEN',
'             l_max := c.max1;',
'          ELSE',
'             l_max := c.val;',
'          END IF;   ',
'',
'          l_chart_scale := l_max / 4000;',
'          l_chart_value := c.val / 1000;',
'          l_chart_max := l_max / 1000;',
'          l_chart_pa := l_max / 3000;',
'          l_chart_ag := 2 * l_max / 3000;',
'          l_chart_title := c.state_name; ',
'          l_chart_plabel := ''In '' || yr.yr || '': '' || trim(to_char(c.val,''999,999,999,999'')) || '' records'';',
'          l_chart_label := ''5 yr avg: '' || trim(to_char(round(c.max0),''999,999,999,999'')) || ''/yr'';',
'',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="true"/><no_data show_waiting_animation="False"><label><text>No data submitted.</text><font family="Verdana" bold="yes" size="10"/><'
||'/label></no_data></settings><gauges><gauge><chart_settings><title enabled="True" position="Top" padding="0"><font family="Verdana" bold="True" size="10"/><text>''',
'            || l_chart_title ||',
'            ''</text><actions><action type="NavigateToURL" url="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_YEAR,P9_X_ORG_TYPE,P9_X_REPORT_TYPE,P9_X_PROGRAM_AREA:'' || :P7_X_GEN_GEO_STATE || '','' || yr.yr ||',
''',-1,CHARTS,-1" target="_self"/></actions></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false" /><corners type="Square" /></chart_background><data_plot_background /></chart_settings><circular><axis radiu'
||'s="37" start_angle="85" sweep_angle="190" size="3"><labels align="Outside" padding="6"><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.}k]]></format></labels><scale minimum="0" maximum="'' ',
'            || l_chart_max || ',
'            ''" major_interval="'' ',
'            || l_chart_scale || ',
'            ''"/><scale_bar><fill color="#292929"/></scale_bar><major_tickmark align="Center" length="10" padding="0"/><minor_tickmark enabled="false"/><color_ranges><color_range start="0" end="'' ',
'            || l_chart_pa || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#B9E2F4"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_pa || ',
'            ''" end="'' ',
'            || l_chart_ag || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#63A9D5"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range><color_range start="'' ',
'            || l_chart_ag || ',
'            ''" end="'' ',
'            || l_chart_max || ',
'            ''" align="Inside" start_size="60" end_size="60" padding="6" color="#4E77A7"><border enabled="true" color="Black" opacity="0.4"/><label enabled="true" align="Inside" padding="34"><format><![CDATA[]]></format><position valign="Center" halig'
||'n="Center"/><font family="Verdana" bold="True" size="10"/></label><fill opacity="0.6"/></color_range></color_ranges></axis><frame><inner_stroke enabled="false"/><outer_stroke enabled="false"/><background><fill type="Gradient"><gradient angle="45"><ke'
||'y color="#FDFDFD"/><key color="#F7F3F4"/></gradient></fill><border enabled="false"/></background><effects enabled="false"/></frame><pointers><pointer value="'' ',
'            || l_chart_value || ',
'            ''"><label enabled="true"><position placement_mode="ByPoint" x="50" y="120"/><format><![CDATA['' ',
'            || l_chart_plabel || ',
'            '']]></format><background enabled="false"/></label><actions><action type="NavigateToURL" url="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_YEAR,P9_X_ORG_TYPE,P9_X_REPORT_TYPE,P9_X_PROGRAM_AREA:'' || :P7_X_GEN_GEO_STATE || '','' || yr.'
||'yr ||',
''',-1,CHARTS,-1" target="_self"/></actions><needle_pointer_style thickness="7" point_thickness="5" point_radius="3"><fill color="Rgb(230,230,230)"/><border color="Black" opacity="0.7"/><effects enabled="true"><bevel enabled="true" distance="2" shadow_'
||'opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1" blur_x="1" blur_y="1" opacity="0.4"/></effects><cap><background><fill type="Gradient"><gradient type="Linear" angle="45"><key color="#D3D3D3"/><key color="#6F6F6F"/></gra'
||'dient></fill><border color="Black" opacity="0.9"/></background><effects enabled="true"><bevel enabled="true" distance="2" shadow_opacity="0.6" highlight_opacity="0.6"/><drop_shadow enabled="true" distance="1.5" blur_x="2" blur_y="2" opacity="0.4"/></'
||'effects></cap></needle_pointer_style><animation enabled="true" start_time="0" duration="0.5" interpolation_type="Bounce"/></pointer></pointers><labels><label enabled="true"><position placement_mode="ByPoint" x="50" y="130"/><format><![CDATA['' ',
'            || l_chart_label || ',
'            '']]></format><background enabled="false"/></label></labels></circular></gauge></gauges></anychart>''; ',
'',
'          htp.p(''',
'            c_'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'            ',
'          l_XML := ''<?xml version = "1.0" encoding="utf-8" standalone = "yes"?><anychart><settings><animation enabled="false"/><no_data show_waiting_animation="False"><label><text>No data for ''',
'            || yr.yr || ''.</text><font family="Verdana" bold="yes" size="10"/></label></no_data></settings><margin left="0" top="0" right="0" bottom="0" /><charts><chart plot_type="CategorizedHorizontal"><chart_settings><title enabled="True"><text>''',
'            || yr.yr || ''</text></title><chart_background><fill type="Solid" color="0xffffff" opacity="0" /><border enabled="false"/><corners type="Square"/></chart_background><data_plot_background></data_plot_background><axes><y_axis position="Oppos'
||'ite"><scale mode="Normal" /><title enabled="false" /><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><m'
||'ajor_grid enabled="False"/><minor_grid enabled="False"/></y_axis><x_axis><scale  mode="Normal"    /><title enabled="false"/><labels enabled="true" position="Outside"><font family="Tahoma" size="10" color="0x000000" /><format><![CDATA[{%Value}{numDeci'
||'mals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format></labels><major_grid enabled="False"/><minor_grid enabled="False"/></x_axis></axes></chart_settings><data_plot_settings enable_3d_mode="false" ><bar_series style="Default"><tooltip_settings '
||'enabled="true"><format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><font family="Tahoma" size="10" color="0x000000" /><position anchor="Float" valign="Top" padding="10" /></tooltip_set'
||'tings><label_settings enabled="true" mode="Outside" multi_line_align="Left"><position anchor="CenterBottom" padding="5" /><format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format><background enabled="false"/><font '
||'family="Tahoma" size="10" color="0x000000" /></label_settings><bar_style></bar_style><marker_settings enabled="True"><marker type="None" /></marker_settings></bar_series></data_plot_settings>'';',
'',
'          if c.hcnt > 0 or c.rcnt >0 or c.bcnt > 0 then',
'          ',
'             l_XML := l_XML ',
'                || ''<data><series><point name="Biological" y="''',
'                || c.bcnt || ''" color="0xB9E2F4" /><point name="Habitat" y="''',
'                || c.hcnt || ''" color="0xB9E2F4" /><point name="Physical/Chemical" y="''',
'                || c.rcnt || ''" color="0xB9E2F4" /></series></data>'';',
'          ',
'          end if;',
'                             ',
'          l_XML := l_XML || ''</chart></charts></anychart>'';',
'  ',
'          htp.p(''',
'            c_d'' || yr.yr || ''.setData('''''' || l_XML || ''''''); '');',
'',
'       END LOOP;',
'   ',
'   END LOOP;',
'   ',
'   htp.p(''',
'        }',
'    </script>'');',
'',
'END;',
''))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342893962059787510)
,p_plug_name=>'Before Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" border="0">',
'<tr>',
'<td>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342894171409790153)
,p_plug_name=>'After Profile Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'</td>',
'<td width="450" align="right">',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;To query and download the submitted data, please visit the',
'<br>',
'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.epa.gov/storet/dw_home.html" target="_blank">STORET/WQX Warehouse Reports</a>',
'</td>',
'</tr>',
'</table>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P7_X_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342789586775586766)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1342788963629586765)
,p_button_name=>'P7_GO'
,p_button_static_id=>'P7_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342789162039586766)
,p_name=>'P7_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342788963629586765)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342789369017586766)
,p_name=>'P7_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1342788963629586765)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342789770525586766)
,p_name=>'P7_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(1342788963629586765)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342789980716586766)
,p_name=>'P7_X_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342788963629586765)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
' select st.state_name,',
'        st.pk_isn',
'   from di_geo_state st',
'  where country_code = ''US''',
'    and epa_region_code is not null',
'  order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342802972544854452)
,p_name=>'P7_0_LABEL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Number of Organizations Submitting Data for &P7_X_STATE_NAME. in &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342803158259854453)
,p_name=>'P7_0_VAL'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:9:&SESSION.:::9:P9_X_GEN_GEO_STATE,P9_X_ORG_TYPE,P9_X_YEAR:&P7_X_GEN_GEO_STATE.,-1,&P7_X_YEAR.">'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</a></strong>''',
'  from state_org_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for Data Owners Contribution for &P7_X_STATE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342803368443854453)
,p_name=>'P7_1_LABEL'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Total Number of Organizations Submitting Data for &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342803590635854453)
,p_name=>'P7_1_VAL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_org),''999,999,999,999'')) || ''</strong>''',
'  from state_org_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342803771101854453)
,p_name=>'P7_2_LABEL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Number of Stations in &P7_X_STATE_NAME. with Data for &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342803970920854453)
,p_name=>'P7_2_VAL'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from station_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342804161974854453)
,p_name=>'P7_3_LABEL'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Total Number of Stations in &P7_X_STATE_NAME. with Data:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342804369821854453)
,p_name=>'P7_3_VAL'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_fa_statn),''999,999,999,999'')) || ''</strong>''',
'  from station_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342804590318854453)
,p_name=>'P7_4_LABEL'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Total Number of Stations in &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342804772193854453)
,p_name=>'P7_4_VAL'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct pk_isn),''999,999,999,999'')) || ''</strong>''',
'  from fa_station',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342807059525935896)
,p_name=>'P7_5_LABEL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Number of Distinct Characteristics Submitted for &P7_X_STATE_NAME. in &P7_X_YEAR.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342807279319935898)
,p_name=>'P7_5_VAL'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong><a href="f?p=&APP_ID.:10:&SESSION.:::10:P10_FK_GEN_GEO_STATE,P10_X_YEAR:&P7_X_GEN_GEO_STATE.,&P7_X_YEAR.">'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</a></strong>''',
'  from state_char_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE',
'   and act_start_year_date = :P7_X_YEAR'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_tag_attributes=>'onmouseover="toolTip_enable(event,this,''Click here for the Top 10 Substances for &P7_X_STATE_NAME.'')"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342807487276935898)
,p_name=>'P7_6_LABEL'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_prompt=>'Total Number of Distinct Characteristics Submitted for &P7_X_STATE_NAME.:&nbsp;&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342807666905935898)
,p_name=>'P7_6_VAL'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(1342801385872820497)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select ''<strong>'' || trim(to_char(count(distinct fk_char),''999,999,999,999'')) || ''</strong>''',
'  from state_char_year',
' where fk_gen_geo_state = :P7_X_GEN_GEO_STATE'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'RIGHT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_escape_on_http_output=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342794374960586787)
,p_computation_sequence=>10
,p_computation_item=>'P7_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P7_X_GEN_GEO_STATE'))
,p_compute_when=>'P7_X_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342819874219151330)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 8 - bitand(nvl(:F102_X_BREADCRUMB,1),8),15)'
);
end;
/
prompt --application/pages/page_00009
begin
wwv_flow_api.create_page(
 p_id=>9
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Data Owners Contribution'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Data Owners Contribution'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130607072735'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342709661729360868)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) = 0'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342710088787397077)
,p_plug_name=>'2012'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342710258971397089)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1379900927779032'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V::None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>'200:::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
,p_legend_title=>'2012 Top 5'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL1. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR1. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'      #DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342710375616397145)
,p_chart_id=>wwv_flow_api.id(1342710258971397089)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342711185725850436)
,p_plug_name=>'2011'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342711364422850438)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2011'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381006379232381'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL2. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR2. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342711482389850440)
,p_chart_id=>wwv_flow_api.id(1342711364422850438)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR2,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342711759584880733)
,p_plug_name=>'2010'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342711964613880735)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2010'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381606570262678'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL3. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR3. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342712060938880736)
,p_chart_id=>wwv_flow_api.id(1342711964613880735)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR3,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342712278069895510)
,p_plug_name=>'2009'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>4
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342712465464895513)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382107421277456'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL4. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR4. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342712561383895513)
,p_chart_id=>wwv_flow_api.id(1342712465464895513)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR4,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342712660885900053)
,p_plug_name=>'2008'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>5
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342712888527900058)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382530484282001'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P9_X_TOTAL5. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P9_X_YEAR5. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342712958198900061)
,p_chart_id=>wwv_flow_api.id(1342712888527900058)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR5,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'            and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_ORG_TYPE ) ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342716061447240868)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the top five organizations within a state and/or organization type which submitted data to STORET, listed by the selected year, over the last five years. The records represent the data available in STORET on measurements of w'
||'ater quality as reported by ALL current organizations, including state, local, and tribal agencies and watershed groups. Data can represent biological, chemical, physical, habitat and continuous monitoring data.</p>',
'<p>Select a year, a State, an Organization Type, Program Area, and a Display Type using the dropdown menus.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342733985152303079)
,p_plug_name=>'Organization Selection'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>61
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p>To view more details, use the pull down menu and select a single organization by name  to display Biological (fish, algae), Habitat (bank stability), and Physical/Chemical (pH, Temperature, metals).</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342743072164906573)
,p_plug_name=>'Organization Details Charts Line 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>71
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342739061601996521)
,p_plug_name=>'Organization Details Year 1'
,p_region_name=>'OrgDetailsChartYear1'
,p_parent_plug_id=>wwv_flow_api.id(1342743072164906573)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>81
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear1(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>',
''))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342739283689996523)
,p_default_chart_type=>'Horizontal2DColumn'
,p_chart_title=>'&P9_X_YEAR1.'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1408925646378466'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR1.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR1_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342739361676996527)
,p_chart_id=>wwv_flow_api.id(1342739283689996523)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR1',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342741960362676068)
,p_plug_name=>'Organization Details Year 2'
,p_region_name=>'OrgDetailsChartYear2'
,p_parent_plug_id=>wwv_flow_api.id(1342743072164906573)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>151
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear2(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342742160436676073)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1411802393058016'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR2.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR2_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342742276304676073)
,p_chart_id=>wwv_flow_api.id(1342742160436676073)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR2',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342742580560890081)
,p_plug_name=>'Organization Details Year 3'
,p_region_name=>'OrgDetailsChartYear3'
,p_parent_plug_id=>wwv_flow_api.id(1342743072164906573)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>161
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear3(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
end;
/
begin
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342742790443890081)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1412432400272024'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR3.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR3_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342742866800890081)
,p_chart_id=>wwv_flow_api.id(1342742790443890081)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR3',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342746073212400908)
,p_plug_name=>'Organization Detail Charts Line 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>181
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342746371266409787)
,p_plug_name=>'Organization Details Year 4'
,p_region_name=>'OrgDetailsChartYear4'
,p_parent_plug_id=>wwv_flow_api.id(1342746073212400908)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>191
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear4(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342746571749409794)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416213705791737'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR4.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR4_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342746670258409795)
,p_chart_id=>wwv_flow_api.id(1342746571749409794)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR4',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342746871181428695)
,p_plug_name=>'Organization Details Year 5'
,p_region_name=>'OrgDetailsChartYear5'
,p_parent_plug_id=>wwv_flow_api.id(1342746073212400908)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>201
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear5(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1342747063757428699)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416705713810642'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P9_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P9_X_YEAR5.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P9_X_YEAR5_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1342747189646428699)
,p_chart_id=>wwv_flow_api.id(1342747063757428699)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P9_X_FK_ORG',
'   and act_start_year_date = :P9_X_YEAR5',
'   and (:P9_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P9_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342748368776579339)
,p_plug_name=>'State Top Organization Charts'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342750084406612240)
,p_plug_name=>'State Charts End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>211
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''CHARTS'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342751172116646628)
,p_plug_name=>'Organization Details End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>221
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'(:P9_X_GEN_GEO_STATE <> -1 OR :P9_X_ORG_TYPE <> -1) AND :P9_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342828288089374892)
,p_plug_name=>'Breadcrumb2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342821980583230815)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) > 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342828460515376408)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342822084046231829)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342828665710377886)
,p_plug_name=>'Breadcrumb4'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342822186816232588)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342860182365021051)
,p_plug_name=>'Data Owners Contribution'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>231
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select a.organization_id,',
'       b.organization_name,',
'       sum(a.biological_count) as biological_count,',
'       sum(a.habitat_count) as habitat_count,',
'       sum(a.regular_count) as regular_count,',
'       dt.column_value,',
'       sum(a.result_count) as result_count,',
'       round(ratio_to_report(sum(result_count)) over (partition by dt.column_value) * 100,2) as perc,',
'       count(distinct fk_fa_statn) as station_count',
'  from station_year a, di_org b, table(pkg_dynamic_list.get_years(:P9_X_YEAR,5)) dt                ',
' where dt.column_value = a.act_start_year_date',
'   and a.fk_org = b.pk_isn',
'   and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'   and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                    from lu_orgtype',
'                                                   where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'   and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                from lu_orgtype',
'                                               where fk_org_type = :P9_X_ORG_TYPE ) )',
' group by a.organization_id, b.organization_name, dt.column_value'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL  AND :P9_X_REPORT_TYPE = ''TABLE'' AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1342860283993021051)
,p_name=>'Data Owners Contribution'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_sort_asc_image=>'arrow_up_gray_light.gif'
,p_sort_asc_image_attr=>' width="13" height="12" '
,p_sort_desc_image=>'arrow_down_gray_light.gif'
,p_sort_desc_image_attr=>' width="13" height="12" '
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'TOP_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342861680914190986)
,p_db_column_name=>'ORGANIZATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Organization Id'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_ID'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342861778034190988)
,p_db_column_name=>'BIOLOGICAL_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Biological'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'BIOLOGICAL_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342861890463190989)
,p_db_column_name=>'HABITAT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Habitat'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'HABITAT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342861986153190989)
,p_db_column_name=>'REGULAR_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Physical/Chemical'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'REGULAR_COUNT'
);
end;
/
begin
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342862076179190989)
,p_db_column_name=>'COLUMN_VALUE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'COLUMN_VALUE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342862175973190989)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Total'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342862389591190990)
,p_db_column_name=>'PERC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Percentage'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'PERC'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343510862607772451)
,p_db_column_name=>'STATION_COUNT'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Stations'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATION_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1346648356468811782)
,p_db_column_name=>'ORGANIZATION_NAME'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Organization Name'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_NAME'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(1342860983058021336)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'15307'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'ORGANIZATION_ID:ORGANIZATION_NAME:STATION_COUNT:BIOLOGICAL_COUNT:HABITAT_COUNT:REGULAR_COUNT:COLUMN_VALUE:RESULT_COUNT:PERC:'
,p_sort_column_1=>'COLUMN_VALUE'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'PERC'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'RESULT_COUNT'
,p_sort_direction_3=>'DESC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_break_enabled_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342736778890801224)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1342733985152303079)
,p_button_name=>'P9_REFRESH'
,p_button_static_id=>'P9_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT-CENTER'
,p_grid_column_attributes=>'valign="top"'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342733189317029833)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_button_name=>'P9_GO'
,p_button_static_id=>'P9_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342713365331147346)
,p_name=>'P9_X_YEAR1'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342710088787397077)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342713689226154231)
,p_name=>'P9_X_YEAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342711185725850436)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 1'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342713863384156225)
,p_name=>'P9_X_YEAR3'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1342711759584880733)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 2'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342714069618158030)
,p_name=>'P9_X_YEAR4'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1342712278069895510)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 3'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342714277929160508)
,p_name=>'P9_X_YEAR5'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1342712660885900053)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 4'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342716478762245814)
,p_name=>'P9_X_GEN_GEO_STATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'          select st.state_name,',
'                 st.pk_isn',
'            from di_geo_state st',
'           where country_code = ''US''',
'             and epa_region_code is not null',
'           order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL STATES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342717290321258664)
,p_name=>'P9_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342733077196026377)
,p_name=>'P9_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342734371262346352)
,p_name=>'P9_X_FK_ORG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342733985152303079)
,p_prompt=>'<strong>Select Organization:</strong>&nbsp;&nbsp;'
,p_post_element_text=>'&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select distinct c.organization_id || '' - '' || c.organization_name as org_name,',
'       c.pk_isn as org_id',
'  from state_org_year a, di_org c',
' where ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'   and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                from lu_orgtype',
'                                               where fk_org_type = :P9_X_ORG_TYPE ) )',
'            and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'   and a.act_start_year_date between to_number(:P9_X_YEAR5) and to_number(:P9_X_YEAR1)',
'   and a.fk_org = c.pk_isn ',
' order by 1 '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342776080541564818)
,p_name=>'P9_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342777090798258561)
,p_name=>'P9_X_TOTAL1'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(1342710088787397077)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342777262879259944)
,p_name=>'P9_X_TOTAL2'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(1342711185725850436)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342777468420261571)
,p_name=>'P9_X_TOTAL3'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(1342711759584880733)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342777673614263071)
,p_name=>'P9_X_TOTAL4'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(1342712278069895510)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342777878116264351)
,p_name=>'P9_X_TOTAL5'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(1342712660885900053)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342857380352850179)
,p_name=>'P9_X_REPORT_TYPE'
,p_is_required=>true
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'<strong>Select Display Type:</strong>&nbsp;&nbsp;'
,p_source=>'CHARTS'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Top 5 Organizations Charts;CHARTS,All Organizations Table;TABLE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342884464412781328)
,p_name=>'P9_X_ORG_TYPE'
,p_item_sequence=>12
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'<strong>Select Organization Type:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn < 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL TYPES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(1344890112294155113)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343435966276643561)
,p_name=>'P9_X_PROGRAM_AREA'
,p_item_sequence=>14
,p_item_plug_id=>wwv_flow_api.id(1342716061447240868)
,p_prompt=>'<strong>Select Program Area:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn >= 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL AREAS -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(1344890112294155113)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343511775256389518)
,p_name=>'P9_X_YEAR1_ST'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(1342739061601996521)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343511971374391342)
,p_name=>'P9_X_YEAR2_ST'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(1342741960362676068)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343512167493393177)
,p_name=>'P9_X_YEAR3_ST'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(1342742580560890081)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343512363395395073)
,p_name=>'P9_X_YEAR4_ST'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(1342746371266409787)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343512560591396386)
,p_name=>'P9_X_YEAR5_ST'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(1342746871181428695)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342715076506207375)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR1'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342715286203210157)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR2'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 1'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342715490012211272)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR3'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342715661746212528)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR4'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 3'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342715866248213856)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_YEAR5'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P9_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 4'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342717666688270743)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P9_X_GEN_GEO_STATE'))
,p_compute_when=>':P9_X_GEN_GEO_STATE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342740765898433019)
,p_computation_sequence=>10
,p_computation_item=>'P9_X_FK_ORG'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342820063268157626)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 16 - bitand(nvl(:F102_X_BREADCRUMB,1),16),31)'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1342737775865830334)
,p_name=>'Refresh Organization Details'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(1342736778890801224)
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1342738484747899154)
,p_event_id=>wwv_flow_api.id(1342737775865830334)
,p_event_result=>'TRUE'
,p_action_sequence=>5
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P9_X_FK_ORG',
'        and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'end;'))
,p_attribute_02=>'P9_X_FK_ORG'
,p_stop_execution_on_error=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1343433867751624813)
,p_event_id=>wwv_flow_api.id(1342737775865830334)
,p_event_result=>'TRUE'
,p_action_sequence=>15
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex.jQuery( "#OrgDetailsChartYear1_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear2_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear3_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear4_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear5_chart" ).trigger( "apexrefresh" );'))
,p_stop_execution_on_error=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1342777968897271222)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Totals'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'   for c in (',
'      select trim(to_char(sum(a.result_count),''999,999,999,999'')) as total_count,',
'             a.act_start_year_date as year_no',
'        from state_org_year a                ',
'       where a.act_start_year_date in (:P9_X_YEAR1, :P9_X_YEAR2, :P9_X_YEAR3, :P9_X_YEAR4, :P9_X_YEAR5)',
'         and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'         and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                      from lu_orgtype',
'                                                     where fk_org_type = :P9_X_ORG_TYPE ) )',
'         and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                          from lu_orgtype',
'                                                         where fk_org_type = :P9_X_PROGRAM_AREA ) )',
'       group by a.act_start_year_date',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_TOTAL1 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_TOTAL2 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_TOTAL3 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_TOTAL4 := c.total_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_TOTAL5 := c.total_count;',
'     end if;',
'  end loop;',
'',
'  for c in (',
'     select fk_org',
'       from ( select a.fk_org,',
'                     dense_rank() over (order by act_start_year_date desc, result_count desc) as rnk',
'                from state_org_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'               where dt.column_value = a.act_start_year_date',
'                 and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )  ',
'                 and ( :P9_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                              from lu_orgtype',
'                                                             where fk_org_type = :P9_X_PROGRAM_AREA ) ) ',
'                 and ( :P9_X_ORG_TYPE = -1 or a.fk_org in ( select fk_org',
'                                                              from lu_orgtype',
'                                                             where fk_org_type = :P9_X_ORG_TYPE ) ) )',
'      where rnk = 1',
'  )',
'  loop',
'',
'     :P9_X_FK_ORG := c.fk_org;',
'',
'  end loop;',
'',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P9_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P9_X_FK_ORG',
'        and ( :P9_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P9_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P9_X_YEAR1 then',
'        :P9_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR2 then',
'        :P9_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR3 then',
'        :P9_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR4 then',
'        :P9_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P9_X_YEAR5 then',
'        :P9_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'',
'end;'))
,p_process_when=>':P9_X_GEN_GEO_STATE IS NOT NULL AND :P9_X_ORG_TYPE IS NOT NULL AND :P9_X_PROGRAM_AREA IS NOT NULL'
,p_process_when_type=>'SQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_api.create_page(
 p_id=>10
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_page_mode=>'NORMAL'
,p_step_title=>'Dashboard: Top 10 Substances for Past 5 Years By State'
,p_step_sub_title=>'Top 10 Substances for Past 5 Years By State'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_help_text=>'No help is available for this page.'
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130529120650'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342718970681286519)
,p_plug_name=>'Top 10 Substances for Past 5 Years for &P10_X_SELECTED_STATE.'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1344882219587709275)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select activity_year,',
'       substance,',
'       result_count',
'  from ( select /*+ DYNAMIC_SAMPLING(dt 5) */',
'                display_name as substance,',
'                regular_count as result_count,',
'                dt.column_value as activity_year,',
'                dense_rank() over (partition by dt.column_value order by regular_count desc) as rnk',
'           from state_char_year a,',
'                table(pkg_dynamic_list.get_years(:P10_X_YEAR,5)) dt',
'          where dt.column_value = A.ACT_START_YEAR_DATE (+)',
'            and a.fk_gen_geo_state (+) = :P10_FK_GEN_GEO_STATE )',
' where rnk <= 10           ',
' order by activity_year desc, result_count desc;'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P10_FK_GEN_GEO_STATE'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1342719160342286535)
,p_name=>'Top 10 Substances for Past 5 Years By State'
,p_max_row_count=>'10000'
,p_max_row_count_message=>'This query returns more than 10,000 rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>1
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342719271537286555)
,p_db_column_name=>'ACTIVITY_YEAR'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Activity Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ACTIVITY_YEAR'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342719359761286563)
,p_db_column_name=>'SUBSTANCE'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Substance'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'SUBSTANCE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1342719462598286563)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Result Count'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(1342719571223286564)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'13893'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>10000
,p_report_columns=>'ACTIVITY_YEAR:SUBSTANCE:RESULT_COUNT'
,p_sort_column_1=>'ACTIVITY_YEAR'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'RESULT_COUNT'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'SUBSTANCE'
,p_sort_direction_3=>'ASC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_break_enabled_on=>'ACTIVITY_YEAR:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342720081515286576)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>These tables provide a count of the  top ten substances within a state�s waters, listed by year, over the last five years. The records represent the data available in STORET on measurements of water quality as reported by ALL current organizations'
||', including state, local, and tribal agencies and watershed groups.</p>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342721483604286585)
,p_plug_name=>'Top 10 Substances for Past 5 Years By State'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342722786155300312)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) = 0'
,p_plug_display_when_cond2=>'1'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342829280517401169)
,p_plug_name=>'Breadcrumb2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342821980583230815)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) > 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342829485712402607)
,p_plug_name=>'Breadcrumb3'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342822084046231829)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) > 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342829690560404014)
,p_plug_name=>'Breadcrumb4'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1342822186816232588)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>'bitand(:F102_X_BREADCRUMB,2) = 0 AND bitand(:F102_X_BREADCRUMB,4) = 0 AND bitand(:F102_X_BREADCRUMB,8) > 0'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342720262844286578)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(1342720081515286576)
,p_button_name=>'P10_GO'
,p_button_static_id=>'P10_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'Go'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342720477150286581)
,p_name=>'P10_FK_GEN_GEO_STATE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342720081515286576)
,p_prompt=>'<Strong>Select State:</Strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name,',
'       pk_isn ',
'  from di_geo_state',
' where country_code = ''US''',
'   and epa_region_code is not null',
' order by state_name'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'-SELECT-'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342720667677286582)
,p_name=>'P10_1_0'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342720081515286576)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342720859762286582)
,p_name=>'P10_X_SELECTED_STATE'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(1342720081515286576)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342830386460506904)
,p_name=>'P10_X_YEAR'
,p_is_required=>true
,p_item_sequence=>5
,p_item_plug_id=>wwv_flow_api.id(1342720081515286576)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342722083793286617)
,p_computation_sequence=>10
,p_computation_item=>'P10_X_SELECTED_STATE'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P10_FK_GEN_GEO_STATE'))
,p_compute_when=>'P10_FK_GEN_GEO_STATE'
,p_compute_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1342820272272160261)
,p_computation_sequence=>20
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 32 - bitand(nvl(:F102_X_BREADCRUMB,1),32),63)'
);
end;
/
prompt --application/pages/page_00012
begin
wwv_flow_api.create_page(
 p_id=>12
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Data Owners Contribution by Tribes'
,p_page_mode=>'NORMAL'
,p_step_title=>'Data Owners Contribution by Tribes'
,p_step_sub_title=>'Data Owners Contribution by Tribes'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'NO_FIRST_ITEM'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20130607072528'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343441569776008880)
,p_plug_name=>'2011'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343441788510008925)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2011'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381006379232381'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL2. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR2. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343441860701009004)
,p_chart_id=>wwv_flow_api.id(1343441788510008925)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR2,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343442363608009080)
,p_plug_name=>'2010'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343442586547009081)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2010'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1381606570262678'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL3. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR3. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343442678411009088)
,p_chart_id=>wwv_flow_api.id(1343442586547009081)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR3,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343443188919009094)
,p_plug_name=>'State Top Organization Charts'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows=>15
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343443359548009100)
,p_plug_name=>'Organization Detail Charts Line 2'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>181
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343443590167009104)
,p_plug_name=>'Organization Details Year 5'
,p_region_name=>'OrgDetailsChartYear5'
,p_parent_plug_id=>wwv_flow_api.id(1343443359548009100)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>201
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear5(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343443772991009104)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416705713810642'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR5.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR5_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343443866114009106)
,p_chart_id=>wwv_flow_api.id(1343443772991009104)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR5',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343443965984009106)
,p_plug_name=>'Organization Details Year 4'
,p_region_name=>'OrgDetailsChartYear4'
,p_parent_plug_id=>wwv_flow_api.id(1343443359548009100)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>191
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear4(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343444169728009108)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1416213705791737'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR4.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR4_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>'))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343444287944009108)
,p_chart_id=>wwv_flow_api.id(1343444169728009108)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR4',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343444984314009122)
,p_plug_name=>'Organization Details End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>221
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE <> -1 AND :P12_X_REPORT_TYPE = ''CHARTS'''
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343445175799009123)
,p_plug_name=>'2009'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>4
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343445363857009123)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382107421277456'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR4..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL4. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR4. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343445479249009132)
,p_chart_id=>wwv_flow_api.id(1343445363857009123)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR4,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343445978757009143)
,p_plug_name=>'2008'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>5
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343446164061009144)
,p_default_chart_type=>'2DPie'
,p_chart_title=>'2009'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1382530484282001'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR5..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL5. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR5. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343446278231009150)
,p_chart_id=>wwv_flow_api.id(1343446164061009144)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR5,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343446762993009151)
,p_plug_name=>'Breadcrumb'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_06'
,p_plug_item_display_point=>'BELOW'
,p_menu_id=>wwv_flow_api.id(1344884213975709290)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_api.id(1344889815508150678)
,p_plug_query_row_template=>1
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343447284086009177)
,p_plug_name=>'Data Owners Contribution'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>231
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select a.organization_id,',
'       b.organization_name,',
'       sum(a.biological_count) as biological_count,',
'       sum(a.habitat_count) as habitat_count,',
'       sum(a.regular_count) as regular_count,',
'       dt.column_value,',
'       sum(a.result_count) as result_count,',
'       round(ratio_to_report(sum(result_count)) over (partition by dt.column_value) * 100,2) as perc,',
'       count(distinct fk_fa_statn) as station_count',
'  from station_year a, di_org b, table(pkg_dynamic_list.get_years(:P12_X_YEAR,5)) dt                ',
' where dt.column_value = a.act_start_year_date',
'   and a.fk_org = b.pk_isn',
'   and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'   and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                    from lu_orgtype',
'                                                   where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'   and a.fk_org in ( select fk_org',
'                       from lu_orgtype',
'                      where fk_org_type = 9 )',
'group by a.organization_id, b.organization_name, dt.column_value'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_row_template=>1
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''TABLE'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
);
wwv_flow_api.create_worksheet(
 p_id=>wwv_flow_api.id(1343447463307009187)
,p_name=>'Data Owners Contribution'
,p_max_row_count=>'100000'
,p_max_row_count_message=>'This query returns more than #MAX_ROW_COUNT# rows, please filter your data to ensure complete results.'
,p_no_data_found_message=>'No data found.'
,p_sort_asc_image=>'arrow_up_gray_light.gif'
,p_sort_asc_image_attr=>' width="13" height="12" '
,p_sort_desc_image=>'arrow_down_gray_light.gif'
,p_sort_desc_image_attr=>' width="13" height="12" '
,p_allow_report_categories=>'N'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'TOP_RIGHT'
,p_report_list_mode=>'TABS'
,p_fixed_header=>'NONE'
,p_show_detail_link=>'N'
,p_show_pivot=>'N'
,p_show_calendar=>'N'
,p_show_flashback=>'N'
,p_download_formats=>'CSV:HTML:EMAIL'
,p_allow_exclude_null_values=>'N'
,p_allow_hide_extra_columns=>'N'
,p_icon_view_columns_per_row=>1
,p_owner=>'DSPOREA'
,p_internal_uid=>2117105263391130
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343447570440009239)
,p_db_column_name=>'ORGANIZATION_ID'
,p_display_order=>1
,p_column_identifier=>'A'
,p_column_label=>'Organization Id'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_ID'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343447658148009269)
,p_db_column_name=>'BIOLOGICAL_COUNT'
,p_display_order=>2
,p_column_identifier=>'B'
,p_column_label=>'Biological'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'BIOLOGICAL_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343447783950009269)
,p_db_column_name=>'HABITAT_COUNT'
,p_display_order=>3
,p_column_identifier=>'C'
,p_column_label=>'Habitat'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'HABITAT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343447864154009269)
,p_db_column_name=>'REGULAR_COUNT'
,p_display_order=>4
,p_column_identifier=>'D'
,p_column_label=>'Physical/Chemical'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'REGULAR_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343447989707009269)
,p_db_column_name=>'COLUMN_VALUE'
,p_display_order=>5
,p_column_identifier=>'E'
,p_column_label=>'Year'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'COLUMN_VALUE'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343448084604009269)
,p_db_column_name=>'RESULT_COUNT'
,p_display_order=>6
,p_column_identifier=>'F'
,p_column_label=>'Total'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'RESULT_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343448172852009269)
,p_db_column_name=>'PERC'
,p_display_order=>8
,p_column_identifier=>'H'
,p_column_label=>'Percentage'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'PERC'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1343511090606805054)
,p_db_column_name=>'STATION_COUNT'
,p_display_order=>9
,p_column_identifier=>'I'
,p_column_label=>'Stations'
,p_allow_pivot=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_tz_dependent=>'N'
,p_static_id=>'STATION_COUNT'
);
wwv_flow_api.create_worksheet_column(
 p_id=>wwv_flow_api.id(1346648154971797312)
,p_db_column_name=>'ORGANIZATION_NAME'
,p_display_order=>10
,p_column_identifier=>'J'
,p_column_label=>'Organization Name'
,p_allow_pivot=>'N'
,p_column_type=>'STRING'
,p_tz_dependent=>'N'
,p_static_id=>'ORGANIZATION_NAME'
);
wwv_flow_api.create_worksheet_rpt(
 p_id=>wwv_flow_api.id(1343448289586009282)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'21180'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_display_rows=>15
,p_report_columns=>'ORGANIZATION_ID:ORGANIZATION_NAME:STATION_COUNT:BIOLOGICAL_COUNT:HABITAT_COUNT:REGULAR_COUNT:COLUMN_VALUE:RESULT_COUNT:PERC:'
,p_sort_column_1=>'COLUMN_VALUE'
,p_sort_direction_1=>'DESC'
,p_sort_column_2=>'PERC'
,p_sort_direction_2=>'DESC'
,p_sort_column_3=>'RESULT_COUNT'
,p_sort_direction_3=>'DESC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
,p_break_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_break_enabled_on=>'COLUMN_VALUE:0:0:0:0:0'
,p_flashback_enabled=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343448483409009301)
,p_plug_name=>'Search Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>5
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<p>These figures display the top five tribal organizations within a state which submitted data to STORET, listed by the selected year, over the last five years. The records represent the data available in STORET on measurements of water quality as re'
||'ported by tribal organizations only. Data can represent biological, chemical, physical, habitat and continuous monitoring data.</p>',
'<p>Select a year, a State, Program Area, and a Display Type using the dropdown menus.</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343450283223009344)
,p_plug_name=>'State Charts End Region'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>211
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'</center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343450477799009344)
,p_plug_name=>'Organization Selection'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>61
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<br>',
'<p>To view more details, use the pull down menu and select a single organization by name  to display Biological (fish, algae), Habitat (bank stability), and Physical/Chemical (pH, Temperature, metals).</p>'))
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343451065058009348)
,p_plug_name=>'2012'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343451267348009348)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1379900927779032'
,p_chart_width=>200
,p_chart_height=>400
,p_chart_animation=>'N'
,p_display_attr=>':H:::::Bottom::V::None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>'200:::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'6'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
,p_legend_title=>'2012 Top 5'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="Pie" name="chart_1379900927779032"> ',
'      <chart_settings>',
'        <title enabled="True">',
'           <text>&P12_X_TOTAL1. Total Records</text>',
'           <font family="Tahoma" size="10" color="0x000000" />',
'        </title>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'',
'        <legend enabled="true" position="Bottom" align="Center" elements_layout="Vertical" ignore_auto_item="True" height="180">',
'          <title enabled="true">',
'            <text>&P12_X_YEAR1. Top 5 Orgs</text>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </title>',
'          <icon>',
'            <marker enabled="true" />',
'          </icon>',
'          <background enabled="False"/>',
'          <items>',
'            <item source="Points" />',
'          </items>',
'          <font family="Tahoma" size="10" color="0x000000" />',
'          <format><![CDATA[{%Icon} {%Name}{numDecimals:0,decimalSeparator:,thousandsSeparator:} - {%YPercentOfSeries}{numDecimals:2,decimalSeparator:.,thousandsSeparator:\,}%]]></format>',
'        </legend>',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <pie_series style="Aqua">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="false"/>',
'          <pie_style>',
'',
'          </pie_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'          <connector color="Black" opacity="0.4"/>',
'        </pie_series>',
'      </data_plot_settings>',
'      #DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
end;
/
begin
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343451377384009352)
,p_chart_id=>wwv_flow_api.id(1343451267348009348)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'with topq as ',
'       ( select a.organization_id,',
'                sum(a.result_count) as result_count,',
'                dense_rank() over (partition by dt.column_value order by sum(result_count) desc) as rnk',
'           from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1,1)) dt                ',
'          where dt.column_value = a.act_start_year_date',
'            and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'            and a.fk_org in ( select fk_org',
'                                from lu_orgtype',
'                               where fk_org_type = 9 ) ',
'          group by a.organization_id, dt.column_value )',
'select link, ',
'       label, ',
'       value',
'  from ( select null link,',
'                organization_id label,',
'                result_count value',
'           from topq',
'          where rnk <= 5',
'          union',
'         select null link,',
'                ''All others'' label,',
'                sum(result_count) value',
'           from topq',
'          where rnk > 5 )',
'  where value > 0',
'  order by 3 desc; '))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343451885295009356)
,p_plug_name=>'Organization Details Charts Line 1'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>71
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<center>'
,p_plug_query_row_template=>1
,p_plug_query_headings_type=>'QUERY_COLUMNS'
,p_plug_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_plug_query_show_nulls_as=>' - '
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343452075495009357)
,p_plug_name=>'Organization Details Year 1'
,p_region_name=>'OrgDetailsChartYear1'
,p_parent_plug_id=>wwv_flow_api.id(1343451885295009356)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>81
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid=>true
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear1(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>',
''))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343452276821009357)
,p_default_chart_type=>'Horizontal2DColumn'
,p_chart_title=>'&P12_X_YEAR1.'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1408925646378466'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:N:N:N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'Tahoma:10:#000000'
,p_y_axis_label_font=>'Tahoma:10:#000000'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:#000000'
,p_y_axis_title_font=>'Tahoma:14:#000000'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR1..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR1.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR1_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343452386654009357)
,p_chart_id=>wwv_flow_api.id(1343452276821009357)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR1',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label'))
,p_series_type=>'Bar'
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343452489866009358)
,p_plug_name=>'Organization Details Year 2'
,p_region_name=>'OrgDetailsChartYear2'
,p_parent_plug_id=>wwv_flow_api.id(1343451885295009356)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>151
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear2(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343452670545009358)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1411802393058016'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR2..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR2.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR2_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343452789226009358)
,p_chart_id=>wwv_flow_api.id(1343452670545009358)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR2',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1343452870320009358)
,p_plug_name=>'Organization Details Year 3'
,p_region_name=>'OrgDetailsChartYear3'
,p_parent_plug_id=>wwv_flow_api.id(1343451885295009356)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>161
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>3
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"',
'    codebase="#HOST_PROTOCOL#://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0"',
'    width="#WIDTH#"',
'    height="#HEIGHT#"',
'    id="#CHART_NAME#"',
'    align="top">',
'<param name="movie" value="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#">',
'<param name="quality" value="high">',
'<param name="allowScriptAccess" value="sameDomain">',
'<param name="allowNetworking" value="all">',
'<param name="scale" value="noscale">',
'<param name="wmode" value="transparent">',
'<param name="FlashVars" value="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'',
'<embed src="#IMAGE_PREFIX#flashchart/anychart_5/swf/#CHART_TYPE#.swf?XMLFile=#HOST#apex_util.flash?p=&APP_ID.:9:&APP_SESSION.:FLOW_FLASH_CHART5_R#REGION_ID#"',
'       quality="high"',
'       width="#WIDTH#"',
'       height="#HEIGHT#"',
'       name="#CHART_NAME#"',
'       scale="noscale"',
'       align=""',
'       allowScriptAccess="sameDomain" ',
'       allowNetworking="all"',
'       type="application/x-shockwave-flash"',
'       pluginspage="#HOST_PROTOCOL#://www.macromedia.com/go/getflashplayer"',
'       wmode="transparent"',
'       FlashVars="initText=#FLASH_INIT#&xmlLoadingText=#FLASH_LOADING#&resourcesLoadingText=#FLASH_RESOURCES#&noDataText=#FLASH_NO_DATA#&waitingForDataText=#FLASH_WAITING#&templatesLoadingText=#FLASH_TEMPLATES#">',
'</embed>',
'</object>',
'#CHART_REFRESH#',
'',
'<script type="text/javascript">',
'function myRefreshChartYear3(){',
'   var chartName = ''#CHART_NAME#'';',
'   chartName = chartName.substring(1);',
'   apex_RefreshFlashChart(&APP_PAGE_ID., chartName, ''en-us'');',
'}',
'</script>'))
,p_plug_source_type=>'NATIVE_FLASH_CHART5'
,p_plug_query_row_template=>1
,p_plug_display_condition_type=>'SQL_EXPRESSION'
,p_plug_display_when_condition=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_REPORT_TYPE = ''CHARTS'' AND :P12_X_PROGRAM_AREA IS NOT NULL'
);
wwv_flow_api.create_flash_chart5(
 p_id=>wwv_flow_api.id(1343453075669009359)
,p_default_chart_type=>'2DPie'
,p_chart_rendering=>'FLASH_PREFERRED'
,p_chart_name=>'chart_1412432400272024'
,p_chart_width=>330
,p_chart_height=>220
,p_chart_animation=>'N'
,p_display_attr=>':H:N:V:::N::V:Y:None:::N:::Default:::S'
,p_dial_tick_attr=>':::::::::::'
,p_gantt_attr=>'Y:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:Rhomb:Rhomb:Full:30:15:5:Y:I:N:S:E::'
,p_pie_attr=>'Outside:::'
,p_map_attr=>'Orthographic:RegionBounds:REGION_NAME'
,p_map_source=>'%'
,p_margins=>':::'
, p_omit_label_interval=> null
,p_bgtype=>'Trans'
,p_color_scheme=>'0'
,p_custom_colors=>'0xB9E2F4'
,p_x_axis_label_font=>'::'
,p_y_axis_label_font=>'::'
,p_async_update=>'N'
, p_names_font=> null
, p_names_rotation=> null
,p_values_font=>'Tahoma:10:#000000'
,p_hints_font=>'Tahoma:10:#000000'
,p_legend_font=>'Tahoma:10:#000000'
,p_grid_labels_font=>'Tahoma:10:'
,p_chart_title_font=>'Tahoma:14:#000000'
,p_x_axis_title_font=>'Tahoma:14:'
,p_y_axis_title_font=>'Tahoma:14:'
,p_gauge_labels_font=>'Tahoma:10:'
,p_use_chart_xml=>'Y'
,p_chart_xml=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'<?xml version = "1.0" encoding="utf-8" standalone = "yes"?>',
'<anychart>',
'  <settings>',
'    <animation enabled="false"/>',
'    <no_data show_waiting_animation="False">',
'      <label>',
'        <text>No data for &P12_X_YEAR3..</text>',
'        <font family="Verdana" bold="yes" size="10"/>',
'      </label>',
'    </no_data>',
'  </settings>',
'  <margin left="0" top="0" right="0" bottom="0" />',
'  <charts>',
'    <chart plot_type="CategorizedHorizontal" name="chart_1408925646378466"> ',
'      <chart_settings>',
'        <title enabled="True"><text>&P12_X_YEAR3.</text></title>',
'        <footer enabled="True" align="Center" align_by="DataPlot">',
'          <background enabled="False"/>',
'          <font color="0x000000" bold="True" />',
'          <text>&P12_X_YEAR3_ST. Stations Reporting Data</text>',
'        </footer>',
'        <chart_background>',
'          <fill type="Solid" color="0xffffff" opacity="0" />',
'          <border enabled="false"/>',
'          <corners type="Square"/>',
'        </chart_background>',
'        <data_plot_background>',
'',
'        </data_plot_background>',
'        <axes>',
'          <y_axis position="Opposite">',
'            <scale   mode="Normal"    />',
'            <title enabled="false" />',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </y_axis>',
'          <x_axis>',
'            <scale  mode="Normal"    />',
'            <title enabled="false"/>',
'            <labels enabled="true" position="Outside">',
'              <font family="Tahoma" size="10" color="0x000000" />',
'              <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            </labels>',
'            <major_grid enabled="False"/>',
'<minor_grid enabled="False"/>',
'            ',
'          </x_axis>',
'          ',
'        </axes>',
'',
'',
'      </chart_settings>',
'      <data_plot_settings enable_3d_mode="false" >',
'        <bar_series style="Default">',
'          <tooltip_settings enabled="true">',
'            <format><![CDATA[{%Name}{enabled:False} - {%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <font family="Tahoma" size="10" color="0x000000" />',
'              <position anchor="Float" valign="Top" padding="10" /> ',
'          </tooltip_settings>',
'          <label_settings enabled="true" mode="Outside" multi_line_align="Left">',
'            <position anchor="CenterBottom" padding="5" />',
'            <format><![CDATA[{%Value}{numDecimals:0,decimalSeparator:.,thousandsSeparator:\,}]]></format>',
'            <background enabled="false"/>',
'',
'            <font family="Tahoma" size="10" color="0x000000" />',
'          </label_settings>',
'          <bar_style>',
'',
'          </bar_style>',
'          <marker_settings enabled="True" >',
'            <marker type="None" />',
'          </marker_settings>',
'        </bar_series>',
'      </data_plot_settings>',
'',
'#DATA#',
'    </chart>',
'  </charts>',
'</anychart>',
''))
);
wwv_flow_api.create_flash_chart5_series(
 p_id=>wwv_flow_api.id(1343453173825009359)
,p_chart_id=>wwv_flow_api.id(1343453075669009359)
,p_series_seq=>10
,p_series_name=>'Series 1'
,p_series_query=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select null link,',
'       result_type label,',
'       sum(cnt) value',
'  from state_org_year',
'unpivot include nulls (cnt for result_type in (regular_count as ''Physical/Chemical'', biological_count as ''Biological'', habitat_count as ''Habitat''))   ',
' where fk_org = :P12_X_FK_ORG',
'   and act_start_year_date = :P12_X_YEAR3',
'   and (:P12_X_GEN_GEO_STATE = -1 or fk_gen_geo_state = :P12_X_GEN_GEO_STATE)',
' group by result_type',
' order by label;'))
,p_series_query_type=>'SQL_QUERY'
,p_series_query_parse_opt=>'PARSE_CHART_QUERY'
,p_series_query_no_data_found=>'No data found.'
,p_series_query_row_count_max=>15
,p_show_action_link=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1343450876599009347)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(1343450477799009344)
,p_button_name=>'P12_REFRESH'
,p_button_static_id=>'P12_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT-CENTER'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1343449083307009303)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_button_name=>'P12_GO'
,p_button_static_id=>'P12_GO'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(118702805099913)
,p_button_image_alt=>'Submit'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_grid_new_grid=>false
,p_grid_new_row=>'Y'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343441974243009030)
,p_name=>'P12_X_TOTAL2'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(1343441569776008880)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343442190505009079)
,p_name=>'P12_X_YEAR2'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1343441569776008880)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 1'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343442760042009094)
,p_name=>'P12_X_YEAR3'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1343442363608009080)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 2'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343442974972009094)
,p_name=>'P12_X_TOTAL3'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(1343442363608009080)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343445572433009143)
,p_name=>'P12_X_TOTAL4'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(1343445175799009123)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343445781913009143)
,p_name=>'P12_X_YEAR4'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(1343445175799009123)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 3'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343446382121009151)
,p_name=>'P12_X_TOTAL5'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(1343445978757009143)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343446581056009151)
,p_name=>'P12_X_YEAR5'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(1343445978757009143)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')) - 4'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343448690695009302)
,p_name=>'P12_X_STATE_NAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343448888106009303)
,p_name=>'P12_1_0'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_prompt=>'&nbsp;'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343449273263009303)
,p_name=>'P12_X_YEAR'
,p_is_required=>true
,p_item_sequence=>2
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_prompt=>'<strong>Select Year:</strong>&nbsp;&nbsp;'
,p_source=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_char(sysdate,''YYYY'')',
'  from dual;'))
,p_source_type=>'QUERY'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select to_number(column_value) as n,',
'       to_number(column_value) as v',
'  from table(pkg_dynamic_list.get_years(null,to_number(to_char(sysdate,''YYYY'')) - 1899))',
' order by 1 desc;'))
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343449480061009318)
,p_name=>'P12_X_GEN_GEO_STATE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_prompt=>'<strong>Select State:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'          select st.state_name,',
'                 st.pk_isn',
'            from di_geo_state st',
'           where country_code = ''US''',
'             and epa_region_code is not null',
'           order by 2'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL STATES -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343449678321009343)
,p_name=>'P12_X_REPORT_TYPE'
,p_is_required=>true
,p_item_sequence=>15
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_prompt=>'<strong>Select Display Type:</strong>&nbsp;&nbsp;'
,p_source=>'CHARTS'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_lov=>'STATIC2:Top 5 Organizations Charts;CHARTS,All Organizations Table;TABLE'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'1'
,p_attribute_02=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343450090756009343)
,p_name=>'P12_X_PROGRAM_AREA'
,p_item_sequence=>14
,p_item_plug_id=>wwv_flow_api.id(1343448483409009301)
,p_prompt=>'<strong>Select Program Area:</strong>&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select organization_type,',
'       pk_isn',
'  from di_org_types',
' where pk_isn >= 100',
' order by sort_order'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- ALL AREAS -'
,p_lov_null_value=>'-1'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_field_template=>wwv_flow_api.id(1344890112294155113)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343450678589009344)
,p_name=>'P12_X_FK_ORG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1343450477799009344)
,p_prompt=>'<strong>Select Organization:</strong>&nbsp;&nbsp;'
,p_post_element_text=>'&nbsp;&nbsp;'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select distinct c.organization_id || '' - '' || c.organization_name as org_name,',
'       c.pk_isn as org_id',
'  from state_org_year a, di_org c',
' where ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'   and a.fk_org in ( select fk_org',
'                       from lu_orgtype',
'                      where fk_org_type = 9 )',
'            and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                         from lu_orgtype',
'                                                        where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'   and a.act_start_year_date between to_number(:P12_X_YEAR5) and to_number(:P12_X_YEAR1)',
'   and a.fk_org = c.pk_isn ',
' order by 1 '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- SELECT -'
,p_lov_null_value=>'0'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343451468272009356)
,p_name=>'P12_X_TOTAL1'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(1343451065058009348)
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343451658452009356)
,p_name=>'P12_X_YEAR1'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1343451065058009348)
,p_use_cache_before_default=>'NO'
,p_source=>'TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))'
,p_source_type=>'FUNCTION'
,p_display_as=>'NATIVE_HIDDEN'
,p_cSize=>30
,p_cMaxlength=>4000
,p_cHeight=>1
,p_cAttributes=>'nowrap="nowrap"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_rowspan=>1
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343513575809769149)
,p_name=>'P12_X_YEAR1_ST'
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_api.id(1343452075495009357)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343513771280771242)
,p_name=>'P12_X_YEAR2_ST'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(1343452489866009358)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343513967614772992)
,p_name=>'P12_X_YEAR3_ST'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(1343452870320009358)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343514163516774888)
,p_name=>'P12_X_YEAR4_ST'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(1343443965984009106)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1343514360281776352)
,p_name=>'P12_X_YEAR5_ST'
,p_item_sequence=>150
,p_item_plug_id=>wwv_flow_api.id(1343443590167009104)
,p_source=>'0'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_HIDDEN'
,p_cMaxlength=>4000
,p_label_alignment=>'RIGHT'
,p_field_alignment=>'LEFT-CENTER'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343453375207009360)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR3'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 2'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343453568461009365)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR1'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY'')))'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343453786160009370)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR2'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 1'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343453958606009370)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR4'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 3'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343454189816009370)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_YEAR5'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'PLSQL_EXPRESSION'
,p_computation=>'NVL(:P12_X_YEAR, TO_NUMBER (TO_CHAR (SYSDATE, ''YYYY''))) - 4'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343454383004009370)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_FK_ORG'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'0'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343454570146009370)
,p_computation_sequence=>10
,p_computation_item=>'P12_X_STATE_NAME'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'select state_name',
'  from di_geo_state',
' where pk_isn = :P12_X_GEN_GEO_STATE'))
,p_compute_when=>':P12_X_GEN_GEO_STATE <> -1'
,p_compute_when_type=>'SQL_EXPRESSION'
);
wwv_flow_api.create_page_computation(
 p_id=>wwv_flow_api.id(1343454780447009371)
,p_computation_sequence=>10
,p_computation_item=>'F102_X_BREADCRUMB'
,p_computation_point=>'BEFORE_HEADER'
,p_computation=>'bitand(nvl(:F102_X_BREADCRUMB,1) + 16 - bitand(nvl(:F102_X_BREADCRUMB,1),16),31)'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(1343455080835009400)
,p_name=>'Refresh Organization Details'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_api.id(1343450876599009347)
,p_bind_type=>'live'
,p_bind_event_type=>'click'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1343455378924009450)
,p_event_id=>wwv_flow_api.id(1343455080835009400)
,p_event_result=>'TRUE'
,p_action_sequence=>5
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P12_X_FK_ORG',
'        and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'end;'))
,p_attribute_02=>'P12_X_FK_ORG,P12_X_YEAR1_ST,P12_X_YEAR2_ST,P12_X_YEAR3_ST,P12_X_YEAR4_ST,P12_X_YEAR5_ST'
,p_stop_execution_on_error=>'Y'
,p_wait_for_result=>'Y'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(1343455568994009478)
,p_event_id=>wwv_flow_api.id(1343455080835009400)
,p_event_result=>'TRUE'
,p_action_sequence=>15
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex.jQuery( "#OrgDetailsChartYear1_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear2_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear3_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear4_chart" ).trigger( "apexrefresh" );',
'apex.jQuery( "#OrgDetailsChartYear5_chart" ).trigger( "apexrefresh" );'))
,p_stop_execution_on_error=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1343454874043009371)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Totals'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'begin',
'   for c in (',
'      select trim(to_char(sum(a.result_count),''999,999,999,999'')) as total_count,',
'             a.act_start_year_date as year_no',
'        from state_org_year a                ',
'       where a.act_start_year_date in (:P12_X_YEAR1, :P12_X_YEAR2, :P12_X_YEAR3, :P12_X_YEAR4, :P12_X_YEAR5)',
'         and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'         and a.fk_org in ( select fk_org',
'                             from lu_orgtype',
'                            where fk_org_type = 9 )',
'         and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                          from lu_orgtype',
'                                                         where fk_org_type = :P12_X_PROGRAM_AREA ) )',
'       group by a.act_start_year_date',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_TOTAL1 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_TOTAL2 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_TOTAL3 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_TOTAL4 := c.total_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_TOTAL5 := c.total_count;',
'     end if;',
'  end loop;',
'',
'  for c in (',
'     select fk_org',
'       from ( select a.fk_org,',
'                     dense_rank() over (order by act_start_year_date desc, result_count desc) as rnk',
'                from state_org_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'               where dt.column_value = a.act_start_year_date',
'                 and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )  ',
'                 and ( :P12_X_PROGRAM_AREA = -1 or a.fk_org in ( select fk_org',
'                                                                   from lu_orgtype',
'                                                                  where fk_org_type = :P12_X_PROGRAM_AREA ) ) ',
'                 and a.fk_org in ( select fk_org',
'                                     from lu_orgtype',
'                                    where fk_org_type = 9 ) )',
'      where rnk = 1',
'  )',
'  loop',
'',
'     :P12_X_FK_ORG := c.fk_org;',
'',
'  end loop;',
'',
'  for c in (',
'     select dt.column_value as year_no,',
'            count(distinct a.fk_fa_statn) as station_count',
'       from station_year a, table(pkg_dynamic_list.get_years(:P12_X_YEAR1)) dt                ',
'      where dt.column_value = a.act_start_year_date',
'        and a.fk_org = :P12_X_FK_ORG',
'        and ( :P12_X_GEN_GEO_STATE = -1 or a.fk_gen_geo_state = :P12_X_GEN_GEO_STATE )',
'      group by dt.column_value  ',
'  )',
'  loop',
'     if c.year_no = :P12_X_YEAR1 then',
'        :P12_X_YEAR1_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR2 then',
'        :P12_X_YEAR2_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR3 then',
'        :P12_X_YEAR3_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR4 then',
'        :P12_X_YEAR4_ST := c.station_count;',
'     elsif c.year_no = :P12_X_YEAR5 then',
'        :P12_X_YEAR5_ST := c.station_count;',
'     end if;',
'  end loop;',
'',
'end;'))
,p_process_when=>':P12_X_GEN_GEO_STATE IS NOT NULL AND :P12_X_PROGRAM_AREA IS NOT NULL'
,p_process_when_type=>'SQL_EXPRESSION'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_api.create_page(
 p_id=>101
,p_user_interface_id=>wwv_flow_api.id(1341394875874886529)
,p_name=>'Login'
,p_page_mode=>'NORMAL'
,p_step_title=>'Login'
,p_step_sub_title=>'Login'
,p_step_sub_title_type=>'TEXT_WITH_SUBSTITUTIONS'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_step_template=>wwv_flow_api.id(1344882111434709273)
,p_page_template_options=>'#DEFAULT#'
,p_dialog_chained=>'Y'
,p_overwrite_navigation_list=>'N'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_is_public_y_n=>'Y'
,p_cache_mode=>'NOCACHE'
,p_cache_timeout_seconds=>21600
,p_last_updated_by=>'DSPOREA'
,p_last_upd_yyyymmddhh24miss=>'20120827091756'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(1342767887895840208)
,p_plug_name=>'Login'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(1342758458865818181)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'N'
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_plug_display_column=>1
,p_plug_display_point=>'BODY_3'
,p_plug_query_row_template=>1
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
,p_attribute_03=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(1342768459362840212)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(1342767887895840208)
,p_button_name=>'P101_LOGIN'
,p_button_static_id=>'P101_LOGIN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(1344882614637709277)
,p_button_image_alt=>'Login'
,p_button_position=>'BODY'
,p_button_alignment=>'LEFT'
,p_request_source=>'LOGIN'
,p_request_source_type=>'STATIC'
,p_grid_new_grid=>false
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
,p_grid_row_span=>1
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342768074936840210)
,p_name=>'P101_USERNAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(1342767887895840208)
,p_prompt=>'Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>40
,p_cMaxlength=>100
,p_colspan=>2
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(1344890201601155113)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'NONE'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(1342768258468840211)
,p_name=>'P101_PASSWORD'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(1342767887895840208)
,p_prompt=>'Password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>40
,p_cMaxlength=>100
,p_colspan=>1
,p_rowspan=>1
,p_label_alignment=>'RIGHT'
,p_field_template=>wwv_flow_api.id(1344890201601155113)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1342768869558840214)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Set Username Cookie'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex_authentication.send_login_username_cookie (',
'    p_username => lower(:P101_USERNAME) );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1342768680820840213)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Login'
,p_process_sql_clob=>wwv_flow_utilities.join(wwv_flow_t_varchar2(
'apex_authentication.login(',
'    p_username => :P101_USERNAME,',
'    p_password => :P101_PASSWORD );'))
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1342769290747840214)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Clear Page(s) Cache'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_api.create_page_process(
 p_id=>wwv_flow_api.id(1342769060651840214)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Username Cookie'
,p_process_sql_clob=>':P101_USERNAME := apex_authentication.get_login_username_cookie;'
);
end;
/
prompt --application/deployment/definition
begin
wwv_flow_api.create_install(
 p_id=>wwv_flow_api.id(1446385560205705047)
);
end;
/
prompt --application/deployment/install
begin
null;
end;
/
prompt --application/deployment/checks
begin
null;
end;
/
prompt --application/deployment/buildoptions
begin
null;
end;
/
prompt --application/end_environment
begin
wwv_flow_api.import_end(p_auto_install_sup_obj => nvl(wwv_flow_application_install.get_auto_install_sup_obj, false));
commit;
end;
/
set verify on feedback on define on
prompt  ...done
