
  CREATE OR REPLACE FUNCTION "STORETW"."SP_FETCH_LEGACY_HUC8" (
   p_input SDO_GEOMETRY
)
RETURN VARCHAR2
AS
  http_req      UTL_HTTP.REQ;
  http_resp     UTL_HTTP.RESP;
  str_return    VARCHAR2(8);
  num_longitude NUMBER;
  num_lattitude NUMBER;
  http_request  VARCHAR2(4000);
  http_response VARCHAR2(4000);

BEGIN

   -----------------------------------------------------------------------------
   -- Step 10
   -- Check over incoming parameters
   -----------------------------------------------------------------------------
   IF p_input.get_gtype != 1
   THEN
       RAISE_APPLICATION_ERROR(-20001,'ERROR, function allows point inputs only!');
   END IF;

   -----------------------------------------------------------------------------
   -- Step 20
   -- Break out the coordinates
   -----------------------------------------------------------------------------
   IF p_input.SDO_POINT IS NOT NULL
   THEN
      num_longitude := p_input.SDO_POINT.x;
      num_lattitude := p_input.SDO_POINT.y;
   ELSE
      num_longitude := p_input.SDO_ORDINATES(1);
      num_lattitude := p_input.SDO_ORDINATES(1);
   END IF;

   IF num_longitude IS NULL OR
   num_lattitude IS NULL
   THEN
      RAISE_APPLICATION_ERROR(-20001,'ERROR, unable to parse point ordinates from input!');
   END IF;

   -----------------------------------------------------------------------------
   -- Step 30
   -- Craft the submission
   -----------------------------------------------------------------------------
   http_request :=
      'pGeometry=POINT(' || TO_CHAR(num_longitude) || ' ' || TO_CHAR(num_lattitude) || ')' || '&' ||
      'pGeometryMod=WKT,SRID=' || TO_CHAR(p_input.SDO_SRID) || '&' ||
      'pLayer=LEGACY_HUC8' || '&' ||
      'pReturnGeometry=FALSE';

   http_req:= UTL_HTTP.BEGIN_REQUEST(
      'http://ofmpub.epa.gov/waters10/waters_services.SpatialAssignmentService?' || UTL_URL.ESCAPE(http_request)
   );

   UTL_HTTP.SET_HEADER(
      http_req,
      'Content-Type',
      'application/javascript'
   );

   -----------------------------------------------------------------------------
   -- Step 40
   -- Receive the response
   -----------------------------------------------------------------------------
   http_resp:= UTL_HTTP.GET_RESPONSE(http_req);

   UTL_HTTP.READ_TEXT(
      http_resp,
      http_response
   );

   UTL_HTTP.END_RESPONSE(http_resp);
   --DBMS_OUTPUT.PUT_LINE(TO_CHAR(http_response));

   -----------------------------------------------------------------------------
   -- Step 50
   -- Parse the response
   -----------------------------------------------------------------------------
   str_return := SUBSTR(
      http_response,
      INSTR(
         http_response,
         '"assignment_value":'
      ) + 20,
      8
   );

   -----------------------------------------------------------------------------
   -- Step
   -- Return what we got
   -----------------------------------------------------------------------------
   IF str_return IN ('ull,"cov','e>Not Fo','IC "-//I')
   THEN
      RETURN NULL;
   ELSE
      RETURN str_return;
   END IF;

END SP_fetch_legacy_huc8;
/

