
  CREATE OR REPLACE PACKAGE "STORETW"."DW_PAGES"
AS
   PROCEDURE home;

   PROCEDURE stationcriteria;

   PROCEDURE resultcriteria;

   PROCEDURE stationquery_count (
      geographic                    CHAR DEFAULT NULL,
      org_station_project_button    CHAR DEFAULT NULL,
      as_multiple_state             OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_state                      NUMBER DEFAULT 0,
      as_county                     CHAR DEFAULT 'ALL',
      v_county_code                 CHAR DEFAULT 'ALL',
      v_org_names                   CHAR DEFAULT NULL,
      MAX_LAT_DD                    NUMBER DEFAULT 90,
      dir_maxlat                    CHAR DEFAULT NULL,
      MIN_LONG_DD                   NUMBER DEFAULT 180,
      dir_minlong                   CHAR DEFAULT NULL,
      MAX_LONG_DD                   NUMBER DEFAULT 0,
      dir_maxlong                   CHAR DEFAULT NULL,
      MIN_LAT_DD                    NUMBER DEFAULT 0,
      dir_minlat                    CHAR DEFAULT NULL,
      as_huc                        OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      v_huc_code                    CHAR DEFAULT 'ALL',
      D_STYPE_LIST                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      D_ORGTYPE_LIST                OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      D_ORG_NAME_LIST               OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      from_mon1                     CHAR DEFAULT 'JAN',
      from_dd1                      NUMBER DEFAULT 1,
      from_yyyy1                    NUMBER DEFAULT 1900,
      end_mon1                      CHAR DEFAULT TO_CHAR (SYSDATE, 'MON'),
      end_dd1                       NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE, 'DD')),
      end_yyyy1                     NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE,
                                                               'YYYY')),
      from_mon2                     CHAR DEFAULT 'DUMMY',
      from_dd2                      NUMBER DEFAULT 0,
      from_yyyy2                    NUMBER DEFAULT 0,
      end_mon2                      CHAR DEFAULT 'DUMMY',
      end_dd2                       NUMBER DEFAULT 0,
      end_yyyy2                     NUMBER DEFAULT 0,
      from_mon3                     CHAR DEFAULT 'DUMMY',
      from_dd3                      NUMBER DEFAULT 0,
      from_yyyy3                    NUMBER DEFAULT 0,
      end_mon3                      CHAR DEFAULT 'DUMMY',
      end_dd3                       NUMBER DEFAULT 0,
      end_yyyy3                     NUMBER DEFAULT 0,
      from_mon4                     CHAR DEFAULT 'DUMMY',
      from_dd4                      NUMBER DEFAULT 0,
      from_yyyy4                    NUMBER DEFAULT 0,
      end_mon4                      CHAR DEFAULT 'DUMMY',
      end_dd4                       NUMBER DEFAULT 0,
      end_yyyy4                     NUMBER DEFAULT 0,
      v_char_names                  CHAR DEFAULT NULL,
      as_char                       CHAR DEFAULT NULL,
      as_org                        CHAR DEFAULT NULL,
      AS_CHAR_ALIAS_TYPE            NUMBER DEFAULT 0,
      char_list                     OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      org_list                      OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      taxon_filter                  CHAR DEFAULT 'ON',
      d_org_list                    NUMBER DEFAULT 0,
      d_org_list2                   NUMBER DEFAULT 0,
      d_org_list3                   OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_proj_list                   NUMBER DEFAULT 0,
      as_proj                       CHAR DEFAULT NULL,
      V_STATION_NAMES               CHAR DEFAULT NULL,
      AS_STATION                    CHAR DEFAULT 'dummy',
      station_list                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_extref                     CHAR DEFAULT NULL,
      d_extref_list                 NUMBER DEFAULT 0,
      d_medium_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_intent_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_community_list              OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      searchtype                    CHAR DEFAULT NULL,
      result_type                   CHAR DEFAULT 'REGULAR',
--CCB --2012-06-22: exclude & char_select advance
       char_filter                   CHAR DEFAULT NULL,
      Reg_Exclude                   CHAR DEFAULT NULL,
      Bio_Exclude                   CHAR DEFAULT NULL,
      Hab_Exclude                   CHAR DEFAULT NULL,
      Met_Exclude                   CHAR DEFAULT NULL,
      source_app                    VARCHAR2 DEFAULT 'WATERSHED',
      in_chartype_list              VARCHAR2 DEFAULT 'ALL',
      in_chartype_names             VARCHAR2 DEFAULT 'ALL');

   PROCEDURE resultquery_count (
      geographic                    CHAR DEFAULT NULL,
      org_station_project_button    CHAR DEFAULT NULL,
      as_multiple_state             OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_state                      NUMBER DEFAULT 0,
      as_county                     CHAR DEFAULT 'ALL',
      v_county_code                 CHAR DEFAULT 'ALL',
      v_org_names                   CHAR DEFAULT NULL,
      MAX_LAT_DD                    NUMBER DEFAULT 90,
      dir_maxlat                    CHAR DEFAULT NULL,
      MIN_LONG_DD                   NUMBER DEFAULT 180,
      dir_minlong                   CHAR DEFAULT NULL,
      MAX_LONG_DD                   NUMBER DEFAULT 0,
      dir_maxlong                   CHAR DEFAULT NULL,
      MIN_LAT_DD                    NUMBER DEFAULT 0,
      dir_minlat                    CHAR DEFAULT NULL,
      as_huc                        OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      v_huc_code                    CHAR DEFAULT 'ALL',
      D_STYPE_LIST                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      D_ORGTYPE_LIST                OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      D_ORG_NAME_LIST               OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      from_mon1                     CHAR DEFAULT 'JAN',
      from_dd1                      NUMBER DEFAULT 1,
      from_yyyy1                    NUMBER DEFAULT 1900,
      end_mon1                      CHAR DEFAULT TO_CHAR (SYSDATE, 'MON'),
      end_dd1                       NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE, 'DD')),
      end_yyyy1                     NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE,
                                                               'YYYY')),
      from_mon2                     CHAR DEFAULT 'DUMMY',
      from_dd2                      NUMBER DEFAULT 0,
      from_yyyy2                    NUMBER DEFAULT 0,
      end_mon2                      CHAR DEFAULT 'DUMMY',
      end_dd2                       NUMBER DEFAULT 0,
      end_yyyy2                     NUMBER DEFAULT 0,
      from_mon3                     CHAR DEFAULT 'DUMMY',
      from_dd3                      NUMBER DEFAULT 0,
      from_yyyy3                    NUMBER DEFAULT 0,
      end_mon3                      CHAR DEFAULT 'DUMMY',
      end_dd3                       NUMBER DEFAULT 0,
      end_yyyy3                     NUMBER DEFAULT 0,
      from_mon4                     CHAR DEFAULT 'DUMMY',
      from_dd4                      NUMBER DEFAULT 0,
      from_yyyy4                    NUMBER DEFAULT 0,
      end_mon4                      CHAR DEFAULT 'DUMMY',
      end_dd4                       NUMBER DEFAULT 0,
      end_yyyy4                     NUMBER DEFAULT 0,
      v_char_names                  CHAR DEFAULT NULL,
      as_char                       CHAR DEFAULT NULL,
      as_org                        CHAR DEFAULT NULL,
      AS_CHAR_ALIAS_TYPE            NUMBER DEFAULT 0,
      char_list                     OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      org_list                      OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      taxon_filter                  CHAR DEFAULT 'ON',
      d_org_list                    NUMBER DEFAULT 0,
      d_org_list2                   NUMBER DEFAULT 0,
      d_proj_list                   NUMBER DEFAULT 0,
      as_proj                       CHAR DEFAULT NULL,
      V_STATION_NAMES               CHAR DEFAULT NULL,
      AS_STATION                    CHAR DEFAULT 'dummy',
      station_list                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_extref                     CHAR DEFAULT NULL,
      d_extref_list                 NUMBER DEFAULT 0,
      d_medium_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_intent_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_community_list              OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      searchtype                    CHAR DEFAULT NULL,
      result_type                   CHAR DEFAULT 'REGULAR',
--CCB --2012-06-22: exclude & char_select advance
       char_filter                   CHAR DEFAULT NULL,
      Reg_Exclude                   CHAR DEFAULT NULL,
      Bio_Exclude                   CHAR DEFAULT NULL,
      Hab_Exclude                   CHAR DEFAULT NULL,
      Met_Exclude                   CHAR DEFAULT NULL,
      source_app                    VARCHAR2 DEFAULT 'WATERSHED',
      in_chartype_list              VARCHAR2 DEFAULT 'ALL',
      in_chartype_names             VARCHAR2 DEFAULT 'ALL');

   PROCEDURE result_hub (
      v_FromStmt            IN VARCHAR2 DEFAULT NULL,
      v_WhereStmt           IN VARCHAR2 DEFAULT NULL,
      vR_FromStmt           IN VARCHAR2 DEFAULT NULL,
      vR_WhereStmt          IN VARCHAR2 DEFAULT NULL,
      vB_FromStmt           IN VARCHAR2 DEFAULT NULL,
      vB_WhereStmt          IN VARCHAR2 DEFAULT NULL,
      vH_FromStmt           IN VARCHAR2 DEFAULT NULL,
      vH_WhereStmt          IN VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      vM_FromStmt           IN VARCHAR2 DEFAULT NULL,
      vM_WhereStmt          IN VARCHAR2 DEFAULT NULL,
      v_ResultCount         IN VARCHAR2,
      vR_ResultCount        IN VARCHAR2,
      vB_ResultCount        IN VARCHAR2,
      vH_ResultCount        IN VARCHAR2,
--CCB --2012-06-22: metrics
      vM_ResultCount        IN VARCHAR2,
      v_rule_optimization   IN VARCHAR2,
      v_report_type         IN CHAR,
      v_filters             IN VARCHAR2,
      v_mode                IN VARCHAR2,
      v_email               IN VARCHAR2 DEFAULT 'No_Email_Provided',
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      v_userprofile         IN NUMBER DEFAULT 8,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      v_distinct            IN VARCHAR2 DEFAULT 'OFF',
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      v_prefix              IN VARCHAR2 DEFAULT 'EPA',
      v_Columns                OWA_UTIL.vc_arr,
      r_Type                   OWA_UTIL.vc_arr,
      report_type              VARCHAR2 := 'CUSTOM');

   PROCEDURE station_hub (
      v_FromStmt       IN VARCHAR2,
      v_WhereStmt      IN VARCHAR2,
      v_StationCount   IN VARCHAR2,
      v_filters        IN VARCHAR2,
      v_mode           IN VARCHAR2,
      v_email          IN VARCHAR2 DEFAULT 'No_Email_Provided',
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      v_userprofile    IN NUMBER DEFAULT 8,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      v_distinct       IN VARCHAR2 DEFAULT 'OFF',
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      v_prefix         IN VARCHAR2 DEFAULT 'EPA',
      v_Columns           OWA_UTIL.ident_arr,
      report_type         VARCHAR2 := 'CUSTOM');

   PROCEDURE blob_download (v_blob_id IN VARCHAR2);
END dw_pages;
/
CREATE OR REPLACE PACKAGE BODY "STORETW"."DW_PAGES"
AS
   PROCEDURE home
   AS
      program_path   VARCHAR2 (1000) := NULL;
      image_path     VARCHAR2 (1000) := NULL;
      page_title     VARCHAR2 (100) := 'STORET Central Warehouse';
   BEGIN
      dw_comp.top (page_title,
                   program_path,
                   image_path,
                   '');

      HTP.PRINT (
         '
        <table width=550 align="center">
            <tr>
                <td width=200 valign="top">
                    <img src="http://www.epa.gov/storet/images/logo.gif" width="176" height="218" alt="STORET Water Drop Logo" align="left" />
                </td>
                <td align=left width=350>
                    <big><b>STORET Station Descriptions</big></b><br />
                    <ul class="epaBodyText">
                        <li><a href="dw_pages.stationcriteria" target="_top">Stations Download</a></li>
                    </ul>
                    <big><b>STORET Results</big></b><br>
                    (Physical/Chemical, Biological and Habitat Result Data)
                    <ul class="epaBodyText">
                        <li><a href="dw_pages.resultcriteria" target="_top">Results Download</a></li>
                    </ul>
                </td>
            </tr>
        </table>
');

      dw_comp.bottom ();
   END home;

   PROCEDURE stationcriteria
   AS
      CURSOR cstype
      IS
           SELECT primary_type,
                  secondary_type,
                  PK_ISN,
                  sort_order
             FROM DI_STATN_TYPES
         ORDER BY sort_order, primary_type, secondary_type;

      --- added the cursor for organization_type
      CURSOR corg_type
      IS
           SELECT ORGANIZATION_TYPE, PK_ISN, sort_order
             FROM DI_ORG_TYPES
         ORDER BY sort_order, organization_type;

      --used to generate org list
      CURSOR corg
      IS
           SELECT ORGANIZATION_ID,
                  LTRIM (RTRIM (ORGANIZATION_NAME)) ORG_NAME,
                  PK_ISN
             FROM DI_ORG
         ORDER BY ORGANIZATION_ID;

      program_path   VARCHAR2 (1000) := NULL;
      image_path     VARCHAR2 (1000) := NULL;
      page_title     VARCHAR2 (100) := 'Stations Download';
   BEGIN
      dw_comp.top (
         page_title,
         program_path,
         image_path,
         'adjust_width_n(document.forms[1].D_ORG_LIST,"~","30~70","None","N");adjust_width_n(document.forms[1].D_ORG_LIST2,"~","30~70","None","N");document.forms[1].reset();');
      HTP.PRINT ('<form action="dw_pages.stationquery_count" method=POST>');

      -- Geographic selection
      dw_comp.geo_select;

      -- Station Type selection
      HTP.PRINT (
         '
        <h4>Organization, Station & Project</h4>
        <center>Select a single type of Organization search that you wish to perform (Organization Type, Organization(s), Station(s) or Project).
        Then enter the corresponding search criteria.
        </center>
        <table BORDER COLS=2 WIDTH="100%" class="tablebord zebra">
        <tr><td width="25%"><input checked type="radio" checked name="org_station_project_button" value="Organization Type" tabindex=51 onclick="javascript:document.forms[1].org_station_project_button[0].checked=true;">&nbsp;Select one or more<br>
         Organization Type(s)<br>(Option 1)</td>
        <td align="center">
        Select one or more Organization Type(s)
        <BR>
        <INPUT TYPE="TEXT" READONLY style="width:300px; font: 10pt/12pt COURIER; font-weight: bold"  VALUE="          ORGANIZATION TYPE" size="69"  onFocus="javascript:this.blur()">
        <BR>
        <FONT face="Courier">
        <SELECT NAME="D_ORGTYPE_LIST" SIZE="10"  tabindex=52 MULTIPLE style="width:300px; font: 10pt/12pt COURIER" onclick="javascript:document.forms[1].org_station_project_button[0].checked=true;">
        <OPTION SELECTED  value="ALL">Select All_________________________');

      FOR corgtype_var IN corg_type
      LOOP
         HTP.formSelectOption (
            corgtype_var.ORGANIZATION_TYPE,
            cattributes   => 'value= ' || corgtype_var.PK_ISN);
      END LOOP;

      HTP.PRINT ('</SELECT></FONT>
        <BR>
        </TD>
        </TR>
        ');
      dw_comp.org_select (54);
      HTP.PRINT (
         '
        <TR>
        <td width="25%"><input type="radio" name="org_station_project_button" value="Organization and Station" tabindex=63 onClick="javascript:document.forms[1].org_station_project_button[2].checked=true;">&nbsp;Select and Search<br>Organization and Station<br>(Option 3)</td>
        <TD align="center">
        <center>Select an Organization and a Search Type, then enter a Search String and click "Search Stations".
        <br><br>
        <INPUT TYPE="TEXT" READONLY style="width: 645px; font-size: 10pt/12pt; font-family: Courier New, Courier, monospace; font-weight: bold"  VALUE="ORG ID                         ORGANIZATION NAME" size="81"  onFocus="javascript:document.forms[1].D_ORG_LIST.focus()">
        <font face="Courier, monospace"> <br>
        <select name="D_ORG_LIST" tabindex="64" size="1" style="width: 650px; font: 10pt/12pt COURIER" onChange="javascript:document.forms[1].as_extref.value=''STANDARD'';document.forms[1].D_EXTREF_LIST.value=0;document.forms[1].org_station_project_button[2].checked=true;">
        <OPTION SELECTED  value="0">Select an Organization________________________________________________________');

      FOR org IN corg
      LOOP
         HTP.formSelectOption (
            org.organization_id || '~' || SUBSTR (org.org_name, 0, 50),
            cattributes   => 'VALUE=' || org.pk_isn);
      END LOOP;

      HTP.PRINT (
         '</SELECT></font></center>
        <table width="50%">
        <tr>
        <td style="border:0;border-width:0 0 0 0" align=left WIDTH="70%"><br><B>Search Type</B>
        <br>&nbsp &nbsp &nbsp<input checked type=radio name="searchtype" tabindex="65" value="ID" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;"> Search by Station ID
        <BR>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="66" value="Name" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;"> Search by Station Name
        <br>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="67" value="Ref" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;"> Search by Station Alias
        <input type="hidden" name="D_EXTREF_LIST" value=0>
        <br>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
        Select Station Alias Type <input type="text" readonly value="STANDARD" name="as_extref" size="10" style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">
        <input type="button" tabindex="68" value="Look Up" onclick="javascript:document.forms[1].searchtype[2].checked=true;document.forms[1].org_station_project_button[2].checked=true;openWin(''extref'');" title="Opens a popup window for Station Alias Type selection">

        <hr align=left width="50%">
        <br><B>Search String </B>
        <input type=hidden name="v_station_names">
        <input type="text" name="as_station" tabindex="69" size="20" style="font: 10pt/12pt COURIER" maxlength="20" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;" >
        </td>
        </tr>
        <tr><td style="border:0;border-width:0 0 0 0"></td></tr>
        </table>

        <br><center><input type="button" tabindex="70" value="Search Stations" onclick="openWin(''station'')" title="Opens a popup window for Station selection">

        <br><br><font style="font-size: 9pt; font-family: Courier New, Courier, monospace"> <select multiple size="10" name="station_list" style="font-size: 8pt; font-family: Courier New, Courier, monospace" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;">
        <option>ORG ID &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;STATION ID  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ALIAS TYPE   &nbsp;&nbsp;&nbsp;STATION ALIAS    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;STATION NAME </option>
        <option value="dummy">________________________________________________________________________________________________________</option>
        </select></font>
        <br>
        <input type="button" tabindex="71" value="Clear Selected" onclick="javascript:deleteSelectedFromStationList();document.forms[1].org_station_project_button[2].checked=true;" title="Remove highlighted Stations from Selected List">
        <input type="button" tabindex="72" value="Clear All" onclick="javascript:deleteAllFromStationList();document.forms[1].org_station_project_button[2].checked=true;" title="Remove all Stations from the Selected List">
        </center>
        </td>
        </tr>


        <TR>
        <td width="25%"><input unchecked type="radio" name="org_station_project_button" value="Organization and Project" tabindex=83 onClick="javascript:document.forms[1].org_station_project_button[3].checked=true;"> Select a Single <br>Organization and Project <br> (Option 4)</td>
        <TD align="center">
        <b>Step 1:</b> Select a Single Organization from the List
        <br>
        <INPUT TYPE="TEXT" READONLY style="width: 645px; font-size: 10pt/12pt; font-family: Courier new, Courier, monospace; font-weight: bold"  VALUE="ORG ID                         ORGANIZATION NAME" size="81"  onFocus="javascript:document.forms[1].D_ORG_LIST2.focus()">
        <br>
        <font face="Courier, monospace">
        <select name="D_ORG_LIST2" size="1" style="width: 650px;font: 10pt/12pt COURIER" tabindex=81 onChange="javascript:document.forms[1].as_proj.value=''Select a Project'';document.forms[1].D_PROJ_LIST.value=0;document.forms[1].org_station_project_button[3].checked=true;">
        <option selected value="0"> Select an Organization________________________________________________________
         <option value="-1">All Organizations (National Projects)');

      FOR org IN corg
      LOOP
         HTP.formSelectOption (
            org.organization_id || '~' || SUBSTR (org.org_name, 0, 50),
            cattributes   => 'VALUE=' || org.pk_isn);
      END LOOP;

      -- project selection
      HTP.PRINT (
         '</SELECT></FONT>
        <br><br>
        <b>Step 2:</b> Select a Single Project by Clicking "Look Up"

        <br>
        <input type="text" readonly value="Select a Project" style="font-size: 10pt; font-family: Courier, monospace" name="as_proj" size="74" onclick="javascript:document.forms[1].org_station_project_button[3].checked=true;" onFocus="javascript:this.blur()">
        <input type="hidden" name="D_PROJ_LIST" value=0>
        <input type="button" value="Look Up" tabindex=82 onclick="openWin(''proj'')" title="Opens a popup window for Project selection">

        </td>
        </TR>
        </TABLE>');

      -- sug added Station types
      -- Station Type selection
      HTP.PRINT (
         '
        <h4>Station Type</h4>
        <table BORDER COLS=1 WIDTH="100%" class="tablebord zebra">
        <tr><td align="center">
        Select one or more Station Type(s)
        <BR>
        <INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER; font-weight: bold"  VALUE="PRIMARY TYPE                             SECONDARY TYPE" size="69"  onFocus="javascript:this.blur()">
        <BR>
        <FONT face="Courier">
        <SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
        <OPTION SELECTED  value="ALL">Select All_________________________________________________________');

      FOR cstype_var IN cstype
      LOOP
         HTP.formSelectOption (
            cstype_var.PRIMARY_TYPE || cstype_var.SECONDARY_TYPE,
            cattributes   => 'value= ' || cstype_var.PK_ISN);
      END LOOP;

      HTP.PRINT ('</SELECT>
        <BR>
        </TD>
        </TR>
        </TABLE>');

      -- Date range selection
      DW_COMP.date_select (15);

      -- Activity Medium selection
      DW_COMP.medium_select (39);

      -- Intent & Community Sampled selections
      DW_COMP.intent_community_select (39);

      -- Characteristics selection
      dw_comp.char_select (18, 'REGULAR', 'ON');

--CCB --2012-06-22: exclude & char_select advance
      HTP.PRINT (
         '<br>
        <center>
        <input type="button" value="Continue" tabindex=25 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
        <input type="button" value="Clear Form" tabindex=26 onclick="javascript: deleteAllFromCharList();deleteAllFromStationList();deleteAllFromOrgList(); deleteAllFromHucList(); document.forms[1].reset();" title="Clear the form">
        </center></form>
        ');
--CCB --2012-06-22: exclude & char_select advance
--      HTP.PRINT (
--         '<br>
--        <center>
--        <table COLS=2 WIDTH="100%" class="tablebord zebra">
--        <tr>
--           <td width="20%"></td>
--           <td align=center>
--           <table COLS=2 WIDTH="85%">
--           <tr>
--              <td style="border:0;border-width:0 0 0 0"><b>Submit Query</b></td>
--              <td style="border:0;border-width:0 0 0 0"><b><A HREF="javascript:openHelp(''http://www.epa.gov/storpubl/modern/doc/DW_storet_help.html#EXCLUDE'')">*EXCLUDE</A> Result Data Type(s): (Optional)</b></td>
--           </tr>
--           <tr>
--              <td valign="top" style="border:0;border-width:0 0 0 0"><p>
--              <div align="center">
--              <div class="searchCriteria">
--                   <input type="button" value="Continue" tabindex=47 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
--                   <input type="button" value="Clear Form" tabindex=48 onclick="javascript: deleteAllFromCharList();deleteAllFromStationList();deleteAllFromOrgList(); deleteAllFromHucList();document.forms[1].reset();" title="Clear the form">
--              </div>
--              </div>
--              </td>
--              <td style="border:0;border-width:0 0 0 0"><p>
--              <div align="center">
--              <div class="reportTypes">
--                <div class="reportCount-regular"><input type="checkbox" name="Reg_Exclude" value="YES" UNCHECKED">&nbsp;REGULAR,&nbsp;</div>
--                <div class="reportCount-biological"><input type="checkbox" name="Bio_Exclude" value="YES" UNCHECKED">&nbsp;BIOLOGICAL,&nbsp;</div>
--                <div class="reportCount-habitat"><input type="checkbox" name="Hab_Exclude" value="YES" UNCHECKED">&nbsp;HABITAT&nbsp;</div>
--                <div class="reportCount-metric"><input type="checkbox" name="Met_Exclude" value="YES" UNCHECKED>&nbsp;METRIC&nbsp;</div>
--              </div>
--              </div>    <div align="right">Advanced Users Only*</div>
--              </td></tr>
--           </table>
--        </table>
--        </center></form>
--        ');
--
      dw_comp.bottom (31);
   END stationcriteria;

   PROCEDURE resultcriteria
   AS
      --sug added the cursor station type
      CURSOR cstation_type
      IS
           SELECT primary_type,
                  secondary_type,
                  PK_ISN,
                  sort_order
             FROM DI_STATN_TYPES
         ORDER BY sort_order, primary_type, secondary_type;

      --- added the cursor for organization_type
      CURSOR corg_type
      IS
           SELECT ORGANIZATION_TYPE, PK_ISN, sort_order
             FROM DI_ORG_TYPES
         ORDER BY sort_order, ORGANIZATION_TYPE;

      --used to generate org list
      CURSOR corg
      IS
           SELECT ORGANIZATION_ID,
                  LTRIM (RTRIM (ORGANIZATION_NAME)) ORG_NAME,
                  PK_ISN
             FROM DI_ORG
         ORDER BY ORGANIZATION_ID;

      --used to generate state list
      CURSOR cstate
      IS
           SELECT pk_isn, state_name
             FROM DI_GEO_STATE
         ORDER BY country_code DESC, state_name;

      program_path   VARCHAR2 (1000) := NULL;
      image_path     VARCHAR2 (1000) := NULL;
      page_title     VARCHAR2 (100) := 'Results Download';
   BEGIN
      dw_comp.top (
         page_title,
         program_path,
         image_path,
         'adjust_width_n(document.forms[1].D_ORG_LIST,"~","30~70","None","N");adjust_width_n(document.forms[1].D_ORG_LIST2,"~","30~70","None","N");document.forms[1].reset();');
      HTP.PRINT ('<form action="dw_pages.resultquery_count" method=POST>');

      -- Geographic location selection
      dw_comp.geo_select;

      --- Organization Type Selection
      HTP.PRINT (
         '
        <h4>Organization, Station & Project</h4>
        <center>Select a single type of Organization search that you wish to perform (Organization Type, Organization(s), Station(s) or Project).
        Then enter the corresponding search criteria.
        </center>
        <table BORDER COLS=2 WIDTH="100%" class="tablebord zebra">
        <tr><td width="25%"><input checked type="radio" checked name="org_station_project_button" value="Organization Type" tabindex=51 onclick="javascript:document.forms[1].org_station_project_button[0].checked=true;">&nbsp;Select one or more<br>Organization Type(s)<br>(Option 1)
         </td>
        <td align="center">
        Select one or more Organization Type(s)
        <BR>

        <INPUT TYPE="TEXT" READONLY style="width:300px; font: 10pt/12pt COURIER; font-weight: bold"  VALUE="          ORGANIZATION TYPE" size="69"  onFocus="javascript:this.blur()">
        <BR>
        <FONT face="Courier">
        <SELECT NAME="D_ORGTYPE_LIST" SIZE="10"  tabindex=52 MULTIPLE style="width:300px; font: 10pt/12pt COURIER" onclick="javascript:document.forms[1].org_station_project_button[0].checked=true;">
        <OPTION SELECTED  value="ALL">Select All_________________________');

      FOR corgtype_var IN corg_type
      LOOP
         HTP.formSelectOption (
            corgtype_var.ORGANIZATION_TYPE,
            cattributes   => 'value= ' || corgtype_var.PK_ISN);
      END LOOP;

      HTP.PRINT ('</SELECT></FONT>
        <BR>
        </TD>
        </TR>');
      dw_comp.org_select (54);
      HTP.PRINT (
         '
        <TR>
        <td width="25%"><input type="radio" name="org_station_project_button" value="Organization and Station" tabindex=63 onClick="javascript:document.forms[1].org_station_project_button[2].checked=true;">&nbsp;Select and Search<br>Organization and Station<br>(Option 3)</td>
        <TD align="center">
        <center>Select an Organization and a Search Type, then enter a Search String and click "Search Stations".
        <br><br>
        <INPUT TYPE="TEXT" READONLY style="width: 645px; font-size: 10pt/12pt; font-family: Courier New, Courier, monospace; font-weight: bold"  VALUE="ORG ID                         ORGANIZATION NAME" size="81"  onFocus="javascript:document.forms[1].D_ORG_LIST.focus()">
        <font face="Courier, monospace"> <br>
        <select name="D_ORG_LIST" tabindex="64" size="1" style="width: 650px; font: 10pt/12pt COURIER" onChange="javascript:document.forms[1].as_extref.value=''STANDARD'';document.forms[1].D_EXTREF_LIST.value=0; document.forms[1].org_station_project_button[2].checked=true;">
        <OPTION SELECTED  value="0">Select an Organization________________________________________________________');

      FOR org IN corg
      LOOP
         HTP.formSelectOption (
            org.organization_id || '~' || SUBSTR (org.org_name, 0, 50),
            cattributes   => 'VALUE=' || org.pk_isn);
      END LOOP;

      HTP.PRINT (
         '</SELECT></font></center>
        <table width="50%">
        <tr>
        <td align=left WIDTH="70%" style="border:0;border-width:0 0 0 0"><br><B>Search Type</B>
        <br>&nbsp &nbsp &nbsp<input checked type=radio name="searchtype" tabindex="65" value="ID" onclick="javascript: document.forms[1].org_station_project_button[2].checked=true;" > Search by Station ID
        <BR>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="66" value="Name" onclick="javascript: document.forms[1].org_station_project_button[2].checked=true;"> Search by Station Name
        <br>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="67" value="Ref" onclick="javascript: document.forms[1].org_station_project_button[2].checked=true;"> Search by Station Alias
        <input type="hidden" name="D_EXTREF_LIST" value=0>
        <br>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
        Select Station Alias Type <input type="text" readonly value="STANDARD" name="as_extref" size="10" style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">
        <input type="button" tabindex="68" value="Look Up" onclick="javascript:document.forms[1].searchtype[2].checked=true;document.forms[1].org_station_project_button[2].checked=true;openWin(''extref''); document.forms[1].org_station_project_button[2].checked=true;" title="Opens a popup window for Station Alias Type selection">

        <hr align=left width="50%">
        <br><B>Search String </B>
        <input type=hidden name="v_station_names">
        <input type="text" name="as_station" tabindex="69" size="20" style="font: 10pt/12pt COURIER" maxlength="20" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;" >
        </td>
        </tr>
        <tr><td style="border:0;border-width:0 0 0 0"></td></tr>
        </table>
        <br><center><input type="button" tabindex="70" value="Search Stations" onclick="openWin(''station'')" title="Opens a popup window for Station selection">
        <br><br><font style="font-size: 9pt; font-family: Courier New, Courier, monospace"> <select multiple size="10" name="station_list" style="font-size: 8pt; font-family: Courier New, Courier, monospace" onclick="javascript:document.forms[1].org_station_project_button[2].checked=true;">
        <option>ORG ID &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;STATION ID  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ALIAS TYPE   &nbsp;&nbsp;&nbsp;STATION ALIAS    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;STATION NAME </option>
        <option value="dummy">________________________________________________________________________________________________________</option>
        </select></font>
        <br>
        <input type="button" tabindex="71" value="Clear Selected" onclick="javascript:deleteSelectedFromStationList();document.forms[1].org_station_project_button[2].checked=true;" title="Remove highlighted Stations from Selected List">
        <input type="button" tabindex="72" value="Clear All" onclick="javascript:deleteAllFromStationList();document.forms[1].org_station_project_button[2].checked=true;" title="Remove all Stations from the Selected List">
        </center>
        </td>
        </tr>
        <TR>
        <td width="25%"><input unchecked type="radio" name="org_station_project_button" value="Organization and Project" tabindex=83 onClick="javascript:document.forms[1].org_station_project_button[3].checked=true;">&nbsp;Select a Single<br>Organization and Project<br>(Option 4)</td>
        <TD align="center">
        <b>Step 1:</b> Select a Single Organization from the List
        <br>
        <INPUT TYPE="TEXT" READONLY style="width: 645px; font-size: 10pt/12pt; font-family: Courier new, Courier, monospace; font-weight: bold"  VALUE="ORG ID                         ORGANIZATION NAME" size="81"  onFocus="javascript:document.forms[1].D_ORG_LIST2.focus()">
        <br>
        <font face="Courier, monospace">
        <select name="D_ORG_LIST2" size="1" style="width: 650px; font: 10pt/12pt COURIER" tabindex=81 onChange="javascript:document.forms[1].as_proj.value=''Select a Project'';document.forms[1].D_PROJ_LIST.value=0;document.forms[1].org_station_project_button[3].checked=true;">
        <option selected value="0"> Select an Organization________________________________________________________
         <option value="-1">All Organizations (National Projects)');

      FOR org IN corg
      LOOP
         HTP.formSelectOption (
            org.organization_id || '~' || SUBSTR (org.org_name, 0, 50),
            cattributes   => 'VALUE=' || org.pk_isn);
      END LOOP;

      -- project selection
      HTP.PRINT (
         '</SELECT></FONT>
        <br><br>
        <b>Step 2:</b> Select a Single Project by Clicking "Look Up"

        <br>
        <input type="text" readonly value="Select a Project" style="font-size: 10pt; font-family: Courier, monospace" name="as_proj" size="74" onclick="javascript:document.forms[1].org_station_project_button[3].checked=true;" onFocus="javascript:this.blur()">
        <input type="hidden" name="D_PROJ_LIST" value=0>
        <input type="button" value="Look Up" tabindex=82 onclick="openWin(''proj'')" title="Opens a popup window for Project selection">

        </td>
        </tr>
        </table>');
      -- sug added Station types
      -- Station Type selection

      HTP.PRINT (
         '<h4>Station Type</h4>
        <table BORDER COLS=1 WIDTH="100%" class="tablebord zebra">

        <tr><td align="center">
        Select one or more Station Type(s)
        <BR>
        <INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER; font-weight: bold"  VALUE="PRIMARY TYPE                             SECONDARY TYPE" size="69"  onFocus="javascript:this.blur()">
        <BR>
        <FONT face="Courier">
        <SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
        <OPTION SELECTED  value="ALL">Select All_________________________________________________________');

      FOR cstype_var IN cstation_type
      LOOP
         HTP.formSelectOption (
            cstype_var.PRIMARY_TYPE || cstype_var.SECONDARY_TYPE,
            cattributes   => 'value= ' || cstype_var.PK_ISN);
      END LOOP;

      HTP.PRINT ('</SELECT>
        <BR>
        </TD>
        </TR>
        </TABLE>');

      -- Date range selection
      DW_COMP.date_select (15);

      -- Activity Medium selection
      DW_COMP.medium_select (39);

      -- Intent & Community Sampled selections
      DW_COMP.intent_community_select (39);

      -- Characteristics selection
      DW_comp.char_select (41, 'BIOLOGICAL');

--CCB --2012-06-22: exclude
--                <div class="reportCount-metric"><input type="checkbox" name="Met_Exclude" value="YES" UNCHECKED>&nbsp;METRIC&nbsp;</div>
      HTP.PRINT (
         '
        <input type="hidden" name="RESULT_TYPE" value="ALLRESULTS">
        <input type="hidden" name="SOURCE_APP" value="FILTERPAGES">
        <br>
        <table COLS=2 WIDTH="100%" class="tablebord zebra">
        <tr>
           <td width="20%"></td>
           <td align=center>
           <table COLS=2 WIDTH="85%">
           <tr>
              <td style="border:0;border-width:0 0 0 0"><b>Submit Query</b></td>
              <td style="border:0;border-width:0 0 0 0"><b><A HREF="javascript:openHelp(''http://www.epa.gov/storpubl/modern/doc/DW_storet_help.html#EXCLUDE'')">*EXCLUDE</A> Report Count(s): (Optional)</b></td>
           </tr>
           <tr>
              <td valign="top" style="border:0;border-width:0 0 0 0"><p>
              <div align="center">
              <div class="searchCriteria">
                   <input type="button" value="Continue" tabindex=47 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
                   <input type="button" value="Clear Form" tabindex=48 onclick="javascript: deleteAllFromCharList();deleteAllFromStationList();deleteAllFromOrgList(); deleteAllFromHucList();document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
              </div>
              </div>
              </td>
              <td style="border:0;border-width:0 0 0 0"><p>
              <div align="center">
              <div class="reportTypes">
                <div class="reportCount-regular"><input type="checkbox" name="Reg_Exclude" value="YES" UNCHECKED">&nbsp;REGULAR,&nbsp;</div>
                <div class="reportCount-biological"><input type="checkbox" name="Bio_Exclude" value="YES" UNCHECKED">&nbsp;BIOLOGICAL,&nbsp;</div>
                <div class="reportCount-habitat"><input type="checkbox" name="Hab_Exclude" value="YES" UNCHECKED">&nbsp;HABITAT&nbsp;</div>
                <div class="reportCount-metric"><input type="checkbox" name="Met_Exclude" value="YES" UNCHECKED>&nbsp;METRIC&nbsp;</div>
              </div>
              </div>    <div align="right">Advanced Users Only*</div>
              </td></tr>
           </table>
        </table>
        </form>
        ');
      dw_comp.bottom (21);
   END resultcriteria;

   PROCEDURE resultquery_count (
      geographic                    CHAR DEFAULT NULL,
      org_station_project_button    CHAR DEFAULT NULL,
      as_multiple_state             OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_state                      NUMBER DEFAULT 0,
      as_county                     CHAR DEFAULT 'ALL',
      v_county_code                 CHAR DEFAULT 'ALL',
      v_org_names                   CHAR DEFAULT NULL,
      max_lat_dd                    NUMBER DEFAULT 90,
      dir_maxlat                    CHAR DEFAULT NULL,
      min_long_dd                   NUMBER DEFAULT 180,
      dir_minlong                   CHAR DEFAULT NULL,
      max_long_dd                   NUMBER DEFAULT 0,
      dir_maxlong                   CHAR DEFAULT NULL,
      min_lat_dd                    NUMBER DEFAULT 0,
      dir_minlat                    CHAR DEFAULT NULL,
      as_huc                        OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      v_huc_code                    CHAR DEFAULT 'ALL',
      d_stype_list                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_orgtype_list                OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_org_name_list               OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      from_mon1                     CHAR DEFAULT 'JAN',
      from_dd1                      NUMBER DEFAULT 1,
      from_yyyy1                    NUMBER DEFAULT 1900,
      end_mon1                      CHAR DEFAULT TO_CHAR (SYSDATE, 'MON'),
      end_dd1                       NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE, 'DD')),
      end_yyyy1                     NUMBER DEFAULT TO_NUMBER (
                                                      TO_CHAR (SYSDATE,
                                                               'YYYY')),
      from_mon2                     CHAR DEFAULT 'DUMMY',
      from_dd2                      NUMBER DEFAULT 0,
      from_yyyy2                    NUMBER DEFAULT 0,
      end_mon2                      CHAR DEFAULT 'DUMMY',
      end_dd2                       NUMBER DEFAULT 0,
      end_yyyy2                     NUMBER DEFAULT 0,
      from_mon3                     CHAR DEFAULT 'DUMMY',
      from_dd3                      NUMBER DEFAULT 0,
      from_yyyy3                    NUMBER DEFAULT 0,
      end_mon3                      CHAR DEFAULT 'DUMMY',
      end_dd3                       NUMBER DEFAULT 0,
      end_yyyy3                     NUMBER DEFAULT 0,
      from_mon4                     CHAR DEFAULT 'DUMMY',
      from_dd4                      NUMBER DEFAULT 0,
      from_yyyy4                    NUMBER DEFAULT 0,
      end_mon4                      CHAR DEFAULT 'DUMMY',
      end_dd4                       NUMBER DEFAULT 0,
      end_yyyy4                     NUMBER DEFAULT 0,
      v_char_names                  CHAR DEFAULT NULL,
      as_char                       CHAR DEFAULT NULL,
      as_org                        CHAR DEFAULT NULL,
      as_char_alias_type            NUMBER DEFAULT 0,
      char_list                     OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      org_list                      OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      taxon_filter                  CHAR DEFAULT 'ON',
      d_org_list                    NUMBER DEFAULT 0,
      d_org_list2                   NUMBER DEFAULT 0,
      d_proj_list                   NUMBER DEFAULT 0,
      as_proj                       CHAR DEFAULT NULL,
      v_station_names               CHAR DEFAULT NULL,
      as_station                    CHAR DEFAULT 'dummy',
      station_list                  OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      as_extref                     CHAR DEFAULT NULL,
      d_extref_list                 NUMBER DEFAULT 0,
      d_medium_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_intent_list                 OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      d_community_list              OWA_UTIL.ident_arr DEFAULT DW_glob_var.empty,
      searchtype                    CHAR DEFAULT NULL,
      result_type                   CHAR DEFAULT 'REGULAR',
--CCB --2012-06-22: exclude & char_select advance
      char_filter                   CHAR DEFAULT NULL,
      Reg_Exclude                   CHAR DEFAULT NULL,
      Bio_Exclude                   CHAR DEFAULT NULL,
      Hab_Exclude                   CHAR DEFAULT NULL,
      Met_Exclude                   CHAR DEFAULT NULL,
      source_app                    VARCHAR2 DEFAULT 'WATERSHED',
      in_chartype_list              VARCHAR2 DEFAULT 'ALL',
      in_chartype_names             VARCHAR2 DEFAULT 'ALL')
   AS
      v_extref_list              VARCHAR2 (500);
      v_extref_name              VARCHAR2 (500);
      v_extref_name_list         VARCHAR2 (1000);
      v_extref                   VARCHAR2 (120);
      v_char_flag                BOOLEAN := FALSE;
      v_CursorID                 INTEGER;
      v_SelectStmt               VARCHAR2 (1000);
      v_FromStmt                 VARCHAR2 (1000);
      v_WhereStmt                VARCHAR2 (3000);
      v_SQLStmt                  VARCHAR2 (5000);
      v_Dummy                    INTEGER;
      v_ResultCount              NUMBER;
      v_stype_list               VARCHAR2 (500);
      v_orgtype_list             VARCHAR2 (500);
      v_StateName                VARCHAR2 (40);
      v_state_list               VARCHAR2 (500);
      v_state_name_list          VARCHAR2 (3000);
      v_huc_list                 VARCHAR2 (500);
      v_HUC_isn                  NUMBER;
      v_huc_name_list            VARCHAR2 (1000);
      v_orgtype_name_list        VARCHAR2 (1000);
      v_Multiple_StateName       VARCHAR2 (5000);
      v_stype_name_list          VARCHAR2 (3000);
      v_stype_name               VARCHAR2 (100);
      v_orgtype_name             VARCHAR2 (100);
      v_ORGTYPE_name_WHERElist   VARCHAR2 (1000);
      v_char_list                VARCHAR2 (2000);
      v_org_list2                VARCHAR2 (2000);
      v_station_list             VARCHAR2 (2000);
      v_org_list                 VARCHAR2 (500);
      v_org_id                   VARCHAR2 (100);
      v_org_id_list              VARCHAR2 (1000);
      v_proj_list                VARCHAR2 (500);
      v_begin_date1              DATE;
      v_end_date1                DATE;
      v_begin_date2              DATE;
      v_end_date2                DATE;
      v_begin_date3              DATE;
      v_end_date3                DATE;
      v_begin_date4              DATE;
      v_end_date4                DATE;
      v_fk_begin_date            NUMBER (12, 0);
      v_fk_end_date              NUMBER (12, 0);
      v_bio_flag                 BOOLEAN := FALSE;
--CCB --2012-06-22: metrics
      v_met_flag                 BOOLEAN := FALSE;
      v_date_flag                BOOLEAN := FALSE;
      v_medium_flag              BOOLEAN := FALSE;
      v_proj_flag                BOOLEAN := FALSE;
      v_curr_date                VARCHAR2 (11)
                                    := TO_CHAR (SYSDATE, 'DD-MON-YYYY');
      v_maxlat                   NUMBER := ABS (max_lat_dd);
      v_minlat                   NUMBER := ABS (min_lat_dd);
      v_maxlong                  NUMBER := ABS (max_long_dd);
      v_minlong                  NUMBER := ABS (min_long_dd);
      v_medium_list              VARCHAR2 (500);
      v_medium_isn_list          VARCHAR2 (50);
      v_medium                   VARCHAR2 (20);
      v_intent_isn_list          VARCHAR2 (50);
      v_intent_list              VARCHAR2 (200);
      v_intent                   VARCHAR2 (20);
      v_community_isn_list       VARCHAR2 (50);
      v_community_list           VARCHAR2 (500);
      v_community                VARCHAR2 (30);
      v_rule_optimization        VARCHAR2 (10) := 'FALSE';
      report_Type                VARCHAR2 (30) := NULL;
      program_path               VARCHAR2 (1000) := NULL;
      image_path                 VARCHAR2 (1000) := NULL;
      page_title                 VARCHAR2 (100) := 'Result Search Summary';

      v_num_repElement           NUMBER;
      v_repElement_count         NUMBER := 0;

      help_file                  VARCHAR2 (100);

      v_filters                  VARCHAR2 (32000) := ''; -- ~ is the delimiter for dw_record_data_request
      v_parameters               VARCHAR2 (32000) := '';

      -- Variables for National Projects
      proj_cd                    VARCHAR2 (256) := NULL;
      proj_nm                    VARCHAR2 (256) := NULL;

      -- WSHed summary variables
      vR_SelectStmt              VARCHAR2 (1000);
      vR_FromStmt                VARCHAR2 (1000);
      vR_WhereStmt               VARCHAR2 (3000);
      vR_SQLStmt                 VARCHAR2 (5000);
      vR_ResultCount             NUMBER := 0;

      vB_SelectStmt              VARCHAR2 (1000);
      vB_FromStmt                VARCHAR2 (1000);
      vB_WhereStmt               VARCHAR2 (3000);
      vB_SQLStmt                 VARCHAR2 (5000);
      vB_ResultCount             NUMBER := 0;

      vH_SelectStmt              VARCHAR2 (1000);
      vH_FromStmt                VARCHAR2 (1000);
      vH_WhereStmt               VARCHAR2 (3000);
      vH_SQLStmt                 VARCHAR2 (5000);
      vH_ResultCount             NUMBER := 0;

--CCB --2012-06-22: metrics
      vM_SelectStmt              VARCHAR2 (2000);  -- METRIC COLUMNS REPORTED
      vM_FromStmt                VARCHAR2 (1000);
      vM_WhereStmt               VARCHAR2 (3000);
      vM_SQLStmt                 VARCHAR2 (5000);
      vM_ResultCount             NUMBER := 0;
--
      vmin_ResultCount           NUMBER;


      CURSOR cALLRepElement
      IS
           SELECT DISTINCT ELEMENT_NAME,
                           ALL_REPORT_NUMBER,
                           ALL_ELEMENT_DEFAULT,
                           HELP_LINK
             FROM APP_COLUMN_NAME
            WHERE ALL_REPORT_NUMBER IS NOT NULL
         ORDER BY ALL_REPORT_NUMBER;

      --Cursor retreives National and Non-National Projects
      CURSOR nat_proj_list
      IS
         SELECT A.pk_isn, A.project_cd, ORG.organization_id
           FROM di_project A, di_org ORG
          WHERE     ORG.pk_isn = A.fk_org
                AND A.project_cd = (SELECT B.project_cd
                                      FROM di_project B
                                     WHERE B.pk_isn = D_PROJ_LIST);

      CURSOR proj_list
      IS
         SELECT A.pk_isn, A.project_cd, ORG.organization_id
           FROM di_project A, di_org ORG
          WHERE ORG.pk_isn = A.fk_org AND A.pk_isn = D_PROJ_LIST;

      PROCEDURE get_date_isn (v_begin_date DATE, v_end_date DATE)
      IS
      BEGIN
         SELECT pk_isn
           INTO v_fk_begin_date
           FROM DI_DATE
          WHERE full_date = v_begin_date;

         SELECT pk_isn
           INTO v_fk_end_date
           FROM DI_DATE
          WHERE full_date = v_end_date;
      END;
   BEGIN
      vR_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
      vB_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
      vH_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
--CCB --2012-06-22: metrics
      vM_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
--

      vR_FromStmt := 'FROM FA_REGULAR_RESULT FA';
      vB_FromStmt := 'FROM FA_BIOLOGICAL_RESULT FA';
      vH_FromStmt := 'FROM FA_HABITAT_RESULT FA';
--CCB --2012-06-22: metrics
      vM_FromStmt := 'FROM FA_ACTIVITY_METRIC FA';
--

      vR_WhereStmt := ' WHERE 1=1';
      vB_WhereStmt := ' WHERE 1=1';
      vH_WhereStmt := ' WHERE 1=1';
--CCB --2012-06-22: metrics
      vM_WhereStmt := ' WHERE 1=1';
--

--CCB --2012-06-22: exclude* 9=0 by user request, 1=0 by filter
      IF Reg_Exclude = 'YES'
      THEN
         vR_WhereStmt := ' WHERE 9=0';
      END IF;
      IF Bio_Exclude = 'YES'
      THEN
         vB_WhereStmt := ' WHERE 9=0';
      END IF;
      IF Hab_Exclude = 'YES'
      THEN
         vH_WhereStmt := ' WHERE 9=0';
      END IF;
      IF Met_Exclude = 'YES'
      THEN
         vM_WhereStmt := ' WHERE 9=0';
      END IF;
--

      --Generate WHERE statement based on geographic search type
      IF geographic = 'StateCounty'
      THEN
         IF as_state <> 0
         THEN
            SELECT state_name
              INTO v_StateName
              FROM di_geo_state
             WHERE pk_isn = as_state;

            IF v_County_Code <> 'ALL'
            THEN
               vR_WhereStmt :=
                     vR_WhereStmt
                  || ' AND FA.fk_geo_county IN ('
                  || dw_util.check_input (v_County_Code)
                  || ')';
               vB_WhereStmt :=
                     vB_WhereStmt
                  || ' AND FA.fk_geo_county IN ('
                  || dw_util.check_input (v_County_Code)
                  || ')';
               vH_WhereStmt :=
                     vH_WhereStmt
                  || ' AND FA.fk_geo_county IN ('
                  || dw_util.check_input (v_County_Code)
                  || ')';
--CCB --2012-06-22: metrics
               vM_WhereStmt :=
                     vM_WhereStmt
                  || ' AND FA.fk_geo_county IN ('
                  || dw_util.check_input (v_County_Code)
                  || ')';
--
            ELSE
               vR_WhereStmt :=
                     vR_WhereStmt
                  || ' AND FA.fk_geo_state = '
                  || dw_util.check_input (as_state);
               vB_WhereStmt :=
                     vB_WhereStmt
                  || ' AND FA.fk_geo_state = '
                  || dw_util.check_input (as_state);
               vH_WhereStmt :=
                     vH_WhereStmt
                  || ' AND FA.fk_geo_state = '
                  || dw_util.check_input (as_state);
--CCB --2012-06-22: metrics
               vM_WhereStmt :=
                     vM_WhereStmt
                  || ' AND FA.fk_geo_state = '
                  || dw_util.check_input (as_state);
--
            END IF;
         END IF;
      ELSIF geographic = 'multipleStates'
      THEN
         IF as_multiple_state.LAST > 0
         THEN
            IF as_multiple_state (1) <> 0
            THEN
               FOR j IN 1 .. as_multiple_state.LAST
               LOOP
                  v_state_list := v_state_list || as_multiple_state (j) || ',';

                  SELECT state_name
                    INTO v_Multiple_StateName
                    FROM di_geo_state
                   WHERE pk_isn = as_multiple_state (j);

                  v_state_name_list :=
                     v_state_name_list || v_Multiple_StateName || '<br>';
               END LOOP;

               v_state_list := RTRIM (v_state_list, ',');

               vR_WhereStmt :=
                     vR_WhereStmt
                  || ' AND FA.fk_geo_state IN ('
                  || dw_util.check_input (v_state_list)
                  || ')';
               vB_WhereStmt :=
                     vB_WhereStmt
                  || ' AND FA.fk_geo_state IN ('
                  || dw_util.check_input (v_state_list)
                  || ')';
               vH_WhereStmt :=
                     vH_WhereStmt
                  || ' AND FA.fk_geo_state IN ('
                  || dw_util.check_input (v_state_list)
                  || ')';
--CCB --2012-06-22: metrics
               vM_WhereStmt :=
                     vM_WhereStmt
                  || ' AND FA.fk_geo_state IN ('
                  || dw_util.check_input (v_state_list)
                  || ')';
--
            ELSE
               v_state_name_list := 'ALL';
            END IF;
         END IF;
      ELSIF geographic = 'HUC'
      THEN
         IF as_huc.LAST > 1
         THEN
            IF as_huc (1) <> 'ALL'
            THEN
               FOR j IN 2 .. as_huc.LAST
               LOOP
                  v_huc_name_list := v_huc_name_list || as_huc (j) || '<br>';

                  SELECT pk_isn
                    INTO v_HUC_isn
                    FROM di_db_cat
                   WHERE HYDROLOGIC_UNIT_CODE = as_huc (j);

                  v_huc_list := v_huc_list || v_HUC_isn || ',';
               END LOOP;

               v_huc_list := RTRIM (v_huc_list, ',');

--CCB --2012-07-10 Correct fk_gen_db_cat in FACT Tables: FA_BIO, REG, HAB, MET
--               vR_WhereStmt :=
--                     vR_WhereStmt
--                  || ' AND FA.fk_gen_db_cat IN ('
--                  || dw_util.check_input (v_huc_list)
--                  || ')';
               vR_WhereStmt :=
                     vR_WhereStmt
                  || ' AND fk_station IN (select pk_isn from storetw.fa_station where fk_gen_db_cat IN ('
                  || dw_util.check_input (v_huc_list)
                  || '))';
               vB_WhereStmt :=
                     vB_WhereStmt
                  || ' AND fk_station IN (select pk_isn from storetw.fa_station where fk_gen_db_cat IN ('
                  || dw_util.check_input (v_huc_list)
                  || '))';
               vH_WhereStmt :=
                     vH_WhereStmt
                  || ' AND fk_station IN (select pk_isn from storetw.fa_station where fk_gen_db_cat IN ('
                  || dw_util.check_input (v_huc_list)
                  || '))';
--CCB --2012-06-22: metrics
               vM_WhereStmt :=
                     vM_WhereStmt
                  || ' AND fk_station IN (select pk_isn from storetw.fa_station where fk_gen_db_cat IN ('
                  || dw_util.check_input (v_huc_list)
                  || '))';
--
            ELSE
               v_huc_name_list := 'ALL';
            END IF;
         END IF;
      ELSIF geographic = 'LatLong'
      THEN
         IF     MAX_LAT_DD = 90
            AND MIN_LONG_DD = 180
            AND MAX_LONG_DD = 0
            AND MIN_LAT_DD = 0
            AND dir_maxlat = 'NORTH'
            AND dir_minlat = 'NORTH'
            AND dir_maxlong = 'WEST'
            AND dir_minlong = 'WEST'
         THEN
            NULL;
         ELSE
            IF dir_maxlong = 'WEST'
            THEN
               v_maxlong := -1 * v_maxlong;
            END IF;

            IF dir_minlong = 'WEST'
            THEN
               v_minlong := -1 * v_minlong;
            END IF;

            IF dir_maxlat = 'SOUTH'
            THEN
               v_maxlat := -1 * v_maxlat;
            END IF;

            IF dir_minlat = 'SOUTH'
            THEN
               v_minlat := -1 * v_minlat;
            END IF;

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND stn_latitude BETWEEN '
               || v_minlat
               || ' AND '
               || v_maxlat
               || ' AND
                    stn_longitude BETWEEN '
               || v_minlong
               || ' AND '
               || v_maxlong;
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND stn_latitude BETWEEN '
               || v_minlat
               || ' AND '
               || v_maxlat
               || ' AND
                    stn_longitude BETWEEN '
               || v_minlong
               || ' AND '
               || v_maxlong;
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND stn_latitude BETWEEN '
               || v_minlat
               || ' AND '
               || v_maxlat
               || ' AND
                    stn_longitude BETWEEN '
               || v_minlong
               || ' AND '
               || v_maxlong;
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND stn_latitude BETWEEN '
               || v_minlat
               || ' AND '
               || v_maxlat
               || ' AND
                    stn_longitude BETWEEN '
               || v_minlong
               || ' AND '
               || v_maxlong;
--
         END IF;
      END IF;

      IF org_station_project_button = 'Organization Type'
      THEN
         -- Table storetw.DI_ORG_TYPES organization type , storetw.LU_ORGTYPE   organization type ASSIGNMENT  TO organization unique identifier
         IF D_ORGTYPE_LIST.LAST > 0
         THEN
            IF D_ORGTYPE_LIST (1) <> 'ALL'
            THEN
               FOR i IN 1 .. d_ORGTYPE_list.LAST
               LOOP
                  -- concatenate a list of org types by unique identifier
                  v_ORGTYPE_list :=
                     v_ORGTYPE_list || d_ORGTYPE_list (i) || ',';

                  -- LIST organization types
                  SELECT ORGANIZATION_TYPE
                    INTO v_ORGTYPE_name
                    FROM DI_ORG_TYPES
                   WHERE PK_ISN = d_ORGTYPE_list (i);

                  -- concatenate a list of org types by name for query summary
                  v_ORGTYPE_name_list :=
                     v_ORGTYPE_name_list || v_ORGTYPE_name || '<br>';
                  v_ORGTYPE_name_WHERElist :=
                        v_ORGTYPE_name_WHERElist
                     || ''''
                     || RTRIM (v_ORGTYPE_name)
                     || ''''
                     || ',';
               END LOOP;

               -- CLEANUP trailing comma from concatenated list of org types
               v_ORGTYPE_list := RTRIM (v_ORGTYPE_list, ',');
               v_ORGTYPE_name_WHERElist :=
                  RTRIM (v_ORGTYPE_name_WHERElist, ',');

               --vR_FromStmt := vR_FromStmt || ',LU_ORGTYPE OT';
               --vB_FromStmt := vB_FromStmt || ',LU_ORGTYPE OT';
               --vH_FromStmt := vH_FromStmt || ',LU_ORGTYPE OT';

               vR_WhereStmt :=
                     vR_WhereStmt
                  || ' AND FA.FK_ORG IN (select fk_ORG from LU_ORGTYPE where fk_ORG_type IN ('
                  || dw_util.check_input (v_ORGtype_list)
                  || '))';
               vB_WhereStmt :=
                     vB_WhereStmt
                  || ' AND FA.FK_ORG IN (select fk_ORG from LU_ORGTYPE where fk_ORG_type IN ('
                  || dw_util.check_input (v_ORGtype_list)
                  || '))';
               vH_WhereStmt :=
                     vH_WhereStmt
                  || ' AND FA.FK_ORG IN (select fk_ORG from LU_ORGTYPE where fk_ORG_type IN ('
                  || dw_util.check_input (v_ORGtype_list)
                  || '))';
--CCB --2012-06-22: metrics
               vM_WhereStmt :=
                     vM_WhereStmt
                  || ' AND FA.FK_ORG IN (select fk_ORG from LU_ORGTYPE where fk_ORG_type IN ('
                  || dw_util.check_input (v_ORGtype_list)
                  || '))';
--
            ELSE
               v_ORGTYPE_name_list := 'ALL';
            END IF;
         END IF;
      ELSIF org_station_project_button = 'Organization Name'
      THEN
         IF org_list.LAST > 1
         THEN
            FOR i IN 2 .. org_list.LAST
            LOOP
               v_org_list2 := v_org_list2 || org_list (i) || ',';

               SELECT organization_id
                 INTO v_org_id
                 FROM DI_ORG
                WHERE PK_ISN = org_list (i);

               v_org_id_list := v_org_id_list || v_org_id || '<br>';
            END LOOP;

            v_org_list2 := RTRIM (v_org_list2, ',');

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fk_org IN ('
               || dw_util.check_input (v_org_list2)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_org IN ('
               || dw_util.check_input (v_org_list2)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND fk_org IN ('
               || dw_util.check_input (v_org_list2)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_org IN ('
               || dw_util.check_input (v_org_list2)
               || ')';
--
         END IF;
      ELSIF    org_station_project_button = 'Organization and Station'
            OR org_station_project_button IS NULL
      THEN
         IF     D_ORG_LIST <> 0
            AND D_PROJ_LIST = 0
            AND (station_list.LAST <= 1 OR station_list.COUNT = 0)
         THEN
            V_ORG_LIST := D_ORG_LIST;

            SELECT organization_id
              INTO v_org_id
              FROM DI_ORG
             WHERE PK_ISN = d_org_list;

            v_org_id_list := v_org_id_list || v_org_id || '<br>';

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
--
         END IF;

         --Process Station list and add to WHERE statement if filtering. Loop starts at 2 to
         --ignore dummy value that is passed. Dummy is used to maintain column width.
         IF station_list.LAST > 1
         THEN
            FOR i IN 2 .. station_list.LAST
            LOOP
               v_station_list := v_station_list || station_list (i) || ',';
            END LOOP;

            v_station_list := RTRIM (v_station_list, ',');

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fk_station IN ('
               || dw_util.check_input (v_station_list)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_station IN ('
               || dw_util.check_input (v_station_list)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND fk_station IN ('
               || dw_util.check_input (v_station_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_station IN ('
               || dw_util.check_input (v_station_list)
               || ')';
--
         END IF;

         --URL variable v_extref=EPABEACH
         --2011-11-07 StationAliasType
         --Process StationAliasType list and add to WHERE statement if filtering.
         v_extref := d_extref_list;

         IF     D_EXTREF_LIST <> 0
            AND (station_list.LAST <= 1 OR station_list.COUNT = 0)
         THEN
            V_EXTREF_LIST := D_EXTREF_LIST;
            V_EXTREF := D_EXTREF_LIST;

            SELECT REF_SCHEME_ACRONYM
              INTO v_extref_name
              FROM LU_EXTERNAL_REF_SCHEME
             WHERE PK_ISN = d_extref_list;

            v_extref_name := v_extref_name || '<br>';
            v_extref_name_list := v_extref_name || '<br>';
            v_org_id_list := v_org_id || '<br>';

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('
               || dw_util.check_input (v_extref_list)
               || '))';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('
               || dw_util.check_input (v_extref_list)
               || '))';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('
               || dw_util.check_input (v_extref_list)
               || '))';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('
               || dw_util.check_input (v_extref_list)
               || '))';
--
         END IF;
      ELSIF    org_station_project_button = 'Organization and Project'
            OR org_station_project_button IS NULL
      THEN
         IF     D_ORG_LIST2 <> 0
            AND D_PROJ_LIST = 0
            AND (station_list.LAST <= 1 OR station_list.COUNT = 0)
         THEN
            V_ORG_LIST := D_ORG_LIST2;

            SELECT organization_id
              INTO v_org_id
              FROM DI_ORG
             WHERE PK_ISN = d_org_list2;

            v_org_id_list := v_org_id_list || v_org_id || '<br>';

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fa.fk_org IN ('
               || dw_util.check_input (v_org_list)
               || ')';
--
         END IF;

         IF D_PROJ_LIST <> 0
         THEN
            -- National and Non-National Projects flow through same logic.
            v_proj_list := '';

            IF D_ORG_LIST <= -1
            THEN
               FOR nat_proj IN nat_proj_list
               LOOP
                  v_proj_list := v_proj_list || ',' || nat_proj.pk_isn;
               --v_org_id_list :=
               --   v_org_id_list || nat_proj.organization_id || '<br>';
               END LOOP;
            ELSE
               FOR nat_proj IN proj_list
               LOOP
                  v_proj_list := v_proj_list || ',' || nat_proj.pk_isn;
               --v_org_id_list :=
               --   v_org_id_list || nat_proj.organization_id || '<br>';
               END LOOP;
            END IF;

            v_proj_list := LTRIM (v_proj_list, ',');

            -- National and Non-National Projects should have only 1 project code.  Value as_proj carries in
            -- project name 'National Project' for national projects.  Variable proj_cd replaces as_proj with project code
            -- concatenated with Project name.
            SELECT project_name
              INTO proj_nm
              FROM di_project
             WHERE pk_isn = D_PROJ_LIST;

            IF INSTR (v_proj_list, ',') <> 0
            THEN
               proj_nm := 'National Project (e.g., ' || proj_nm || ')';
            END IF;

            SELECT project_cd
              INTO proj_cd
              FROM di_project
             WHERE pk_isn = D_PROJ_LIST;

            proj_cd := proj_cd || ' - ' || proj_nm;

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND FA.pk_isn IN (select fk_result from regular_result_project where fk_project = '
               || dw_util.check_input (v_proj_list)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND FA.pk_isn IN (select fk_result from biological_result_project where fk_project = '
               || dw_util.check_input (v_proj_list)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND FA.pk_isn IN (select fk_result from habitat_result_project where fk_project = '
               || dw_util.check_input (v_proj_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND FA.pk_isn IN (select fk_result from metric_result_project where fk_project = '
               || dw_util.check_input (v_proj_list)
               || ')';
-- New Table:  STORETW.METRIC_RESULT_PROJECT.sql
--
            v_proj_flag := TRUE;
         END IF;
      END IF;

      --*********
      --sug added station type list [STATION TYPE]
      --Process station type list and add to WHERE statement if filtering
      IF D_STYPE_LIST.LAST > 0
      THEN
         IF D_STYPE_LIST (1) <> 'ALL'
         THEN
            FOR i IN 1 .. d_stype_list.LAST
            LOOP
               v_stype_list := v_stype_list || d_stype_list (i) || ',';

               SELECT DECODE (secondary_type,
                              NULL, primary_type,
                              primary_type || '-' || secondary_type)
                 INTO v_stype_name
                 FROM DI_STATN_TYPES
                WHERE PK_ISN = d_stype_list (i);

               v_stype_name_list :=
                  v_stype_name_list || v_stype_name || '<br>';
            END LOOP;

            v_stype_list := RTRIM (v_stype_list, ',');

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND FA.fk_statn_types IN ('
               || dw_util.check_input (v_stype_list)
               || ')';
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND FA.fk_statn_types IN ('
               || dw_util.check_input (v_stype_list)
               || ')';
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND FA.fk_statn_types IN ('
               || dw_util.check_input (v_stype_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND FA.fk_statn_types IN ('
               || dw_util.check_input (v_stype_list)
               || ')';
--
         ELSE
            v_stype_name_list := 'ALL';
         END IF;
      END IF;

      IF RESULT_TYPE = 'ALLRESULTS' AND source_app = 'WATERSHED'
      THEN
         NULL;
      ELSE
         --Generate WHERE statement based on DATE ranges
         v_begin_date1 :=
            TO_DATE (from_dd1 || '-' || from_mon1 || '-' || from_yyyy1,
                     'DD-MON-YYYY');
         v_end_date1 :=
            TO_DATE (end_dd1 || '-' || end_mon1 || '-' || end_yyyy1,
                     'DD-MON-YYYY');

         IF     v_begin_date1 = TO_DATE ('01-JAN-1900', 'DD-MON-YYYY')
            AND v_end_date1 = v_curr_date
            AND from_mon2 = 'DUMMY'
            AND end_mon2 = 'DUMMY'
            AND from_mon3 = 'DUMMY'
            AND end_mon3 = 'DUMMY'
            AND from_mon4 = 'DUMMY'
            AND end_mon4 = 'DUMMY'
         THEN
            NULL;
         ELSE
            get_date_isn (v_begin_date1, v_end_date1);
--ccb --2012-08-02 Activity Start dates NULL outside year (1900 thru 2050)
            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND (fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND (fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' AND (fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND (fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--

            v_date_flag := TRUE;
         END IF;

         IF from_mon2 <> 'DUMMY' AND end_mon2 <> 'DUMMY'
         THEN
            v_begin_date2 :=
               TO_DATE (from_dd2 || '-' || from_mon2 || '-' || from_yyyy2,
                        'DD-MON-YYYY');
            v_end_date2 :=
               TO_DATE (end_dd2 || '-' || end_mon2 || '-' || end_yyyy2,
                        'DD-MON-YYYY');
            get_date_isn (v_begin_date2, v_end_date2);

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--
         END IF;

         IF from_mon3 <> 'DUMMY' AND end_mon3 <> 'DUMMY'
         THEN
            v_begin_date3 :=
               TO_DATE (from_dd3 || '-' || from_mon3 || '-' || from_yyyy3,
                        'DD-MON-YYYY');
            v_end_date3 :=
               TO_DATE (end_dd3 || '-' || end_mon3 || '-' || end_yyyy3,
                        'DD-MON-YYYY');
            get_date_isn (v_begin_date3, v_end_date3);

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--
         END IF;

         IF from_mon4 <> 'DUMMY' AND end_mon4 <> 'DUMMY'
         THEN
            v_begin_date4 :=
               TO_DATE (from_dd4 || '-' || from_mon4 || '-' || from_yyyy4,
                        'DD-MON-YYYY');
            v_end_date4 :=
               TO_DATE (end_dd4 || '-' || end_mon4 || '-' || end_yyyy4,
                        'DD-MON-YYYY');
            get_date_isn (v_begin_date4, v_end_date4);

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vB_WhereStmt :=
                  vB_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
            vH_WhereStmt :=
                  vH_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' OR fk_date_act_start BETWEEN '
               || v_fk_begin_date
               || ' AND '
               || v_fk_end_date;
--
         END IF;
      END IF;

--CCB --2012-06-22: metrics (corrected 07-30-2012)
      IF v_date_flag = TRUE
      THEN
         vR_WhereStmt := vR_WhereStmt || ')';
         vB_WhereStmt := vB_WhereStmt || ')';
         vH_WhereStmt := vH_WhereStmt || ')';
         vM_WhereStmt := vM_WhereStmt || ')';
      END IF;

      --Process characteristic list and add to WHERE statement if filtering. Loop starts at 2 to
      --ignore dummy value that is passed. Dummy is used to maintain column width.
      IF char_list.LAST > 1
      THEN
         FOR i IN 2 .. char_list.LAST
         LOOP
            v_char_list := v_char_list || char_list (i) || ',';
         END LOOP;

         v_char_list := RTRIM (v_char_list, ',');

--CCB --2012-06-22: char_select advance + DUPLICATE characteristics selection --2012-08-24: CORRECTION distinct clause + dynamic sql
      IF char_filter = 'sample'
      THEN
         vR_WhereStmt :=
               vR_WhereStmt
            || ' AND source_uid IN (select DISTINCT source_uid '||vR_FromStmt||' '||vR_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || '))))';
         vB_WhereStmt :=
               vB_WhereStmt
            || ' AND source_uid IN (select DISTINCT source_uid '||vB_FromStmt||' '||vB_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || '))))';
         vH_WhereStmt :=
               vH_WhereStmt
            || ' AND source_uid IN (select DISTINCT source_uid '||vH_FromStmt||' '||vH_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || '))))';
      ELSE
--         vR_WhereStmt :=
--               vR_WhereStmt
--            || ' AND fk_char IN ('
--            || dw_util.check_input (v_char_list)
--            || ')';
--         vB_WhereStmt :=
--               vB_WhereStmt
--            || ' AND fk_char IN ('
--            || dw_util.check_input (v_char_list)
--            || ')';
--         vH_WhereStmt :=
--               vH_WhereStmt
--            || ' AND fk_char IN ('
--            || dw_util.check_input (v_char_list)
--            || ')';
--CCB --2012-06-22: char_select advance + DUPLICATE characteristics selection
         vR_WhereStmt :=
               vR_WhereStmt
            || ' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || ')))';
         vB_WhereStmt :=
               vB_WhereStmt
            || ' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || ')))';
         vH_WhereStmt :=
               vH_WhereStmt
            || ' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || ')))';
      END IF;
--CCB --2012-06-22: metrics* --2012-08-24: CORRECTION distinct clause + dynamic sql
         vM_WhereStmt :=
               vM_WhereStmt
            || ' AND source_act_uid IN (select DISTINCT source_act_uid '||vM_FromStmt||' '||vM_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
            || dw_util.check_input (v_char_list)
            || '))))';
--
         v_Char_Flag := TRUE;
      END IF;

      --Process Intent list and add to WHERE statement if filtering.
      IF d_intent_list.LAST > 0
      THEN
         IF d_intent_list (1) <> 'ALL'
         THEN
            v_bio_flag := TRUE;
--CCB --2012-06-22: metrics
            v_met_flag := TRUE;

            FOR i IN 1 .. d_intent_list.LAST
            LOOP
               v_intent_isn_list :=
                  v_intent_isn_list || d_intent_list (i) || ',';

               SELECT activity_intent
                 INTO v_intent
                 FROM di_activity_intent
                WHERE pk_isn = d_intent_list (i);

               v_intent_list := v_intent_list || v_intent || '<br>';
            END LOOP;

            v_intent_isn_list := RTRIM (v_intent_isn_list, ',');

            vR_WhereStmt := vR_WhereStmt || ' AND 1=0';
            vH_WhereStmt := vH_WhereStmt || ' AND 1=0';

            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_act_intent IN ('
               || dw_util.check_input (v_intent_isn_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_act_intent IN ('
               || dw_util.check_input (v_intent_isn_list)
               || ')';
--
         ELSE
            v_intent_list := 'ALL';
         END IF;
      END IF;

      --Process Community list and add to WHERE statement if filtering.
      IF d_community_list.LAST > 0
      THEN
         IF d_community_list (1) <> 'ALL'
         THEN
            v_bio_flag := TRUE;
--CCB --2012-06-22: metrics
            v_met_flag := TRUE;

            FOR i IN 1 .. d_community_list.LAST
            LOOP
               v_community_isn_list :=
                  v_community_isn_list || d_community_list (i) || ',';

               SELECT activity_community
                 INTO v_community
                 FROM di_community_sampled
                WHERE pk_isn = d_community_list (i);

               v_community_list := v_community_list || v_community || '<br>';
            END LOOP;

            v_community_isn_list := RTRIM (v_community_isn_list, ',');

            vR_WhereStmt := vR_WhereStmt || ' AND 1=0';
            vH_WhereStmt := vH_WhereStmt || ' AND 1=0';

            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_community_sampled IN ('
               || dw_util.check_input (v_community_isn_list)
               || ')';
--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_community_sampled IN ('
               || dw_util.check_input (v_community_isn_list)
               || ')';
--
         ELSE
            v_community_list := 'ALL';
         END IF;
      END IF;

      --Process medium list and add to WHERE statement if filtering.
      IF d_medium_list.LAST > 0
      THEN
         IF d_medium_list (1) <> 'ALL'
         THEN
            FOR i IN 1 .. d_medium_list.LAST
            LOOP
               v_medium_isn_list :=
                  v_medium_isn_list || d_medium_list (i) || ',';

               SELECT activity_medium
                 INTO v_medium
                 FROM di_activity_medium
                WHERE pk_isn = d_medium_list (i);

               v_medium_list := v_medium_list || v_medium || '<br>';
            END LOOP;

            v_medium_isn_list := RTRIM (v_medium_isn_list, ',');

            vR_WhereStmt :=
                  vR_WhereStmt
               || ' AND fk_act_medium IN ('
               || dw_util.check_input (v_medium_isn_list)
               || ')';

            vB_WhereStmt :=
                  vB_WhereStmt
               || ' AND fk_act_medium IN ('
               || dw_util.check_input (v_medium_isn_list)
               || ')';

--CCB --2012-06-22: metrics
            vM_WhereStmt :=
                  vM_WhereStmt
               || ' AND fk_act_medium IN ('
               || dw_util.check_input (v_medium_isn_list)
               || ')';
--

            vH_WhereStmt := vH_WhereStmt || ' AND 1=0';

            v_medium_flag := TRUE;
         ELSE
            v_medium_list := 'ALL';
         END IF;
      END IF;

      --process chartype_list
      --WShed Summary
      IF     result_type = 'ALLRESULTS'
         AND source_app = 'WATERSHED'
         AND in_chartype_list <> 'ALL'
      THEN
         vR_WhereStmt :=
               vR_WhereStmt
            || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
            || ' where ct.pk_isn = cct.fk_chartype '
            || ' and cct.fk_characteristic = fa.fk_char '
            || ' and ct.pk_isn in ('
            || dw_util.check_input (in_chartype_list)
            || '))';

         vB_WhereStmt :=
               vB_WhereStmt
            || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
            || ' where ct.pk_isn = cct.fk_chartype '
            || ' and cct.fk_characteristic = fa.fk_char '
            || ' and ct.pk_isn in ('
            || dw_util.check_input (in_chartype_list)
            || '))';

         vH_WhereStmt :=
               vH_WhereStmt
            || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
            || ' where ct.pk_isn = cct.fk_chartype '
            || ' and cct.fk_characteristic = fa.fk_char '
            || ' and ct.pk_isn in ('
            || dw_util.check_input (in_chartype_list)
            || '))';

--CCB --2012-06-22: metrics
         vM_WhereStmt :=
               vM_WhereStmt
            || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
            || ' where ct.pk_isn = cct.fk_chartype '
            || ' and cct.fk_characteristic = fa.fk_char '
            || ' and ct.pk_isn in ('
            || dw_util.check_input (in_chartype_list)
            || '))';
--
      END IF;

      --Assemble sql statement
      IF result_type = 'REGULAR'
      THEN
         v_SelectStmt := vR_SelectStmt;
         v_FromStmt := vR_FromStmt;
         v_WhereStmt := vR_WhereStmt;
         v_SQLStmt :=
               'BEGIN '
            || v_SelectStmt
            || ' '
            || v_FromStmt
            || ' '
            || v_WhereStmt
            || ';END;';
      ELSIF result_type = 'BIOLOGICAL'
      THEN
         v_SelectStmt := vB_SelectStmt;
         v_FromStmt := vB_FromStmt;
         v_WhereStmt := vB_WhereStmt;
         v_SQLStmt :=
               'BEGIN '
            || v_SelectStmt
            || ' '
            || v_FromStmt
            || ' '
            || v_WhereStmt
            || ';END;';
      ELSIF result_type = 'HABITAT'
      THEN
         v_SelectStmt := vH_SelectStmt;
         v_FromStmt := vH_FromStmt;
         v_WhereStmt := vH_WhereStmt;
         v_SQLStmt :=
               'BEGIN '
            || v_SelectStmt
            || ' '
            || v_FromStmt
            || ' '
            || v_WhereStmt
            || ';END;';
--CCB --2012-06-22: metrics
      ELSIF result_type = 'METRIC'
      THEN
         v_SelectStmt := vM_SelectStmt;
         v_FromStmt := vM_FromStmt;
         v_WhereStmt := vM_WhereStmt;
         v_SQLStmt :=
               'BEGIN '
            || v_SelectStmt
            || ' '
            || v_FromStmt
            || ' '
            || v_WhereStmt
            || ';END;';
--
      END IF;



      vR_SQLStmt :=
            'BEGIN '
         || vR_SelectStmt
         || ' '
         || vR_FromStmt
         || ' '
         || vR_WhereStmt
         || ';END;';
      vB_SQLStmt :=
            'BEGIN '
         || vB_SelectStmt
         || ' '
         || vB_FromStmt
         || ' '
         || vB_WhereStmt
         || ';END;';
      vH_SQLStmt :=
            'BEGIN '
         || vH_SelectStmt
         || ' '
         || vH_FromStmt
         || ' '
         || vH_WhereStmt
         || ';END;';
--CCB --2012-06-22: metrics hardcoded zero
--      vM_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
--
--      vM_FromStmt := 'FROM FA_ACTIVITY_METRIC FA';
--
--      vM_WhereStmt := ' WHERE 9=1';
--
      vM_SQLStmt :=
            'BEGIN '
         || vM_SelectStmt
         || ' '
         || vM_FromStmt
         || ' '
         || vM_WhereStmt
         || ';END;';
--


      IF result_type = 'ALLRESULTS'
      THEN
         -- REGULAR RESULTS COUNT
         v_CursorID := DBMS_SQL.OPEN_CURSOR;
         DBMS_SQL.PARSE (v_CursorID, vR_SQLStmt, DBMS_SQL.NATIVE);
         DBMS_SQL.BIND_VARIABLE (v_CursorID, ':ResultCount', vR_ResultCount);
         v_Dummy := DBMS_SQL.EXECUTE (v_CursorID);
         DBMS_SQL.VARIABLE_VALUE (v_CursorID, ':ResultCount', vR_ResultCount);
         DBMS_SQL.CLOSE_CURSOR (v_CursorID);

         --BIO RESULTS COUNT
         v_CursorID := DBMS_SQL.OPEN_CURSOR;
         DBMS_SQL.PARSE (v_CursorID, vB_SQLStmt, DBMS_SQL.NATIVE);
         DBMS_SQL.BIND_VARIABLE (v_CursorID, ':ResultCount', vB_ResultCount);
         v_Dummy := DBMS_SQL.EXECUTE (v_CursorID);
         DBMS_SQL.VARIABLE_VALUE (v_CursorID, ':ResultCount', vB_ResultCount);
         DBMS_SQL.CLOSE_CURSOR (v_CursorID);

         --HAB RESULT COUNT
         v_CursorID := DBMS_SQL.OPEN_CURSOR;
         DBMS_SQL.PARSE (v_CursorID, vH_SQLStmt, DBMS_SQL.NATIVE);
         DBMS_SQL.BIND_VARIABLE (v_CursorID, ':ResultCount', vH_ResultCount);
         v_Dummy := DBMS_SQL.EXECUTE (v_CursorID);
         DBMS_SQL.VARIABLE_VALUE (v_CursorID, ':ResultCount', vH_ResultCount);
         DBMS_SQL.CLOSE_CURSOR (v_CursorID);

--CCB --2012-06-22: metrics
         --MET RESULT COUNT
         v_CursorID := DBMS_SQL.OPEN_CURSOR;
         DBMS_SQL.PARSE (v_CursorID, vM_SQLStmt, DBMS_SQL.NATIVE);
         DBMS_SQL.BIND_VARIABLE (v_CursorID, ':ResultCount', vM_ResultCount);
         v_Dummy := DBMS_SQL.EXECUTE (v_CursorID);
         DBMS_SQL.VARIABLE_VALUE (v_CursorID, ':ResultCount', vM_ResultCount);
         DBMS_SQL.CLOSE_CURSOR (v_CursorID);

--CCB --2012-06-22: metrics
--         v_ResultCount := (vR_ResultCount + vB_ResultCount + vH_ResultCount);
         v_ResultCount := (vR_ResultCount + vB_ResultCount + vH_ResultCount + vM_ResultCount);
--
      ELSE
         --Process SQL statement and capture count value
         v_CursorID := DBMS_SQL.OPEN_CURSOR;
         DBMS_SQL.PARSE (v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
         DBMS_SQL.BIND_VARIABLE (v_CursorID, ':ResultCount', v_ResultCount);
         v_Dummy := DBMS_SQL.EXECUTE (v_CursorID);
         DBMS_SQL.VARIABLE_VALUE (v_CursorID, ':ResultCount', v_ResultCount);
         DBMS_SQL.CLOSE_CURSOR (v_CursorID);
      END IF;

      --identify the minimum count
      vmin_ResultCount := 0;

      IF vr_resultcount > 0
      THEN
         vmin_ResultCount := vr_resultcount;
         report_Type := 'REGULAR';
      END IF;

      IF vb_resultcount > 0
      THEN
         IF ( (vmin_ResultCount > vb_resultcount) OR (vmin_ResultCount = 0))
         THEN
            vmin_ResultCount := vb_resultcount;
            report_Type := 'BIOLOGICAL';
         END IF;
      END IF;

      IF vh_resultcount > 0
      THEN
         IF ( (vmin_ResultCount > vh_resultcount) OR (vmin_ResultCount = 0))
         THEN
            vmin_ResultCount := vh_resultcount;
            report_Type := 'HABITAT';
         END IF;
      END IF;

--CCB --2012-06-22: metrics
      IF vm_resultcount > 0
      THEN
         IF ( (vmin_ResultCount > vm_resultcount) OR (vmin_ResultCount = 0))
         THEN
            vmin_ResultCount := vm_resultcount;
            report_Type := 'METRIC';
         END IF;
      END IF;
--

      --Generate HTML page
      dw_comp.top (page_title, program_path, image_path);

      -- 2010-09-01 Header for Search Parameter Values
      v_parameters := v_parameters || 'Query Parameter Values: ' || CHR (10);

      HTP.PRINT (
            '<center><h4>Number of Results Returned: '
         || TO_CHAR (v_ResultCount, '999,999,999')
         || '</h4></center>');
      HTP.PRINT ('<div class="queryForm">');

      HTP.PRINT ('<div class="searchCriteria">');
      HTP.PRINT ('<h5>Search Criteria</h5>');

-- debug variables here
--            HTP.PRINT ('<div class="searchCriteria-label">vR_SQLStmt:</div>');
--            HTP.PRINT ('<div class="searchCriteria-value">'||vR_SQLStmt||'</div>');
--            HTP.PRINT ('<div class="searchCriteria-label">vM_SQLStmt:</div>');
--            HTP.PRINT ('<div class="searchCriteria-value">'||vM_SQLStmt||'</div>');


      --Display geographic search parameters based on the selected search option
      IF geographic = 'StateCounty'
      THEN
         IF as_state <> 0
         THEN
            v_filters := v_filters || '~' || 'State';
            v_parameters :=
                  v_parameters
               || 'State: '
               || CHR (9)
               || v_StateName
               || CHR (10);

            IF v_County_Code <> 'ALL'
            THEN
               v_filters := v_filters || '~' || 'County';
               v_parameters :=
                     v_parameters
                  || 'County: '
                  || CHR (9)
                  || as_county
                  || CHR (10);
               HTP.PRINT ('<div class="searchCriteria-label">State:</div>');
               HTP.PRINT (
                     '<div class="searchCriteria-value">'
                  || v_StateName
                  || '</div>');
               HTP.PRINT ('<div class="searchCriteria-label">County:</div>');
               HTP.PRINT (
                     '<div class="searchCriteria-value">'
                  || as_county
                  || '</div>');
            ELSE
               HTP.PRINT ('<div class="searchCriteria-label">State:</div>');
               HTP.PRINT (
                     '<div class="searchCriteria-value">'
                  || v_StateName
                  || '</div>');
               HTP.PRINT ('<div class="searchCriteria-label">County:</div>');
               HTP.PRINT ('<div class="searchCriteria-value">ALL</div>');
            END IF;
         ELSE
            HTP.PRINT ('<div class="searchCriteria-label">State:</div>');
            HTP.PRINT ('<div class="searchCriteria-value">ALL</div>');
            HTP.PRINT ('<div class="searchCriteria-label">County:</div>');
            HTP.PRINT ('<div class="searchCriteria-value">ALL</div>');
         END IF;
      ELSIF geographic = 'multipleStates'
      THEN
         IF v_state_list IS NOT NULL
         THEN
            IF v_state_list <> 'ALL'
            THEN
               v_filters := v_filters || '~' || 'States';
               v_parameters :=
                     v_parameters
                  || 'States: '
                  || CHR (9)
                  || v_state_name_list
                  || CHR (10);
            END IF;

            HTP.PRINT ('<div class="searchCriteria-label">State(s):</div>');
            HTP.PRINT (
                  '<div class="searchCriteria-value">'
               || v_state_name_list
               || '</div>');
         ELSE
            HTP.PRINT ('<div class="searchCriteria-label">State(s):</div>');
            HTP.PRINT ('<div class="searchCriteria-value">ALL</div>');
         END IF;
      ELSIF geographic = 'HUC'
      THEN
         IF

