
  CREATE OR REPLACE PACKAGE "STORETW"."DW_UTIL"
AS
   PROCEDURE record_data_request (
      p_filters         IN     VARCHAR2,
      p_filetype        IN     VARCHAR2,
      p_timestamp       IN     VARCHAR2,
      p_file_length     IN     NUMBER,
      P_record_title    IN     VARCHAR2 DEFAULT NULL,
      p_request_mode    IN     VARCHAR2 DEFAULT 'Online',
      p_email           IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      p_userprofile     IN     NUMBER DEFAULT NULL,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
      p_query           IN     VARCHAR2 DEFAULT NULL,
      pR_query          IN     VARCHAR2 DEFAULT NULL,
      pB_query          IN     VARCHAR2 DEFAULT NULL,
      pH_query          IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      pM_query          IN     VARCHAR2 DEFAULT NULL,
      p_filename        IN     VARCHAR2 DEFAULT NULL,
      p_record_count    IN     NUMBER DEFAULT NULL,
      p_request_id         OUT NUMBER,
      P_rrecord_title   IN     VARCHAR2 DEFAULT NULL,
      P_brecord_title   IN     VARCHAR2 DEFAULT NULL,
      P_hrecord_title   IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      P_mrecord_title   IN     VARCHAR2 DEFAULT NULL,
      p_reg_data        IN     VARCHAR2 DEFAULT NULL,
      p_bio_data        IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      p_hab_data        IN     VARCHAR2 DEFAULT NULL,
      p_met_data        IN     VARCHAR2 DEFAULT NULL);

   PROCEDURE write_file (p_query        IN     VARCHAR2,
                         p_separator    IN     VARCHAR2 DEFAULT CHR (9),
                         p_dir          IN     VARCHAR2,
                         p_filename     IN     VARCHAR2,
                         p_header       IN     VARCHAR2,
                         p_start_with   IN     NUMBER DEFAULT 1,
                         p_count           OUT NUMBER);

   PROCEDURE project_blob_md (v_blob_id     IN     VARCHAR2,
                              v_location    IN     VARCHAR2,
                              v_filename    IN     VARCHAR2,
                              v_blob_type      OUT VARCHAR2);

   PROCEDURE station_download_custom (
      v_FromStmt       IN     VARCHAR2,
      v_WhereStmt      IN     VARCHAR2,
      v_Columns        IN     OWA_UTIL.ident_arr,
      v_filename       IN     VARCHAR2,
      P_email          IN     VARCHAR2,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      P_userprofile    IN     NUMBER,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      P_distinct       IN     VARCHAR2,
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      p_prefix         IN     VARCHAR2,
      v_mode           IN     VARCHAR2,
      p_record_count   IN     NUMBER,
      v_filters        IN     VARCHAR2,
      out_file            OUT VARCHAR2,
      request_id          OUT NUMBER);

   PROCEDURE result_download_custom (
      v_FromStmt            IN     VARCHAR2 DEFAULT NULL,
      v_WhereStmt           IN     VARCHAR2 DEFAULT NULL,
      vR_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vR_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      vB_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vB_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      vH_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vH_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      vM_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vM_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      v_rule_optimization   IN     VARCHAR2,
      v_report_type         IN     CHAR DEFAULT 'REGULAR',
      v_Columns             IN     OWA_UTIL.vc_arr,
      v_filename            IN     VARCHAR2,
      P_email               IN     VARCHAR2,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      P_userprofile         IN     NUMBER,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      P_distinct            IN     VARCHAR2,
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      p_prefix              IN     VARCHAR2,
      v_mode                IN     VARCHAR2,
      p_record_count        IN     NUMBER,
      v_filters             IN     VARCHAR2,
      out_file                 OUT VARCHAR2,
      request_id               OUT NUMBER,
      r_Type                IN     OWA_UTIL.vc_arr);

   PROCEDURE result_download_zip (in_command     IN VARCHAR2,
                                  out_filename   IN VARCHAR2);

   PROCEDURE result_metadata (v_org_id_list     IN     OWA_UTIL.ident_arr,
                              v_md_filename     IN     VARCHAR2,
                              v_project_blobs      OUT VARCHAR2);

   PROCEDURE process_data_request (p_req_id IN NUMBER);

   PROCEDURE process_batch_requests;

   PROCEDURE process_data_request_list (P_REQ_LIST IN VARCHAR2);

   PROCEDURE process_pendingbatch_imm;

   FUNCTION encrypt_text (p_text IN VARCHAR2)
      RETURN VARCHAR2;

   FUNCTION decrypt_text (p_text IN VARCHAR2)
      RETURN VARCHAR2;

   FUNCTION check_input (p_text IN VARCHAR2)
      RETURN VARCHAR2;
END dw_util;
/
CREATE OR REPLACE PACKAGE BODY "STORETW"."DW_UTIL"
AS
   PROCEDURE record_data_request (
      p_filters         IN     VARCHAR2,
      p_filetype        IN     VARCHAR2,
      p_timestamp       IN     VARCHAR2,
      p_file_length     IN     NUMBER,
      P_record_title    IN     VARCHAR2 DEFAULT NULL,
      p_request_mode    IN     VARCHAR2 DEFAULT 'Online',
      p_email           IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      p_userprofile     IN     NUMBER DEFAULT NULL,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
      p_query           IN     VARCHAR2 DEFAULT NULL,
      pR_query          IN     VARCHAR2 DEFAULT NULL,
      pB_query          IN     VARCHAR2 DEFAULT NULL,
      pH_query          IN     VARCHAR2 DEFAULT NULL,
--CCB
      pM_query          IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-08-17: index?
--      pI_query          IN     VARCHAR2 DEFAULT NULL,
      p_filename        IN     VARCHAR2 DEFAULT NULL,
      p_record_count    IN     NUMBER DEFAULT NULL,
      p_request_id         OUT NUMBER,
      P_rrecord_title   IN     VARCHAR2 DEFAULT NULL,
      P_brecord_title   IN     VARCHAR2 DEFAULT NULL,
      P_hrecord_title   IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      P_mrecord_title   IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-08-17: index?
--      P_irecord_title   IN     VARCHAR2 DEFAULT NULL,
      p_reg_data        IN     VARCHAR2 DEFAULT NULL,
      p_bio_data        IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      p_hab_data        IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-08-17: index?
      p_met_data        IN     VARCHAR2 DEFAULT NULL)
--      p_met_data        IN     VARCHAR2 DEFAULT NULL,
--      p_ind_data        IN     VARCHAR2 DEFAULT NULL)
   AS
      -- Declare local variables.
      -- added pR-query, pB_query, pH_query to the input parameters.
      -- flags for report type checkbox values
      lv_REG_DATA_FLAG         dw_data_requests.REG_DATA_FLAG%TYPE;
      lv_BIO_DATA_FLAG         dw_data_requests.BIO_DATA_FLAG%TYPE;
      lv_HAB_DATA_FLAG         dw_data_requests.HAB_DATA_FLAG%TYPE;
--CCB --2012-06-22: metrics
      lv_MET_DATA_FLAG         dw_data_requests.MET_DATA_FLAG%TYPE;
--CCB --2012-08-17: index?
--      lv_IND_DATA_FLAG         dw_data_requests.IND_DATA_FLAG%TYPE;

      lv_REQUEST_TYPE          dw_data_requests.REQUEST_TYPE%TYPE;
      lv_DATETIME              dw_data_requests.DATETIME%TYPE;
      lv_FILESIZE_kb           dw_data_requests.FILESIZE_kb%TYPE;
      lv_F_STATE               dw_data_requests.F_STATE%TYPE;
      lv_F_COUNTY              dw_data_requests.F_COUNTY%TYPE;
      lv_F_LATLONG             dw_data_requests.F_LATLONG%TYPE;
      lv_F_HUC                 dw_data_requests.F_HUC%TYPE;
      lv_F_STATIONTYPE         dw_data_requests.F_STATIONTYPE%TYPE;
      lv_F_CHARACTERISTIC      dw_data_requests.F_CHARACTERISTIC%TYPE;
      lv_F_ORGANIZATION        dw_data_requests.F_ORGANIZATION%TYPE;
      lv_F_STATION             dw_data_requests.F_STATION%TYPE;
      lv_f_act_StartDate       dw_data_requests.f_act_startdate%TYPE;
      lv_f_act_medium          dw_data_requests.f_act_medium%TYPE;
      lv_f_project             dw_data_requests.f_project%TYPE;
      lv_f_act_intent          dw_data_requests.f_act_intent%TYPE;
      lv_f_Community_sampled   dw_data_requests.f_community_sampled%TYPE;

      lv_f_Chartype            dw_data_requests.f_Chartype%TYPE;

      lv_REQUEST_MODE          dw_data_requests.REQUEST_MODE%TYPE;
      lv_REQUEST_STATUS        dw_data_requests.REQUEST_STATUS%TYPE;
      lv_EMAIL_ADDRESS         dw_data_requests.EMAIL_ADDRESS%TYPE;
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      lv_USERPROFILE           dw_data_requests.FK_ORG_TYPE%TYPE;
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
      lv_NOTIFIED              dw_data_requests.NOTIFIED%TYPE;
      lv_QUERY_TEXT            dw_data_requests.QUERY_TEXT%TYPE;
      lv_QUERY_TEXT2           dw_data_requests.QUERY_TEXT2%TYPE;

      lvR_QUERY_TEXT           dw_data_requests.RQUERY_TEXT%TYPE;
      lvR_QUERY_TEXT2          dw_data_requests.RQUERY_TEXT2%TYPE;
      lvB_QUERY_TEXT           dw_data_requests.BQUERY_TEXT%TYPE;
      lvB_QUERY_TEXT2          dw_data_requests.BQUERY_TEXT2%TYPE;
      lvH_QUERY_TEXT           dw_data_requests.HQUERY_TEXT%TYPE;
      lvH_QUERY_TEXT2          dw_data_requests.HQUERY_TEXT2%TYPE;
--CCB --2012-06-22: metrics
      lvM_QUERY_TEXT           dw_data_requests.MQUERY_TEXT%TYPE;
      lvM_QUERY_TEXT2          dw_data_requests.MQUERY_TEXT2%TYPE;
--CCB --2012-08-17: index?
--      lvI_QUERY_TEXT           dw_data_requests.IQUERY_TEXT%TYPE;
--      lvI_QUERY_TEXT2          dw_data_requests.IQUERY_TEXT2%TYPE;

      lv_FILENAME              dw_data_requests.FILENAME%TYPE;
      lv_RECORD_COUNT          dw_data_requests.RECORD_COUNT%TYPE;
      lv_record_title          dw_data_requests.record_title%TYPE;

      lv_filters               VARCHAR2 (32000) := p_filters;
      lv_request_id            dw_data_requests.request_id%TYPE;
   BEGIN
      --initialize local variables.  Some of them represent filters and rest are report details.
      lv_REQUEST_TYPE := p_filetype;
      lv_DATETIME := TO_DATE (p_timestamp, 'YYYYMMDD_HH24MISS');
      lv_FILESIZE_kb := p_file_length;
      lv_F_STATE := 0;
      lv_F_COUNTY := 0;
      lv_F_LATLONG := 0;
      lv_F_HUC := 0;
      lv_F_STATIONTYPE := 0;
      lv_F_CHARACTERISTIC := 0;
      lv_F_ORGANIZATION := 0;
      lv_F_STATION := 0;

      lv_f_act_StartDate := 0;
      lv_f_act_medium := 0;
      lv_f_project := 0;
      lv_f_act_intent := 0;
      lv_f_Community_sampled := 0;
      lv_f_chartype := 0;

      lv_REQUEST_MODE := p_request_mode;
      lv_REQUEST_STATUS := 'New';
      lv_EMAIL_ADDRESS := p_email;
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      lv_USERPROFILE := p_userprofile;
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
      lv_NOTIFIED := 'N';
      lv_QUERY_TEXT := SUBSTR (p_query, 1, 4000);
      lv_QUERY_TEXT2 := SUBSTR (p_query, 4001, 8000);

      lvR_QUERY_TEXT := SUBSTR (pR_query, 1, 4000);
      lvR_QUERY_TEXT2 := SUBSTR (pR_query, 4001, 8000);

      lvB_QUERY_TEXT := SUBSTR (pB_query, 1, 4000);
      lvB_QUERY_TEXT2 := SUBSTR (pB_query, 4001, 8000);

      lvH_QUERY_TEXT := SUBSTR (pH_query, 1, 4000);
      lvH_QUERY_TEXT2 := SUBSTR (pH_query, 4001, 8000);

--CCB --2012-06-22: metrics
      lvM_QUERY_TEXT := SUBSTR (pM_query, 1, 4000);
      lvM_QUERY_TEXT2 := SUBSTR (pM_query, 4001, 8000);
--CCB --2012-08-17: index?
--      lvI_QUERY_TEXT := SUBSTR (pI_query, 1, 4000);
--      lvI_QUERY_TEXT2 := SUBSTR (pI_query, 4001, 8000);

      lv_FILENAME := p_filename;
      lv_RECORD_COUNT := p_record_count;
      lv_record_title := p_record_title;

      lv_REG_DATA_FLAG := p_reg_data;
      lv_BIO_DATA_FLAG := p_bio_data;
      lv_HAB_DATA_FLAG := p_hab_data;

--CCB --2012-06-22: metrics
      lv_MET_DATA_FLAG := p_met_data;
--CCB --2012-08-17: index?
--      lv_IND_DATA_FLAG := p_ind_data;

      --Set local variables with appropriate data for different request modes.
      IF p_request_mode = 'Online'
      THEN
         lv_REQUEST_MODE := p_request_mode;
         lv_REQUEST_STATUS := NULL;
         lv_EMAIL_ADDRESS := NULL;
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
         lv_USERPROFILE := NULL;
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
         lv_QUERY_TEXT := NULL;
         lv_QUERY_TEXT2 := NULL;
         lvR_QUERY_TEXT := NULL;
         lvR_QUERY_TEXT2 := NULL;
         lvB_QUERY_TEXT := NULL;
         lvB_QUERY_TEXT2 := NULL;
         lvH_QUERY_TEXT := NULL;
         lvH_QUERY_TEXT2 := NULL;
--CCB --2012-06-22: metrics
         lvM_QUERY_TEXT := NULL;
         lvM_QUERY_TEXT2 := NULL;
--CCB --2012-08-17: index?
--         lvI_QUERY_TEXT := NULL;
--         lvI_QUERY_TEXT2 := NULL;
         lv_FILENAME := NULL;
         lv_RECORD_COUNT := NULL;
         lv_NOTIFIED := NULL;
         lv_record_title := NULL;
      ELSIF p_request_mode IN ('Immediate', 'Overnight')
      THEN
         lv_REQUEST_MODE := p_request_mode;
         lv_REQUEST_STATUS := 'New';
         lv_EMAIL_ADDRESS := p_email;
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
         lv_USERPROFILE := p_userprofile;
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
         lv_NOTIFIED := 'N';

         lv_QUERY_TEXT := SUBSTR (p_query, 1, 4000);
         lv_QUERY_TEXT2 := SUBSTR (p_query, 4001, 8000);

         lvR_QUERY_TEXT := SUBSTR (pR_query, 1, 4000);
         lvR_QUERY_TEXT2 := SUBSTR (pR_query, 4001, 8000);

         lvB_QUERY_TEXT := SUBSTR (pB_query, 1, 4000);
         lvB_QUERY_TEXT2 := SUBSTR (pB_query, 4001, 8000);

         lvH_QUERY_TEXT := SUBSTR (pH_query, 1, 4000);
         lvH_QUERY_TEXT2 := SUBSTR (pH_query, 4001, 8000);

--CCB --2012-06-22: metrics
         lvM_QUERY_TEXT := SUBSTR (pM_query, 1, 4000);
         lvM_QUERY_TEXT2 := SUBSTR (pM_query, 4001, 8000);
--CCB --2012-08-17: index?
--         lvI_QUERY_TEXT := SUBSTR (pI_query, 1, 4000);
--         lvI_QUERY_TEXT2 := SUBSTR (pI_query, 4001, 8000);

         lv_FILENAME := p_filename;
         lv_RECORD_COUNT := p_record_count;
         lv_record_title := p_record_title;
      END IF;

      -- Review lv_filters parameter and flag local filter variables.  These variables will be used for recording in a table.
      -- If no filters are used during the search, then p_filters and lv_filters will have values of '~' and '~~' respectively.
      -- Hence, perform the filter identification only if the length of lv_filters is greater than 2.

      IF LENGTH (lv_filters) > 2
      THEN
         IF INSTR (lv_filters, '~State~') > 0
         THEN
            lv_f_state := 1;
         END IF;

         IF INSTR (lv_filters, '~County~') > 0
         THEN
            lv_f_county := 1;
         END IF;

         IF INSTR (lv_filters, '~LatLong~') > 0
         THEN
            lv_f_latlong := 1;
         END IF;

         IF INSTR (lv_filters, '~HUC~') > 0
         THEN
            lv_f_huc := 1;
         END IF;

         IF INSTR (lv_filters, '~StationType~') > 0
         THEN
            lv_f_stationtype := 1;
         END IF;

         IF INSTR (lv_filters, '~Characteristic~') > 0
         THEN
            lv_f_Characteristic := 1;
         END IF;

         IF INSTR (lv_filters, '~Organization~') > 0
         THEN
            lv_f_Organization := 1;
         END IF;

         IF INSTR (lv_filters, '~Stations~') > 0
         THEN
            lv_f_Station := 1;
         END IF;

         IF INSTR (lv_filters, '~Act_StartDate~') > 0
         THEN
            lv_f_act_StartDate := 1;
         END IF;

         IF INSTR (lv_filters, '~Act_Medium~') > 0
         THEN
            lv_f_act_medium := 1;
         END IF;

         IF INSTR (lv_filters, '~Project~') > 0
         THEN
            lv_f_project := 1;
         END IF;

         IF INSTR (lv_filters, '~Act_Intent~') > 0
         THEN
            lv_f_act_intent := 1;
         END IF;

         IF INSTR (lv_filters, '~CommunitySampled~') > 0
         THEN
            lv_f_Community_sampled := 1;
         END IF;

         IF INSTR (lv_filters, '~Chartype~') > 0
         THEN
            lv_f_Chartype := 1;
         END IF;
      END IF;

      HTP.br;

      SELECT seq_dw_data_request_id.NEXTVAL INTO lv_request_id FROM DUAL;

      -- Insert record into dw_data_requests.
      INSERT INTO dw_data_requests (request_id,
                                    REQUEST_TYPE,
                                    DATETIME,
                                    FILESIZE_KB,
                                    F_STATE,
                                    F_COUNTY,
                                    F_LATLONG,
                                    F_HUC,
                                    F_STATIONTYPE,
                                    F_CHARACTERISTIC,
                                    F_ORGANIZATION,
                                    F_STATION,
                                    f_act_StartDate,
                                    f_act_medium,
                                    f_project,
                                    f_act_intent,
                                    f_Community_sampled,
                                    REQUEST_MODE,
                                    REQUEST_STATUS,
                                    EMAIL_ADDRESS,
                                    QUERY_TEXT,
                                    QUERY_TEXT2,
                                    RQUERY_TEXT,
                                    RQUERY_TEXT2,
                                    BQUERY_TEXT,
                                    BQUERY_TEXT2,
                                    HQUERY_TEXT,
                                    HQUERY_TEXT2,
--CCB --2012-06-22: metrics
                                    MQUERY_TEXT,
                                    MQUERY_TEXT2,
--CCB --2012-08-17: index?
--                                    IQUERY_TEXT,
--                                    IQUERY_TEXT2,
                                    FILENAME,
                                    RECORD_COUNT,
                                    Notified,
                                    RECORD_TITLE,
                                    R_RECORD_TITLE,
                                    B_RECORD_TITLE,
                                    H_RECORD_TITLE,
--CCB --2012-06-22: metrics
                                    M_RECORD_TITLE,
--CCB --2012-08-17: index?
--                                    I_RECORD_TITLE,
                                    f_Chartype,
                                    REG_DATA_FLAG,
                                    BIO_DATA_FLAG,
                                    HAB_DATA_FLAG,
--CCB --2012-06-22: metrics
                                    MET_DATA_FLAG,
--CCB --2012-08-17: index?
--                                    IND_DATA_FLAG,
                                    FK_ORG_TYPE)
           VALUES (lv_request_id,
                   lv_REQUEST_TYPE,
                   lv_DATETIME,
                   lv_FILESIZE_kb,
                   lv_F_STATE,
                   lv_F_COUNTY,
                   lv_F_LATLONG,
                   lv_F_HUC,
                   lv_F_STATIONTYPE,
                   lv_F_CHARACTERISTIC,
                   lv_F_ORGANIZATION,
                   lv_F_STATION,
                   lv_f_act_StartDate,
                   lv_f_act_medium,
                   lv_f_project,
                   lv_f_act_intent,
                   lv_f_Community_sampled,
                   lv_REQUEST_MODE,
                   lv_REQUEST_STATUS,
                   lv_EMAIL_ADDRESS,
                   lv_QUERY_TEXT,
                   lv_QUERY_TEXT2,
                   lvR_QUERY_TEXT,
                   lvR_QUERY_TEXT2,
                   lvB_QUERY_TEXT,
                   lvB_QUERY_TEXT2,
                   lvH_QUERY_TEXT,
                   lvH_QUERY_TEXT2,
--CCB --2012-06-22: metrics
                   lvM_QUERY_TEXT,
                   lvM_QUERY_TEXT2,
--CCB --2012-08-17: index?
--                   lvI_QUERY_TEXT,
--                   lvI_QUERY_TEXT2,
                   lv_FILENAME,
                   lv_RECORD_COUNT,
                   lv_NOTIFIED,
                   lv_RECORD_TITLE,
                   p_Rrecord_title,
                   P_Brecord_title,
                   p_Hrecord_title,
--CCB --2012-06-22: metrics
                   p_Mrecord_title,
--CCB --2012-08-17: index?
--                   p_Irecord_title,
                   lv_f_Chartype,
                   lv_REG_DATA_FLAG,
                   lv_BIO_DATA_FLAG,
                   lv_HAB_DATA_FLAG,
--CCB --2012-06-22: metrics
                   lv_MET_DATA_FLAG,
--CCB --2012-08-17: index?
--                   lv_IND_DATA_FLAG,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
                   lv_USERPROFILE);

      COMMIT;
      p_request_id := lv_request_id;
   END record_data_request;

   PROCEDURE write_file (p_query        IN     VARCHAR2,
                         p_separator    IN     VARCHAR2 DEFAULT CHR (9),
                         p_dir          IN     VARCHAR2,
                         p_filename     IN     VARCHAR2,
                         p_header       IN     VARCHAR2,
                         p_start_with   IN     NUMBER DEFAULT 1,
                         p_count           OUT NUMBER)
   IS
      l_output        UTL_FILE.file_type;
      l_theCursor     INTEGER DEFAULT DBMS_SQL.open_cursor;
      l_columnValue   VARCHAR2 (32000);
      l_status        INTEGER;
      l_colCnt        NUMBER DEFAULT 0;
      l_separator     VARCHAR2 (10) DEFAULT '';
      l_cnt           NUMBER DEFAULT 0;
   BEGIN
      l_output :=
         UTL_FILE.fopen (dw_glob_var.lv_utl_file_dir,
                         p_filename,
                         'w',
                         32000);

      DBMS_SQL.parse (l_theCursor, p_query, DBMS_SQL.native);

      FOR i IN 1 .. 1000
      LOOP
         BEGIN
            DBMS_SQL.define_column (l_theCursor,
                                    i,
                                    l_columnValue,
                                    32000);
            l_colCnt := i;
         EXCEPTION
            WHEN OTHERS
            THEN
               IF (SQLCODE = -1007)
               THEN
                  EXIT;
               ELSE
                  RAISE;
               END IF;
         END;
      END LOOP;

      DBMS_SQL.define_column (l_theCursor,
                              1,
                              l_columnValue,
                              32000);

      l_status := DBMS_SQL.execute (l_theCursor);

      IF p_header IS NOT NULL
      THEN
         UTL_FILE.put_line (l_output, p_header);
      END IF;

      LOOP
         EXIT WHEN (DBMS_SQL.fetch_rows (l_theCursor) <= 0);
         l_separator := '';

         FOR i IN p_start_with .. l_colCnt
         LOOP
            DBMS_SQL.COLUMN_VALUE (l_theCursor, i, l_columnValue);
            UTL_FILE.put (l_output, l_separator || l_columnValue);
            l_separator := p_separator;
         END LOOP;

         UTL_FILE.new_line (l_output);
         l_cnt := l_cnt + 1;
      END LOOP;

      DBMS_SQL.close_cursor (l_theCursor);

      UTL_FILE.fclose (l_output);
      p_count := l_cnt;
   END write_file;

   PROCEDURE project_blob_md (v_blob_id     IN     VARCHAR2,
                              v_location    IN     VARCHAR2,
                              v_filename    IN     VARCHAR2,
                              v_blob_type      OUT VARCHAR2)
   AS
      v_blob_id_split   NUMBER;
      v_org_isn         NUMBER;
      v_is_number       NUMBER;
      v_blob            BLOB;
      v_type            CHAR (3);
      out_file_name     VARCHAR2 (100);
      v_blob_count      NUMBER;
   BEGIN
      v_blob_id_split := INSTR (v_blob_id, '-');
      v_org_isn := TO_NUMBER (SUBSTR (v_blob_id, 1, v_blob_id_split - 1));
      v_is_number := TO_NUMBER (SUBSTR (v_blob_id, v_blob_id_split + 1));

      SELECT COUNT (blob_type)
        INTO v_blob_count
        FROM fa_blob
       WHERE     organization_is_number = v_org_isn
             AND tsmblob_is_number = v_is_number;

      IF v_blob_count = 1
      THEN
         SELECT blob_content, blob_type
           INTO v_blob, v_type
           FROM fa_blob
          WHERE     organization_is_number = v_org_isn
                AND tsmblob_is_number = v_is_number;

         out_file_name := v_filename || '.' || v_type;

         v_blob_type := v_type;
         ExportBlob (v_location || '/' || out_file_name, v_blob);
      END IF;
   END project_blob_md;

   PROCEDURE station_download_custom (
      v_FromStmt       IN     VARCHAR2,
      v_WhereStmt      IN     VARCHAR2,
      v_Columns        IN     OWA_UTIL.ident_arr,
      v_filename       IN     VARCHAR2,
      P_email          IN     VARCHAR2,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      P_userprofile    IN     NUMBER,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      P_distinct       IN     VARCHAR2,
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      p_prefix         IN     VARCHAR2,
      v_mode           IN     VARCHAR2,
      p_record_count   IN     NUMBER,
      v_filters        IN     VARCHAR2,
      out_file            OUT VARCHAR2,
      request_id          OUT NUMBER)
   AS
      --The out_file variable, the output of this routine, contains the entire URL of
      --the file created herein for the online processing.
      --For Overnight/Immediate processing only the file name, not the virtual path.

      --Name of downloadable file that will be created on the server.  This
      --file name will be generated based on the current date and time.
      out_file_name         VARCHAR2 (30);

      download_path         VARCHAR2 (100);
      lv_rows               NUMBER;

      v_SQLStmt             VARCHAR2 (32000);
      v_SelectStmt          VARCHAR2 (32000);
      v_Print_Names_List    VARCHAR2 (32000);
      v_FromStmtNew         VARCHAR2 (32000);
      v_WhereStmtNew        VARCHAR2 (32000);
      v_CurrentColumn       VARCHAR2 (200);

      --flags used to ensure a table is not included twice in the FROM clause
      f_LU_STATN_TYPES      BOOLEAN := FALSE;
      f_LU_GEO_STATE        BOOLEAN := FALSE;

      v_exists              BOOLEAN;
      v_blocksize           NUMBER;

      LV_FILE_LENGTH        NUMBER;
      LV_FILE_NAME          VARCHAR2 (50);
      LV_FILETYPE           VARCHAR2 (3);
      LV_TIMESTAMP          VARCHAR2 (20);
      v_stn_report_number   NUMBER;

      lv_request_id         dw_data_requests.request_id%TYPE;
      jn                    BINARY_INTEGER;

      CURSOR c_ReportColumn
      IS
           SELECT print_name, col_name
             FROM APP_COLUMN_NAME
            WHERE stn_report_number = v_stn_report_number
         ORDER BY stn_col_order;

      lv_outfile_display    VARCHAR2 (200);
   BEGIN
      ROLLBACK;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
--      v_SelectStmt := 'SELECT FA.pk_isn,';
      v_SelectStmt := 'SELECT DISTINCT FA.pk_isn, ';
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      v_FromStmtNew := v_FromStmt;
      v_WhereStmtNew := v_WhereStmt;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
            v_SelectStmt := REPLACE(v_SelectStmt, 'FA.pk_isn,', '1 pk_isn, ');
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

      --include appropriate tables based on columns selected
      FOR i IN 1 .. v_Columns.LAST
      LOOP
         v_stn_report_number := TO_NUMBER (v_Columns (i));

         FOR ReportColumn IN c_ReportColumn
         LOOP
            v_CurrentColumn := ReportColumn.col_name;
            v_print_names_list :=
               v_print_names_list || ReportColumn.print_name || CHR (9);

            IF    ReportColumn.col_name = 'PRIMARY_TYPE'
               OR ReportColumn.col_name = 'SECONDARY_TYPE'
            THEN
               IF f_LU_STATN_TYPES = FALSE
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES st';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND fk_statn_types = st.pk_isn (+)';
                  f_LU_STATN_TYPES := TRUE;
               END IF;
            END IF;

            IF ReportColumn.col_name = 'HD.ID_CODE'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND fk_mad_hdatum = hd.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'SHD.ID_CODE'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM shd';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND fk_std_hdatum = shd.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND fk_mad_hmethod = hm.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'ORGANIZATION_NAME'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'ELEVATION_DATUM'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_MAD_VDATUM vd';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_mad_vdatum = vd.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'ELEVATION_METHOD'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_MAD_VMETHOD vm';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_mad_vmethod = vm.pk_isn (+)';
            END IF;

            IF    ReportColumn.col_name = 'STATE_NAME'
               OR ReportColumn.col_name = 'COUNTRY_NAME'
            THEN
               IF f_LU_GEO_STATE = FALSE
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                  f_LU_GEO_STATE := TRUE;
               END IF;
            END IF;

            IF ReportColumn.col_name = 'COUNTY_NAME'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_geo_county = gc.pk_isn (+)';
            END IF;

            IF     ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               AND ReportColumn.print_name = 'Hydrologic Unit Name'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               v_CurrentColumn := 'ca.' || ReportColumn.col_name;
            END IF;

            -- added for Generated_HUName
            IF     ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               AND ReportColumn.print_name = 'Generated Hydrologic Unit Name'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca2';
               v_WhereStmtNew :=
                  v_WhereStmtNew || ' AND FA.fk_gen_db_cat = ca2.pk_isn (+)';
               v_CurrentColumn := 'ca2.' || ReportColumn.col_name;
            END IF;

            IF ReportColumn.col_name = 'PRIMARY_ESTUARY'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_ESTRY_PRIMARY ep';
               v_WhereStmtNew :=
                     v_WhereStmtNew
                  || ' AND FA.fk_estry_primary = ep.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'SECONDARY_ESTUARY'
            THEN
               v_FromStmtNew := v_FromStmtNew || ',LU_ESTRY_SECONDARY es';
               v_WhereStmtNew :=
                     v_WhereStmtNew
                  || ' AND FA.fk_estry_secondary = es.pk_isn (+)';
            END IF;

            IF ReportColumn.col_name = 'FA.BLOB_ID'
            THEN
               --  2010-05-12 Extra single quote  making the sql invalid query
               v_CurrentColumn :=
                     'DECODE(FA.BLOB_ID, NULL, NULL,'''
                  || dw_glob_var.lv_program_path
                  || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               --  2010-05-12 Closing Parenthesis would not appear in SQL statement without additional spaces appended
               v_CurrentColumn := v_CurrentColumn || '  ';
            END IF;

            --  2010-06-21 Closing Parenthesis would not appear in SQL statement without additional spaces appended
            v_CurrentColumn := v_CurrentColumn || '  ';
            v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
         END LOOP;
      END LOOP;

      v_SelectStmt := RTRIM (v_SelectStmt, ',');
      v_print_names_list := RTRIM (v_print_names_list, '||CHR(9)||');

      v_SQLStmt :=
         v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;

      --checking to see if a filename is passed
      IF (v_filename <> 'NONE')
      THEN
         out_file_name := v_filename;
      ELSE
         -- Generating a unique name for creating a file on the server.
         out_file_name := TO_CHAR (SYSDATE, 'YYYYMMDD_HH24MISS');

         --v2062
         out_file_name := out_file_name || '.txt';
      END IF;

      -- set file related parameters.
      lv_file_length := NULL;
      lv_file_name := out_file_name;
      lv_filetype := 'SDS';

      --v2062
      lv_timestamp := SUBSTR (out_file_name, 1, 15);

      download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;

      -- out_file is an out parameter.  It holds URL of the downloadable file that
      -- will be created by this procedure.
      IF v_mode = 'Online'
      THEN
         out_file := download_path || out_file_name;
      ELSIF v_mode IN ('Overnight', 'Immediate')
      THEN
         out_file := p_prefix || '_' || out_file_name;
         lv_file_name := p_prefix || '_' || out_file_name;
      END IF;

      IF v_mode = 'Online'
      THEN
         dw_util.write_file (v_SQLStmt,
                             CHR (9),
                             DW_GLOB_VAR.LV_IODIR,
                             out_file_name,
                             v_print_names_list,
                             2,
                             lv_rows);
      END IF;


      -- Online - find the length of the file after closing the file
      IF v_mode = 'Online'
      THEN
         UTL_FILE.fgetattr (dw_glob_var.lv_utl_file_dir,
                            out_file,
                            v_exists,
                            lv_file_length,
                            v_blocksize);

         lv_file_length := ROUND (lv_file_length / 1024, 1);
      ELSE
         lv_file_length := NULL;
      END IF;

      -- Call the Dw_record_data_request to record the request.
      lv_outfile_display := REPLACE (out_file, '.txt', '');

      dw_util.record_data_request (v_filters,
                                   lv_filetype,
                                   lv_timestamp,
                                   lv_file_length,
                                   v_print_names_list,
                                   V_MODE,
                                   P_email,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
                                   P_userprofile,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
                                   v_SQLStmt,
                                   NULL,
                                   NULL,
                                   NULL,
--CCB --2012-06-22: metrics
                                   NULL,	--pM_query
--CCB --2012-08-17: index?
--                                   NULL,	--pI_query
                                   lv_file_name,
                                   p_record_count,
                                   lv_request_id);

      IF v_mode = 'Immediate'
      THEN
         DBMS_JOB.SUBMIT (
            jn,
            'dw_util.process_data_request(' || lv_request_id || ');');

         UPDATE dw_data_requests
            SET job_queue_id = jn, processed_date = SYSDATE
          WHERE request_id = lv_request_id;

         COMMIT;
      END IF;

      IF v_mode IN ('Overnight', 'Immediate')
      THEN
         dw_mail_pkg.send (
            p_sender_email   => dw_glob_var.gv_storet_email,
            p_from           =>    'STORET Web Site <'
                                || dw_glob_var.gv_storet_email
                                || '>',
            p_to             => dw_mail_pkg.array (p_email),
            p_subject        =>    'STORET data request submitted (PROCESSING).  Request_ID: '
                                || lv_request_id,
            p_body           =>    'Your request for Station Download is submitted for '
                                || v_mode
                                || ' batch processing.

Following is your request information:

Request ID    :  '
                                || lv_request_id
                                || '
Request Type  :  Station Download
Record Count  :  '
                                || p_record_count
                                || '
Request Mode  :  '
                                || v_mode
                                || ' batch
File Name     :  '
                                || lv_outfile_display
                                || '.'
                                || dw_glob_var.gv_cmprs_fl_ext
                                || '
URL           :  '
                                || download_path
                                || lv_outfile_display
                                || '.'
                                || dw_glob_var.gv_cmprs_fl_ext
                                || '
Email provided:  '
                                || p_email
                                || '

You will be notified when the request is processed.'
                                || CHR (10)
                                || CHR (10)
                                || 'List of Filters: '
                                || v_filters);
      END IF;

      request_id := lv_request_id;
   EXCEPTION
      WHEN UTL_FILE.INVALID_PATH
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
         COMMIT;
      WHEN UTL_FILE.INVALID_MODE
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
         COMMIT;
      WHEN UTL_FILE.INVALID_FILEHANDLE
      THEN
         COMMIT;
         DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
      WHEN UTL_FILE.INVALID_OPERATION
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
         COMMIT;
      WHEN UTL_FILE.READ_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('BAD READ');
         COMMIT;
      WHEN UTL_FILE.WRITE_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
         COMMIT;
      WHEN UTL_FILE.INTERNAL_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('INTERNAL');
         COMMIT;
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.put_line (SQLERRM);
   END station_download_custom;

   PROCEDURE result_download_custom (
      v_FromStmt            IN     VARCHAR2 DEFAULT NULL,
      v_WhereStmt           IN     VARCHAR2 DEFAULT NULL,
      vR_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vR_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      vB_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vB_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      vH_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vH_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-06-22: metrics
      vM_FromStmt           IN     VARCHAR2 DEFAULT NULL,
      vM_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
--CCB --2012-08-17: index?
--      vI_FromStmt           IN     VARCHAR2 DEFAULT NULL,
--      vI_WhereStmt          IN     VARCHAR2 DEFAULT NULL,
      v_rule_optimization   IN     VARCHAR2,
      v_report_type         IN     CHAR DEFAULT 'REGULAR',
      v_Columns             IN     OWA_UTIL.vc_arr,
      v_filename            IN     VARCHAR2,
      P_email               IN     VARCHAR2,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
      P_userprofile         IN     NUMBER,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
      P_distinct            IN     VARCHAR2,
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
      p_prefix              IN     VARCHAR2,
      v_mode                IN     VARCHAR2,
      p_record_count        IN     NUMBER,
      v_filters             IN     VARCHAR2,
      out_file                 OUT VARCHAR2,
      request_id               OUT NUMBER,
      r_Type                IN     OWA_UTIL.vc_arr)
   AS
      --The out_file variable, the output of this routine, contains the entire URL of
      --the file created herein for the online processing.
      --For Overnight/Immediate processing only the file name, not the virtual path.

      --Name of downloadable file that will be created on the server.  This
      --file name will be generated based on the current date and time.
      out_file_name         VARCHAR2 (30);

      download_path         VARCHAR2 (100);
      lv_rows               NUMBER;

      v_SQLStmt             VARCHAR2 (32000);
      v_SelectStmt          VARCHAR2 (32000);
      v_Print_Names_List    VARCHAR2 (30000);
      v_FromStmtNew         VARCHAR2 (4000);
      v_WhereStmtNew        VARCHAR2 (4000);
      v_CurrentColumn       VARCHAR2 (200);

      --flags used to ensure a table is not included twice in the FROM clause
      f_LU_GEO_STATE        BOOLEAN := FALSE;
      f_Project_State       BOOLEAN := FALSE;
      v_exists              BOOLEAN;
      v_blocksize           NUMBER;
      LV_FILE_LENGTH        NUMBER;
      LV_FILE_NAME          VARCHAR2 (50);
      LV_FILETYPE           VARCHAR2 (3);
      LV_TIMESTAMP          VARCHAR2 (20);

      lv_basefile           VARCHAR2 (1000);

      v_report_number       NUMBER;

      lv_request_id         dw_data_requests.request_id%TYPE;
      jn                    BINARY_INTEGER;

      vR_SQLStmt            VARCHAR2 (32000);
      vB_SQLStmt            VARCHAR2 (32000);
      vH_SQLStmt            VARCHAR2 (32000);
--CCB --2012-06-22: metrics
      vM_SQLStmt            VARCHAR2 (32000);
--CCB --2012-08-17: index?
--      vI_SQLStmt            VARCHAR2 (32000);

      vR_Print_Names_List   VARCHAR2 (30000);
      vB_Print_Names_List   VARCHAR2 (30000);
      vH_Print_Names_List   VARCHAR2 (30000);
--CCB --2012-06-22: metrics
      vM_Print_Names_List   VARCHAR2 (30000);
--CCB --2012-08-17: index?
--      vI_Print_Names_List   VARCHAR2 (30000);

      lv_curquery           VARCHAR2 (4000);

      TYPE ReportColumn_refcur IS REF CURSOR;

      rc_ReportColumn       ReportColumn_refcur;

      TYPE ReportColumn_rectype IS RECORD
      (
         print_name   VARCHAR2 (255),
         col_name     VARCHAR2 (255)
      );

      ReportColumn          ReportColumn_rectype;

      lv_reg_data           VARCHAR2 (10);
      lv_bio_data           VARCHAR2 (10);
      lv_hab_data           VARCHAR2 (10);
--CCB --2012-06-22: metrics
      lv_met_data           VARCHAR2 (10);
--CCB --2012-08-17: index?
--      lv_met_data           VARCHAR2 (10);
      lv_report_type        VARCHAR2 (25);
   BEGIN
      ROLLBACK;

      --include appropriate tables in FROM clause based on columns selected
      --wshed summary
      IF v_report_type = 'BIOLOGICAL' OR v_report_type = 'ALLRESULTS'
      THEN
         v_print_names_list := NULL;
         v_CurrentColumn := NULL;

         IF v_report_type = 'ALLRESULTS'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := vB_FromStmt;
            v_WhereStmtNew := vB_WhereStmt;
            f_LU_GEO_STATE := FALSE;
            f_Project_State := FALSE;
         ELSIF v_report_type = 'BIOLOGICAL'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := v_FromStmt;
            v_WhereStmtNew := v_WhereStmt;
         END IF;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

         FOR i IN 1 .. v_Columns.LAST
         LOOP
            v_report_number := TO_NUMBER (v_Columns (i));
            lv_curquery := NULL;

            IF v_report_type = 'ALLRESULTS'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE ALL_report_number = '
                  || v_report_number
                  || ' AND bio_report_number IS NOT NULL ORDER BY all_COL_ORDER';
            ELSIF v_report_type = 'BIOLOGICAL'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE bio_report_number = '
                  || v_report_number
                  || ' ORDER BY bio_COL_ORDER';
            END IF;

            OPEN rc_ReportColumn FOR lv_curquery;

            LOOP
               --initialize
               ReportColumn.print_name := NULL;
               ReportColumn.col_name := NULL;

               FETCH rc_ReportColumn
               INTO ReportColumn.print_name, ReportColumn.col_name;

               EXIT WHEN rc_ReportColumn%NOTFOUND;

               v_CurrentColumn := ReportColumn.col_name;
               v_print_names_list :=
                  v_print_names_list || ReportColumn.print_name || CHR (9);

               IF ReportColumn.col_name = 'HD.ID_CODE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hdatum = hd.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hmethod = hm.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
               END IF;

               IF    ReportColumn.col_name = 'STATE_NAME'
                  OR v_Columns (i) = 'COUNTRY_NAME'
               THEN
                  IF f_LU_GEO_STATE = FALSE
                  THEN
                     v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                     v_WhereStmtNew :=
                           v_WhereStmtNew
                        || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                     f_LU_GEO_STATE := TRUE;
                  END IF;
               END IF;

               IF ReportColumn.col_name = 'COUNTY_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_geo_county = gc.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_CurrentColumn := 'ORGANIZATION_NAME';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYSIS_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYTICAL_PROCEDURE_SOURCE'
               THEN
                  v_CurrentColumn :=
                     'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_CATEGORY'
               THEN
                  v_CurrentColumn :=
                     'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
               END IF;

               IF ReportColumn.col_name = 'FA.BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.ACT_BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.STD_VALUE'
               THEN
                  v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
               END IF;

               IF ReportColumn.col_name = 'PRIMARY_TYPE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES ST';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_statn_types = st.pk_isn (+)';
               END IF;

               v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
            END LOOP;
         END LOOP;

         IF v_report_type = 'ALLRESULTS'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            vB_print_names_list := RTRIM (v_print_names_list, CHR (9));

            vB_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         ELSIF v_report_type = 'BIOLOGICAL'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            v_print_names_list := RTRIM (v_print_names_list, CHR (9));

            HTP.PRINT ('v_print_names_list ' || v_print_names_list);

            v_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         END IF;
      END IF;                                                  --WSHED SUMMARY

      IF v_report_type = 'HABITAT' OR v_report_type = 'ALLRESULTS'
      THEN
         v_print_names_list := NULL;
         v_CurrentColumn := NULL;

         IF v_report_type = 'ALLRESULTS'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT  DISTINCT  ';
            END IF;

            v_FromStmtNew := vH_FromStmt;
            v_WhereStmtNew := vH_WhereStmt;
            f_LU_GEO_STATE := FALSE;
            f_Project_State := FALSE;
         ELSIF v_report_type = 'HABITAT'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;
         END IF;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

         FOR i IN 1 .. v_Columns.LAST
         LOOP
            v_report_number := TO_NUMBER (v_Columns (i));
            lv_curquery := NULL;

            IF v_report_type = 'ALLRESULTS'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE ALL_report_number = '
                  || v_report_number
                  || ' AND hab_report_number IS NOT NULL ORDER BY all_COL_ORDER';
            ELSIF v_report_type = 'HABITAT'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE hab_report_number = '
                  || v_report_number
                  || ' ORDER BY hab_COL_ORDER';
            END IF;

            OPEN rc_ReportColumn FOR lv_curquery;

            LOOP
               --initialize
               ReportColumn.print_name := NULL;
               ReportColumn.col_name := NULL;

               FETCH rc_ReportColumn
               INTO ReportColumn.print_name, ReportColumn.col_name;

               EXIT WHEN rc_ReportColumn%NOTFOUND;

               v_CurrentColumn := ReportColumn.col_name;
               v_print_names_list :=
                  v_print_names_list || ReportColumn.print_name || CHR (9);

               IF ReportColumn.col_name = 'HD.ID_CODE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hdatum = hd.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hmethod = hm.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
               END IF;

               IF    ReportColumn.col_name = 'STATE_NAME'
                  OR v_Columns (i) = 'COUNTRY_NAME'
               THEN
                  IF f_LU_GEO_STATE = FALSE
                  THEN
                     v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                     v_WhereStmtNew :=
                           v_WhereStmtNew
                        || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                     f_LU_GEO_STATE := TRUE;
                  END IF;
               END IF;

               IF ReportColumn.col_name = 'COUNTY_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_geo_county = gc.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_CurrentColumn := 'ORGANIZATION_NAME';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYSIS_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYTICAL_PROCEDURE_SOURCE'
               THEN
                  v_CurrentColumn :=
                     'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_CATEGORY'
               THEN
                  v_CurrentColumn :=
                     'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
               END IF;

               IF ReportColumn.col_name = 'FA.BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.ACT_BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.STD_VALUE'
               THEN
                  v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
               END IF;

               IF ReportColumn.col_name = 'PRIMARY_TYPE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES ST';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_statn_types = st.pk_isn (+)';
               END IF;

               v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
            END LOOP;
         END LOOP;

         IF v_report_type = 'ALLRESULTS'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            vH_print_names_list := RTRIM (v_print_names_list, CHR (9));

            vH_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         ELSIF v_report_type = 'HABITAT'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            v_print_names_list := RTRIM (v_print_names_list, CHR (9));

            v_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         END IF;
      END IF;

      IF v_report_type = 'REGULAR' OR v_report_type = 'ALLRESULTS'
      THEN
         v_print_names_list := NULL;
         v_CurrentColumn := NULL;

         IF v_report_type = 'ALLRESULTS'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := vR_FromStmt;
            v_WhereStmtNew := vR_WhereStmt;
            f_LU_GEO_STATE := FALSE;
            f_Project_State := FALSE;
         ELSIF v_report_type = 'REGULAR'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := v_FromStmt;
            v_WhereStmtNew := v_WhereStmt;
         END IF;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

         FOR i IN 1 .. v_Columns.LAST
         LOOP
            v_report_number := TO_NUMBER (v_Columns (i));
            lv_curquery := NULL;

            IF v_report_type = 'ALLRESULTS'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE all_report_number = '
                  || v_report_number
                  || ' AND reg_report_number IS NOT NULL ORDER BY all_COL_ORDER';
            ELSIF v_report_type = 'REGULAR'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE reg_report_number = '
                  || v_report_number
                  || ' ORDER BY reg_COL_ORDER';
            END IF;

            OPEN rc_ReportColumn FOR lv_curquery;

            LOOP
               --initialize
               ReportColumn.print_name := NULL;
               ReportColumn.col_name := NULL;

               FETCH rc_ReportColumn
               INTO ReportColumn.print_name, ReportColumn.col_name;

               EXIT WHEN rc_ReportColumn%NOTFOUND;

               v_CurrentColumn := ReportColumn.col_name;
               v_print_names_list :=
                  v_print_names_list || ReportColumn.print_name || CHR (9);

               IF ReportColumn.col_name = 'HD.ID_CODE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hdatum = hd.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hmethod = hm.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
               END IF;

               IF    ReportColumn.col_name = 'STATE_NAME'
                  OR v_Columns (i) = 'COUNTRY_NAME'
               THEN
                  IF f_LU_GEO_STATE = FALSE
                  THEN
                     v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                     v_WhereStmtNew :=
                           v_WhereStmtNew
                        || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                     f_LU_GEO_STATE := TRUE;
                  END IF;
               END IF;

               IF ReportColumn.col_name = 'COUNTY_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_geo_county = gc.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_CurrentColumn := 'ORGANIZATION_NAME';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYSIS_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYTICAL_PROCEDURE_SOURCE'
               THEN
                  v_CurrentColumn :=
                     'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_CATEGORY'
               THEN
                  v_CurrentColumn :=
                     'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
               END IF;

               IF ReportColumn.col_name = 'FA.BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.ACT_BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.STD_VALUE'
               THEN
                  v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
               END IF;

               IF ReportColumn.col_name = 'PRIMARY_TYPE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES ST';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_statn_types = st.pk_isn (+)';
               END IF;

               v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
            END LOOP;
         END LOOP;

         IF v_report_type = 'ALLRESULTS'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            vR_print_names_list := RTRIM (v_print_names_list, CHR (9));

            vR_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         ELSIF v_report_type = 'REGULAR'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            v_print_names_list := RTRIM (v_print_names_list, CHR (9));

            v_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         END IF;
      END IF;

--CCB --2012-06-22: metrics BEGIN

      IF v_report_type = 'METRIC' OR v_report_type = 'ALLRESULTS'
      THEN
         v_print_names_list := NULL;
         v_CurrentColumn := NULL;

         IF v_report_type = 'ALLRESULTS'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := vM_FromStmt;
            v_WhereStmtNew := vM_WhereStmt;
            f_LU_GEO_STATE := FALSE;
            f_Project_State := FALSE;
         ELSIF v_report_type = 'METRIC'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := v_FromStmt;
            v_WhereStmtNew := v_WhereStmt;
         END IF;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

         FOR i IN 1 .. v_Columns.LAST
         LOOP
            v_report_number := TO_NUMBER (v_Columns (i));
            lv_curquery := NULL;

            IF v_report_type = 'ALLRESULTS'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE all_report_number = '
                  || v_report_number
                  || ' AND met_report_number IS NOT NULL ORDER BY ALL_COL_ORDER';
            ELSIF v_report_type = 'METRIC'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE met_report_number = '
                  || v_report_number
                  || ' ORDER BY MET_COL_ORDER';
            END IF;

            OPEN rc_ReportColumn FOR lv_curquery;

            LOOP
               --initialize
               ReportColumn.print_name := NULL;
               ReportColumn.col_name := NULL;

               FETCH rc_ReportColumn
               INTO ReportColumn.print_name, ReportColumn.col_name;

               EXIT WHEN rc_ReportColumn%NOTFOUND;

               v_CurrentColumn := ReportColumn.col_name;
               v_print_names_list :=
                  v_print_names_list || ReportColumn.print_name || CHR (9);

               IF ReportColumn.col_name = 'HD.ID_CODE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hdatum = hd.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hmethod = hm.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
               END IF;

               IF    ReportColumn.col_name = 'STATE_NAME'
                  OR v_Columns (i) = 'COUNTRY_NAME'
               THEN
                  IF f_LU_GEO_STATE = FALSE
                  THEN
                     v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                     v_WhereStmtNew :=
                           v_WhereStmtNew
                        || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                     f_LU_GEO_STATE := TRUE;
                  END IF;
               END IF;

               IF ReportColumn.col_name = 'COUNTY_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_geo_county = gc.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_CurrentColumn := 'ORGANIZATION_NAME';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYSIS_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYTICAL_PROCEDURE_SOURCE'
               THEN
                  v_CurrentColumn :=
                     'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_CATEGORY'
               THEN
                  v_CurrentColumn :=
                     'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
               END IF;

               IF ReportColumn.col_name = 'FA.BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.ACT_BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.STD_VALUE'
               THEN
                  v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
               END IF;

               IF ReportColumn.col_name = 'LMT.NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_METRICTYPE LMT';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_metrictype = lmt.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'PRIMARY_TYPE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES ST';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_statn_types = st.pk_isn (+)';
               END IF;

               v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
            END LOOP;
         END LOOP;

         IF v_report_type = 'ALLRESULTS'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            vM_print_names_list := RTRIM (v_print_names_list, CHR (9));

            vM_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         ELSIF v_report_type = 'METRIC'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            v_print_names_list := RTRIM (v_print_names_list, CHR (9));

            v_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         END IF;
      END IF;
--CCB --2012-06-22: metrics END

--CCB --2012-08-17: index? BEGIN

      IF v_report_type = 'INDEX' OR v_report_type = 'ALLRESULTS'
      THEN
         v_print_names_list := NULL;
         v_CurrentColumn := NULL;

         IF v_report_type = 'ALLRESULTS'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

--CCB --2012-08-17: index?            v_FromStmtNew := vI_FromStmt;
--CCB --2012-08-17: index?            v_WhereStmtNew := vI_WhereStmt;
            f_LU_GEO_STATE := FALSE;
            f_Project_State := FALSE;
         ELSIF v_report_type = 'METRIC'
         THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)            v_SelectStmt := 'SELECT ';
            v_SelectStmt := 'SELECT DISTINCT  ';

            IF v_rule_optimization = 'TRUE'
            THEN
--CCB --2012-05-23: DISTINCT Clause (v_distinct)               v_SelectStmt := 'SELECT  ';
               v_SelectStmt := 'SELECT DISTINCT  ';
            END IF;

            v_FromStmtNew := v_FromStmt;
            v_WhereStmtNew := v_WhereStmt;
         END IF;

--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian
-- /** --Begin Remark
--
         IF P_distinct = 'ON'
         THEN
            v_SelectStmt := v_SelectStmt;
         ELSE
            v_SelectStmt := REPLACE(v_SelectStmt, 'SELECT DISTINCT ', 'SELECT ');
         END IF;
--
-- **/ --End Remark
--CCB --2012-05-23: DISTINCT Clause (v_distinct) added by Kevin Christian

         FOR i IN 1 .. v_Columns.LAST
         LOOP
            v_report_number := TO_NUMBER (v_Columns (i));
            lv_curquery := NULL;

            IF v_report_type = 'ALLRESULTS'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE all_report_number = '
                  || v_report_number
                  || ' AND met_report_number IS NOT NULL ORDER BY ALL_COL_ORDER';
            ELSIF v_report_type = 'INDEX'
            THEN
               lv_curquery :=
                     'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE met_report_number = '
                  || v_report_number
                  || ' ORDER BY MET_COL_ORDER';
            END IF;

            OPEN rc_ReportColumn FOR lv_curquery;

            LOOP
               --initialize
               ReportColumn.print_name := NULL;
               ReportColumn.col_name := NULL;

               FETCH rc_ReportColumn
               INTO ReportColumn.print_name, ReportColumn.col_name;

               EXIT WHEN rc_ReportColumn%NOTFOUND;

               v_CurrentColumn := ReportColumn.col_name;
               v_print_names_list :=
                  v_print_names_list || ReportColumn.print_name || CHR (9);

               IF ReportColumn.col_name = 'HD.ID_CODE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HDATUM hd';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hdatum = hd.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'GEOPOSITIONING_METHOD'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',LU_MAD_HMETHOD hm';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND fk_act_mad_hmethod = hm.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_ORG og';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_org = og.pk_isn (+)';
               END IF;

               IF    ReportColumn.col_name = 'STATE_NAME'
                  OR v_Columns (i) = 'COUNTRY_NAME'
               THEN
                  IF f_LU_GEO_STATE = FALSE
                  THEN
                     v_FromStmtNew := v_FromStmtNew || ',DI_GEO_STATE gs';
                     v_WhereStmtNew :=
                           v_WhereStmtNew
                        || ' AND FA.fk_geo_state = gs.pk_isn (+)';
                     f_LU_GEO_STATE := TRUE;
                  END IF;
               END IF;

               IF ReportColumn.col_name = 'COUNTY_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_GEO_COUNTY gc';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_geo_county = gc.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'HYDROLOGIC_UNIT_NAME'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_DB_CAT ca';
                  v_WhereStmtNew :=
                     v_WhereStmtNew || ' AND FA.fk_db_cat = ca.pk_isn (+)';
               END IF;

               IF ReportColumn.col_name = 'ORGANIZATION_NAME'
               THEN
                  v_CurrentColumn := 'ORGANIZATION_NAME';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYSIS_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_START_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.VISIT_STOP_DATE_TIME'
               THEN
                  v_CurrentColumn :=
                     'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
               END IF;

               IF ReportColumn.col_name = 'FA.ANALYTICAL_PROCEDURE_SOURCE'
               THEN
                  v_CurrentColumn :=
                     'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
               END IF;

               IF ReportColumn.col_name = 'FA.ACTIVITY_CATEGORY'
               THEN
                  v_CurrentColumn :=
                     'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
               END IF;

               IF ReportColumn.col_name = 'FA.BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.ACT_BLOB_ID'
               THEN
                  v_CurrentColumn :=
                        'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''
                     || dw_glob_var.lv_program_path
                     || 'DW_PAGES.blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
               END IF;

               IF ReportColumn.col_name = 'FA.STD_VALUE'
               THEN
                  v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
               END IF;

--CCB --2012-08-17: index? ...
--               IF ReportColumn.col_name = 'LMT.NAME'
--               THEN
--                  v_FromStmtNew := v_FromStmtNew || ',LU_METRICTYPE LMT';
--                  v_WhereStmtNew :=
--                        v_WhereStmtNew
--                     || ' AND FA.fk_metrictype = lmt.pk_isn (+)';
--               END IF;

               IF ReportColumn.col_name = 'PRIMARY_TYPE'
               THEN
                  v_FromStmtNew := v_FromStmtNew || ',DI_STATN_TYPES ST';
                  v_WhereStmtNew :=
                        v_WhereStmtNew
                     || ' AND FA.fk_statn_types = st.pk_isn (+)';
               END IF;

               v_SelectStmt := v_SelectStmt || v_CurrentColumn || ',';
            END LOOP;
         END LOOP;

         IF v_report_type = 'ALLRESULTS'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

--CCB --2012-08-17: index? ...
--            vI_print_names_list := RTRIM (v_print_names_list, CHR (9));
--
--            vI_SQLStmt :=
--               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         ELSIF v_report_type = 'INDEX'
         THEN
            v_SelectStmt :=
               SUBSTR (v_SelectStmt, 1, (LENGTH (v_SelectStmt) - 1));

            v_print_names_list := RTRIM (v_print_names_list, CHR (9));

            v_SQLStmt :=
               v_SelectStmt || ' ' || v_FromStmtNew || ' ' || v_WhereStmtNew;
         END IF;
      END IF;
--CCB --2012-08-17: index?  END

      -- code for report type check boxes (10/15/2008)
      lv_reg_data := 'NO';
      lv_bio_data := 'NO';
      lv_hab_data := 'NO';
--CCB --2012-06-22: metrics
      lv_met_data := 'NO';
--CCB --2012-08-17: index?
--      lv_ind_data := 'NO';

      FOR i IN 1 .. r_Type.LAST
      LOOP
         lv_report_type := r_Type (i);

         IF lv_report_type = 'REGULAR'
         THEN
            lv_reg_data := 'YES';
         ELSIF lv_report_type = 'BIOLOGICAL'
         THEN
            lv_bio_data := 'YES';
--CCB --2012-06-22: metrics
         ELSIF lv_report_type = 'HABITAT'
         THEN
            lv_hab_data := 'YES';
         ELSIF lv_report_type = 'METRIC'
         THEN
            lv_met_data := 'YES';
--CCB --2012-08-17: index?
--         ELSIF lv_report_type = 'INDEX'
--         THEN
--            lv_ind_data := 'YES';
         END IF;
      END LOOP;

      --checking to see if a filename is passed
      IF (v_filename <> 'NONE')
      THEN
         out_file_name := v_filename;
      ELSE
         -- Generating a unique name for creating a file on the server.
         out_file_name := TO_CHAR (SYSDATE, 'YYYYMMDD_HH24MISS');

         IF v_report_type = 'BIOLOGICAL'
         THEN
            lv_filetype := 'SDB';
         ELSIF v_report_type = 'HABITAT'
         THEN
            lv_filetype := 'SDH';
--CCB --2012-06-22: metrics
         ELSIF v_report_type = 'METRIC'
         THEN
            lv_filetype := 'SDM';
--CCB --2012-08-17: index?
--         ELSIF v_report_type = 'INDEX'
--         THEN
--            lv_filetype := 'SDI';
        ELSIF v_report_type = 'REGULAR'
         THEN
            lv_filetype := 'SDR';
         ELSIF v_report_type = 'ALLRESULTS'
         THEN
            lv_filetype := 'SDA';
         END IF;

         --v2062
         out_file_name := out_file_name || '.txt';
      END IF;

      lv_file_length := NULL;
      lv_file_name := out_file_name;

      --v2062
      lv_timestamp := SUBSTR (out_file_name, 1, 15);
      download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;

      -- out_file is an out parameter.  It holds URL of the downloadable file that
      -- will be created by this procedure.
      IF v_mode = 'Online'
      THEN
         out_file := download_path || out_file_name;
      ELSIF v_mode IN ('Overnight', 'Immediate')
      THEN
         out_file := p_prefix || '_' || out_file_name;
         lv_file_name := p_prefix || '_' || out_file_name;
      END IF;

      --ONLINE IS OBSOLETE.
      IF v_mode = 'Online'
      THEN
         dw_util.write_file (v_SQLStmt,
                             CHR (9),
                             DW_GLOB_VAR.LV_IODIR,
                             out_file_name,
                             v_print_names_list,
                             1,
                             lv_rows);
      END IF;

      -- Online - find the length of the file after closing the file
      IF v_mode = 'Online'
      THEN
         UTL_FILE.fgetattr (dw_glob_var.lv_utl_file_dir,
                            out_file,
                            v_exists,
                            lv_file_length,
                            v_blocksize);

         lv_file_length := ROUND (lv_file_length / 1024, 1);
      ELSE
         lv_file_length := NULL;
      END IF;

      -- Call the Dw_record_data_request to record the request.
      dw_util.record_data_request (v_filters,
                                   lv_filetype,
                                   lv_timestamp,
                                   lv_file_length,
                                   v_print_names_list,
                                   V_MODE,
                                   P_email,
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
-- /** --Begin Remark
--
                                   P_userprofile,
--
-- **/ --End Remark
--CCB --2012-05-22: User Profile (v_userprofile) added by Kevin Christian
                                   v_SQLStmt,
                                   vR_SQLStmt,
                                   vB_SQLStmt,
                                   vH_SQLStmt,
--CCB --2012-06-22: metrics
                                   vM_SQLStmt,
--CCB --2012-08-17: index?
--                                   vI_SQLStmt,
                                   lv_file_name,
                                   p_record_count,
                                   lv_request_id,
                                   vr_print_names_list,
                                   vb_print_names_list,
                                   vH_print_names_list,
--CCB --2012-06-22: metrics
                                   vM_print_names_list,
--CCB --2012-08-17: index?
--                                   vI_print_names_list,
                                   lv_reg_data,
                                   lv_bio_data,
--CCB --2012-06-22: metrics
                                   lv_hab_data,
--CCB --2012-08-17: index?
                                   lv_met_data);
--                                   lv_met_data,
--                                   lv_ind_data);

      IF v_mode = 'Immediate'
      THEN
         DBMS_JOB.SUBMIT (
            jn,
            'dw_util.process_data_request(' || lv_request_id || ');');

         UPDATE dw_data_requests
            SET job_queue_id = jn, processed_date = SYSDATE
          WHERE request_id = lv_request_id;

         COMMIT;
      END IF;

      lv_basefile := REPLACE (out_file, '.txt', '');

      IF v_mode IN ('Overnight', 'Immediate')
      THEN
         dw_mail_pkg.send (
            p_sender_email   => dw_glob_var.gv_storet_email,
            p_from           =>    'STORET Web Site <'
                                || dw_glob_var.gv_storet_email
                                || '>',
            p_to             => dw_mail_pkg.array (p_email),
            p_subject        =>    'STORET data request submitted (PROCESSING).  Request_ID: '
                                || lv_request_id,
            p_body           =>    'Your request for Result Download is submitted for '
                                || v_mode
                                || ' batch processing.

Following is your request information:

Request ID    :  '
                                || lv_request_id
                                || '
Request Type  :  Result Download
Record Count  :  '
                                || p_record_count
                                || '
Request Mode  :  '
                                || v_mode
                                || ' batch
File Name     :  '
                                || lv_basefile
                                || '.'
                                || dw_glob_var.gv_cmprs_fl_ext
                                || '
URL           :  '
                                || download_path
                                || lv_basefile
                                || '.'
                                || dw_glob_var.gv_cmprs_fl_ext
                                || '
Email provided:  '
                                || p_email
                                || '

You will be notified when the request is processed.'
                                || CHR (10)
                                || CHR (10)
                                || 'List of Filters: '
                                || v_filters);
      END IF;

      request_id := lv_request_id;
   EXCEPTION
      WHEN UTL_FILE.INVALID_PATH
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
         COMMIT;
      WHEN UTL_FILE.INVALID_MODE
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
         COMMIT;
      WHEN UTL_FILE.INVALID_FILEHANDLE
      THEN
         COMMIT;
         DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
      WHEN UTL_FILE.INVALID_OPERATION
      THEN
         DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
         COMMIT;
      WHEN UTL_FILE.READ_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('BAD READ');
         COMMIT;
      WHEN UTL_FILE.WRITE_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
         COMMIT;
      WHEN UTL_FILE.INTERNAL_ERROR
      THEN
         DBMS_OUTPUT.PUT_LINE ('INTERNAL');
         COMMIT;
      WHEN OTHERS
      THEN
         HTP.PRINT (
            'ERROR in recording the Data Request.  Please contact storet@epa.gov. (DW_UTIL.RESULT_DOWNLOAD_CUSTOM)');
         HTP.PRINT (SQLERRM);
         DBMS_OUTPUT.PUT_LINE ('ERROR IN DW_UTIL.RESULT_DOWNLOAD_CUSTOM');
         out_file := 'FAILED';
         request_id := -1;
         NULL;
   END result_download_custom;

   PROCEDURE result_download_zip (in_command     IN VARCHAR2,
                                  out_filename   IN VARCHAR2)
   AS
      --The out_file variable will contain the entire URL of the file created within
      --the called download procedures.
      v_zip_rc         NUMBER := 0;
      v_exists         BOOLEAN;
      v_file_length    NUMBER;
      v_blocksize      NUMBER;
      v_time_start     NUMBER;
      v_time_current   NUMBER;
   BEGIN
      v_zip_rc := execmd (in_command);

      v_time_start :=
         TO_NUMBER (
              TO_CHAR (SYSDATE, 'HH24')
            + TO_CHAR (SYSDATE, 'MI') / 60
            + TO_CHAR (SYSDATE, 'SS') / 3600);

      LOOP
         UTL_FILE.fgetattr (dw_glob_var.lv_utl_file_dir,
                            out_filename,
                            v_exists,
                            v_file_length,
                            v_blocksize);
         v_

