
  CREATE OR REPLACE PROCEDURE "STORETW"."DELETEFROMSTORETW"
(
in_TargetTableName IN VARCHAR,
in_TargetColName IN VARCHAR,
in_TargetColType IN VARCHAR,
in_SourceSystem IN VARCHAR,
in_UID	   IN NUMBER,
out_return_val OUT VARCHAR
)
AS

delete_stmt	  VARCHAR(4000);


BEGIN

IF in_TargetTableName ='ACTIVITY' THEN

  DELETE FROM FA_REGULAR_RESULT WHERE SOURCE_SYSTEM='WQX' AND SOURCE_UID=in_uid;
  commit;
  DELETE FROM FA_BIOLOGICAL_RESULT WHERE SOURCE_SYSTEM='WQX' AND SOURCE_UID=in_uid;
  commit;
  DELETE FROM FA_HABITAT_RESULT WHERE SOURCE_SYSTEM='WQX' AND SOURCE_UID=in_uid;
  commit;
  DELETE FROM FA_activity_metric WHERE SOURCE_SYSTEM='WQX' AND SOURCE_act_UID=in_uid;
  commit;
  out_return_val:='SUCCESS';

ELSE

	IF UPPER(in_TargetColType) = 'VARCHAR' THEN
	   delete_stmt := 'Delete from ' || in_TargetTableName ||
	                  ' Where ' || 'UPPER(TRIM(SOURCE_SYSTEM)) = ''' || UPPER(TRIM(in_SourceSystem )) || ''' AND ' ||
					  in_TargetColName || ' LIKE ' || '''' || in_UID || '''';
	ELSIF UPPER(in_TargetColType) = 'NUMBER' THEN
	   delete_stmt := 'Delete from ' || in_TargetTableName ||
	                  ' Where ' || 'UPPER(TRIM(SOURCE_SYSTEM)) = ''' || UPPER(TRIM(in_SourceSystem )) || ''' AND ' ||
					  in_TargetColName || ' = ' || in_UID;

	END IF;

    DBMS_OUTPUT.PUT_LINE(delete_stmt);

	EXECUTE IMMEDIATE delete_stmt;

	out_return_val:='SUCCESS';
	COMMIT;
END IF;
EXCEPTION
    WHEN OTHERS THEN
	BEGIN
       DBMS_OUTPUT.PUT_LINE(SQLERRM);
       out_return_val:='FAILURE';
	END;

END;

/

