
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_BATCH_DOWNLOAD_PICKUP" (p_days number default 30) AS

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  := 'Batch Data Requests';
  v_exists 		      boolean;
  v_file_length 		number;
  v_blocksize 		number;
lv_filesize_kb  number;


cursor c1 is
select request_id,filename,request_status,request_mode,to_char(datetime,'DD-MON-YYYY HH24:MI:SS') DATETIME
from dw_data_requests
where datetime > sysdate-p_days
and request_mode in ('Immediate','Overnight')
order by request_id;


BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,'');

htp.print('<table align = center border= .1 cellspacing = 0 cellpadding=5>');
      htp.print(' <Bold>
       <tr> <td align =center> Request_ID </td>
            <td align =center> Mode </td>
            <td align =center> DateTime </td>
            <td align =center> Filename </td>
            <td align =center> Size </td>
       </tr> </Bold>');
for c1_var in c1 loop
  v_exists := null;
  utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,c1_var.filename||'.gz',v_exists,v_file_length,v_blocksize);
    IF v_exists THEN
      lv_filesize_kb:=ROUND(v_file_length/1024,1);
      htp.print('
       <tr> <td>'||c1_var.request_id ||' </td>
            <td>'||c1_var.request_mode ||' </td>
            <td>'||c1_var.datetime||' </td>
            <td><a href= '||DW_GLOB_VAR.LV_DOWNLOAD_PATH||c1_var.filename||'.gz>'||c1_var.filename||'.gz</a> </td>
            <td>'||lv_filesize_kb ||' Kb</td>
       </tr>');
     end if;
end loop;
    htp.print('</table>');
DW_bottom_of_page();

END;

/

