
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_CHAR_SELECT" (
tabstart in number,
result_type char default 'REGULAR',
station_flag char default 'OFF') AS

--used to generate char alias type list
CURSOR calias IS
SELECT pk_isn, char_alias_type_name
FROM LU_CHAR_ALIAS_TYPE
WHERE char_alias_type_category = 'NT'
ORDER BY pk_isn;

--used to generate char alias type list for Bio results
CURSOR calias_bio IS
SELECT pk_isn, char_alias_type_name
FROM LU_CHAR_ALIAS_TYPE
WHERE char_alias_type_category IS NOT NULL
ORDER BY pk_isn;

BEGIN
htp.print('
<h4>Characteristic</h4>');
IF station_flag = 'ON' THEN
	htp.print('<center>Find Stations with at least one reported value of the selected Characteristics</center>');
END IF;
htp.print('
<table BORDER COLS=1 WIDTH="100%" >
<tr>
<td align="center">
<center>Use the Characteristic Search to create a list of up to 50 Characteristics</center>
<br>
<b>Characteristic Search &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp Search By&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp </b>
<BR>
<font face= "Courier, monospace">
<input type=hidden name="v_char_names">
<input type="text" name="as_char" tabindex='|| to_char(tabstart) ||' size="20" maxlength="20" style="font-size: 10pt; font-family: Courier, monospace">
&nbsp &nbsp &nbsp &nbsp &nbsp
<select name="as_char_alias_type" tabindex='|| to_char(tabstart+1) ||' size="1" style="font-size: 10pt; font-family: Courier, monospace" >
<option value=0>CHARACTERISTIC NAME</option>');
IF result_type = 'BIOLOGICAL' THEN
  FOR alias IN calias_bio LOOP
       htp.formSelectOption(alias.char_alias_type_name, cattributes => 'VALUE='||alias.pk_isn);
  END LOOP;
ELSE
  FOR alias IN calias LOOP
      htp.formSelectOption(alias.char_alias_type_name, cattributes => 'VALUE='||alias.pk_isn);
  END LOOP;
END IF;
htp.print('</font></SELECT>
<BR>
<font face="Arial">
<input type="button" tabindex='|| to_char(tabstart+2) ||' value="Search"  onclick="openWin(''char_alias'')" title="Opens a popup window for characteristic selection">
<input checked type="checkbox" name="taxon_filter" tabindex='|| to_char(tabstart+3) ||' value="ON" >Hide Taxonomic Names
<BR><BR><font face= "Courier, monospace">
<select multiple size="10" name="char_list" style="font-size: 10pt; font-family: Courier, monospace" >
<option>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp Characteristic Name</option>
<option value="dummy">___________________________________________________________</option>
</select></font>
<BR>
<input type="button" tabindex='|| to_char(tabstart+4) ||' value="Clear Selected" onclick="javascript:deleteSelectedFromCharList();" title="Remove highlighted Characteristics from Selected List">
<input type="button" tabindex='|| to_char(tabstart+5) ||' value="Clear All" onclick="javascript:deleteAllFromCharList();" title="Remove all Characteristics from the Selected List">
</font>
</td>
</tr>
</table>');

END;

/

