
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_MONTHLY_STATS" (p_month in date default add_months(sysdate,-1)) is

lv_month char(6):= TO_CHAR(p_month,'YYYYMM');

cursor monthly_stats_cur is
select count(*) Requests,
       request_type,
       decode(f_state,'1','X',f_state) f_state,
       decode(f_county,'1','X',f_county) f_county,
       decode(f_latlong, '1','X',f_latlong) f_latlong,
       decode(f_huc,'1','X',f_huc) f_huc,
       decode(f_stationtype,'1','X',f_stationtype) f_stationtype,
       decode(f_characteristic,'1','X',f_characteristic) f_characteristic,
       decode(f_organization,'1','X',f_organization) f_organization,
       decode(f_station,'1','X',f_station) f_station,
       decode(f_act_startdate,'1','X',f_act_startdate) f_act_startdate,
       decode(f_act_medium,'1','X',f_act_medium) f_act_medium,
       decode(f_project,'1','X',f_project) f_project,
       decode(f_act_intent,'1','X',f_act_intent) f_act_intent,
       decode(f_community_sampled,'1','X',f_community_sampled) f_community_sampled
from dw_data_requests
WHERE TO_CHAR(DATETIME,'YYYYMM') = lv_month
group by f_state,f_county,f_latlong, f_huc,f_stationtype,f_characteristic,
f_organization,f_station,f_act_startdate,f_act_medium,f_project,f_act_intent,
f_community_sampled,request_type
order by Requests desc,request_type;

cursor monthly_type_counts_cur is
select rpad(decode(request_type,'SDS','Station Descriptions (SDS)',
                           'SDR','Regular Results (SDR)',
                           'SDB','Biological Results (SDB)',
                           'SDH','Habitat Results (SDH)'),27) Request_Type,
    count(*) Requests
from dw_data_requests
where TO_CHAR(DATETIME,'YYYYMM') = lv_month
group by Request_Type
order by 1;

cursor monthly_mode_counts_cur is
select rpad(decode(request_mode,'Immediate','Batch (Immediate)','Overnight','Batch (Overnight)',request_mode),18) Request_Mode,count(*) requests
from dw_data_requests
where TO_CHAR(DATETIME,'YYYYMM') = lv_month
group by Request_Mode
order by 1;

/*
lv_total_count number:=0;
lv_request_mode_counts varchar2(500):= null;
lv_request_type_counts varchar2(500):= null;
lv_stats varchar2(3000):= null;
lv_crlf  char(2) default chr(13)||chr(10);
lv_stats_heading varchar2(200);
lv_monthly_mesg varchar2(4000);
*/

lv_total_count number:=0;
lv_request_mode_counts varchar2(6000):= null;
lv_request_type_counts varchar2(6000):= null;
lv_stats varchar2(10000):= null;
lv_crlf  char(2) default chr(13)||chr(10);
lv_stats_heading varchar2(8000);
lv_monthly_mesg varchar2(32000);


begin
/**
lv_stats_heading:= 'State,County,LatLong,HUC,StationType,Characteristic,Organization,Station,ActStartDate,ActMedium,Project,ActIntent,CommunitySampled,RequestType,Requests';
**/
lv_stats_heading:= 'Requests,RequestType,State,County,LatLong,HUC,StnType,Char,Org,Station,ActStart,ActMedium,Project,ActIntent,CommSampled';

-- total counts.
select count(*) into lv_total_count
from dw_data_requests
where TO_CHAR(DATETIME,'YYYYMM') = lv_month;

if lv_total_count > 0 then
--request type counts
for cv_type in monthly_type_counts_cur loop
  if lv_request_type_counts is null then
    lv_request_type_counts:= cv_type.request_type||' --> '||cv_type.requests;
  else
    lv_request_type_counts:= lv_request_type_counts||lv_crlf||cv_type.request_type||' --> '||cv_type.requests;
  end if;
end loop;
--request mode counts
for cv_mode in monthly_mode_counts_cur loop
  if lv_request_mode_counts is null then
    lv_request_mode_counts:= cv_mode.request_mode||' --> '||cv_mode.requests;
  else
    lv_request_mode_counts:= lv_request_mode_counts||lv_crlf||cv_mode.request_mode||' --> '||cv_mode.requests;
  end if;
end loop;

--monthly stats
for cv_stats in monthly_stats_cur loop
  if lv_stats is null then
    lv_stats:=cv_stats.requests||','||cv_stats.request_type||','||
        cv_stats.f_state||','||cv_stats.f_county||','||cv_stats.f_latlong||','||
        cv_stats.f_huc||','||cv_stats.f_stationtype||','||cv_stats.f_characteristic||','||
        cv_stats.f_organization||','||cv_stats.f_station||','||cv_stats.f_act_startdate||','||
        cv_stats.f_act_medium||','||cv_stats.f_project||','||cv_stats.f_act_intent||','||
        cv_stats.f_community_sampled;
  else
    lv_stats:=lv_stats||lv_crlf||
        cv_stats.requests||','||cv_stats.request_type||','||
        cv_stats.f_state||','||cv_stats.f_county||','||cv_stats.f_latlong||','||
        cv_stats.f_huc||','||cv_stats.f_stationtype||','||cv_stats.f_characteristic||','||
        cv_stats.f_organization||','||cv_stats.f_station||','||cv_stats.f_act_startdate||','||
        cv_stats.f_act_medium||','||cv_stats.f_project||','||cv_stats.f_act_intent||','||
        cv_stats.f_community_sampled;
  end if;
end loop;
end if;
lv_monthly_mesg:= '          STORET Central Warehouse Monthly Statistical Report '||lv_crlf;
lv_monthly_mesg:= lv_monthly_mesg||'                    Month : '||rtrim(to_char(p_month,'Month'))||', '||to_char(p_month,'yyyy')||lv_crlf||lv_crlf;

if lv_total_count = 0 then
  lv_monthly_mesg:= lv_monthly_mesg||'No Data requests found.';
elsif lv_total_count > 0 then
  --provide total count
  lv_monthly_mesg:=lv_monthly_mesg||'Total data requests --> '||to_char(lv_total_count);
  -- distribution by type
  lv_monthly_mesg:= lv_monthly_mesg||lv_crlf||lv_crlf||'Report Type Summary'||
    lv_crlf||lv_request_type_counts;
  -- Request Mode summary
  lv_monthly_mesg:= lv_monthly_mesg||lv_crlf||lv_crlf||'Request Mode Summary'||
    lv_crlf||lv_request_mode_counts;
  -- distribution based on filters
  lv_monthly_mesg:= lv_monthly_mesg||lv_crlf||lv_crlf||'Request distribution across filters'||lv_crlf||lv_stats_heading||lv_crlf||lv_stats;
end if;

    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( dw_glob_var.gv_STORET_email),
       p_subject => 'STORET Warehouse Monthly Statistical Report for '||TO_CHAR(p_month,'Mon., YYYY'),
       p_body => lv_monthly_mesg);


end;

/

