
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_RESULT_COUNT" (
--Version2.6 Date: 2010-09-01
geographic 		char default NULL,
as_state 		number default 0,
as_county 		char default 'ALL',
v_county_code 		char default 'ALL',
MAX_LAT_DD 		number default 90,
dir_maxlat 		char default NULL,
MIN_LONG_DD 		number default 180,
dir_minlong		char default NULL,
MAX_LONG_DD 		number default 0,
dir_maxlong		char default NULL,
MIN_LAT_DD 		number default 0,
dir_minlat 		char default NULL,
as_huc 			char default 'ALL',
--D_STYPE_LIST 		owa_util.ident_arr,
--sug added the station_type variable [STATION TYPE]
D_STYPE_LIST 		owa_util.ident_arr default DW_glob_var.empty,
from_mon1		char default 'JAN',
from_dd1		number default 1,
from_yyyy1		number default 1900,
end_mon1		char default TO_CHAR(SYSDATE,'MON'),
end_dd1			number default TO_NUMBER(TO_CHAR(SYSDATE,'DD')),
end_yyyy1		number default TO_NUMBER(TO_CHAR(SYSDATE,'YYYY')),
from_mon2		char default 'DUMMY',
from_dd2		number default 0,
from_yyyy2		number default 0,
end_mon2		char default 'DUMMY',
end_dd2			number default 0,
end_yyyy2		number default 0,
from_mon3		char default 'DUMMY',
from_dd3		number default 0,
from_yyyy3		number default 0,
end_mon3		char default 'DUMMY',
end_dd3			number default 0,
end_yyyy3		number default 0,
from_mon4		char default 'DUMMY',
from_dd4		number default 0,
from_yyyy4		number default 0,
end_mon4		char default 'DUMMY',
end_dd4			number default 0,
end_yyyy4		number default 0,
--characteristic 	char,
v_char_names		char default NULL,
as_char 		char default NULL,
AS_CHAR_ALIAS_TYPE	number default 0,
char_list		owa_util.ident_arr default DW_glob_var.empty,
taxon_filter 		char default 'ON',
--d_org_list		owa_util.ident_arr default DW_glob_var.empty,
--d_proj_list		owa_util.ident_arr default DW_glob_var.empty
d_org_list		number default 0,
d_proj_list		number default 0,
as_proj     		char default NULL,
V_STATION_NAMES		char default NULL,
AS_STATION		char default 'dummy',
station_list		owa_util.ident_arr default DW_glob_var.empty,
as_extref		char default NULL,
d_extref_list		number default 0,
d_medium_list       	owa_util.ident_arr default DW_glob_var.empty,
d_intent_list       	owa_util.ident_arr default DW_glob_var.empty,
d_community_list    	owa_util.ident_arr default DW_glob_var.empty,
searchtype		char default NULL,
result_type		char default 'ALLRESULTS',
source_app               varchar2 default 'WATERSHED',
in_chartype_list   varchar2 default 'ALL',
in_chartype_names varchar2 default 'ALL'
)

AS
v_CursorID		INTEGER;
v_SelectStmt		VARCHAR2(1000);
v_FromStmt		VARCHAR2(1000);
v_WhereStmt		VARCHAR2(3000);
v_SQLStmt		VARCHAR2(5000);
v_Dummy			INTEGER;
v_ResultCount		NUMBER;
--2011-11-07 StationAliasType
v_extref_list		VARCHAR2(500);
v_extref_name		VARCHAR2(500);
v_extref_name_list	VARCHAR2(1000);
v_extref		VARCHAR2(120);
--
v_stype_list		VARCHAR2(500);
v_StateName		varchar2(40);
v_stype_name_list 	varchar2(1000);
v_stype_name		varchar2(100);
v_char_list		varchar2(2000);
v_station_list		varchar2(2000);
v_org_list		varchar2(500);
v_org_id		varchar2(100);
--v_org_id_list		varchar2(500);
v_org_id_list		varchar2(1000);
v_proj_list		varchar2(500);
v_proj_id		varchar2(100);
v_proj_id_list		varchar2(500);
v_begin_date1		date;
v_end_date1		date;
v_begin_date2		date;
v_end_date2		date;
v_begin_date3		date;
v_end_date3		date;
v_begin_date4		date;
v_end_date4		date;
v_fk_begin_date		number(12,0);
v_fk_end_date		number(12,0);
--v_char_flag		BOOLEAN := FALSE;
v_date_flag		BOOLEAN := FALSE;
v_curr_date		varchar2(11) := to_char(SYSDATE,'DD-MON-YYYY');
-- ignore negative values on lat/long
v_maxlat		number := ABS(max_lat_dd);
v_minlat		number := ABS(min_lat_dd);
v_maxlong		number := ABS(max_long_dd);
v_minlong		number := ABS(min_long_dd);
v_medium_list     	varchar2(500);
v_medium_isn_list 	varchar2(50);
v_medium          	varchar2(20);
v_intent_isn_list 	varchar2(50);
v_intent_list     	varchar2(200);
v_intent          	varchar2(20);
v_taxon			boolean := FALSE;
v_community_isn_list  	varchar2(50);
v_community_list  	varchar2(500);
v_community       	varchar2(30);
v_rule_optimization	varchar2(10):= 'FALSE';
--v_max_report_size	number:= 30000;
v_max_report_size	number:= 60000;
--
report_type			varchar2(30):= 'FALSE';
program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100)  :='Result Search Summary';

v_num_repElement 	number;
v_repElement_count	number :=0;

help_file         varchar2(100);

--v_filters varchar2(1000):= '~';
-- 2010-09-01 Search Paramater values: query parameters
v_filters varchar2(32000):= ''; -- ~ is the delimiter for dw_record_data_request
v_parameters varchar2(32000):= '';

-- Variables for National Projects
cpk_isn           number := null;
--proj_cd		varchar2(100) := null;
--proj_nm		varchar2(100) := null;
-- 2010-09-01 Modified
proj_cd		varchar2(256) := null;
proj_nm		varchar2(256) := null;

-- WSHed summary variables
vR_SelectStmt		VARCHAR2(1000);
vR_FromStmt		VARCHAR2(1000);
vR_WhereStmt		VARCHAR2(3000);
vR_SQLStmt		VARCHAR2(5000);
vR_ResultCount		NUMBER;

vB_SelectStmt		VARCHAR2(1000);
vB_FromStmt		VARCHAR2(1000);
vB_WhereStmt		VARCHAR2(3000);
vB_SQLStmt		VARCHAR2(5000);
vB_ResultCount		NUMBER;

vH_SelectStmt		VARCHAR2(1000);
vH_FromStmt		VARCHAR2(1000);
vH_WhereStmt		VARCHAR2(3000);
vH_SQLStmt		VARCHAR2(5000);
vH_ResultCount		NUMBER;

-- 2010-09-01 Modified
vmin_ResultCount		NUMBER;

-- 2010-09-01 Modified
--/*
CURSOR cRepElement IS
	SELECT DISTINCT ELEMENT_NAME, REG_REPORT_NUMBER, REG_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where REG_REPORT_NUMBER IS NOT NULL
	order by REG_REPORT_NUMBER;

CURSOR cBioRepElement IS
	SELECT DISTINCT ELEMENT_NAME, BIO_REPORT_NUMBER, BIO_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where BIO_REPORT_NUMBER IS NOT NULL
	order by BIO_REPORT_NUMBER;

CURSOR cHabRepElement IS
	SELECT DISTINCT ELEMENT_NAME, HAB_REPORT_NUMBER, HAB_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where HAB_REPORT_NUMBER IS NOT NULL
	order by HAB_REPORT_NUMBER;
--*/

-- ALLRESULTS
--WShed summary
CURSOR cALLRepElement IS
	SELECT DISTINCT ELEMENT_NAME, ALL_REPORT_NUMBER, ALL_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where ALL_REPORT_NUMBER IS NOT NULL
	order by ALL_REPORT_NUMBER;


--Cursor retreives National and Non-National Projects
CURSOR nat_proj_list IS
	select A.pk_isn, A.project_cd, ORG.organization_id from di_project A, di_org ORG where
	ORG.pk_isn = A.fk_org and
	A.project_cd = (select B.project_cd from di_project B where B.pk_isn = D_PROJ_LIST);

CURSOR proj_list IS
	select A.pk_isn, A.project_cd, ORG.organization_id from di_project A, di_org ORG where
	ORG.pk_isn = A.fk_org and A.pk_isn = D_PROJ_LIST;


procedure get_date_isn(v_begin_date DATE, v_end_date DATE) is
BEGIN
	SELECT pk_isn INTO v_fk_begin_date
		FROM DI_DATE
		WHERE full_date = v_begin_date;
	SELECT pk_isn INTO v_fk_end_date
		FROM DI_DATE
		WHERE full_date = v_end_date;
END;



BEGIN
    --Wshed summary
-- 2010-09-01 Modified
--/*
--	v_FromStmt := ' ';
	v_FromStmt := 'FROM FA_REGULAR_RESULT FA';
--
v_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
IF result_type = 'REGULAR' THEN
	v_FromStmt := 'FROM FA_REGULAR_RESULT FA';
END IF;
IF result_type = 'BIOLOGICAL' THEN
	v_FromStmt := 'FROM FA_BIOLOGICAL_RESULT FA';
END IF;
IF result_type = 'HABITAT' THEN
	v_FromStmt := 'FROM FA_HABITAT_RESULT FA';
END IF;
--*/
--WShed Summary
IF result_type = 'ALLRESULTS' THEN
   vR_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
   vB_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
   vH_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';

	vR_FromStmt := 'FROM FA_REGULAR_RESULT FA';
	vB_FromStmt := 'FROM FA_BIOLOGICAL_RESULT FA';
	vH_FromStmt := 'FROM FA_HABITAT_RESULT FA';

    vR_WhereStmt := ' WHERE 1=1';
    vB_WhereStmt := ' WHERE 1=1';
    vH_WhereStmt := ' WHERE 1=1';
END IF;



v_WhereStmt := ' WHERE 1=1';
--Generate WHERE statement based on geographic search type
IF geographic = 'StateCounty' THEN
	IF as_state <> 0 THEN
		SELECT state_name into v_StateName
  			From di_geo_state
  			where pk_isn = as_state;
		IF v_County_Code <> 'ALL' THEN
			v_WhereStmt:= v_WhereStmt || ' AND FA.fk_geo_county IN ('||v_County_Code||')';
			--2010-09-01 Modified
			IF result_type = 'ALLRESULTS'  THEN
				vR_WhereStmt:= vR_WhereStmt || ' AND FA.fk_geo_county IN ('||v_County_Code||')';
				vB_WhereStmt:= vB_WhereStmt || ' AND FA.fk_geo_county IN ('||v_County_Code||')';
				vH_WhereStmt:= vH_WhereStmt || ' AND FA.fk_geo_county IN ('||v_County_Code||')';
			END IF;
		ELSE
			v_WhereStmt:= v_WhereStmt || ' AND FA.fk_geo_state = '||as_state;
			--2010-09-01 Modified
			IF result_type = 'ALLRESULTS'  THEN
				vR_WhereStmt:= vR_WhereStmt || ' AND FA.fk_geo_state = '||as_state;
				vB_WhereStmt:= vB_WhereStmt || ' AND FA.fk_geo_state = '||as_state;
				vH_WhereStmt:= vH_WhereStmt || ' AND FA.fk_geo_state = '||as_state;
			END IF;
		END IF;
	--ELSE
		--v_WhereStmt:= 'Where FA.fk_geo_state IS NOT NULL';
	END IF;
ELSIF geographic = 'HUC' THEN
	IF as_huc <> 'ALL' THEN
		--v_WhereStmt:= v_WhereStmt || ' AND FA.hydrologic_unit_code = '''||as_huc||'''';
--	  v_WhereStmt:= v_WhereStmt || ' AND FA.generated_HUC = '''||as_huc||'''';
	  v_WhereStmt:= v_WhereStmt || ' AND FA.fk_gen_db_cat IN (select pk_isn from di_db_cat where HYDROLOGIC_UNIT_CODE IN ('
			|| ''''||as_huc||'''' || '))';

	  --2010-09-01 Modified
	  --WShed Summary
	  IF result_type = 'ALLRESULTS'  THEN
--	  	vR_WhereStmt:= vR_WhereStmt || ' AND FA.generated_HUC = '''||as_huc||'''';
--	  	vB_WhereStmt:= vB_WhereStmt || ' AND FA.generated_HUC = '''||as_huc||'''';
--	  	vH_WhereStmt:= vH_WhereStmt || ' AND FA.generated_HUC = '''||as_huc||'''';
	  	vR_WhereStmt:= vR_WhereStmt || ' AND FA.fk_gen_db_cat IN (select pk_isn from di_db_cat where HYDROLOGIC_UNIT_CODE IN ('
			|| ''''||as_huc||'''' || '))';
	  	vB_WhereStmt:= vB_WhereStmt || ' AND FA.fk_gen_db_cat IN (select pk_isn from di_db_cat where HYDROLOGIC_UNIT_CODE IN ('
			|| ''''||as_huc||'''' || '))';
	  	vH_WhereStmt:= vH_WhereStmt || ' AND FA.fk_gen_db_cat IN (select pk_isn from di_db_cat where HYDROLOGIC_UNIT_CODE IN ('
			|| ''''||as_huc||'''' || '))';
	  END IF;

	END IF;
ELSIF geographic = 'LatLong' THEN
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = 180 AND MAX_LONG_DD = 0
	AND MIN_LAT_DD = 0 and dir_maxlat='NORTH'and dir_minlat='NORTH'
	and dir_maxlong='WEST' and dir_minlong='WEST'
	THEN
		--v_WhereStmt:= null;
            null;
	ELSE
		IF dir_maxlong = 'WEST' THEN
			v_maxlong := -1 * v_maxlong;
		END IF;
		IF dir_minlong = 'WEST' THEN
			v_minlong := -1 * v_minlong;
		END IF;
		IF dir_maxlat = 'SOUTH' THEN
			v_maxlat := -1 * v_maxlat;
		END IF;
		IF dir_minlat = 'SOUTH' THEN
			v_minlat := -1 * v_minlat;
		END IF;
		v_WhereStmt := v_WhereStmt || ' AND stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
		--2010-09-01 Modified
		IF result_type = 'ALLRESULTS'  THEN
			vR_WhereStmt := vR_WhereStmt || ' AND stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
			vB_WhereStmt := vB_WhereStmt || ' AND stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
			vH_WhereStmt := vH_WhereStmt || ' AND stn_latitude BETWEEN '||v_minlat||' AND '||v_maxlat||' AND
			stn_longitude BETWEEN '||v_minlong||' AND '||v_maxlong;
		END IF;
	END IF;
END IF;

--*********
--sug added station type list [STATION TYPE]
--Process station type list and add to WHERE statement if filtering
IF D_STYPE_LIST.LAST > 0 THEN
  IF D_STYPE_LIST(1) <> 'ALL' THEN
	FOR i IN 1 .. d_stype_list.LAST LOOP
		v_stype_list := v_stype_list||d_stype_list(i)||',';
--		SELECT primary_type||'-'||secondary_type INTO v_stype_name
		SELECT decode(secondary_type,null,primary_type,primary_type||'-'||secondary_type ) INTO v_stype_name
			FROM DI_STATN_TYPES
			WHERE PK_ISN = d_stype_list(i);
		v_stype_name_list := v_stype_name_list||v_stype_name||'<br>';
	END LOOP;
	v_stype_list := RTRIM(v_stype_list,',');
	v_WhereStmt := v_WhereStmt||' AND FA.fk_statn_types IN ('||v_stype_list||')';
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
		vR_WhereStmt := vR_WhereStmt||' AND FA.fk_statn_types IN ('||v_stype_list||')';
		vB_WhereStmt := vB_WhereStmt||' AND FA.fk_statn_types IN ('||v_stype_list||')';
		vH_WhereStmt := vH_WhereStmt||' AND FA.fk_statn_types IN ('||v_stype_list||')';
	END IF;
  ELSE
	v_stype_name_list := 'ALL';
  END IF;
END IF;


--**********
--*
--TEST  WSheed summary
--IF RESULT_TYPE ='ALLRESULTS' THEN
-- 2010-09-01 Modified
-- added for WShed Summary test
IF RESULT_TYPE ='ALLRESULTS' AND source_app = 'WATERSHED' THEN
  NULL;
ELSE
--Generate WHERE statement based on DATE ranges
v_begin_date1 := TO_DATE(from_dd1||'-'||from_mon1||'-'||from_yyyy1,'DD-MON-YYYY');
v_end_date1 := TO_DATE(end_dd1||'-'||end_mon1||'-'||end_yyyy1,'DD-MON-YYYY');
IF v_begin_date1 = to_date('01-JAN-1900','DD-MON-YYYY') AND v_end_date1 = v_curr_date
   AND from_mon2 = 'DUMMY' AND end_mon2 = 'DUMMY'
   AND from_mon3 = 'DUMMY' AND end_mon3 = 'DUMMY'
   AND from_mon4 = 'DUMMY' AND end_mon4 = 'DUMMY' THEN
       null;
ELSE
      get_date_isn(v_begin_date1,v_end_date1);
	v_WhereStmt := v_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' AND (fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	END IF;
	v_date_flag := TRUE;
END IF;

IF from_mon2 <> 'DUMMY' AND end_mon2 <> 'DUMMY' THEN
	v_begin_date2 := TO_DATE(from_dd2||'-'||from_mon2||'-'||from_yyyy2,'DD-MON-YYYY');
	v_end_date2 := TO_DATE(end_dd2||'-'||end_mon2||'-'||end_yyyy2,'DD-MON-YYYY');
	get_date_isn(v_begin_date2,v_end_date2);
	v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	END IF;
END IF;

IF from_mon3 <> 'DUMMY' AND end_mon3 <> 'DUMMY' THEN
	v_begin_date3 := TO_DATE(from_dd3||'-'||from_mon3||'-'||from_yyyy3,'DD-MON-YYYY');
	v_end_date3 := TO_DATE(end_dd3||'-'||end_mon3||'-'||end_yyyy3,'DD-MON-YYYY');
	get_date_isn(v_begin_date3,v_end_date3);
	v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	END IF;
END IF;

IF from_mon4 <> 'DUMMY' AND end_mon4 <> 'DUMMY' THEN
	v_begin_date4 := TO_DATE(from_dd4||'-'||from_mon4||'-'||from_yyyy4,'DD-MON-YYYY');
	v_end_date4 := TO_DATE(end_dd4||'-'||end_mon4||'-'||end_yyyy4,'DD-MON-YYYY');
	get_date_isn(v_begin_date4,v_end_date4);
	v_WhereStmt := v_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vB_WhereStmt := vB_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
        vH_WhereStmt := vH_WhereStmt||' OR fk_date_act_start BETWEEN '||v_fk_begin_date||' AND '||v_fk_end_date;
	END IF;
END IF;

IF v_date_flag = TRUE THEN
	v_WhereStmt := v_WhereStmt||')';
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||')';
        vB_WhereStmt := vB_WhereStmt||')';
        vH_WhereStmt := vH_WhereStmt||')';
	END IF;
END IF;

end if;  -- added for WShed Summary test
-- added for WShed Summary test

--Process characteristic list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF char_list.LAST > 1 THEN
	FOR i IN 2 .. char_list.LAST LOOP
		v_char_list := v_char_list||char_list(i)||',';
	END LOOP;
	v_char_list := RTRIM(v_char_list,',');
	--v_FromStmt := v_FromStmt||',STATION_CHAR';
	--v_WhereStmt := v_WhereStmt||' AND fk_fa_statn = sd.pk_isn AND fk_char IN ('||v_char_list||')';
--	v_WhereStmt := v_WhereStmt||' AND fk_char IN ('||v_char_list||')';-- commented for CR-25
	v_WhereStmt := v_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
			|| v_char_list || ')))';
	--2010-09-01 Modified
	IF result_type = 'ALLRESULTS'  THEN
--        vR_WhereStmt := vR_WhereStmt||' AND fk_char IN ('||v_char_list||')';
--        vB_WhereStmt := vB_WhereStmt||' AND fk_char IN ('||v_char_list||')';
--        vH_WhereStmt := vH_WhereStmt||' AND fk_char IN ('||v_char_list||')';
        vR_WhereStmt := vR_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
			|| v_char_list || ')))';
        vB_WhereStmt := vB_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
			|| v_char_list || ')))';
        vH_WhereStmt := vH_WhereStmt||' AND fk_char IN (select pk_isn from di_characteristic where display_name IN (select distinct display_name from di_characteristic where pk_isn IN ('
			|| v_char_list || ')))';
	END IF;
--	v_Char_Flag := TRUE;
END IF;
/**
-- pre-National Project logic
--Process organization list and add to WHERE statement if filtering
  IF D_ORG_LIST.LAST > 1 THEN
IF D_ORG_LIST(1) <> 'ALL' AND D_ORG_LIST(1) <> '' THEN
	FOR i IN 1 .. d_org_list.LAST LOOP
		v_org_list := v_org_list||d_org_list(i)||',';
		SELECT organization_id INTO v_org_id
			FROM DI_ORG
			WHERE PK_ISN = d_org_list(i);
		v_org_id_list := v_org_id_list||v_org_id||'<br>';
	END LOOP;
	v_org_list := RTRIM(v_org_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_org IN ('||v_org_list||')';
ELSIF D_ORG_LIST(1) = 'ALL' THEN
	v_org_id_list := 'ALL';
END IF;
  END IF;
**/

IF D_ORG_LIST <> 0 AND D_PROJ_LIST = 0 AND (station_list.LAST <= 1 OR station_list.count = 0)THEN
	V_ORG_LIST := D_ORG_LIST;
	SELECT organization_id INTO v_org_id
			FROM DI_ORG
			WHERE PK_ISN = d_org_list;
	v_org_id_list := v_org_id_list||v_org_id||'<br>';
	-- v_WhereStmt := v_WhereStmt||' AND fk_org IN ('||v_org_list||')';
	  v_WhereStmt := v_WhereStmt||' AND fa.fk_org IN ('||v_org_list||')';

	--2010-09-01 Modified
	--WShed Summary
	  IF result_type = 'ALLRESULTS'  THEN
	  	vR_WhereStmt := vR_WhereStmt||' AND fa.fk_org IN ('||v_org_list||')';
		vB_WhereStmt := vB_WhereStmt||' AND fa.fk_org IN ('||v_org_list||')';
		vH_WhereStmt := vH_WhereStmt||' AND fa.fk_org IN ('||v_org_list||')';
	  END IF;
END IF;

-- pre-National Project logic
--Process project list and add to WHERE statement if filtering
/*IF D_PROJ_LIST(1) <> 'ALL' AND D_PROJ_LIST(1) <> '' THEN
	FOR i IN 1 .. d_proj_list.LAST LOOP
		v_proj_list := v_proj_list||d_proj_list(i)||',';
		SELECT identification_cd INTO v_proj_id
			FROM DI_PROJECT
			WHERE PK_ISN = d_proj_list(i);
		v_proj_id_list := v_proj_id_list||v_proj_id||'<br>';
	END LOOP;

ELSIF D_PROJ_LIST(1) = 'ALL' THEN
	v_proj_id_list := 'ALL';
END IF;
*/


IF D_PROJ_LIST <> 0 THEN
-- National and Non-National Projects flow through same logic.
		v_proj_list := '';
	IF D_ORG_LIST <= -1 THEN
		FOR nat_proj IN nat_proj_list LOOP
       		v_proj_list := v_proj_list||','||nat_proj.pk_isn;
			v_org_id_list := v_org_id_list||nat_proj.organization_id||'<br>';
		END LOOP;
	ELSE
		FOR nat_proj IN proj_list LOOP
        		v_proj_list := v_proj_list||','||nat_proj.pk_isn;
			v_org_id_list := v_org_id_list||nat_proj.organization_id||'<br>';
		END LOOP;
	END IF;
		v_proj_list := ltrim(v_proj_list,',');

-- National and Non-National Projects should have only 1 project code.  Value as_proj carries in
-- project name 'National Project' for national projects.  Variable proj_cd replaces as_proj with project code
-- concatenated with Project name.
		select project_name into proj_nm from di_project where pk_isn = D_PROJ_LIST;
		if instr(v_proj_list,',') <> 0 then proj_nm := 'National Project (e.g., '||proj_nm||')'; end if;
		select project_cd into proj_cd from di_project where pk_isn = D_PROJ_LIST;
		proj_cd := proj_cd||' - '||proj_nm;


--  Pre-National Project code associated with single-project select and even older multi-project code
--		v_proj_list := d_proj_list;
--		SELECT project_cd INTO v_proj_id
--			FROM DI_PROJECT
--			WHERE PK_ISN = d_proj_list;
--		v_proj_id_list := v_proj_id_list||v_proj_id||'<br>';
--		v_proj_list := RTRIM(v_proj_list,',');


		IF result_type = 'REGULAR' THEN
      		v_FromStmt := v_FromStmt||',REGULAR_RESULT_PROJECT';
		END IF;
		IF result_type = 'BIOLOGICAL' THEN
			v_FromStmt := v_FromStmt||',BIOLOGICAL_RESULT_PROJECT';
		END IF;
		IF result_type = 'HABITAT' THEN
			v_FromStmt := v_FromStmt||',HABITAT_RESULT_PROJECT';
		END IF;
		--2010-09-01 Modified
		--WShed Summary
		IF result_type = 'ALLRESULTS'  THEN
	 	 	vR_FromStmt := vR_FromStmt||',REGULAR_RESULT_PROJECT';
			vB_FromStmt := vB_FromStmt||',BIOLOGICAL_RESULT_PROJECT';
			vH_FromStmt := vH_FromStmt||',HABITAT_RESULT_PROJECT';
		END IF;


	v_WhereStmt := v_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project in('||v_proj_list||')';
	--2010-09-01 Modified
	--WShed Summary
	IF result_type = 'ALLRESULTS'  THEN
          vR_WhereStmt := vR_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project in('||v_proj_list||')';
          vB_WhereStmt := vB_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project in('||v_proj_list||')';
          vH_WhereStmt := vH_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project in('||v_proj_list||')';
	END IF;

-- pre-National Project logic
--  	v_WhereStmt := v_WhereStmt||' AND fk_result = FA.pk_isn AND fk_project = ' ||v_proj_list;
--	V_ORG_LIST := D_ORG_LIST;
--	V_ORG_LIST := 2;
--	SELECT organization_id INTO v_org_id
--			FROM DI_ORG
--			WHERE PK_ISN = d_org_list;
--			WHERE PK_ISN = 2;
--	v_org_id_list := v_org_id_list||v_org_id||'<br>';

	v_rule_optimization := 'TRUE';
	--2010-09-01 Modified
	--v_SelectStmt := 'SELECT /*+ RULE*/ count(FA.pk_isn) INTO :ResultCount';
	v_SelectStmt := 'SELECT count(FA.pk_isn) INTO :ResultCount';
END IF;

--URL variable v_extref=EPABEACH
--2011-11-07 StationAliasType
--Process StationAliasType list and add to WHERE statement if filtering.
v_extref := d_extref_list;
IF D_EXTREF_LIST <> 0 AND (station_list.LAST <= 1 OR station_list.count = 0) THEN
	V_EXTREF_LIST := D_EXTREF_LIST;
	V_EXTREF := D_EXTREF_LIST;
	SELECT REF_SCHEME_ACRONYM INTO v_extref_name
			FROM LU_EXTERNAL_REF_SCHEME
			WHERE PK_ISN = d_extref_list;
		v_extref_name := v_extref_name||'<br>';
		v_extref_name_list := v_extref_name||'<br>';
	v_org_id_list := v_org_id||'<br>';
	v_WhereStmt := v_WhereStmt||' AND  FA.pk_isn in (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('||v_extref_list||'))';
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('||v_extref_list||'))';
        vB_WhereStmt := vB_WhereStmt||' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('||v_extref_list||'))';
        vH_WhereStmt := vH_WhereStmt||' AND fk_station IN (select fk_station from storetw.lu_station_alias lsa, storetw.lu_external_ref_scheme lrs where lrs.pk_isn=lsa.fk_ref_scheme and lrs.pk_isn in  ('||v_extref_list||'))';
	END IF;
END IF;

--Process Station list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF station_list.LAST > 1 THEN
	FOR i IN 2 .. station_list.LAST LOOP
		v_station_list := v_station_list||station_list(i)||',';
	END LOOP;
	v_station_list := RTRIM(v_station_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_station IN ('||v_station_list||')';
	--2010-09-01 Modified
	--WShed Summary
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' AND fk_station IN ('||v_station_list||')';
        vB_WhereStmt := vB_WhereStmt||' AND fk_station IN ('||v_station_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND fk_station IN ('||v_station_list||')';
	END IF;
END IF;

--Process Intent list and add to WHERE statement if filtering.
IF d_intent_list.LAST > 0 THEN
  IF d_intent_list(1) <> 'ALL' THEN
	FOR i IN 1 .. d_intent_list.LAST LOOP
		v_intent_isn_list := v_intent_isn_list||d_intent_list(i)||',';
            SELECT activity_intent INTO v_intent
            FROM di_activity_intent
            WHERE pk_isn = d_intent_list(i);
            v_intent_list := v_intent_list ||v_intent||'<br>';
            IF v_intent = 'Taxon Abundance' THEN    -- activity intent = taxon abundance
               v_taxon := TRUE;
            END IF;
	END LOOP;
	--2011-01-18 Modified
	report_type:='BIOLOGICAL';
	v_intent_isn_list := RTRIM(v_intent_isn_list,',');
	--v_WhereStmt := v_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        v_WhereStmt := v_WhereStmt||' AND 1=0';
	--2010-09-01 Modified
	--WShed Summary
	IF report_type = 'BIOLOGICAL' and result_type = 'ALLRESULTS'  THEN
        --vR_WhereStmt := vR_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        vR_WhereStmt := vR_WhereStmt||' AND 1=0';
        vB_WhereStmt := vB_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND 1=0';
        --vH_WhereStmt := vH_WhereStmt||' AND fk_act_intent IN ('||v_intent_isn_list||')';
	END IF;
  ELSE
	v_intent_list := 'ALL';
      v_taxon := TRUE;
  END IF;
END IF;

--Process Community list and add to WHERE statement if filtering.
IF d_community_list.LAST > 0 THEN
  IF d_community_list(1) <> 'ALL' THEN
	FOR i IN 1 .. d_community_list.LAST LOOP
		v_community_isn_list := v_community_isn_list||d_community_list(i)||',';
            SELECT activity_community INTO v_community
            FROM di_community_sampled
            WHERE pk_isn = d_community_list(i);
            v_community_list := v_community_list ||v_community||'<br>';
	END LOOP;
	v_community_isn_list := RTRIM(v_community_isn_list,',');
	v_WhereStmt := v_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
	--2010-09-01 Modified
	--WShed Summary
	IF result_type = 'ALLRESULTS'  THEN
        --vR_WhereStmt := vR_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
        vB_WhereStmt := vB_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
        --vH_WhereStmt := vH_WhereStmt||' AND (fk_community_sampled IN ('||v_community_isn_list||') OR fk_community_sampled IS NULL)';
	END IF;
  ELSE
	v_community_list := 'ALL';
  END IF;
END IF;

--Process medium list and add to WHERE statement if filtering.
IF d_medium_list.LAST > 0 THEN
  IF d_medium_list(1) <> 'ALL' THEN
	FOR i IN 1 .. d_medium_list.LAST LOOP
		v_medium_isn_list := v_medium_isn_list||d_medium_list(i)||',';
            SELECT activity_medium INTO v_medium
            FROM di_activity_medium
            WHERE pk_isn = d_medium_list(i);
            v_medium_list := v_medium_list ||v_medium||'<br>';
	END LOOP;
	v_medium_isn_list := RTRIM(v_medium_isn_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
	--2010-09-01 Modified
	--WShed Summary
	IF result_type = 'ALLRESULTS'  THEN
        vR_WhereStmt := vR_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
	--2011-01-18 Modified
        vB_WhereStmt := vB_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
        vH_WhereStmt := vH_WhereStmt||' AND 1=0';
        --vH_WhereStmt := vH_WhereStmt||' AND fk_act_medium IN ('||v_medium_isn_list||')';
	END IF;
  ELSE
	v_medium_list := 'ALL';
  END IF;
END IF;

--process chartype_list
  --WShed Summary
	  --2010-09-01 Modified
	  --IF result_type = 'ALLRESULTS'  and in_chartype_list <> 'ALL' THEN
	  IF result_type = 'ALLRESULTS'  AND source_app = 'WATERSHED' and in_chartype_list <> 'ALL' THEN
	  vR_WhereStmt:= vR_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = fa.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  vB_WhereStmt:= vB_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = fa.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  vH_WhereStmt:= vH_WhereStmt || ' AND exists (select 1 from characteristic_chartype cct, lu_chartype ct '
	  	||' where ct.pk_isn = cct.fk_chartype '
		||' and cct.fk_characteristic = fa.fk_char '
		||' and ct.pk_isn in ('||in_chartype_list||'))';

	  END IF;

--Assemble sql statement
--v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||' AND sd.location_point_type = ''*POINT OF RECORD'';END;';
v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||';END;';
--2010-09-01 Modified
--WShed Summary
IF result_type = 'ALLRESULTS'  THEN
	vR_SQLStmt := 'BEGIN '||vR_SelectStmt||' '||vR_FromStmt||' '||vR_WhereStmt||';END;';
	vB_SQLStmt := 'BEGIN '||vB_SelectStmt||' '||vB_FromStmt||' '||vB_WhereStmt||';END;';
	vH_SQLStmt := 'BEGIN '||vH_SelectStmt||' '||vH_FromStmt||' '||vH_WhereStmt||';END;';
END IF;

--WShed Summary
IF result_type = 'ALLRESULTS' THEN
-- REGULAR RESULTS COUNT
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vR_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vR_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vR_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

--BIO RESULTS COUNT
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vB_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vB_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vB_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

--HAB RESULT COUNT
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, vH_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', vH_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', vH_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

	--2010-09-01 Modified
	--WShed Summary
	IF result_type = 'ALLRESULTS'  THEN
		IF v_intent_list = 'ALL' and v_community_list = 'ALL' THEN
			v_ResultCount:= (vR_ResultCount+vB_ResultCount+vH_ResultCount);
		ELSE
			v_ResultCount:= (vR_ResultCount+vB_ResultCount+vH_ResultCount);
		END IF;
	ELSE
			NULL;
	END IF;
else

--Process SQL statement and capture count value
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':ResultCount', v_ResultCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':ResultCount', v_ResultCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

END IF;

--2010-09-01 Modified
--identify the minimum count
vmin_ResultCount := 0;
if vr_resultcount > 0 then
vmin_ResultCount := vr_resultcount;
report_Type:='REGULAR';
end if;

if vb_resultcount > 0 then
  if ((vmin_ResultCount > vb_resultcount) or (vmin_ResultCount = 0)) then
    vmin_ResultCount:= vb_resultcount;
    report_Type:='BIOLOGICAL';
     end if;
end if;

if vh_resultcount > 0 then
  if ((vmin_ResultCount > vh_resultcount) or (vmin_ResultCount = 0)) then
    vmin_ResultCount:= vh_resultcount;
    report_Type:='HABITAT';
    end if;
end if;

-- 2010-09-01 Email Variable for Search Parameter Values
v_parameters:=v_parameters||'Query Parameter Values: '||chr(10);

--Generate HTML page

DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
htp.print('<br><center><h4>Number of Results Returned: '||TO_CHAR(v_ResultCount,'999,999,999')||'</h4></center><table cols=1 border=1 width=500 align="CENTER"><tr><td><table cols=2 width="100%" cellspacing=10>');
htp.print( '<tr><td colspan=2 align="center"><b>Search Criteria</b></td></tr>' );

--Display geographic search parameters based on the selected search option
-- DEBUG SECTION
/*
htp.print( '<br>vR_ResultCount: <b>'||vR_ResultCount||'<br><br></b>');
htp.print( '<br>vB_ResultCount: <b>'||vB_ResultCount||'<br><br></b>');
htp.print( '<br>vH_ResultCount: <b>'||vH_ResultCount||'<br><br></b>');
--
htp.print( '<br>result_type: <b>'||result_type||'<br><br></b>');
htp.print( '<br>geographic: <b>'||geographic||'<br><br></b>');
htp.print( '<br>source_app: <b>'||source_app||'<br><br></b>');
htp.print( '<br>geographic: <b>'||geographic||'<br><br></b>');
htp.print( '<br>as_huc: <b>'||as_huc||'<br><br></b>');
--htp.print( '<br>D_STYPE_LIST: <b>'||D_STYPE_LIST||'<br><br></b>');
htp.print( '<br>searchtype: <b>'||searchtype||'<br><br></b>');
htp.print( '<br>result_type: <b>'||result_type||'<br><br></b>');
htp.print( '<br>source_app: <b>'||source_app||'<br><br></b>');
--htp.print( '<br>v_date_flag: <b>'||v_date_flag||'<br><br></b>');
htp.print( '<br>v_rule_optimization: <b>'||v_rule_optimization||'<br><br></b>');
htp.print( '<br>report_Type: <b>'||report_Type||'<br><br></b>');
htp.print( '<br>program_path: <b>'||program_path||'<br><br></b>');
htp.print( '<br>script_path: <b>'||script_path||'<br><br></b>');
htp.print( '<br>image_path: <b>'||image_path||'<br><br></b>');
htp.print( '<br>page_title: <b>'||page_title||'<br><br></b>');
--
htp.print( '<br>vR_SQLStmt: <b>'||vR_SQLStmt||'<br><br></b>');
htp.print( '<br>vB_SQLStmt: <b>'||vB_SQLStmt||'<br><br></b>');
htp.print( '<br>vH_SQLStmt: <b>'||vH_SQLStmt||'<br><br></b>');
htp.print( '<br>v_SQLStmt: <b>'||v_SQLStmt||'<br><br></b>');
*/
-- DEBUG SECTION
--
--
if (v_ResultCount < dw_glob_var.gv_rslt_Overnight_lmt AND v_ResultCount > 0) then
htp.print('<br><form name=formz action="DW_result_hub_custom" method=POST>');
htp.print('<table width=650 cols=1 border=1 align="center"><tr><td><table cols=3 cellspacing="10"
align="center">
<tr><td colspan=3><b><center>Select Report Type(s)</center></b></td></tr>
<tr>');
 if (vR_ResultCount > 0 )then
      htp.print('<td><input type="checkbox" name="r_Type" value="REGULAR" CHECKED > REGULAR
('||vR_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="REGULAR" disabled="disabled"> REGULAR(
'||vR_ResultCount||' record(s)) </input></td>');
     end if;
    if (vB_ResultCount > 0 or v_intent_list <>'ALL' or v_community_list <> 'ALL')then
      htp.print('<td><input type="checkbox" name="r_Type" value="BIOLOGICAL" CHECKED > BIOLOGICAL
('||vB_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="BIOLOGICAL" disabled="disabled"> BIOLOGICAL
('||vB_ResultCount||' record(s))</input></td>');

    end if;
    if (vH_ResultCount > 0 )then
      htp.print('<td><input type="checkbox" name="r_Type" value="HABITAT" CHECKED > HABITAT
('||vH_ResultCount||' record(s))</input></td>');

    else
      htp.print('<td><input type="checkbox" name="r_Type" value="HABITAT" disabled="disabled"> HABITAT
('||vH_ResultCount||' record(s))
      </input></td>');
    end if;
    end if;
 htp.print('</tr>
 <tr><td colspan=3></td></tr> </table></tr></td></table>');
--
htp.print('<table cols=1 border=1 width=500 align="CENTER"><tr><td><table cols=2 width="100%" cellspacing=10>');
htp.print( '<tr><td colspan=2 align="center"><b>Search Criteria</b></td></tr>' );
--
--Display geographic search parameters based on the selected search option
IF geographic = 'StateCounty' THEN
	IF as_state <> 0 THEN
	  v_filters:=v_filters||'~'||'State';
	  v_parameters:=v_parameters||'State: '||chr(9)||v_StateName||chr(10);
		IF v_County_Code <> 'ALL' THEN
  	   	  v_filters:=v_filters||'~'||'County';
  	   	  v_parameters:=v_parameters||'County: '||chr(9)||as_county||chr(10);
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> '||as_county||'</b></td></tr>' );
		ELSE
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
		END IF;
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> ALL</b></td></tr>' );
		htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
	END IF;
ELSIF geographic = 'HUC' THEN
	IF as_huc IS NOT NULL THEN
           IF as_huc <> 'ALL' THEN
	       v_filters:=v_filters||'~'||'HUC';
	       v_parameters:=v_parameters||'HUC: '||chr(9)||as_huc||chr(10);
           END IF;
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> '||as_huc||'</b></td></tr>' );
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> ALL</b></td></tr>' );
	END IF;
ELSIF geographic = 'LatLong' THEN
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = -180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0 THEN
		htp.print( '<tr><td width="50%" align="right"><b>Latitude/Longitude: </td><td> ALL</b></td></tr>' );
	ELSE
/**
		htp.print( '<tr><td width="50%" align="right"><b>MIN Latitude: </td><td> '||MIN_LAT_DD||' '||dir_minlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MAX Latitude: </td><td> '||MAX_LAT_DD||' '||dir_maxlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MIN Longitude: </td><td> '||MIN_LONG_DD||' '||dir_minlong||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>MAX Longitude: </td><td> '||MAX_LONG_DD||' '||dir_maxlong||'</b></td></tr>' );
**/
		htp.print( '<tr><td width="50%" align="right"><b>North Limit: </td><td> '||MAX_LAT_DD||' '||dir_maxlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>South Limit: </td><td> '||MIN_LAT_DD||' '||dir_minlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>East Limit: </td><td> '||MAX_LONG_DD||' '||dir_maxlong||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>West Limit: </td><td> '||MIN_LONG_DD||' '||dir_minlong||'</b></td></tr>' );

	END IF;
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = 180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0
 	 and dir_maxlat='NORTH'and dir_minlat='NORTH' and dir_maxlong='WEST' and dir_minlong='WEST'
	THEN
	  null;
	else
	  v_filters:=v_filters||'~'||'LatLong';
   	   v_parameters:=v_parameters||'Latitude/Longitude: '||chr(10);
   	   v_parameters:=v_parameters||'North Limit: '||chr(9)||MAX_LAT_DD||' '||dir_maxlat||chr(10);
   	   v_parameters:=v_parameters||'South Limit: '||chr(9)||MIN_LAT_DD||' '||dir_minlat||chr(10);
   	   v_parameters:=v_parameters||'East Limit: '||chr(9)||MAX_LONG_DD||' '||dir_maxlong||chr(10);
   	   v_parameters:=v_parameters||'West Limit: '||chr(9)||MIN_LONG_DD||' '||dir_minlong||chr(10);
	end if;
END IF;

--htp.print( '<tr><td align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

--sug added the station type filter [STATION TYPE]
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );
if v_STYPE_Name_LIST is null then
  null;
elsif v_STYPE_Name_LIST = 'ALL' THEN
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );
  NULL;
ELSE
  v_filters:=v_filters||'~'||'StationType';
  v_parameters:=v_parameters||'StationType: '||chr(9)||v_STYPE_Name_LIST||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

end if;
--*****
-- 2011-01-18 Display and Email Query Parameters
if v_medium_list is null then
  null;
elsif v_medium_list = 'ALL' THEN
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Medium Type(s): </td><td> '||v_medium_list||'</b></td></tr>' );
  NULL;
ELSE
  v_filters:=v_filters||'~'||'Act_Medium';
  v_parameters:=v_parameters||'MediumType: '||chr(9)||v_medium_list||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Medium Type(s): </td><td> '||v_medium_list||'</b></td></tr>' );

end if;
--*****
if v_intent_list is null then
  null;
elsif v_intent_list = 'ALL' THEN
--htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Intent(s): </td><td> '||v_intent_list||'</b></td></tr>' );
  NULL;
ELSE
  v_filters:=v_filters||'~'||'Act_Intent';
  v_parameters:=v_parameters||'ActivityIntent: '||chr(9)||v_intent_list||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Intent(s): </td><td> '||v_intent_list||'</b></td></tr>' );

	if v_community_list is null then
	  null;
	elsif v_community_list = 'ALL' THEN
	  v_parameters:=v_parameters||'CommunitySampled: '||chr(9)||v_community_list||chr(10);
	  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Community Sampled(s): </td><td> '||v_community_list||'</b></td></tr>' );
	  NULL;
	ELSE
	  v_filters:=v_filters||'~'||'CommunitySampled';
	  v_parameters:=v_parameters||'CommunitySampled: '||chr(9)||v_community_list||chr(10);
	  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Community Sampled(s): </td><td> '||v_community_list||'</b></td></tr>' );

	end if;

end if;
--*****



IF v_org_id_list IS NOT NULL THEN
	  v_filters:=v_filters||'~'||'Organization';
	  v_parameters:=v_parameters||'Organization(s): '||chr(9)||v_org_id_list||chr(10);
	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Organization: </td><td> '||v_org_id_list||'</b></td></tr>');
END IF;

--IF v_proj_id_list IS NOT NULL THEN
IF v_proj_list IS NOT NULL THEN
	  v_filters:=v_filters||'~'||'Project';
	  v_parameters:=v_parameters||'Project(s): '||chr(9)||proj_cd||chr(10);
--	htp.print( '<tr><td align="right" valign="top"><b>Project: </td><td> '||as_proj||'</b></td></tr>');
	htp.print( '<tr><td align="right" valign="top"><b>Project: </td><td> '||proj_cd||'</b></td></tr>');
END IF;

IF TRIM(v_station_names) IS NOT NULL THEN
	 v_filters:=v_filters||'~'||'Organization';
	 v_filters:=v_filters||'~'||'Stations';
	 v_parameters:=v_parameters||'Organization/Stations: '||chr(10);
	 v_parameters:=v_parameters||'Station(s): '||chr(9)||v_station_names||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station(s): </td><td> '||v_station_names||'</b></td></tr>');
END IF;

--URL variable v_extref=EPABEACH
--2011-11-07 StationAliasType
IF TRIM(v_extref_name) IS NOT NULL THEN
	 v_filters:=v_filters||'~'||'Organization';
	 v_filters:=v_filters||'~'||'StationAliasType';
   v_parameters:=v_parameters||'StationAliasType(s): '||chr(9)||v_extref_name||chr(10);
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>StationAliasType(s): </td><td> '||v_extref_name||'</b></td></tr>');
END IF;

IF v_date_flag <> TRUE THEN
   IF result_type = 'ALLRESULTS' THEN
     null;
   ELSE
	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Start Dates: </td><td> ALL</b></td></tr>');
   END IF;
ELSE
	 v_filters:=v_filters||'~'||'Act_StartDate';
	 v_parameters:=v_parameters||'Activity Start Date(s): '||chr(9)||to_char(v_begin_date1,'DD-MON-YYYY')||' to '||to_char(v_end_date1,'DD-MON-YYYY')||chr(10);
  	htp.print( '<tr><td width="50%" align="right" valign="top"><b>Activity Start Dates: </td><td> '||to_char(v_begin_date1,'DD-MON-YYYY')||' to '||to_char(v_end_date1,'DD-MON-YYYY')||'</b>');
  	IF v_begin_date2 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date2,'DD-MON-YYYY')||' to '||to_char(v_end_date2,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date2,'DD-MON-YYYY')||' to '||to_char(v_end_date2,'DD-MON-YYYY'));
  	END IF;
  	IF v_begin_date3 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date3,'DD-MON-YYYY')||' to '||to_char(v_end_date3,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date3,'DD-MON-YYYY')||' to '||to_char(v_end_date3,'DD-MON-YYYY'));
 	 END IF;
  	IF v_begin_date4 IS NOT NULL THEN
	 v_parameters:=v_parameters||'                        '||chr(9)||to_char(v_begin_date4,'DD-MON-YYYY')||' to '||to_char(v_end_date4,'DD-MON-YYYY')||chr(10);
	  	htp.print('<BR>'|| to_char(v_begin_date4,'DD-MON-YYYY')||' to '||to_char(v_end_date4,'DD-MON-YYYY'));
  	END IF;
	htp.print('</td></tr>');
END IF;

IF result_type = 'BIOLOGICAL' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Intent(s): </td><td> '||v_intent_list||'</b></td></tr>');
       if v_intent_list = 'ALL' then
         null;
       else
	 v_filters:=v_filters||'~'||'Act_Intent';
	 v_parameters:=v_parameters||'Activity Intent: '||chr(9)||v_intent_list||chr(10);
       end if;
  IF v_taxon = TRUE THEN
       if v_community_list = 'ALL' then
         null;
       else
	 v_filters:=v_filters||'~'||'CommunitySampled';
	 v_parameters:=v_parameters||'Community Sampled: '||chr(9)||v_community_list||chr(10);
       end if;
    htp.print( '<tr><td align="right" valign="top"><b>Community Sampled: </td><td> '||v_community_list||'</b></td></tr>');
  END IF;
END IF;

IF result_type = 'REGULAR' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Medium: </td><td> '||v_medium_list||'</b></td></tr>');
    IF v_medium_list = 'ALL' THEN
      NULL;
    ELSE
	 v_filters:=v_filters||'~'||'Act_Medium';
	 v_parameters:=v_parameters||'Activity Medium: '||chr(9)||v_medium_list||chr(10);
    END IF;
END IF;

IF TRIM(v_char_names) IS NULL THEN
  IF result_type = 'ALLRESULTS' THEN
    NULL;
  ELSE
    htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> ALL</b></td></tr>');
  END IF;
ELSE
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> '||v_char_names||'</b></td></tr>');
  v_filters:=v_filters||'~'||'Characteristic';
  v_parameters:=v_parameters||'Characteristic(s): '||chr(9)||v_char_names||chr(10);
END IF;

IF result_type = 'ALLRESULTS'  and in_chartype_names <> 'ALL' THEN
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic Type(s): </td><td> '||in_chartype_names||'</b></td></tr>');
  v_filters:=v_filters||'~'||'Chartype';
--v_filters:=v_filters||'~'||'Characteristic';
  v_parameters:=v_parameters||'Characteristic Type(s): '||chr(9)||in_chartype_names||chr(10);
END IF;

htp.print('</table></td></tr></table>');

--2010-09-01 Assign Variable for Email Message Body
--CONCATENATE filters list + line feed <return>
--            parameters list for PROCESSING Email
v_filters:=v_filters||'~'||chr(10)||chr(10)||v_parameters;
-- 2011-01-11 CHARACTERS 1000 ===> 32000
--
--htp.print( '<br><br><b>'||v_SQLStmt||'<br><br></b>');
--Display report choices and report column select boxes
--
--following are added for debug/development
--htp.print('resultcount '||v_resultcount);
--htp.print('r_resultcount '||vr_resultcount);
--htp.print('b_resultcount '||vb_resultcount);
--htp.print('h_resultcount '||vh_resultcount);
--htp.print('min_resultcount '||vmin_resultcount);
--end of debug/develop
--
-- DEBUG SECTION
/*
htp.print( '<br>vR_ResultCount: <b>'||vR_ResultCount||'<br><br></b>');
htp.print( '<br>vB_ResultCount: <b>'||vB_ResultCount||'<br><br></b>');
htp.print( '<br>vH_ResultCount: <b>'||vH_ResultCount||'<br><br></b>');
--
htp.print( '<br>result_type: <b>'||result_type||'<br><br></b>');
htp.print( '<br>geographic: <b>'||geographic||'<br><br></b>');
htp.print( '<br>source_app: <b>'||source_app||'<br><br></b>');
htp.print( '<br>geographic: <b>'||geographic||'<br><br></b>');
htp.print( '<br>as_huc: <b>'||as_huc||'<br><br></b>');
--htp.print( '<br>D_STYPE_LIST: <b>'||D_STYPE_LIST||'<br><br></b>');
htp.print( '<br>searchtype: <b>'||searchtype||'<br><br></b>');
htp.print( '<br>result_type: <b>'||result_type||'<br><br></b>');
htp.print( '<br>source_app: <b>'||source_app||'<br><br></b>');
--htp.print( '<br>v_date_flag: <b>'||v_date_flag||'<br><br></b>');
htp.print( '<br>v_rule_optimization: <b>'||v_rule_optimization||'<br><br></b>');
htp.print( '<br>report_Type: <b>'||report_Type||'<br><br></b>');
htp.print( '<br>program_path: <b>'||program_path||'<br><br></b>');
htp.print( '<br>script_path: <b>'||script_path||'<br><br></b>');
htp.print( '<br>image_path: <b>'||image_path||'<br><br></b>');
htp.print( '<br>page_title: <b>'||page_title||'<br><br></b>');
--
--htp.print( '<br>v_date_flag: <b>'||v_date_flag||'<br><br></b>');
htp.print( '<br>v_filters: <b>'||v_filters||'<br><br></b>');
htp.print( '<br>v_parameters: <b>'||v_parameters||'<br><br></b>');
htp.print( '<br>Characteristic List: <b>'||v_char_names||'<br><br></b>');
htp.print( '<br>Project List: <b>'||v_ORG_ID_LIST||' , '||proj_cd||'<br><br></b>');
--
--as_extref
htp.print( '<br>External Ref Scheme: <b>'||as_extref||'<br><br></b>');
htp.print( '<br>Station List: <b>'||v_station_names||'<br><br></b>');
htp.print( '<br>Intent List: <b>'||v_intent_list||'<br><br></b>');
htp.print( '<br>Community List: <b>'||v_community_list||'<br><br></b>');
htp.print( '<br>Medium List: <b>'||v_medium_list||'<br><br></b>');
--
htp.print( '<br>vR_SQLStmt: <b>'||vR_SQLStmt||'<br><br></b>');
htp.print( '<br>vB_SQLStmt: <b>'||vB_SQLStmt||'<br><br></b>');
htp.print( '<br>vH_SQLStmt: <b>'||vH_SQLStmt||'<br><br></b>');
htp.print( '<br>v_SQLStmt: <b>'||v_SQLStmt||'<br><br></b>');
--
*/
-- DEBUG SECTION
IF v_ResultCount = 0 THEN
	htp.print('<br><center> No Results match your search criteria. Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');
ELSIF v_ResultCount > dw_glob_var.gv_rslt_Overnight_lmt	THEN
	htp.print('<br><center> The number of Results that match your search criteria has exceeded the <BR> allowable
Result Report size limit of '||TO_CHAR(dw_glob_var.gv_rslt_Overnight_lmt,'999,999,999')||'.  Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');

  elsif (vmin_ResultCount  > dw_glob_var.gv_rslt_online_lmt and vmin_ResultCount  <= dw_glob_var.gv_rslt_Immediate_lmt) then
    -- provide Immediate and Overnight options
       htp.print('<br><center> Select ''Back'' to modify search parameters and refine your query. '||
              '<BR>Select Batch Processing to generate the report offline based on your current selections.  '||
              '<BR>You may customize the content of your report by selecting Data Elements below.</center>');
htp.print('<br>
<input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
<input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
<!--WShed Summary -->
<input type="hidden" name="vR_FromStmt" value="'||vR_FromStmt||'">
<input type="hidden" name="vR_WhereStmt" value="'||vR_WhereStmt||'">

<input type="hidden" name="vB_FromStmt" value="'||vB_FromStmt||'">
<input type="hidden" name="vB_WhereStmt" value="'||vB_WhereStmt||'">

<input type="hidden" name="vH_FromStmt" value="'||vH_FromStmt||'">
<input type="hidden" name="vH_WhereStmt" value="'||vH_WhereStmt||'">


<input type="hidden" name="v_ResultCount" value="'||v_ResultCount||'">
<input type="hidden" name="vR_ResultCount" value="'||vR_ResultCount||'">
<input type="hidden" name="vB_ResultCount" value="'||vB_ResultCount||'">
<input type="hidden" name="vH_ResultCount" value="'||vH_ResultCount||'">
<input type="hidden" name="v_filters" value="'||v_filters||'">
<input type="hidden" name="v_rule_optimization" value="'||v_rule_optimization||'">
<input type="hidden" name="v_report_type" value="'||result_type||'">
<input type="hidden" name="v_mode" value="Immediate">
<input type="hidden" name="r_Type" value="'||report_Type||'">
   <table cols=2 cellspacing=10 align="center" width=600>
    <tr><td colspan=2 align=left>Please enter your email address: <input type="text" size=50 maxlength=50 name=''v_email''></td></tr>
    <tr><td colspan=2 align=left>Please specify three characters to prefix your report name : <input type="text" size=3 maxlength=3 name=''v_prefix''></td>
    </tr>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=2 border=0 cellspacing=10>
			<tr cellpadding = 10><td colspan=2 align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td width=230 align="center"><input type="button" value="Immediate" width=40 onClick=document.formz.v_mode.value=''Immediate'';valiDeferInput();></td>
                   <td width=230  align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td colspan=2  align=left>Note: Immediate Batch processing is limited to data requests with results up to '||dw_glob_var.gv_rslt_Immediate_lmt||'. Any Immediate Batch request over the limit will be automatically scheduled as Overnight Batch.</td></tr>

                  <tr><td colspan=2  align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');

  elsif vmin_ResultCount  > dw_glob_var.gv_rslt_Immediate_lmt and v_ResultCount <= dw_glob_var.gv_rslt_Overnight_lmt then
    -- provide Overnight option only
    htp.print('<br><center> Select ''Back'' to modify search parameters and refine your query. '||
              '<BR>Select Batch Processing to generate the report offline based on your current selections.  '||
              '<BR>You may customize the content of your report by selecting Data Elements below.</center>');
htp.print('<br>
<input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
<input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
<!--WShed Summary -->
<input type="hidden" name="vR_FromStmt" value="'||vR_FromStmt||'">
<input type="hidden" name="vR_WhereStmt" value="'||vR_WhereStmt||'">

<input type="hidden" name="vB_FromStmt" value="'||vB_FromStmt||'">
<input type="hidden" name="vB_WhereStmt" value="'||vB_WhereStmt||'">

<input type="hidden" name="vH_FromStmt" value="'||vH_FromStmt||'">
<input type="hidden" name="vH_WhereStmt" value="'||vH_WhereStmt||'">

<input type="hidden" name="v_ResultCount" value="'||v_ResultCount||'">
<input type="hidden" name="vR_ResultCount" value="'||vR_ResultCount||'">
<input type="hidden" name="vB_ResultCount" value="'||vB_ResultCount||'">
<input type="hidden" name="vH_ResultCount" value="'||vH_ResultCount||'">
<input type="hidden" name="v_filters" value="'||v_filters||'">
<input type="hidden" name="v_rule_optimization" value="'||v_rule_optimization||'">
<input type="hidden" name="v_report_type" value="'||result_type||'">
<input type="hidden" name="v_mode" value="Overnight">
   <table cols=2 cellspacing=10 align="center" width=600>
    <tr><td colspan=2 align=left>Please enter your email address: <input type="text" size=50 maxlength=50 name=''v_email''></td></tr>
    <tr><td colspan=2 align=left>Please specify three characters to prefix your report name : <input type="text" size=3 maxlength=3 name=''v_prefix''></td>
    </tr>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=1 border=0 cellspacing=10>
			<tr cellpadding = 10><td align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td align="center"><input type="button" value="Overnight"  width=40 onClick=valiDeferInput();></td>
                  </tr>
                  <tr><td align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');
 end if;
-- end of changes for sir1633
if (v_ResultCount < dw_glob_var.gv_rslt_Overnight_lmt AND v_ResultCount > 0) then
htp.print('<table width=850 cols=1 border=1 align="center"><tr><td colspan=4><b><center>Select Data Elements for Report(s)</center></b></td></tr>
<tr><td valign="top" width="25%">
');
/*
IF result_type = 'REGULAR' THEN
	SELECT COUNT(DISTINCT(REG_REPORT_NUMBER)) INTO v_num_repElement
		FROM APP_COLUMN_NAME
		WHERE REG_REPORT_NUMBER IS NOT NULL;

	FOR RepElement in cRepElement LOOP
		IF v_repElement_count >= v_num_repElement/3 THEN
			htp.print('</td><td valign="top">');
			v_repElement_count := 0;
		END IF;
		v_repElement_count := v_repElement_count +1;
		IF RepElement.REG_ELEMENT_DEFAULT ='Y' THEN
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.reg_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
			htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.reg_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		ELSE
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.reg_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
			htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.reg_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		END IF;
	END LOOP;
END IF;

IF result_type = 'BIOLOGICAL' THEN
	SELECT COUNT(DISTINCT(BIO_REPORT_NUMBER)) INTO v_num_repElement
		FROM APP_COLUMN_NAME
		WHERE BIO_REPORT_NUMBER IS NOT NULL;

	FOR RepElement in cBIORepElement LOOP
		IF v_repElement_count >= v_num_repElement/3 THEN
			htp.print('</td><td valign="top">');
			v_repElement_count := 0;
		END IF;
		v_repElement_count := v_repElement_count +1;
		IF RepElement.BIO_ELEMENT_DEFAULT ='Y' THEN
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.BIO_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.BIO_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		ELSE
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.BIO_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.BIO_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		END IF;
	END LOOP;
END IF;

IF result_type = 'HABITAT' THEN
	SELECT COUNT(DISTINCT(HAB_REPORT_NUMBER)) INTO v_num_repElement
		FROM APP_COLUMN_NAME
		WHERE HAB_REPORT_NUMBER IS NOT NULL;

	FOR RepElement in cHABRepElement LOOP
		IF v_repElement_count >= v_num_repElement/3 THEN
			htp.print('</td><td valign="top">');
			v_repElement_count := 0;
		END IF;
		v_repElement_count := v_repElement_count +1;
		IF RepElement.HAB_ELEMENT_DEFAULT ='Y' THEN
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.HAB_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.HAB_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		ELSE
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.HAB_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.HAB_report_number||'">'||RepElement.element_name||'<br>');
			END IF;

		END IF;
	END LOOP;
END IF;
*/
IF result_type = 'ALLRESULTS' THEN
	SELECT COUNT(DISTINCT(ALL_REPORT_NUMBER)) INTO v_num_repElement
		FROM APP_COLUMN_NAME
		WHERE ALL_REPORT_NUMBER IS NOT NULL;

	FOR RepElement in cALLRepElement LOOP
		IF v_repElement_count >= v_num_repElement/3 THEN
			htp.print('</td><td valign="top">');
			v_repElement_count := 0;
		END IF;
		v_repElement_count := v_repElement_count +1;
		IF RepElement.ALL_ELEMENT_DEFAULT ='Y' THEN
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.ALL_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.ALL_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		ELSE
			IF RepElement.HELP_LINK > 0 THEN
				help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.ALL_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
			ELSE
				htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.ALL_report_number||'">'||RepElement.element_name||'<br>');
			END IF;
		END IF;
	END LOOP;
END IF;

htp.print('
</td></tr></table>
<center>
<input type="button" value="Select All" onClick=longReport();>
<input type="button" value="Clear All" onClick=clearReport();>
<input type="RESET" value="Restore Defaults">
</center>
</td></tr><br></table><br>');
--*********************************************************************
--sug included the comment [HELP CHANGE]
htp.print('<table align=right>
<tr><td><font size=1>*Element Group.  Click to see the Element list</font></td></tr></table>');
--*********************************************************************
end if;
if v_ResultCount <= dw_glob_var.gv_rslt_online_lmt AND v_ResultCount > 0 then
-- online processing
htp.print('<table cols=2 cellspacing=10 align="center" width=500><tr><td width=250>
<center><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></center></td><td>
<left><input type="button" value="Continue>>" onClick=submitReport();><left></td></tr></table>
</form>');

elsif (vmin_ResultCount  > dw_glob_var.gv_rslt_online_lmt and vmin_ResultCount  <= dw_glob_var.gv_rslt_Immediate_lmt) then
--elsif (v_ResultCount  > dw_glob_var.gv_rslt_online_lmt and v_ResultCount  <= dw_glob_var.gv_rslt_Immediate_lmt) then
    -- provide Immediate and Overnight options
   htp.print('<table cols=2 cellspacing=10 align="center" width=600>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=2 border=0 cellspacing=10>
			<tr cellpadding = 10><td colspan=2 align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td width=230 align="center"><input type="button" value="Immediate" width=40 onClick=document.formz.v_mode.value=''Immediate'';valiDeferInput();></td>
                   <td width=230  align="center"><input type="button" value="Overnight"  width=40 onClick=document.formz.v_mode.value=''Overnight'';valiDeferInput();></td>
                  </tr>
                  <tr><td colspan=2  align=left>Note: Immediate Batch processing is limited to data requests with results up to '||dw_glob_var.gv_rslt_Immediate_lmt||'. Any Immediate Batch request over the limit will be automatically scheduled as Overnight Batch.</td></tr>

                  <tr><td colspan=2  align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');

  elsif vmin_ResultCount  > dw_glob_var.gv_rslt_Immediate_lmt and v_ResultCount <= dw_glob_var.gv_rslt_Overnight_lmt then
  --elsif lv_ResultCount  > dw_glob_var.gv_rslt_Immediate_lmt and v_ResultCount <= dw_glob_var.gv_rslt_Overnight_lmt then
    -- provide Overnight option only
    htp.print('<table cols=2 cellspacing=10 align="center" width=600>
     <tr><td width=100><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></td>
         <td width=500>
             <table cols=1 border=.1>
             <tr><td>
               <table cols=1 border=0 cellspacing=10>
			<tr cellpadding = 10><td align=center><B>Batch Processing</B></td> </tr>
                  <tr cellpadding=10 >
                   <td align="center"><input type="button" value="Overnight"  width=40 onClick=valiDeferInput();></td>
                  </tr>
                  <tr><td align=left>Note: Download files will exceed maximum limits for spread sheet applications (ie. EXCEL - Worksheet size: 65,536 Rows.)</td></tr>
               </table>
             </td></tr>
             </table>
        </td>
     </tr>
    </table>');
end if;

DW_bottom_of_page(5);

END DW_RESULT_COUNT;
/

