
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_RESULT_DOWNLOAD_CUSTOM" (
--Version2.5.1 Date2011-03-25
v_FromStmt            IN    VARCHAR2 DEFAULT NULL,
v_WhereStmt            IN    VARCHAR2 DEFAULT NULL,
vR_FromStmt            IN    VARCHAR2 DEFAULT NULL,
vR_WhereStmt            IN    VARCHAR2 DEFAULT NULL,
vB_FromStmt            IN    VARCHAR2 DEFAULT NULL,
vB_WhereStmt            IN    VARCHAR2 DEFAULT NULL,
vH_FromStmt            IN    VARCHAR2 DEFAULT NULL,
vH_WhereStmt            IN    VARCHAR2 DEFAULT NULL,
v_rule_optimization        IN    VARCHAR2,
v_report_type            IN    CHAR default 'REGULAR',
v_Columns            IN    owa_util.vc_arr,
--v_ActColumns            IN    owa_util.ident_arr,
v_filename                    IN    varchar2,
P_email                IN    VARCHAR2,
p_prefix            in      varchar2,
v_mode                IN    VARCHAR2,
p_record_count            in    number,
v_filters            in     varchar2,
out_file            OUT    varchar2,
request_id             out     number,
r_Type                          IN    owa_util.vc_arr
) AS

LV_DEBUG_ID NUMBER;
-- WHSED SUMMARY. Edited input parameters.
--The out_file variable, the output of this routine, contains the entire URL of
--the file created herein for the online processing.  For Overnight/Immediate processing only the file name, not the virtual path.

-- File handler while creating a file using utl_file package.
--my_out_file            UTL_FILE.FILE_TYPE;
--
--Name of downloadable file that will be created on the server.  This
--file name will be generated based on the current date and time.
out_file_name            VARCHAR2(30);
--iodir                     VARCHAR2(100);
download_path             VARCHAR2(100);
lv_rows                   NUMBER;

v_pk_isn            NUMBER(12);
--v_Dummy                INTEGER;
--v_CursorID            INTEGER;
v_SQLStmt            VARCHAR2(32000);
v_SelectStmt            VARCHAR2(32000);
--v_ReturnRow               VARCHAR2(32000);
--v_ReturnRow2           VARCHAR2(32000);
v_Print_Name            VARCHAR2(40);
v_Print_Names_List        VARCHAR2(30000);
v_FromStmtNew             VARCHAR2(4000);
v_WhereStmtNew             VARCHAR2(4000);
v_CurrentColumn           VARCHAR2(200);

--flags used to ensure a table is not included twice in the FROM clause
--f_LU_STATN_TYPES         BOOLEAN := FALSE;
f_LU_GEO_STATE             BOOLEAN := FALSE;
f_DI_ACTIVITY            BOOLEAN := FALSE;
f_LU_RESULT_LONG        BOOLEAN := FALSE;
f_Project_State                 BOOLEAN := FALSE;
v_exists         boolean;
v_blocksize         number;
LV_FILE_LENGTH number;
LV_FILE_NAME varchar2(50);
LV_FILETYPE varchar2(3);
LV_TIMESTAMP varchar2(20);
--v_stn_report_number    number;

lv_basefile varchar2(1000);

v_report_number    number;

lv_request_id dw_data_requests.request_id%type;
jn binary_integer;

--lv_tarfile varchar2(200);


--WSHED SUMMARY
vR_SQLStmt            VARCHAR2(32000);
vR_Print_Name            VARCHAR2(40);

vB_SQLStmt            VARCHAR2(32000);
vB_Print_Name            VARCHAR2(40);

vH_SQLStmt            VARCHAR2(32000);
vH_Print_Name            VARCHAR2(40);


vR_Print_Names_List        VARCHAR2(30000);
vB_Print_Names_List        VARCHAR2(30000);
vH_Print_Names_List        VARCHAR2(30000);

lv_curquery varchar2(4000);

TYPE ReportColumn_refcur IS REF CURSOR;

rc_ReportColumn ReportColumn_refcur;

/*

CURSOR c_ReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE reg_report_number = v_report_number
        ORDER BY REG_COL_ORDER;

CURSOR c_BIOReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE bio_report_number = v_report_number
        ORDER BY bio_COL_ORDER;

CURSOR c_HABReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE hab_report_number = v_report_number
        ORDER BY hab_COL_ORDER;

--WSHED SUMMARY
CURSOR cA_ReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE ALL_report_number = v_report_number
        AND reg_report_number is not null
        ORDER BY ALL_COL_ORDER;

CURSOR cA_BIOReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE ALL_report_number = v_report_number
        AND bio_report_number IS NOT NULL
        ORDER BY all_COL_ORDER;

CURSOR cA_HABReportColumn IS
    SELECT print_name,col_name
        FROM APP_COLUMN_NAME
        WHERE all_report_number = v_report_number
        AND hab_report_number IS NOT NULL
        ORDER BY all_COL_ORDER;
        */
--end of wshed summary

 TYPE ReportColumn_rectype IS RECORD(
      print_name varchar2(255),
      col_name   varchar2(255));


 ReportColumn ReportColumn_rectype;

lv_reg_data varchar2(10);
lv_bio_data varchar2(10);
lv_hab_data varchar2(10);
lv_report_type varchar2(25);
BEGIN
rollback;



--WSHED SUMMARY.  MOVED TO IF LOOPS

--  v_SelectStmt := 'SELECT ';
--  IF v_rule_optimization = 'TRUE' THEN
--      v_SelectStmt := 'SELECT  ';
--  END IF;

--v_FromStmtNew := v_FromStmt;
--v_WhereStmtNew := v_WhereStmt;

--include appropriate tables in FROM clause based on columns selected
--wshed summary
IF v_report_type = 'BIOLOGICAL' or v_report_type = 'ALLRESULTS' THEN
    v_print_names_list:= null;
    v_CurrentColumn:= null;
  IF v_report_type = 'ALLRESULTS' THEN
    v_SelectStmt := 'SELECT ';
      IF v_rule_optimization = 'TRUE' THEN
           v_SelectStmt := 'SELECT  ';
      END IF;
    v_FromStmtNew := vB_FromStmt;
    v_WhereStmtNew := vB_WhereStmt;
        f_LU_GEO_STATE:= FALSE;
                f_Project_State:=FALSE;
    ELSIF v_report_type = 'BIOLOGICAL' THEN
    v_SelectStmt := 'SELECT ';
    IF v_rule_optimization = 'TRUE' THEN
        v_SelectStmt := 'SELECT  ';
    END IF;
    v_FromStmtNew := v_FromStmt;
    v_WhereStmtNew := v_WhereStmt;
  END IF;

  FOR i IN 1 .. v_Columns.LAST LOOP
        v_report_number := TO_NUMBER(v_Columns(i));
        lv_curquery:= null;
    IF v_report_type = 'ALLRESULTS' THEN
          --FOR ReportColumn in cA_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE ALL_report_number = '||v_report_number||' AND bio_report_number IS NOT NULL ORDER BY all_COL_ORDER';
    ELSIF v_report_type = 'BIOLOGICAL' THEN
        --FOR ReportColumn in c_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE bio_report_number = '||v_report_number||' ORDER BY bio_COL_ORDER';
    END IF;
    OPEN rc_ReportColumn FOR lv_curquery; LOOP
      --initialize
      ReportColumn.print_name:=null;
      ReportColumn.col_name:= null;
      FETCH rc_ReportColumn INTO ReportColumn.print_name, ReportColumn.col_name;
      EXIT WHEN rc_ReportColumn%NOTFOUND;

        v_CurrentColumn := ReportColumn.col_name;
        v_print_names_list := v_print_names_list||ReportColumn.print_name||CHR(9);

        IF ReportColumn.col_name = 'HD.ID_CODE' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
        END IF;
                IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
            IF f_LU_GEO_STATE = FALSE THEN
                v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
                v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
                f_LU_GEO_STATE := TRUE;
            END IF;
        END IF;
        IF ReportColumn.col_name= 'COUNTY_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
        END IF;
     IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
          v_CurrentColumn := 'ORGANIZATION_NAME';
     END IF;
            IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
        END IF;

        IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
        END IF;

        IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
          v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
        END IF;
                   IF ReportColumn.col_name= 'FA.ACTIVITY_CATEGORY' THEN
          v_CurrentColumn := 'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
        END IF;
        IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.STD_VALUE' THEN
            v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
        END IF;
        IF ReportColumn.col_name= 'PRIMARY_TYPE' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_STATN_TYPES ST';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_statn_types = st.pk_isn (+)';
        END IF;
--        IF ReportColumn.col_name= 'DP.PROJECT_NAME' OR ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION' THEN
--               if(ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION') then
--                     v_CurrentColumn :='TRANSLATE(DP.PROJECT_DESCRIPTION,chr(9)||chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(182)||chr(96)||chr(94))';
--              end if;
--               IF f_Project_State = FALSE  THEN
--                   v_FromStmtNew := v_FromStmtNew||',DI_PROJECT dp';
----                   2010-07-21 TWO Column Unique Identifier: ORGANIZATION_ID,PROJECT_ID
----               v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+)';
--       v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+) AND FA.organization_id = dp.tsmproj_org_id (+)';
--                   f_Project_State :=TRUE;
--                END IF;
--        END IF;
        v_SelectStmt := v_SelectStmt ||v_CurrentColumn||',';--'||CHR(9)||';
     END LOOP;
    END LOOP;
  -- WSHED SUMMARY
  IF v_report_type = 'ALLRESULTS' THEN
       v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--       vB_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
       vB_print_names_list := RTRIM(v_print_names_list,CHR(9));
        --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     vB_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;

  ELSIF v_report_type = 'BIOLOGICAL' THEN
        v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--     v_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
     v_print_names_list := RTRIM(v_print_names_list,CHR(9));

           htp.print('v_print_names_list '||v_print_names_list );
     --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;


  END IF;
END IF; --WSHED SUMMARY

IF v_report_type = 'HABITAT' or v_report_type = 'ALLRESULTS' THEN
--WSHED SUMMARY
    v_print_names_list:= null;
    v_CurrentColumn:= null;
  IF v_report_type = 'ALLRESULTS' THEN
    v_SelectStmt := 'SELECT ';
      IF v_rule_optimization = 'TRUE' THEN
           v_SelectStmt := 'SELECT  ';
      END IF;
    v_FromStmtNew := vH_FromStmt;
    v_WhereStmtNew := vH_WhereStmt;
    --ALLRESULTS
        f_LU_GEO_STATE:= FALSE;
                f_Project_State:=FALSE;
  ELSIF v_report_type = 'HABITAT' THEN
    v_SelectStmt := 'SELECT ';
    IF v_rule_optimization = 'TRUE' THEN
        v_SelectStmt := 'SELECT  ';
    END IF;

  END IF;

  FOR i IN 1 .. v_Columns.LAST LOOP
        v_report_number := TO_NUMBER(v_Columns(i));
        lv_curquery:= null;
    IF v_report_type = 'ALLRESULTS' THEN
          --FOR ReportColumn in cA_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE ALL_report_number = '||v_report_number||' AND hab_report_number IS NOT NULL ORDER BY all_COL_ORDER';
    ELSIF v_report_type = 'HABITAT' THEN
        --FOR ReportColumn in c_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE hab_report_number = '||v_report_number||' ORDER BY hab_COL_ORDER';
    END IF;
    OPEN rc_ReportColumn FOR lv_curquery; LOOP
      --initialize
      ReportColumn.print_name:=null;
      ReportColumn.col_name:= null;
      FETCH rc_ReportColumn INTO ReportColumn.print_name, ReportColumn.col_name;
      EXIT WHEN rc_ReportColumn%NOTFOUND;

/*
    IF v_report_type = 'ALLRESULTS' THEN
        FOR ReportColumn in cA_HABReportColumn LOOP
    ELSIF v_report_type = 'HABITAT' THEN
        FOR ReportColumn in c_HABReportColumn LOOP
    END IF;
*/
    --FOR i IN 1 .. v_Columns.LAST LOOP
    --    v_report_number := TO_NUMBER(v_Columns(i));
    --    FOR ReportColumn in c_HABReportColumn LOOP

            v_CurrentColumn := ReportColumn.col_name;
        v_print_names_list := v_print_names_list||ReportColumn.print_name||CHR(9);

        IF ReportColumn.col_name = 'HD.ID_CODE' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
            IF f_LU_GEO_STATE = FALSE THEN
                v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
                v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
                f_LU_GEO_STATE := TRUE;
            END IF;
        END IF;
        IF ReportColumn.col_name= 'COUNTY_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
        END IF;

     IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
          v_CurrentColumn := 'ORGANIZATION_NAME';
             END IF;
    IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
        END IF;

        IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
        END IF;

        IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
          v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
        END IF;
        IF ReportColumn.col_name= 'FA.ACTIVITY_CATEGORY' THEN
          v_CurrentColumn := 'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
        END IF;
        IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.STD_VALUE' THEN
            v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
        END IF;
        IF ReportColumn.col_name= 'PRIMARY_TYPE' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_STATN_TYPES ST';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_statn_types = st.pk_isn (+)';
        END IF;
--        IF ReportColumn.col_name= 'DP.PROJECT_NAME' OR ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION' THEN
--            if(ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION') then
--                             v_CurrentColumn :='TRANSLATE(DP.PROJECT_DESCRIPTION,chr(9)||chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(182)||chr(96)||chr(94))';
--                      end if;
--                        IF f_Project_State = FALSE  THEN
--                        v_FromStmtNew := v_FromStmtNew||',DI_PROJECT dp';
----                   2010-07-21 TWO Column Unique Identifier: ORGANIZATION_ID,PROJECT_ID
----               v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+)';
--               v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+) AND FA.organization_id = dp.tsmproj_org_id (+)';
--                        f_Project_State :=TRUE;
--                       END IF;
--        END IF;
        v_SelectStmt := v_SelectStmt ||v_CurrentColumn||',';--'||CHR(9)||';
        END LOOP;
    END LOOP;

      -- WSHED SUMMARY
  IF v_report_type = 'ALLRESULTS' THEN
          v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--     vH_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
     vH_print_names_list := RTRIM(v_print_names_list,CHR(9));
     --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     vH_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;
  ELSIF v_report_type = 'HABITAT' THEN
        v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--     v_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
     v_print_names_list := RTRIM(v_print_names_list,CHR(9));
     --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;
  END IF;

END IF; --WSHED SUMMARY EDIT

IF v_report_type = 'REGULAR' or v_report_type = 'ALLRESULTS' THEN
    v_print_names_list:= null;
    v_CurrentColumn:= null;
  IF v_report_type = 'ALLRESULTS' THEN
    v_SelectStmt := 'SELECT ';
      IF v_rule_optimization = 'TRUE' THEN
           v_SelectStmt := 'SELECT  ';
      END IF;
    v_FromStmtNew := vR_FromStmt;
    v_WhereStmtNew := vR_WhereStmt;
    f_LU_GEO_STATE:= FALSE;
        f_Project_State:=FALSE;
  ELSIF v_report_type = 'REGULAR' THEN
    v_SelectStmt := 'SELECT ';
    IF v_rule_optimization = 'TRUE' THEN
        v_SelectStmt := 'SELECT  ';
    END IF;
    v_FromStmtNew := v_FromStmt;
    v_WhereStmtNew := v_WhereStmt;
  END IF;


/*
  FOR i IN 1 .. v_Columns.LAST LOOP
        v_report_number := TO_NUMBER(v_Columns(i));


    IF v_report_type = 'ALLRESULTS' THEN
        FOR ReportColumn in cA_ReportColumn LOOP
    ELSIF v_report_type = 'REGULAR' THEN
        FOR ReportColumn in c_ReportColumn LOOP
    END IF;
*/
-- code for report type check boxes (10/15/2008)
lv_reg_data:='NO';
lv_bio_data:='NO';
lv_hab_data :='NO';
  FOR i IN 1 .. r_Type.LAST LOOP
     lv_report_type := r_Type(i);
     IF lv_report_type = 'REGULAR' THEN
       lv_reg_data :='YES';
     ELSIF lv_report_type = 'BIOLOGICAL' THEN
       lv_bio_data :='YES';
       ELSIF lv_report_type = 'HABITAT' THEN
         lv_hab_data :='YES';
     END IF;

  END LOOP;

  FOR i IN 1 .. v_Columns.LAST LOOP
        v_report_number := TO_NUMBER(v_Columns(i));
        lv_curquery:= null;
    IF v_report_type = 'ALLRESULTS' THEN
          --FOR ReportColumn in cA_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE all_report_number = '||v_report_number||' AND reg_report_number IS NOT NULL ORDER BY all_COL_ORDER';
    ELSIF v_report_type = 'REGULAR' THEN
        --FOR ReportColumn in c_BIOReportColumn LOOP
        lv_curquery:= 'SELECT print_name,col_name FROM APP_COLUMN_NAME WHERE reg_report_number = '||v_report_number||' ORDER BY reg_COL_ORDER';
    END IF;
    OPEN rc_ReportColumn FOR lv_curquery; LOOP
      --initialize
      ReportColumn.print_name:=null;
      ReportColumn.col_name:= null;
      FETCH rc_ReportColumn INTO ReportColumn.print_name, ReportColumn.col_name;
      EXIT WHEN rc_ReportColumn%NOTFOUND;

    --FOR i IN 1 .. v_Columns.LAST LOOP
    --v_report_number := TO_NUMBER(v_Columns(i));
    --FOR ReportColumn in c_ReportColumn LOOP

           v_CurrentColumn := ReportColumn.col_name;
        v_print_names_list := v_print_names_list||ReportColumn.print_name||CHR(9);

        IF ReportColumn.col_name = 'HD.ID_CODE' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
            v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
            v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
            IF f_LU_GEO_STATE = FALSE THEN
                v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
                v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
                f_LU_GEO_STATE := TRUE;
            END IF;
        END IF;
        IF ReportColumn.col_name= 'COUNTY_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
        END IF;
        IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
        END IF;

    IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
          v_CurrentColumn := 'ORGANIZATION_NAME';
    END IF;
   IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
        END IF;

        IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
        END IF;

        IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
          v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
          --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
        END IF;
        IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
          v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||'' ''||ANALYTICAL_PROCEDURE_ID';
        END IF;
        IF ReportColumn.col_name= 'FA.ACTIVITY_CATEGORY' THEN
          v_CurrentColumn := 'CASE WHEN REPLICATE_NUMBER is null or REPLICATE_NUMBER = 0 THEN ACTIVITY_CATEGORY else ACTIVITY_CATEGORY||''-''||REPLICATE_NUMBER end';
        END IF;
        IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
            v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
        END IF;
        IF ReportColumn.col_name= 'FA.STD_VALUE' THEN
            v_CurrentColumn := 'TO_CHAR(FA.STD_VALUE,''9.9999EEEE'')';
        END IF;
        IF ReportColumn.col_name= 'PRIMARY_TYPE' THEN
            v_FromStmtNew := v_FromStmtNew||',DI_STATN_TYPES ST';
            v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_statn_types = st.pk_isn (+)';
        END IF;
--         IF ReportColumn.col_name= 'DP.PROJECT_NAME' OR ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION' THEN
--              if(ReportColumn.col_name= 'DP.PROJECT_DESCRIPTION') then
--                     v_CurrentColumn :='TRANSLATE(DP.PROJECT_DESCRIPTION,chr(9)||chr(10)||chr(13)||chr(34)||chr(126),chr(182)||chr(182)||chr(182)||chr(96)||chr(94))';
--              end if;
--              IF f_Project_State = FALSE  THEN
--                v_FromStmtNew :=  v_FromStmtNew||',DI_PROJECT dp';
----                   2010-07-21 TWO Column Unique Identifier: ORGANIZATION_ID,PROJECT_ID
----               v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+)';
--       v_WhereStmtNew := v_WhereStmtNew||' AND FA.project_id = dp.project_cd (+) AND FA.organization_id = dp.tsmproj_org_id (+)';
--                f_Project_State :=TRUE;
--                END IF;
--           END IF;

        v_SelectStmt := v_SelectStmt ||v_CurrentColumn||',';--'||CHR(9)||';
        END LOOP;
    END LOOP;

  -- WSHED SUMMARY
  IF v_report_type = 'ALLRESULTS' THEN
       v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--     vR_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
     vR_print_names_list := RTRIM(v_print_names_list,CHR(9));
     --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     vR_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;
  ELSIF v_report_type = 'REGULAR' THEN
        v_SelectStmt := substr(v_SelectStmt,1, (length(v_SelectStmt)-1));
-- 2011-03-25
-- remove extra delimiter on column header
--     v_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
     v_print_names_list := RTRIM(v_print_names_list,CHR(9));
     --v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
     v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;
  END IF;

END IF;
--WSHED SUMMARY COMMENTED NEXT 4 LINES.
--v_SelectStmt := RTRIM(v_SelectStmt,'||CHR(9)||');
--v_print_names_list := RTRIM(v_print_names_list,'||CHR(9)||');
----v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
--v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;

--checking to see if a filename is passed
if (v_filename <> 'NONE') then
  out_file_name := v_filename;
else
  -- Generating a unique name for creating a file on the server.
  out_file_name := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS');
  IF v_report_type = 'BIOLOGICAL' THEN
    --out_file_name := 'SDB'||out_file_name||'.txt' ;
    lv_filetype:='SDB';
  ELSIF v_report_type = 'HABITAT' THEN
    --out_file_name := 'SDH'||out_file_name||'.txt' ;
    lv_filetype:='SDH';
  ELSIF v_report_type = 'REGULAR' THEN
    --out_file_name := 'SDR'||out_file_name||'.txt' ;
    lv_filetype:='SDR';
  ELSIF v_report_type = 'ALLRESULTS' THEN
    --out_file_name := 'SDA'||out_file_name||'.txt' ;
    lv_filetype:='SDA';
  end if;

--v2062
    out_file_name := out_file_name||'.txt' ;

end if;
  lv_file_length:=null;
  lv_file_name:=out_file_name;
  --lv_timestamp:=substr(out_file_name,4,15);
  --v2062
  lv_timestamp:=substr(out_file_name,1,15);
  download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;
  -- out_file is an out parameter.  It holds URL of the downloadable file that
  -- will be created by this procedure.
  if v_mode = 'Online' then
    out_file:=download_path||out_file_name;
  elsif v_mode in ('Overnight','Immediate') then
    out_file:=p_prefix||'_'||out_file_name;
    lv_file_name:=p_prefix||'_'||out_file_name;
  end if;

    --htp.print('<BR>'||v_sqlstmt||'<BR>');
    --WSHED SUMMARY. NOT EDITED FOR WSHED CHANGES. ONLINE IS OBSOLETE.
    if v_mode = 'Online' then

        --v_CursorID := DBMS_SQL.OPEN_CURSOR;
        --DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
        ----DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_pk_isn, 12);
        ----DBMS_SQL.DEFINE_COLUMN(v_CursorID, 2, v_ReturnRow, 32000);
        ----DBMS_SQL.DEFINE_COLUMN(v_CursorID, 3, v_ReturnRow2, 32000);
        --DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
        --v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

        ----
        ---- File handler used by utl_file package.
        ----
        --iodir := DW_GLOB_VAR.LV_IODIR;

        --my_out_file := UTL_FILE.FOPEN(iodir,out_file_name,'W',30000);
        --UTL_FILE.PUT_LINE(my_out_file,v_print_names_list);

        --LOOP
        --    IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
        --        EXIT;
        --    END IF;
        --    DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
        --    --DBMS_SQL.COLUMN_VALUE(v_CursorID, 2, v_ReturnRow);
        --    --DBMS_SQL.COLUMN_VALUE(v_CursorID, 3, v_ReturnRow2);
        --    --UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow||CHR(9)||v_ReturnRow2);
        --    UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow);
        --END LOOP;

        --DBMS_SQL.CLOSE_CURSOR(v_CursorID);
        --UTL_FILE.FCLOSE(my_out_file);

        dw_write_file(v_SQLStmt, chr(9), DW_GLOB_VAR.LV_IODIR, out_file_name, v_print_names_list, 1, lv_rows);

    end if;

-- Online - find the length of the file after closing the file
  if v_mode = 'Online' then
    utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,lv_file_length,v_blocksize);
    --htp.print('<br><br>The size of your report download is <b>'||ROUND(lv_file_length/1024,1)||'KB</b>');
    lv_file_length:=ROUND(lv_file_length/1024,1);
  else
    lv_file_length:=null;
  end if;

-- Call the Dw_record_data_request to record the request.

  dw_record_data_request(v_filters,lv_filetype,lv_timestamp,lv_file_length,v_print_names_list,V_MODE,P_email,v_SQLStmt,vR_SQLStmt,vB_SQLStmt,vH_SQLStmt,lv_file_name,p_record_count,lv_request_id,vr_print_names_list,vb_print_names_list,vH_print_names_list,lv_reg_data,lv_bio_data,lv_hab_data);
  --HTP.PRINT('CALL TO DW_RECORD_DATA_REQUEST');

    if v_mode = 'Immediate' THEN
    --      dbms_job.SUBMIT(jn,'dw_process_data_request('||lv_request_id||');',sysdate + 1/1440);
      --dbms_output.put_line(jn);
      --dbms_output.put_line('debug '||lv_request_id);

      dbms_job.SUBMIT(jn,'dw_process_data_request('||lv_request_id||');');
      update dw_data_requests
       set job_queue_id = jn,
           processed_date=sysdate
       where request_id = lv_request_id;
      commit;
    end if;

--lv_tarfile:=replace(out_file,'.txt','.tar');
lv_basefile:=replace(out_file,'.txt','');
  if v_mode in ('Overnight','Immediate') then
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( p_email),
       p_subject => 'STORET data request submitted (PROCESSING).  Request_ID: '||lv_request_id,
       p_body =>
'Your request for Result Download is submitted for '||v_mode||' batch processing.

Following is your request information:

Request ID    :  '||lv_request_id ||'
Request Type  :  Result Download
Record Count  :  '||p_record_count ||'
Request Mode  :  '||v_mode ||' batch
File Name     :  '||lv_basefile||'.'||dw_glob_var.gv_cmprs_fl_ext  ||'
URL           :  '||download_path||lv_basefile||'.'||dw_glob_var.gv_cmprs_fl_ext  ||'
Email provided:  '||p_email ||'

You will be notified when the request is processed.'||chr(10)||chr(10)||'List of Filters: '||v_filters);
  end if;
request_id:= lv_request_id;

EXCEPTION
  WHEN UTL_FILE.INVALID_PATH THEN DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
  commit;
  WHEN UTL_FILE.INVALID_MODE THEN DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
  commit;
  WHEN UTL_FILE.INVALID_FILEHANDLE THEN
  commit;
    DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
  WHEN UTL_FILE.INVALID_OPERATION THEN
    DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
  commit;
  WHEN UTL_FILE.READ_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD READ');
  commit;
  WHEN UTL_FILE.WRITE_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
  commit;
  WHEN UTL_FILE.INTERNAL_ERROR THEN DBMS_OUTPUT.PUT_LINE ('INTERNAL');
  commit;
 when others then
  HTP.PRINT('ERROR in recording the Data Request.  Please contact storet@epa.gov. (DW_RESULT_DOWNLOAD_CUSTOM)');
  htp.print(sqlerrm);
  DBMS_OUTPUT.PUT_LINE('ERROR IN DW_RESULT_DOWNLOAD_CUSTOM');
  out_file:='FAILED';
request_id :=-1;
  null;
END;
/

