
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_RESULT_DOWNLOAD_ZIP"
(in_command in varchar2,
 out_filename           IN    VARCHAR2
)
AS

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--
--The out_file variable will contain the entire URL of the file created within
--the called download procedures.
--
v_zip_rc                number := 0;
v_file_name             varchar2(200);
v_exists 		      boolean;
v_file_length 		number;
v_blocksize 		number;
v_time_start		number;
v_time_current		number;

BEGIN

/* c2.0.5 code

 	v_file_name := substr(out_file,instr(out_file,'/',-1));  -- get the file_name without the download path
      	v_file_name := substr(v_file_name,1,instr(v_file_name,'.txt')-1);  -- strip '.txt' from the file_name
      	v_zip_rc := execmd('/bin/cp -p '||DW_glob_var.lv_iodir||v_file_name||'.txt '||DW_glob_var.lv_iodir||v_file_name||'-2.txt');
      	v_zip_rc := execmd('/bin/gzip '||DW_glob_var.lv_iodir||v_file_name||'-2.txt');

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,v_file_name||'-2.txt.gz',v_exists,v_file_length,v_blocksize);
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN v_file_length > 0 OR ABS(v_time_start-v_time_current)> 0.01667;
	END LOOP;

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN ABS(v_time_start-v_time_current)> 0.004;
	END LOOP;

	page_title :='Download Results';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);

	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
      	htp.print('You have requested to download monitoring Results');
	htp.Br;
	htp.Br;
	htp.Br;

      	IF v_zip_rc <> 0 THEN
           	htp.print('Error:  Attempt to compress data file was unsuccessful!');
      	ELSE
	     	htp.anchor(DW_glob_var.lv_download_path||v_file_name||'-2.txt.gz', htf.bold('Download your compressed file now...'));
	     	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,v_file_name||'-2.txt.gz',v_exists,v_file_length,v_blocksize);
           	IF v_exists THEN
	          	htp.print('<br><br>The size of your report download is '||ROUND(v_file_length/1024,1)||'KB');
           	END IF;
      	END IF;
	htp.print('</center>');
	DW_bottom_of_page(9);
*/
  -- sug
      	v_zip_rc := execmd(in_command);

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_filename,v_exists,v_file_length,v_blocksize);
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN v_file_length > 0 OR ABS(v_time_start-v_time_current)> 0.01667;
	END LOOP;

	v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+TO_CHAR(SYSDATE,'SS')/3600);
	LOOP
		v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+ TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
	EXIT WHEN ABS(v_time_start-v_time_current)> 0.004;
	END LOOP;
      --*************************************************
	/*
	--sug commented as part of Metadata Report
	page_title :='Download Results';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);

	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
      	htp.print('You have requested to download monitoring Results');
	htp.Br;
	htp.Br;
	htp.Br;

      	IF v_zip_rc <> 0 THEN
           	htp.print('Error:  Attempt to compress data file was unsuccessful!');
      	ELSE

	     	htp.anchor(DW_glob_var.lv_download_path||v_file_name||'-2.txt.gz', htf.bold('Download your compressed file now...'));
	     	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,v_file_name||'-2.txt.gz',v_exists,v_file_length,v_blocksize);
           	IF v_exists THEN
	          	htp.print('<br><br>The size of your report download is '||ROUND(v_file_length/1024,1)||'KB');
           	END IF;
      	END IF;
	htp.print('</center>');
	DW_bottom_of_page(9);
	*/
	--***************************************************
END;

/

