
  CREATE OR REPLACE PROCEDURE "STORETW"."DW_STATION_SELECT_WME" (
station_isn number DEFAULT 0,
station_id  char   DEFAULT NULL
) AS

--used to generate org list
CURSOR corg IS
SELECT pk_isn, organization_id, organization_name
FROM DI_ORG
ORDER BY organization_id;

--used to generate station list based on station_isn passed in
CURSOR cstation IS
	SELECT organization_id, station_id, station_name, pk_isn
		FROM FA_STATION
		WHERE pk_isn = station_isn;

v_org_id  char(15);
v_prepop  boolean := TRUE;

BEGIN
-- find the pre-selected org based on the station passed in
IF station_isn > 0 then
     SELECT organization_id INTO v_org_id
     FROM fa_station
     WHERE pk_isn = station_isn;
END IF;

htp.print('
<H4>Station</H4>
<table BORDER COLS=1 WIDTH="100%" >
<TR>
<TD>
<center>Select an Organization and a Search Type, then enter a Search String and click "Search Stations".
<br><br>
<INPUT TYPE="TEXT" READONLY style="font-size: 10pt; font-family: Courier New, Courier, monospace; font-weight: bold"  VALUE="ORG ID                              ORGANIZATION NAME" size="78"  onFocus="javascript:document.forms[1].D_ORG_LIST.focus()">
<font face="Courier, monospace"> <br>');
htp.print('<select name="D_ORG_LIST" tabindex="1" size="1" style="font: 10pt/12pt COURIER" onChange="javascript:document.forms[1].as_extref.value=''STANDARD'';document.forms[1].D_EXTREF_LIST.value=0">');
htp.formSelectOption('Select an Organization_____________________________________________________',cattributes => 'VALUE="0"');
FOR org IN corg LOOP
    if rtrim(v_org_id) = rtrim(org.organization_id) then
         htp.formSelectOption(org.organization_id||'~'||org.organization_name, cselected => 'TRUE', cattributes => 'VALUE='||org.pk_isn);
    else
         htp.formSelectOption(org.organization_id||'~'||org.organization_name, cattributes => 'VALUE='||org.pk_isn);
    end if;
END LOOP;

htp.print('</SELECT></font></center>
<table cols=2 width="100%">
<tr>
<td width="30%"></td>
<td align=left WIDTH="70%"><br><B>Search Type</B>
<br>&nbsp &nbsp &nbsp<input checked type=radio name="searchtype" tabindex="2" value="ID" > Search by Station ID
<BR>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="3" value="Name"> Search by Station Name
<br>&nbsp &nbsp &nbsp<input type=radio name="searchtype" tabindex="4" value="Ref"> Search by Station Alias
<input type="hidden" name="D_EXTREF_LIST" value=0>
<br>&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
Select Station Alias Type <input type="text" readonly value="STANDARD" name="as_extref" size="10" style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">
<input type="button" tabindex="5" value="Look Up" onclick="javascript:document.forms[1].searchtype[2].checked=true;openWin(''extref'')" title="Opens a popup window for Station Alias Type selection">

<hr align=left width="70%">
<br><B>Search String </B>
<input type=hidden name="v_station_names">
<input type="text" name="as_station" tabindex="6" size="20" style="font: 10pt/12pt COURIER" maxlength="20" >
</td>
</tr>
</table>
<br><center><input type="button" tabindex="7" value="Search Stations" onclick="openWin(''station'')" title="Opens a popup window for Station selection">

<br><br><font style="font-size: 9pt; font-family: Courier New, Courier, monospace"> <select multiple size="10" name="station_list" style="font-size: 8pt; font-family: Courier New, Courier, monospace">
<option>Org ID~Station ID~Alias Type~Station Alias~Station Name</option>
<option value="dummy">____________________________________________________________________________________________________________________________</option>
');
IF v_prepop = TRUE THEN
     FOR station IN cstation LOOP
          HTP.FormSelectOption(station.organization_id||'~'||station.station_id
              ||'~N/A~N/A~'||station.station_name,cattributes => 'value ='||station.pk_isn);
     END LOOP;
     v_prepop := FALSE;
END IF;
htp.print('
</select></font>
<br>
<input type="button" tabindex="8" value="Clear Selected" onclick="javascript:deleteSelectedFromStationList();" title="Remove highlighted Stations from Selected List">
<input type="button" tabindex="9" value="Clear All" onclick="javascript:deleteAllFromStationList();" title="Remove all Stations from the Selected List">
</center>
</td>
</tr>
</table>
');

END;

/

