
  CREATE OR REPLACE PROCEDURE "STORETW"."INSERTINTOACTIVITYPROJECT" (
   in_Table_Name   IN VARCHAR2,
   in_Activity_UID IN NUMBER,
   in_Project_UID  IN NUMBER,
   in_Org_UID      IN NUMBER,
   out_PROC_RESULT OUT NUMBER
) -- 0 : Means Unprocessed, 1: Means Success, 9999 : Error
AS

   prj_pk_isn      NUMBER;
   rslt_pk_isn    NUMBER;
   row_counter NUMBER := 0;

   CURSOR regular_results_cursor
   IS
   SELECT
   a.pk_isn
   FROM
   storetw.fa_regular_result a
   WHERE
   a.SOURCE_SYSTEM = 'WQX' AND
   a.SOURCE_UID = in_Activity_UID;

   CURSOR biological_results_cursor
   IS
   SELECT
   a.pk_isn
   FROM
   storetw.fa_biological_result a
   WHERE
   a.source_system = 'WQX' AND
   a.source_uid = in_Activity_UID;

BEGIN

   out_PROC_RESULT := 0;

   SELECT
   a.pk_isn
   INTO prj_pk_isn
   FROM
   storetw.di_project a
   WHERE
   a.source_system = 'WQX' AND
   a.SOURCE_UID = in_Project_UID;

   IF UPPER(TRIM(in_Table_Name)) = 'REGULAR_RESULT_PROJECT'
   THEN
      FOR results_rec IN regular_results_cursor
      LOOP

         INSERT /*+ APPEND */ INTO storetw.regular_result_project(
            fk_result,
            fk_project
         ) VALUES (
            results_rec.pk_isn,
            prj_pk_isn
         );

         row_counter := row_counter + 1;

         IF row_counter = 5000 THEN
             COMMIT;
            row_counter := 0;
         END IF;

      END LOOP;

   ELSE

      FOR results_rec IN biological_results_cursor
      LOOP
         INSERT INTO /*+ APPEND */  storetw.biological_result_project(
            fk_result,
            fk_project
         ) VALUES (
            results_rec.pk_isn,
            prj_pk_isn
         );

         IF row_counter = 5000
         THEN
            COMMIT;
            row_counter := 0;
         END IF;

      END LOOP;

   END IF;

   COMMIT;

   IF out_PROC_RESULT != 9999
   THEN
      out_PROC_RESULT := 1;
      RETURN;

   END IF;

END;
/

