
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_COMPUTE_STD_LAT_LONG"
  (in_latitude 			IN  NUMBER,
   in_longitude 		IN  NUMBER,
   in_hdatum_code		IN  varchar2,
   in_country_code	        IN varchar2,
   in_state_code                IN VARCHAR2,
   out_std_latitude 		OUT NUMBER,
   out_std_longitude 		OUT NUMBER,
   out_std_hdatum_code 		OUT varchar2,
   out_sp_status 		OUT VARCHAR2)
IS

-- geometry objects ORACLE SPATIAL
  geom1 mdsys.sdo_geometry;
  geom2 mdsys.sdo_geometry;

  lv_nad83 		number;
  lv_state_postal_code 	char(2);
  lv_country_code 	char(2);
  lv_cntr 		number:=0;
  lv_convert 		number(1) := 0;
  lv_srid 		number(6,0);

  -- new local variables
  l_id_code			varchar2(12);  --lu_mad_hdatum.id_code%type;

  -- Oracle srid for datum that need to be converted.
  --WGS72    		8306
  --WGS84    		8307
  --NAD27    		8260
  --NAD27 US - Alaska  	8254
  --NAD27 cANADA  	8256
  --NAD27 MEXICO  	8263
  --Puerto Rico ???

  --SRID codes for different datums.  copied from etl_glob_var package.
  srid_WGS72 constant number(6,0):=8306 ;
  srid_WGS84 constant  number(6,0):=8307;
  srid_NAD27_Alaska  constant number(6,0):=8254;
  srid_NAD27_CANADA  constant number(6,0):=8256;
  srid_NAD27_MEXICO  constant number(6,0):=8263;
  srid_NAD27  constant number(6,0):=8260;
  srid_NAD83  constant number(6,0):=8265;


BEGIN

--changed 02/19/2007
  lv_state_postal_code 	:=substr(upper(trim(in_state_code)),1,2);
  lv_country_code 	:=substr(upper(trim(in_country_code)),1,2);

    -- fk of nad83
    select pk_isn into lv_nad83 from lu_mad_hdatum where id_code='NAD83';

--changed 02/19/2007
     l_id_code:=substr(upper(trim(in_hdatum_code)),1,12);

      -- initialize variables
      lv_convert:=0;
      lv_srid:=null;

      -- Determine if conversion is needed. If so, identify the source SRID.

     if in_latitude is null then
       lv_convert:= -1;
     elsif l_id_code  = 'WGS72' then
       lv_srid := srid_wgs72;
       lv_convert := 1;
      elsif l_id_code  = 'WGS84' then
       lv_srid := srid_wgs84;
       lv_convert := 1;
      elsif l_id_code  = 'NAD27' then

        if lv_country_code='CN' then
          lv_srid :=srid_NAD27_CANADA;
          lv_convert := 1;
        elsif lv_country_code='MX' then
          lv_srid:=srid_NAD27_MEXICO;
          lv_convert := 1;
        elsif lv_country_code='US' and lv_state_postal_code='AK' then
          lv_srid := srid_NAD27_Alaska;
          lv_convert := 1;
        elsif lv_country_code= 'US' then
          -- If not Alaska then it is considered continental US.
          lv_srid:=srid_NAD27;
          lv_convert := 1;
        else
          lv_convert := 0;
        end if;
      else
       lv_convert:=0;
      end if;


      if lv_convert = 1 then
       -- initialize/reset variables.
       geom1	:=	null;
       geom2	:=	null;

       --out_std_hdatum_code := lv_nad83;
       out_std_hdatum_code := 'NAD83';

       geom1:= mdsys.sdo_geometry(2001,lv_srid,
                mdsys.sdo_point_type(in_longitude,in_latitude,null),null,null);
       geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>srid_NAD83); --convert to nad 83
       --pull the x/y back out

         -- return values

       out_std_longitude	:= geom2.sdo_point.x;
       out_std_latitude		:= geom2.sdo_point.y;
       out_sp_status 		:= 'SUCCESS' ;


      elsif lv_convert = 0 then

       out_std_longitude	:= in_longitude;
       out_std_latitude		:= in_latitude;
       out_std_hdatum_code  := in_hdatum_code;
       out_sp_status 		:= 'SUCCESS' ;

      elsif lv_convert = -1 then
        null;
       out_sp_status 		:= 'FAILURE' ;
      end if;


 EXCEPTION
     WHEN NO_DATA_FOUND THEN
       NULL;
       out_sp_status := 'FAILURE' ;
     WHEN OTHERS THEN
       -- Consider logging the error and then re-raise
       out_sp_status := 'FAILURE' ;
       RAISE;
END SP_COMPUTE_STD_LAT_LONG;

/

