
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_CONV_STD"
 as
  IN_NBR NUMBER;
  STATUS VARCHAR2(200);
  lv_message varchar2(4000):= null;
  lv_email_address varchar2(100);

  cursor cstn is
  select s.pk_isn,s.latitude,s.longitude,
         gs.COUNTRY_CODE,gs.STATE_POSTAL_CODE, hd.id_code,s.fk_mad_hdatum,
         s.STATION_IS_NUMBER,s.ORGANIZATION_ID,s.LOCATION_POINT_TYPE
  from storetw.fa_station s,	storetw.DI_GEO_STATE gs,
       lu_mad_hdatum hd
  where 	s.FK_GEO_STATE = gs.PK_ISN (+) AND
	s.fk_mad_hdatum = hd.pk_isn (+)
	 AND  s.std_LATITUDE is null
	 AND  s.std_LONGITUDE is null
 ;

  -- geometry objects
  geom1 mdsys.sdo_geometry;
  geom2 mdsys.sdo_geometry;
  --local variables
  lv_lat storetw.fa_station.std_LATITUDE%type;
  lv_long storetw.fa_station.std_LONGITUDE%type;
  lv_std_mad_hdatum storetw.fa_station.FK_std_HDATUM%type;
  lv_nad83 storetw.fa_station.FK_std_HDATUM%type;
  lv_state_postal_code storetw.DI_GEO_STATE.state_postal_code%type;
  lv_country_code storetw.DI_GEO_STATE.country_code%type;
  lv_cntr number:=0;
  lv_convert number(1) := 0;
  lv_srid number(6,0);


BEGIN

  IN_NBR := NULL;
--status:='sucessful';

-- Oracle srid for datum that need to be converted.
--WGS72    		8306
--WGS84    		8307
--NAD83    		8265
--NAD27    		8260
--NAD27 US - Alaska  	8254
--NAD27 cANADA  	8256
--NAD27 MEXICO  	8263
--Puerto Rico ???

  -- fk of nad83
  select pk_isn into lv_nad83
  from lu_mad_hdatum
  where id_code='NAD83';

  for cstn_var in cstn loop
   -- initialize variables
   lv_convert:=0;
   lv_srid:=null;
   -- Determine if conversion is needed. If so, identify the source SRID.
  if cstn_var.latitude is null then
    lv_convert:= -1;
  elsif cstn_var.id_code  = 'WGS72' then
    lv_srid := etl_glob_var.srid_wgs72;
    lv_convert := 1;
   elsif cstn_var.id_code  = 'WGS84' then
    lv_srid := etl_glob_var.srid_wgs84;
    lv_convert := 1;
   elsif cstn_var.id_code  = 'UNKWN' then
    lv_srid := etl_glob_var.srid_nad83;
    lv_convert := 0;
   elsif cstn_var.id_code  = 'NAD83' then
    lv_srid := etl_glob_var.srid_nad83;
    lv_convert := 0;
   elsif cstn_var.id_code  = 'NAD27' then
     -- fetch POINT OF RECORD country/state information.
      lv_country_code :=null;
      lv_state_postal_code :=null;
    if cstn_var.location_point_type = '*POINT OF RECORD' THEN
      lv_state_postal_code := cstn_var.state_postal_code;
      lv_country_code := cstn_var.country_code;
    else
      BEGIN
      select country_code, state_postal_code
      into lv_country_code,lv_state_postal_code
      from storetw.fa_station fas,	storetw.DI_GEO_STATE gs
      where fas.FK_GEO_STATE = gs.PK_ISN (+) AND
	fas.station_is_number = cstn_var.station_is_number
       and fas.organization_id = cstn_var.organization_id
       and fas.location_point_type = '*POINT OF RECORD';

     EXCEPTION WHEN NO_DATA_FOUND THEN
       LV_COUNTRY_CODE := '00';
       LV_STATE_POSTAL_CODE :='00';
     END;
    end if;

     if lv_country_code='CN' then
       lv_srid :=etl_glob_var.srid_NAD27_CANADA;
       lv_convert := 1;
     elsif lv_country_code='MX' then
       lv_srid:=etl_glob_var.srid_NAD27_MEXICO;
       lv_convert := 1;
     elsif lv_country_code='US' and lv_state_postal_code='AK' then
       lv_srid := etl_glob_var.srid_NAD27_Alaska;
       lv_convert := 1;
     elsif lv_country_code= 'US' then
       -- If not Alaska then it is considered continental US.
       lv_srid:=etl_glob_var.srid_NAD27;
       lv_convert := 1;
     else
       lv_convert := 0;
     end if;
   else
    lv_convert:=0;
   end if;


   if lv_convert = 1 then
    -- initialize/reset variables.
    geom1:=null;
    geom2:=null;
    lv_lat :=null;
    lv_long :=null;

    lv_std_mad_hdatum := lv_nad83;
    geom1:= mdsys.sdo_geometry(2001,					-- a point
		lv_srid,						-- source coordinate system
		mdsys.sdo_point_type(cstn_var.longitude,
		cstn_var.latitude,null),
		null,null);
    geom2:=mdsys.sdo_cs.transform(geom1, 				-- convert to nad 83
		etl_glob_var.srid_NAD83					-- target coordinate system
				);
    --pull the x/y back out
    lv_long:=geom2.sdo_point.x;
    lv_lat:=geom2.sdo_point.y;

    -- update
    update storetw.fa_station c
    set c.std_latitude = lv_lat,
        c.std_longitude = lv_long,
        c.fk_std_hdatum = lv_std_mad_hdatum
    where c.pk_isn = cstn_var.pk_isn;

  --status:='sucessful';
    status:='successfull';

   elsif lv_convert = 0 then
    update storetw.fa_station c
    set c.std_latitude = cstn_var.latitude,
        c.std_longitude = cstn_var.longitude,
        c.fk_std_hdatum = lv_nad83		-- cstn_var.fk_mad_hdatum
    where c.pk_isn = cstn_var.pk_isn;
   elsif lv_convert = -1 then
    null;
   end if;
    -- perform intermediate commits.
    lv_cntr:=lv_cntr+1;
    if lv_cntr > 3000 then
      commit;
      lv_cntr:=0;
    end if;

  end loop;

  commit;


 -- IN_NBR := NULL;
 -- status := null;

--status:='sucessful';

 -- STORETW.SP_REFRESH_WS_TABLES_NEW(IN_NBR => IN_NBR,STATUS => STATUS);


 -- DBMS_OUTPUT.PUT_LINE('STATUS = ' || STATUS);


 -- lv_message:='End of STORETW SP_REFRESH_ws_tables_new '||to_char(sysdate,'dd-mon-yyyy hh24:mi')||' Status='||status;

 --  /*STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
 -- storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'STORET WATERSHED REFRESH STORED PROCEDURES', p_body =>
 -- lv_message);
 -- */


exception when others then

lv_message:=sqlerrm;

END;
/

