
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_CREATE_INDEXES_AFTER_WQXETL" AS
v_create_stmt varchar2(4000);
cursor c_create_objects is select * from mt_object_ddl_wqx_etl
where OBJECT_DELETE_STATUS='YES';
V_EXISTS_IN_DB varchar2(30);
BEGIN
FOR cv in c_create_objects loop
v_create_stmt:=null;
v_create_stmt:=cv.OBJECT_DDL;
V_EXISTS_IN_DB:=null;
begin
  execute immediate v_create_stmt;
  select 'YES' INTO V_EXISTS_IN_DB
  FROM user_indexes
  where table_name=cv.table_name
    and index_name=cv.object_name;
  if v_exists_in_db = 'YES' THEN
  UPDATE mt_object_ddl_wqx_etl
  SET OBJECT_CREATE_STATUS='YES',
    OBJECT_CREATE_DATE=SYSDATE
  where TABLE_NAME=cv.table_name
  and OBJECT_NAME=cv.object_name
  and OBJECT_TYPE=cv.OBJECT_TYPE;
  END if;
  EXCEPTION WHEN OTHERS THEN
   DBMS_OUTPUT.PUT_LINE('ERROR creating already dropped index. Please see MT_OBJECT_DDL_WQX_ETL table for further information.');
  END;
commit;
end loop;
commit;
begin
execute immediate 'ANALYZE TABLE fa_regular_result COMPUTE STATISTICS FOR ALL INDEXES';
exception when others then null;
end;
end;


/

