
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_DELETE_FROM_STORETW" (
   out_return_val OUT VARCHAR)
AS
   type t_tbl_number is table of number(20);
   type t_tbl_rowid  is table of rowid;
   l_sql        VARCHAR2(32000);
   l_cursor     SYS_REFCURSOR;
   l_limit      NUMBER := 20000;
   l_ref_uids   t_tbl_number;
   l_ref_rowids t_tbl_rowid;
BEGIN

    dbms_stats.gather_table_stats(ownname => 'STORETW',
        tabname => 'STG_DELETE_REF',
        cascade => TRUE,
        estimate_percent => DBMS_STATS.auto_sample_size);


    -- Delete ACTIVITY_GROUP and child table

    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_activity_group b ' ||
             ' where a.table_name = ''ACTIVITY_GROUP'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from activity_group_detail
         where fk_activity_group = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ACTIVITY_GROUP'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_activity_group
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete ATTACHED_OBJECT

    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ATTACHED_OBJECT'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_blob
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete BIOLOGICAL_HABITAT_INDEX

    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_bio_habitat_index b ' ||
             ' where a.table_name = ''BIOLOGICAL_HABITAT_INDEX'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from activity_metric_index
         where fk_bio_habitat_index = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''BIOLOGICAL_HABITAT_INDEX'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_bio_habitat_index
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete ORG_ADDRESS

    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ORG_ADDRESS'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from md_org_address
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete ORG_ELECTRONIC_ADDRESS

    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ORG_ELECTRONIC_ADDRESS'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from md_org_eaddress
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete ORG_PHONE

    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ORG_PHONE'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from md_org_eaddress
         where source_system = 'WQX'
           and source_orgph_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete ACTIVITY and children tables

    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_regular_result b ' ||
             ' where a.table_name = ''ACTIVITY'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from regular_result_project
         where fk_result = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_biological_result b ' ||
             ' where a.table_name = ''ACTIVITY'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from biological_result_project
         where fk_result = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_habitat_result b ' ||
             ' where a.table_name = ''ACTIVITY'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from habitat_result_project
         where fk_result = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_activity_metric b ' ||
             ' where a.table_name = ''ACTIVITY'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_act_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from activity_metric_index
         where fk_activitymetric = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''ACTIVITY'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit / 10;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_regular_result
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_biological_result
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_habitat_result
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_activity_metric
         where source_system = 'WQX'
           and source_act_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete MONITORING_LOCATION and children tables

    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, fa_station b ' ||
             ' where a.table_name = ''MONITORING_LOCATION'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from station_project
         where fk_station = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from lu_station_alias
         where fk_station = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''MONITORING_LOCATION'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from fa_station
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;




    -- Delete PROJECT and children tables

    l_sql := 'select b.pk_isn ' ||
             '  from stg_delete_ref a, di_project b ' ||
             ' where a.table_name = ''PROJECT'' ' ||
             '   and b.source_system = ''WQX'' ' ||
             '   and b.source_uid = a.ref_uid ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from regular_result_project
         where fk_project = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from biological_result_project
         where fk_project = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from habitat_result_project
         where fk_project = l_ref_uids(i);

        commit;

        forall i in 1 .. l_ref_uids.count
        delete
          from station_project
         where fk_project = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    l_sql := 'select a.ref_uid ' ||
             '  from stg_delete_ref a ' ||
             ' where a.table_name = ''PROJECT'' ' ||
             ' order by 1';

    open l_cursor for l_sql;

    loop

        fetch l_cursor bulk collect into l_ref_uids limit l_limit;
        exit when l_ref_uids.count = 0;

        forall i in 1 .. l_ref_uids.count
        delete
          from di_project
         where source_system = 'WQX'
           and source_uid = l_ref_uids(i);

        commit;

    end loop;

    close l_cursor;


    out_return_val := 'SUCCESS';

EXCEPTION
   WHEN OTHERS
   THEN
      BEGIN
         rollback;
         DBMS_OUTPUT.PUT_LINE (SQLERRM);
         out_return_val := 'FAILURE';
      END;
END sp_delete_from_storetw;
/

