
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_EMAIL_INVENTORY" (
   p_start_date      DATE,
   p_end_date        DATE,
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   lv_message         VARCHAR2 (32000) := NULL;
   lv_email_address   VARCHAR2 (1000);
   v_body             VARCHAR2 (32000) := NULL;
   v_query            VARCHAR2 (32000) := NULL;

   --Cursor retrieves ORG_ID, ORG_NAME, ORG_TYPE as reference metadata
   --7-10minutes
   CURSOR org_id(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || RTRIM ("ORGANIZATION_NAME")
               || CHR (10)
                  AS "ORGANIZATION"
          FROM "STORETW"."DI_ORG"
         WHERE PK_ISN IN
                  ( (SELECT DISTINCT PK_ISN AS FK_ORG
                       FROM "STORETW"."DI_ORG"
                      WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                   UNION
                   (SELECT DISTINCT FK_ORG
                      FROM "STORETW"."DI_PROJECT"
                     WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                   UNION
                   (SELECT DISTINCT FK_ORG
                      FROM "STORETW"."FA_STATION"
                     WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                   UNION
                   (SELECT DISTINCT FK_ORG
                      FROM "STORETW"."FA_REGULAR_RESULT"
                     WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                   UNION
                   (SELECT DISTINCT FK_ORG
                      FROM "STORETW"."FA_BIOLOGICAL_RESULT"
                     WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                   UNION
                   (SELECT DISTINCT FK_ORG
                      FROM "STORETW"."FA_HABITAT_RESULT"
                     WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date)
                  )
      ORDER BY ORGANIZATION_ID;

   --Cursor retrieves Results,Projects,Stations,Document/Graphics,Organizations
   CURSOR samp_reg_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || CHR (9)
               || COUNT (DISTINCT "ACTIVITY_ID")
               || CHR (9)
               || RTRIM ("ACTIVITY_MEDIUM")
               || CHR (9)
               || COUNT (1)
               || CHR (10)
                  AS "RESULT_COUNT"
          FROM "STORETW"."FA_REGULAR_RESULT"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY ORGANIZATION_ID, ACTIVITY_MEDIUM
      ORDER BY ORGANIZATION_ID, ACTIVITY_MEDIUM;

   --
   CURSOR samp_hab_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || CHR (9)
               || COUNT (DISTINCT "ACTIVITY_ID")
               || CHR (9)
               || RTRIM ("ACTIVITY_TYPE")
               || ' , '
               || RTRIM ("ACTIVITY_CATEGORY")
               || CHR (9)
               || COUNT (1)
               || CHR (10)
                  AS "RESULT_COUNT"
          FROM "STORETW"."FA_HABITAT_RESULT"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY ORGANIZATION_ID, ACTIVITY_TYPE, ACTIVITY_CATEGORY
      ORDER BY ORGANIZATION_ID, ACTIVITY_TYPE, ACTIVITY_CATEGORY;

   --
   CURSOR samp_bio_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || CHR (9)
               || COUNT (DISTINCT "ACTIVITY_ID")
               || CHR (9)
               || RTRIM ("ACTIVITY_INTENT")
               || ' , '
               || RTRIM ("ACTIVITY_COMMUNITY")
               || CHR (9)
               || COUNT (1)
               || CHR (10)
                  AS "RESULT_COUNT"
          FROM "STORETW"."FA_BIOLOGICAL_RESULT"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY ORGANIZATION_ID, ACTIVITY_INTENT, ACTIVITY_COMMUNITY
      ORDER BY ORGANIZATION_ID, ACTIVITY_INTENT, ACTIVITY_COMMUNITY;

   --
   CURSOR statn_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || CHR (9)
               || RTRIM ("FK_PRIMARY_TYPE")
               || CHR (9)
               || COUNT (1)
               || CHR (10)
                  AS "STATION_COUNT"
          FROM "STORETW"."FA_STATION"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY ORGANIZATION_ID, FK_PRIMARY_TYPE
      ORDER BY ORGANIZATION_ID, FK_PRIMARY_TYPE;

   --
   CURSOR prj_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("TSMPROJ_ORG_ID")
               || CHR (9)
               || CHR (9)
               || COUNT ("PROJECT_CD")
               || CHR (10)
                  AS "PROJECT_COUNT"
          FROM "STORETW"."DI_PROJECT"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY TSMPROJ_ORG_ID
      ORDER BY TSMPROJ_ORG_ID;

   --
   CURSOR blob_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("TSMBLOB_ORG_ID")
               || CHR (9)
               || CHR (9)
               || COUNT ("BLOB_TITLE" || ' , ' || "BLOB_TYPE")
               || CHR (10)
                  AS "BLOB_COUNT"
          FROM "STORETW"."FA_BLOB"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      GROUP BY TSMBLOB_ORG_ID
      ORDER BY TSMBLOB_ORG_ID;

   --
   CURSOR org_count(c_start_date in date, c_end_date in date)
   IS
        SELECT    RTRIM ("ORGANIZATION_ID")
               || CHR (9)
               || CHR (9)
               || NVL ("ORGANIZATION_TYPE", 'Private Industry')
               || CHR (10)
                  AS "ORGANIZATION"
          FROM "STORETW"."DI_ORG"
         WHERE LAST_CHANGE_DATE BETWEEN c_start_date AND c_end_date
      ORDER BY ORGANIZATION_ID;

BEGIN
   --lv_email_address := 'storet@epa.gov';

   lv_email_address := storetw.dw_glob_var.gv_storet_email;

   /*
   lv_message :=
         'Start of Warehouse(STORETW) Inventory Report. '
      || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi');
   */

   -- /*
   --STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
   --storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'STORET Warehouse Weekly (incremental) Refresh Report', p_body =>
   --lv_message);
   -- */

   /*
   STORETW.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        =>    'Start of STORET Warehouse Weekly (incremental) Refresh Report. '
                          || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi'),
      p_body           => lv_message);
   */

   SELECT    'Subject: CORRECTIONS: STORET Warehouse Weekly (incremental) Refresh Report. [station types]'
          || CHR (10)
          || CHR (10)
          || 'From:    Kevin Christian'
          || CHR (10)
          || CHR (10)
          || 'To:    Water Quality Monitoring Community'
          || CHR (10)
          || CHR (10)
          || CHR (10)
          || 'The text report below contains the WQX data submission counts for'
          || CHR (10)
          || 'following:'
          || CHR (10)
          || CHR (10)
          || 'Organization ID are identified by Organization Name'
          || CHR (10)
          || 'Results: Regular,Habitat, Biological'
          || CHR (10)
          || 'Stations:'
          || CHR (10)
          || 'Projects:'
          || CHR (10)
          || 'Document/Graphics:'
          || CHR (10)
          || 'Organizations:'
          || CHR (10)
          || CHR (10)
          || 'The report details WQX Data Submission by Organization ID and Name.'
          || CHR (10)
          || 'A simple text report queried from the STORET Warehouse Tables.'
          || CHR (10)
          || CHR (10)
          || 'STORET Data Warehouse:  http://www.epa.gov/storet/dw_home.html '
          || CHR (10)
          || ' Warehouse Refresh Cycle:  Weekly - Every Wednesday Night 5:00pm '
          || CHR (10)
          || ' Pacific Time.'
          || CHR (10)
          || CHR (10)
          || 'Note: This is a draft report. The automated report will be emailed to '
          || CHR (10)
          || 'the STORET Listserver following each weekly Warehouse Refresh '
          || CHR (10)
          || '(Extract, Transform and Load) session used to publish '
          || CHR (10)
          || 'WQX Data submission via the STORET Warehouse.'
          || CHR (10)
          || CHR (10)
          || 'Comments should be directed to the STORET Helpdesk via email:'
          || CHR (10)
          || 'storet@epa.gov'
          || CHR (10)
          || 'Have a Nice Day!'
          || CHR (10)
          || CHR (10)
          || 'Thanks.'
          || CHR (10)
          || 'STORET Group.'
          || CHR (10)
          || '1-800-424-9067'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;

   --select 'ORIGINAL Inventory Report Date: '||TO_DATE((sysdate-7), 'dd-Mon-yyyy HH:MI:SS AM')||' thru '||TO_DATE((sysdate), 'dd-Mon-yyyy HH:MI:SS AM')||chr(10)||chr(10)
   --INTO v_query from dual;

   SELECT    'ORIGINAL Inventory Report Date: '
          || TO_CHAR ( p_start_date, 'dd-Mon-yyyy HH:MI:SS AM')
          || ' thru '
          || TO_CHAR ( p_end_date, 'dd-Mon-yyyy HH:MI:SS AM')
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;


   SELECT    CHR (10)
          || 'Reference Metadata:'
          || CHR (10)
          || 'ORGANIZATION_ID    ORGANIZATION_NAME'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;

   v_query := '';

   -- Organization METADATA Report
   OPEN org_id(p_start_date, p_end_date);

   LOOP
      FETCH org_id INTO v_query;

      EXIT WHEN org_id%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE org_id;


   SELECT    CHR (10)
          || 'Regular Result(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    SAMPLE_COUNT    ACTIVITY_MEDIUM    RESULT_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;


   --v_query := '';
   -- Sample Counts per MEDIUM aggregated by REGULAR_RESULT
   OPEN samp_reg_count(p_start_date, p_end_date);

   LOOP
      v_query := '';

      FETCH samp_reg_count INTO v_query;

      EXIT WHEN samp_reg_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE samp_reg_count;

   v_body := v_body || v_query;


   SELECT    CHR (10)
          || 'Habitat Result(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    SAMPLE_COUNT    ACTIVITY_TYPE,ACTIVITY_CATEGORY    RESULT_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Sample Counts per TYPE aggregated by HABITAT_RESULT
   OPEN samp_hab_count(p_start_date, p_end_date);

   LOOP
      FETCH samp_hab_count INTO v_query;

      EXIT WHEN samp_hab_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE samp_hab_count;


   SELECT    CHR (10)
          || 'Biological Result(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    SAMPLE_COUNT    ACTIVITY_INTENT,ACTIVITY_COMMUNITY    RESULT_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Sample Counts per INTENT aggregated by BIOLOGICAL_RESULT
   OPEN samp_bio_count(p_start_date, p_end_date);

   LOOP
      FETCH samp_bio_count INTO v_query;

      EXIT WHEN samp_bio_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE samp_bio_count;


   SELECT    CHR (10)
          || 'Station(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    STATION_TYPE    STATION_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Station Counts aggregated by ORGANIZATION
   OPEN statn_count(p_start_date, p_end_date);

   LOOP
      FETCH statn_count INTO v_query;

      EXIT WHEN statn_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE statn_count;


   SELECT    CHR (10)
          || 'Project(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    PROJECT_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Organization NEW Counts
   OPEN prj_count(p_start_date, p_end_date);

   LOOP
      FETCH prj_count INTO v_query;

      EXIT WHEN prj_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE prj_count;


   SELECT    CHR (10)
          || 'Document/Graphic(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    BLOB_COUNT'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Organization NEW Counts
   OPEN blob_count(p_start_date, p_end_date);

   LOOP
      FETCH blob_count INTO v_query;

      EXIT WHEN blob_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE blob_count;


   SELECT    CHR (10)
          || 'Organization(s):'
          || CHR (10)
          || 'ORGANIZATION_ID    ORGANIZATION_TYPE'
          || CHR (10)
     INTO v_query
     FROM DUAL;

   v_body := v_body || v_query;
   v_query := '';


   -- Organization NEW Counts
   OPEN org_count(p_start_date, p_end_date);

   LOOP
      FETCH org_count INTO v_query;

      EXIT WHEN org_count%NOTFOUND;

      v_body := v_body || v_query;
   END LOOP;

   CLOSE org_count;


   lv_message := v_body;
   -- lv_email_address:='"STORET news and information" <storetinfo@lists.epa.gov>';
   --lv_email_address:='storetinfo@lists.epa.gov';
   --lv_email_address := 'storet@epa.gov';

   STORETW.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        =>    'STORET Warehouse Weekly (incremental) Refresh Report. '
                          || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi'),
      p_body           => lv_message);

   /*
   lv_message :=
         'End of Warehouse(STORETW) Inventory Report. '
      || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi');
   lv_email_address := 'storet@epa.gov';

   STORETW.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        =>    'End of STORET Warehouse Weekly (incremental) Refresh Report. '
                          || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi'),
      p_body           => lv_message);
    */

   p_record_no := null;
   p_comments := '';

EXCEPTION
   WHEN OTHERS
   THEN
      lv_message := SQLERRM;
      --lv_email_address := 'storet@epa.gov';

      --  /*
      STORETW.dw_mail_pkg.send (
         p_sender_email   => storetw.dw_glob_var.gv_storet_email,
         p_from           => 'STORET@EPA.GOV',
         p_to             => storetw.dw_mail_pkg.array (lv_email_address),
         p_subject        =>    'ERROR during STORET Warehouse Weekly (incremental) Refresh Report.'
                             || TO_CHAR ( (SYSDATE), 'dd-mon-yyyy hh24:mi'),
         p_body           => lv_message);
      -- */

      raise;

END;
/

