
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_POST_PROCESSING_FOR_WQX_ETL" (
   in_dummy_val IN NUMBER,
   out_proc_status OUT NUMBER
)
AS
   str_block VARCHAR2(4000);

BEGIN

   -----------------------------------------------------------------------------
   -- Step 10
   -- Create an anonymous block to run the required stored procedures
   -----------------------------------------------------------------------------
   /*
   str_block := 'DECLARE '
             || '    lv_message         LONG;'
             || '    lv_from            VARCHAR2(100) := ''STORET@INDUSCORP.COM'';'
             || '    lv_email_address   VARCHAR2(100) := ''STORET@INDUSCORP.COM'';'
             || 'BEGIN '
             || '    lv_message := ''Post ETL start time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''01/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_insertintoactivityproject(); '
             || '    lv_message := ''sp_insertintoactivityproject end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''02/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_conv_wgs84_latlong(); '
             || '    lv_message := ''sp_conv_wgs84_latlong end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''03/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_update_geomwgs84_latlong(); '
             || '    lv_message := ''sp_update_geomwgs84_latlong end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''04/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_update_fa_station_huc(sysdate - 14, 10000); '
             || '    lv_message := ''sp_update_fa_station_huc end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''05/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_update_result_tables_huc(10000,FALSE); '
             || '    lv_message := ''sp_update_result_tables_huc end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''06/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_update_result_tables_statn(10000,FALSE); '
             || '    lv_message := ''sp_update_result_tables_statn end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''07/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || '    storetw.sp_run_station_char_medium(); '

             || '    storetw.sp_email_inventory(); '
             || '    lv_message := ''Post ETL end time: '' || to_char(sysdate,''MM/DD/YYYY HH24:MI:SS'');'
             || '    storetw.dw_mail_pkg.send(p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => lv_from, p_to => storetw.dw_mail_pkg.array(lv_email_address), p_subject => ''18/18 Post-ETL Run Performance Metrics'', p_body => lv_message);'

             || 'END;';
   */

   str_block := 'BEGIN '
             || '    dw_post_etl_pkg.sp_start_post_etl_process();'
             || 'END;';

   -----------------------------------------------------------------------------
   -- Step 20
   -- Build and Execute a single job running each individual stored procedure
   -----------------------------------------------------------------------------
   dbms_scheduler.create_job(
      job_name        => 'STORETW.POST_PROCESSING_FOR_WQX_ETL',
      job_type        => 'PLSQL_BLOCK',
      job_action      => str_block,
      enabled         => TRUE,
      comments        => 'Post Processing ETL'
   );

   -----------------------------------------------------------------------------
   -- Step 30
   -- As the procedures run in separate thread, there is no possible value but 0
   -----------------------------------------------------------------------------
   out_proc_status   := 0;

END;
/

