
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_PRE_PROCESSING_FOR_WQX_ETL" (
   in_DUMMY_VAL      IN     NUMBER,
   out_PROC_STATUS      OUT NUMBER)
AS
   jn                 BINARY_INTEGER;
   lv_etl_full_load   VARCHAR2 (6) := 'NO';
BEGIN
   BEGIN
      SELECT PARAMETER_VALUE
        INTO lv_etl_full_load
        FROM mt_wh_config
       WHERE parameter_name = 'ETL_FULL_LOAD';

      --sys.dbms_job.SUBMIT(jn,'sp_DROP_INDEXES_B4_WQXETL;');
      --dbms_output.put_line('job id = '||to_char(jn));
      IF lv_etl_full_load = 'YES'
      THEN
         sp_DROP_INDEXES_B4_WQXETL;
      END IF;

      COMMIT;
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.put_line (
               'failure sp_DROP_INDEXES_B4_WQXETL procedure in pre_processing_for_wqx_etl '
            || SQLERRM);
         NULL;
   END;

   BEGIN
      SP_SEQUENCE_SYNCH;
      COMMIT;
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.put_line (
               'failure SP_SEQUENCE_SYNCH procedure in pre_processing_for_wqx_etl '
            || SQLERRM);
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'truncate table stg_activity_project';
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.put_line (
            'truncate stg_activity_project failure: ' || SQLERRM);
         NULL;
   END;

   BEGIN
      EXECUTE IMMEDIATE 'truncate table stg_delete_ref';
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.put_line (
            'truncate stg_delete_ref failure: ' || SQLERRM);
         NULL;
   END;

   UPDATE mt_wh_config
      SET PARAMETER_VALUE = 'NO'
    WHERE parameter_name = 'ETL_FULL_LOAD';

   COMMIT;

   out_PROC_STATUS := 0;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.put_line (
         'failure running post_processing_for_wqx_etl ' || SQLERRM);
      out_proc_status := 9999;
END;
/

