
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_STATION_CHAR_MEDIUM" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_org_err    NUMBER := 0;
   l_org        NUMBER := 0;
   l_cct        NUMBER := 0;
   l_cct2       NUMBER := 0;
   l_reg        NUMBER := 0;
   l_hab        NUMBER := 0;
   l_bio        NUMBER := 0;
   l_sta        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN
   -- Check to see if organizations for which an organization type cannot be mapped exist
   SELECT COUNT (DISTINCT organization_id)
     INTO l_org_err
     FROM di_org a
    WHERE DECODE (
             UPPER (organization_type),
             'US GOVERNMENT/FEDERAL', 'FEDERAL/US GOVERNMENT',
             'GOVERNMENT/STATE', 'STATE/US GOVERNMENT',
             'US GOVERNMENT/STATE', 'STATE/US GOVERNMENT',
             'US GOVERNMENT/LOCAL', 'LOCAL/US GOVERNMENT',
             'US GOVERNMENT/INTERSTATE COMSN', 'INTERSTATE COMSN/US GOVERNMENT',
             'PRIVATE', 'PRIVATE NON-INDUSTRIAL',
             UPPER (organization_type)) NOT IN
             (SELECT UPPER (organization_type) FROM di_org_types);

   -- Create organization type association for organizations
   MERGE INTO lu_orgtype dst
        USING (SELECT a.pk_isn AS fk_org, b.pk_isn AS fk_org_type
                 FROM di_org a, di_org_types b
                WHERE DECODE (
                         UPPER (a.organization_type),
                         'US GOVERNMENT/FEDERAL', 'FEDERAL/US GOVERNMENT',
                         'GOVERNMENT/STATE', 'STATE/US GOVERNMENT',
                         'US GOVERNMENT/STATE', 'STATE/US GOVERNMENT',
                         'US GOVERNMENT/LOCAL', 'LOCAL/US GOVERNMENT',
                         'US GOVERNMENT/INTERSTATE COMSN', 'INTERSTATE COMSN/US GOVERNMENT',
                         'PRIVATE', 'PRIVATE NON-INDUSTRIAL',
                         UPPER (a.organization_type)) =
                         UPPER (b.organization_type)) src
           ON (src.fk_org = dst.fk_org AND src.fk_org_type = dst.fk_org_type)
   WHEN NOT MATCHED
   THEN
      INSERT     (dst.fk_org, dst.fk_org_type)
          VALUES (src.fk_org, src.fk_org_type);

   l_org := SQL%ROWCOUNT;

   COMMIT;


   INSERT /*+APPEND*/
         INTO  characteristic_chartype (fk_characteristic, fk_chartype)
      SELECT c.pk_isn, mcc.fk_chartype
        FROM di_characteristic c, mt_char_chartype mcc
       WHERE     c.display_name = mcc.char_name
             AND NOT EXISTS
                        (SELECT 1
                           FROM characteristic_chartype cc
                          WHERE     cc.fk_characteristic = c.pk_isn
                                AND cc.fk_chartype = mcc.fk_chartype);

   l_cct := SQL%ROWCOUNT;

   COMMIT;


   -- Add "Not Assigned" characteristic type for newly added characteristics
   -- TODO: Add to Informatica ETL and remove from post ETL
   INSERT /*+APPEND*/
         INTO  characteristic_chartype (fk_characteristic, fk_chartype)
      SELECT a.pk_isn AS fk_characteristic, 12 AS fk_chartype
        FROM di_characteristic a
       WHERE a.pk_isn NOT IN
                (SELECT fk_characteristic FROM characteristic_chartype);

   l_cct2 := SQL%ROWCOUNT;

   COMMIT;


   -- Keep CHARTYPE column in sync with CHARACTERISTIC_CHARTYPE table
   -- TODO: Add to Informatica ETL and remove from post ETL
   UPDATE di_characteristic a
      SET chartype =
             (SELECT MIN (c.chartype)
                FROM characteristic_chartype b, lu_chartype c
               WHERE     b.fk_chartype = c.pk_isn
                     AND b.fk_characteristic = a.pk_isn)
    WHERE chartype IS NULL;

   COMMIT;


   --truncate station_char_medium and drop all indexes on station_char_medium
   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.station_char_medium';

   FOR c IN (SELECT index_name
               FROM all_indexes
              WHERE owner = 'STORETW' AND table_name = 'STATION_CHAR_MEDIUM')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;


   -----------------------------------------------------------------------------
   -- Load fa_regular_result into station_char_medium
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  station_char_medium (fk_char,
                                    fk_act_medium,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_db_cat,
                                    hydrologic_unit_code,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    search_name,
                                    char_type_code,
                                    regular_count,
                                    act_min_start_date,
                                    act_max_start_date,
                                    act_max_start_stop_date,
                                    result_count,
                                    rslt_min_value_measure,
                                    rslt_max_value_measure,
                                    rslt_avg_value_measure,
                                    rslt_measure_unit,
                                    last_change_date,
                                    fk_date_act_min_start,
                                    fk_date_act_max_start)
      SELECT /*+PARALLEL(a 4) */
            a.fk_char,
             a.fk_act_medium,
             a.fk_fa_statn,
             a.fk_org,
             a.fk_gen_db_cat,
             b.generated_huc AS hydrologic_unit_code,
             trim(b.organization_id) AS organization_id,
             trim(b.station_id) AS station_id,
             b.station_name AS station_name,
             c.display_name,
             c.search_name,
             c.type_code AS char_type_code,
             a.result_count AS regular_count,
             a.act_min_start_date,
             a.act_max_start_date,
             a.act_max_start_stop_date,
             a.result_count,
             a.rslt_min_value_measure,
             a.rslt_max_value_measure,
             a.rslt_avg_value_measure,
             a.rslt_measure_unit,
             a.last_change_date,
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_min_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY')),
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_max_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY'))
        FROM (  SELECT /*+PARALLEL(fa_regular_result 4) NO_MERGE*/
                      fk_char AS fk_char,
                       fk_act_medium AS fk_act_medium,
                       fk_station AS fk_fa_statn,
                       fk_org AS fk_org,
                       fk_gen_db_cat AS fk_gen_db_cat,
                       MIN (activity_start_date_time) AS act_min_start_date,
                       MAX (activity_start_date_time) AS act_max_start_date,
                       CASE
                          WHEN MAX (activity_stop_date_time) >
                                  MAX (activity_start_date_time)
                          THEN
                             MAX (activity_stop_date_time)
                          ELSE
                             MAX (activity_start_date_time)
                       END
                          AS act_max_start_stop_date,
                       COUNT (*) AS result_count,
                       MIN (std_value) AS rslt_min_value_measure,
                       MAX (std_value) AS rslt_max_value_measure,
                       AVG (std_value) AS rslt_avg_value_measure,
                       std_unit AS rslt_measure_unit,
                       MAX (last_change_date) AS last_change_date
                  FROM fa_regular_result
                 WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
              GROUP BY fk_char,
                       fk_act_medium,
                       fk_station,
                       fk_org,
                       fk_gen_db_cat,
                       std_unit) a,
             fa_station b,
             di_characteristic c
       WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+);

   l_reg := SQL%ROWCOUNT;

   COMMIT;

   -----------------------------------------------------------------------------
   -- Load fa_habitat_result into station_char_medium
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  station_char_medium (fk_char,
                                    fk_act_medium,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_db_cat,
                                    hydrologic_unit_code,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    search_name,
                                    char_type_code,
                                    habitat_count,
                                    act_min_start_date,
                                    act_max_start_date,
                                    act_max_start_stop_date,
                                    result_count,
                                    rslt_min_value_measure,
                                    rslt_max_value_measure,
                                    rslt_avg_value_measure,
                                    rslt_measure_unit,
                                    last_change_date,
                                    fk_date_act_min_start,
                                    fk_date_act_max_start)
      SELECT /*+PARALLEL(a 4) */
            a.fk_char,
             NULL AS fk_act_medium,
             a.fk_fa_statn,
             a.fk_org,
             a.fk_gen_db_cat,
             b.generated_huc AS hydrologic_unit_code,
             trim(b.organization_id) AS organization_id,
             trim(b.station_id) AS station_id,
             b.station_name AS station_name,
             c.display_name,
             c.search_name,
             c.type_code AS char_type_code,
             a.result_count AS habitat_count,
             a.act_min_start_date,
             a.act_max_start_date,
             a.act_max_start_stop_date,
             a.result_count,
             a.rslt_min_value_measure,
             a.rslt_max_value_measure,
             a.rslt_avg_value_measure,
             a.rslt_measure_unit,
             a.last_change_date,
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_min_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY')),
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_max_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY'))
        FROM (  SELECT /*+PARALLEL(fa_habitat_result 4) NO_MERGE*/
                      fk_char AS fk_char,
                       fk_station AS fk_fa_statn,
                       fk_org AS fk_org,
                       fk_gen_db_cat AS fk_gen_db_cat,
                       MIN (activity_start_date_time) AS act_min_start_date,
                       MAX (activity_start_date_time) AS act_max_start_date,
                       CASE
                          WHEN MAX (activity_stop_date_time) >
                                  MAX (activity_start_date_time)
                          THEN
                             MAX (activity_stop_date_time)
                          ELSE
                             MAX (activity_start_date_time)
                       END
                          AS act_max_start_stop_date,
                       COUNT (*) AS result_count,
                       MIN (std_value) AS rslt_min_value_measure,
                       MAX (std_value) AS rslt_max_value_measure,
                       AVG (std_value) AS rslt_avg_value_measure,
                       std_unit AS rslt_measure_unit,
                       MAX (last_change_date) AS last_change_date
                  FROM fa_habitat_result
                 WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
              GROUP BY fk_char,
                       fk_station,
                       fk_org,
                       fk_gen_db_cat,
                       std_unit) a,
             fa_station b,
             di_characteristic c
       WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+);

   l_hab := SQL%ROWCOUNT;

   COMMIT;

   -----------------------------------------------------------------------------
   -- Load fa_biological_result into station_char_medium
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  station_char_medium (fk_char,
                                    fk_act_medium,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_db_cat,
                                    hydrologic_unit_code,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    search_name,
                                    char_type_code,
                                    biological_count,
                                    act_min_start_date,
                                    act_max_start_date,
                                    act_max_start_stop_date,
                                    result_count,
                                    rslt_min_value_measure,
                                    rslt_max_value_measure,
                                    rslt_avg_value_measure,
                                    rslt_measure_unit,
                                    last_change_date,
                                    fk_date_act_min_start,
                                    fk_date_act_max_start)
      SELECT /*+PARALLEL(a 4) */
            a.fk_char,
             a.fk_act_medium,
             a.fk_fa_statn,
             a.fk_org,
             a.fk_gen_db_cat,
             b.generated_huc AS hydrologic_unit_code,
             trim(b.organization_id) AS organization_id,
             trim(b.station_id) AS station_id,
             b.station_name AS station_name,
             c.display_name,
             c.search_name,
             c.type_code AS char_type_code,
             a.result_count AS regular_count,
             a.act_min_start_date,
             a.act_max_start_date,
             a.act_max_start_stop_date,
             a.result_count,
             a.rslt_min_value_measure,
             a.rslt_max_value_measure,
             a.rslt_avg_value_measure,
             a.rslt_measure_unit,
             a.last_change_date,
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_min_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY')),
             (SELECT pk_isn
                FROM di_date
               WHERE full_date =
                        TO_DATE (
                           TO_CHAR (a.act_max_start_date, 'MM/DD/YYYY'),
                           'MM/DD/YYYY'))
        FROM (  SELECT /*+PARALLEL(fa_biological_result 4) NO_MERGE*/
                      fk_char AS fk_char,
                       fk_act_medium AS fk_act_medium,
                       fk_station AS fk_fa_statn,
                       fk_org AS fk_org,
                       fk_gen_db_cat AS fk_gen_db_cat,
                       MIN (activity_start_date_time) AS act_min_start_date,
                       MAX (activity_start_date_time) AS act_max_start_date,
                       CASE
                          WHEN MAX (activity_stop_date_time) >
                                  MAX (activity_start_date_time)
                          THEN
                             MAX (activity_stop_date_time)
                          ELSE
                             MAX (activity_start_date_time)
                       END
                          AS act_max_start_stop_date,
                       COUNT (*) AS result_count,
                       MIN (std_value) AS rslt_min_value_measure,
                       MAX (std_value) AS rslt_max_value_measure,
                       AVG (std_value) AS rslt_avg_value_measure,
                       std_unit AS rslt_measure_unit,
                       MAX (last_change_date) AS last_change_date
                  FROM fa_biological_result
                 WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
              GROUP BY fk_char,
                       fk_act_medium,
                       fk_station,
                       fk_org,
                       fk_gen_db_cat,
                       std_unit) a,
             fa_station b,
             di_characteristic c
       WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+);

   l_bio := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscm_fk_char ON station_char_medium(fk_char) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
            l_comments || 'Create iscm_fk_char failed: ' || SQLCODE || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscm_fk_act_medium ON station_char_medium(fk_act_medium) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscm_fk_act_medium failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscm_fk_fa_statn ON station_char_medium(fk_fa_statn) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscm_fk_fa_statn failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iscm_search_name ON station_char_medium(search_name) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscm_search_name failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscm_fk_date_act_min_start ON station_char_medium(fk_date_act_min_start) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscm_fk_date_act_min_start failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscm_fk_date_act_max_start ON station_char_medium(fk_date_act_max_start) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscm_fk_date_act_max_start failed: '
            || SQLCODE
            || '. ';
   END;

   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'STATION_CHAR_MEDIUM',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);


   UPDATE storetw.fa_station a
      SET a.station_visited = 'YES'
    WHERE EXISTS
             (SELECT 1
                FROM station_char_medium b
               WHERE b.fk_fa_statn = a.pk_isn);

   l_sta := SQL%ROWCOUNT;

   COMMIT;

   p_record_no := l_reg + l_bio + l_hab;
   p_comments :=
         l_comments
      || 'RR: '
      || l_reg
      || '. BR: '
      || l_bio
      || '. HR: '
      || l_hab
      || '. ORGERR: '
      || l_org_err
      || '. ORG: '
      || l_org
      || '. CCT: '
      || l_cct
      || '. CCTNA: '
      || l_cct2
      || '. STA: '
      || l_sta
      || '.';
END sp_refresh_station_char_medium;
/

