
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_STATION_CHAR_NEW" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
    l_res       NUMBER := 0;
    l_comments  VARCHAR2(4000) := '';
BEGIN
   -----------------------------------------------------------------------------
   --truncate station_char and drop all indexes on station_char
   -----------------------------------------------------------------------------
   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.station_char';

   FOR c IN (SELECT index_name
               FROM all_indexes
              WHERE owner = 'STORETW' AND table_name = 'STATION_CHAR')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ics_fk_char';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments := l_comments || 'Drop ics_fk_char failed: ' || sqlcode || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ics_fk_fa_statn';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments := l_comments || 'Drop ics_fk_fa_statn failed: ' || sqlcode || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ics_search_name';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments := l_comments || 'Drop ics_search_name failed: ' || sqlcode || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ics_char_type_code';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments := l_comments || 'Drop ics_char_type_code failed: ' || sqlcode || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX ics_fk_char_fk_fa_statn';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments := l_comments || 'Drop ics_fk_char_fk_fa_statn failed: ' || sqlcode || '. ';
   END;
   */


   -----------------------------------------------------------------------------
   -- Aggregate station_char_medium into station_char
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  station_char (fk_char,
                             fk_fa_statn,
                             hydrologic_unit_code,
                             organization_id,
                             organization_name,
                             station_id,
                             station_name,
                             stn_std_latitude,
                             stn_std_longitude,
                             display_name,
                             search_name,
                             char_type_code,
                             regular_count,
                             biological_count,
                             habitat_count,
                             act_min_start_date,
                             act_max_start_date,
                             act_max_start_stop_date,
                             result_count)
        SELECT /*+PARALLEL(a 4)*/
               a.fk_char,
               a.fk_fa_statn,
               a.hydrologic_unit_code,
               a.organization_id,
               c.organization_name,
               a.station_id,
               a.station_name,
               b.std_latitude as stn_std_latitude,
               b.std_longitude as stn_std_longitude,
               a.display_name,
               a.search_name,
               a.char_type_code,
               SUM (a.regular_count) AS regular_count,
               SUM (a.biological_count) AS biological_count,
               SUM (a.habitat_count) AS habitat_count,
               MIN (a.act_min_start_date) AS act_min_start_date,
               MAX (a.act_max_start_date) AS act_max_start_date,
               MAX (a.act_max_start_stop_date) AS act_max_start_stop_date,
               SUM (a.result_count) AS result_count
          FROM station_char_medium a, fa_station b, di_org c
         WHERE a.fk_fa_statn = b.pk_isn
           AND a.fk_org = c.pk_isn
      GROUP BY a.fk_char,
               a.fk_fa_statn,
               a.hydrologic_unit_code,
               a.organization_id,
               c.organization_name,
               a.station_id,
               a.station_name,
               b.std_latitude,
               b.std_longitude,
               a.display_name,
               a.search_name,
               a.char_type_code;

   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX isc_fk_char ON station_char(fk_char) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_fk_char failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX isc_fk_fa_statn ON station_char(fk_fa_statn) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_fk_fa_statn failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX isc_hydrologic_unit_code ON station_char(hydrologic_unit_code) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_hydrologic_unit_code failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX isc_search_name ON station_char(search_name) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_search_name failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX isc_organization_id ON station_char(lower(organization_id)) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_organization_id failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX isc_station_id ON station_char(lower(station_id)) TABLESPACE storetindx PCTFREE 10 NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create isc_station_id failed: '
            || SQLCODE
            || '. ';
   END;


   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'STATION_CHAR',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);


   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';
END;
/

