
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_STATION_CHAR_YEAR" as
  lv_message varchar2(32000):= null;
  lv_email_address varchar2(1000);
  v_body varchar2(32000):= null;
  v_query varchar2(32000):= null;
--
    v_ctr PLS_INTEGER := 0;

   l_org_err    NUMBER := 0;
   l_org        NUMBER := 0;
   l_cct        NUMBER := 0;
   l_cct2       NUMBER := 0;
   l_reg        NUMBER := 0;
   l_hab        NUMBER := 0;
   l_bio        NUMBER := 0;
   l_met        NUMBER := 0;
   l_sta        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';

   p_record_no  NUMBER := 0;
   p_comments   VARCHAR2 (4000) := '';


BEGIN

lv_email_address:='christian.kevin@epa.gov';

lv_message:='Start of SP_REFRESH_STATION_CHAR_YEAR. '||to_char(sysdate,'dd-mon-yyyy hh24:mi');

STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'Start of Warehouse(STORETW) SP_REFRESH_STATION_CHAR_YEAR Report. '||to_char(sysdate,'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);



   --truncate station_char_year and drop all indexes on station_char_year
   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.station_char_year';

   FOR c IN (SELECT index_name
               FROM all_indexes
              WHERE owner = 'STORETW' AND table_name = 'STATION_CHAR_YEAR')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;


   -----------------------------------------------------------------------------
   -- Load fa_regular_result into station_char_year
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  storetw.station_char_year (fk_char,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_geo_state,
                                    fk_gen_geo_county,
                                    fk_gen_db_cat,
                                    state_name,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    regular_count,
                                    act_start_year_date,
                                    result_count)
       SELECT /*+PARALLEL(a 4) */
             a.fk_char,
              a.fk_fa_statn,
              a.fk_org,
              b.fk_gen_geo_state,
              b.fk_gen_geo_county,
              b.fk_gen_db_cat,
              d.state_name AS state_name,
              trim(b.organization_id) AS organization_id,
              trim(b.station_id) AS station_id,
              b.station_name AS station_name,
              c.display_name,
               a.result_count AS regular_count,
               a.act_start_year_date,
               a.result_count
          FROM (  SELECT /*+PARALLEL(fa_regular_result 4) NO_MERGE*/
                        fk_char AS fk_char,
                         fk_station AS fk_fa_statn,
                         fk_org AS fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY') AS act_start_year_date,
                         COUNT (*) AS result_count
                    FROM storetw.fa_regular_result
                   WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
                GROUP BY fk_char,
                         fk_station,
                         fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY')) a,
               storetw.fa_station b,
               storetw.di_geo_state d,
               storetw.di_characteristic c
         WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+)  AND b.fk_gen_geo_state = d.pk_isn(+) ;
   l_reg := SQL%ROWCOUNT;

   COMMIT;

   -----------------------------------------------------------------------------
   -- Load fa_habitat_result into station_char_year
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  storetw.station_char_year (fk_char,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_geo_state,
                                    fk_gen_geo_county,
                                    fk_gen_db_cat,
                                    state_name,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    habitat_count,
                                    act_start_year_date,
                                    result_count)
       SELECT /*+PARALLEL(a 4) */
             a.fk_char,
              a.fk_fa_statn,
              a.fk_org,
              b.fk_gen_geo_state,
              b.fk_gen_geo_county,
              b.fk_gen_db_cat,
              d.state_name AS state_name,
              trim(b.organization_id) AS organization_id,
              trim(b.station_id) AS station_id,
              b.station_name AS station_name,
              c.display_name,
               a.result_count AS habitat_count,
               a.act_start_year_date,
               a.result_count
          FROM (  SELECT /*+PARALLEL(fa_habitat_result 4) NO_MERGE*/
                        fk_char AS fk_char,
                         fk_station AS fk_fa_statn,
                         fk_org AS fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY') AS act_start_year_date,
                         COUNT (*) AS result_count
                    FROM storetw.fa_habitat_result
                   WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
                GROUP BY fk_char,
                         fk_station,
                         fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY')) a,
               storetw.fa_station b,
               storetw.di_geo_state d,
               storetw.di_characteristic c
         WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+)  AND b.fk_gen_geo_state = d.pk_isn(+) ;
   l_hab := SQL%ROWCOUNT;

   COMMIT;

   -----------------------------------------------------------------------------
   -- Load fa_biological_result into station_char_year
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  storetw.station_char_year (fk_char,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_geo_state,
                                    fk_gen_geo_county,
                                    fk_gen_db_cat,
                                    state_name,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    biological_count,
                                    act_start_year_date,
                                    result_count)
       SELECT /*+PARALLEL(a 4) */
             a.fk_char,
              a.fk_fa_statn,
              a.fk_org,
              b.fk_gen_geo_state,
              b.fk_gen_geo_county,
              b.fk_gen_db_cat,
              d.state_name AS state_name,
              trim(b.organization_id) AS organization_id,
              trim(b.station_id) AS station_id,
              b.station_name AS station_name,
              c.display_name,
               a.result_count AS biological_count,
               a.act_start_year_date,
               a.result_count
          FROM (  SELECT /*+PARALLEL(fa_biological_result 4) NO_MERGE*/
                        fk_char AS fk_char,
                         fk_station AS fk_fa_statn,
                         fk_org AS fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY') AS act_start_year_date,
                         COUNT (*) AS result_count
                    FROM storetw.fa_biological_result
                   WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
                GROUP BY fk_char,
                         fk_station,
                         fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY')) a,
               storetw.fa_station b,
               storetw.di_geo_state d,
               storetw.di_characteristic c
         WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+)  AND b.fk_gen_geo_state = d.pk_isn(+) ;
   l_bio := SQL%ROWCOUNT;

   COMMIT;


   -----------------------------------------------------------------------------
   -- Load fa_activity_metric into station_char_year
   -----------------------------------------------------------------------------
   INSERT /*+ APPEND */
         INTO  storetw.station_char_year (fk_char,
                                    fk_fa_statn,
                                    fk_org,
                                    fk_gen_geo_state,
                                    fk_gen_geo_county,
                                    fk_gen_db_cat,
                                    state_name,
                                    organization_id,
                                    station_id,
                                    station_name,
                                    display_name,
                                    metric_count,
                                    act_start_year_date,
                                    result_count)
       SELECT /*+PARALLEL(a 4) */
             a.fk_char,
              a.fk_fa_statn,
              a.fk_org,
              b.fk_gen_geo_state,
              b.fk_gen_geo_county,
              b.fk_gen_db_cat,
              d.state_name AS state_name,
              trim(b.organization_id) AS organization_id,
              trim(b.station_id) AS station_id,
              b.station_name AS station_name,
              c.display_name,
               a.result_count AS metric_count,
               a.act_start_year_date,
               a.result_count
          FROM (  SELECT /*+PARALLEL(fa_activity_metric 4) NO_MERGE*/
                        fk_char AS fk_char,
                         fk_station AS fk_fa_statn,
                         fk_org AS fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY') AS act_start_year_date,
                         COUNT (*) AS result_count
                    FROM storetw.fa_activity_metric
                   WHERE fk_char IS NOT NULL AND fk_station IS NOT NULL
                GROUP BY fk_char,
                         fk_station,
                         fk_org,
                         TO_CHAR (activity_start_date_time,'YYYY')) a,
               storetw.fa_station b,
               storetw.di_geo_state d,
               storetw.di_characteristic c
         WHERE a.fk_fa_statn = b.pk_isn(+) AND a.fk_char = c.pk_isn(+)  AND b.fk_gen_geo_state = d.pk_isn(+) ;
   l_met := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscy_fk_char ON station_char_year(fk_char) TABLESPACE storetindx PCTFREE 10 STORAGE ( INITIAL 4096K NEXT 4096K PCTINCREASE 0) NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
            l_comments || 'Create iscy_fk_char failed: ' || SQLCODE || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscy_fk_gen_geo_state ON station_char_year(fk_gen_geo_state) TABLESPACE storetindx PCTFREE 10 STORAGE ( INITIAL 4096K NEXT 4096K PCTINCREASE 0) NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscy_fk_gen_geo_state failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscy_fk_fa_statn ON station_char_year(fk_fa_statn) TABLESPACE storetindx PCTFREE 10 STORAGE ( INITIAL 4096K NEXT 4096K PCTINCREASE 0) NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscy_fk_fa_statn failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iscy_state_name ON station_char_year(state_name) TABLESPACE storetindx PCTFREE 10 STORAGE ( INITIAL 4096K NEXT 4096K PCTINCREASE 0) NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscy_state_name failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE BITMAP INDEX iscy_act_start_year_date ON station_char_year(act_start_year_date) TABLESPACE storetindx PCTFREE 10 STORAGE ( INITIAL 4096K NEXT 4096K PCTINCREASE 0) NOPARALLEL NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iscy_act_start_year_date failed: '
            || SQLCODE
            || '. ';
   END;



   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'station_char_year',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);


   UPDATE storetw.fa_station a
      SET a.station_visited = 'YES'
    WHERE EXISTS
             (SELECT 1
                FROM station_char_year b
               WHERE b.fk_fa_statn = a.pk_isn);

   l_sta := SQL%ROWCOUNT;

   COMMIT;

   p_record_no := l_reg + l_bio + l_hab;
   p_comments :=
         l_comments
      || 'RR: '
      || l_reg
      || '. BR: '
      || l_bio
      || '. HR: '
      || l_hab
      || '. ORGERR: '
      || l_org_err
      || '. ORG: '
      || l_org
      || '. CCT: '
      || l_cct
      || '. CCTNA: '
      || l_cct2
      || '. STA: '
      || l_sta
      || '.';




lv_message:='End of SP_REFRESH_STATION_CHAR_YEAR. '||to_char(sysdate,'dd-mon-yyyy hh24:mi')||
		p_record_no||chr(10)||p_comments;

STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'End of Warehouse(STORETW) SP_REFRESH_STATION_CHAR_YEAR Report. '||to_char(sysdate,'dd-mon-yyyy hh24:mi'), p_body =>
lv_message);


exception when others then

lv_message:=sqlerrm;
 --  /*
STORETW.dw_mail_pkg.send (p_sender_email => storetw.dw_glob_var.gv_storet_email, p_from => 'STORET@EPA.GOV',p_to =>
storetw.dw_mail_pkg.array(lv_email_address), p_subject => 'ERROR during Warehouse(STORETW) SP_REFRESH_STATION_CHAR_YEAR Report.', p_body =>
lv_message);
 -- */

--execute storetw.SP_REFRESH_STATION_CHAR_YEAR
--
END SP_REFRESH_STATION_CHAR_YEAR;
/

