
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_HUC_ORG_SUMMARY" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   l_res        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN

   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_huc_org_summary';


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ho_huc';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_ho_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_ho_huc_orgid';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Drop iws_ho_huc_orgid failed: '
            || SQLCODE
            || '. ';
   END;

   /*
   --grants
   BEGIN
      EXECUTE IMMEDIATE
         'GRANT SELECT ON storetw.ws_huc_org_summary TO storetweb';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */


   INSERT /*+ APPEND */
         INTO  ws_huc_org_summary (hydrologic_unit_code,
                                   organization_id,
                                   organization_name,
                                   min_activity_start_date_time,
                                   max_activity_stop_date_time,
                                   station_count,
                                   result_count,
                                   characteristic_count)
        SELECT /*+PARALLEL(ws_station_data 4)*/
               a.hydrologic_unit_code,
               NVL (a.organization_id, di_org.organization_id)
                  AS organization_id,
               a.organization_name,
               MIN (a.min_activity_start_date_time)
                  AS min_activity_start_date_time,
               MAX (a.max_activity_stop_date_time)
                  AS max_activity_stop_date_time,
               COUNT (DISTINCT a.unique_station_identifier) AS station_count,
               SUM (a.char_result_count) AS result_count,
               COUNT (DISTINCT a.characteristic_id) AS characteristic_count
          FROM ws_station_data a, di_org
         WHERE     a.hydrologic_unit_code IS NOT NULL
               AND a.organization_id = di_org.organization_id
      GROUP BY a.hydrologic_unit_code,
               NVL (a.organization_id, di_org.organization_id),
               a.organization_name;

   l_res := SQL%ROWCOUNT;

   COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ho_huc ON ws_huc_org_summary(TRIM(hydrologic_unit_code)) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ho_huc failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
         'CREATE INDEX iws_ho_huc_orgid ON ws_huc_org_summary(TRIM(hydrologic_unit_code),LOWER(TRIM(organization_id))) TABLESPACE storetindx NOLOGGING';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create iws_ho_huc_orgid failed: '
            || SQLCODE
            || '. ';
   END;


   DBMS_STATS.gather_table_stats (
      ownname            => 'STORETW',
      tabname            => 'WS_HUC_ORG_SUMMARY',
      cascade            => TRUE,
      estimate_percent   => DBMS_STATS.auto_sample_size);

   p_record_no := l_res;
   p_comments :=
         l_comments
      || 'INS: '
      || l_res
      || '.';

END;
/

