
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_ORG_ACT_PROJ" (
   p_limiter         NUMBER DEFAULT NULL,
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   --regular result cursor
   CURSOR regular_result_data_cur
   IS
        SELECT /*+PARALLEL(regular_result_project 4) PARALLEL(fa_regular_result 4) */
               DISTINCT fa_regular_result.organization_id,
                        fa_regular_result.activity_id,
                        fa_regular_result.activity_start_date_time,
                        di_project.project_cd
          FROM fa_regular_result, regular_result_project, di_project
         WHERE     fa_regular_result.pk_isn = regular_result_project.fk_result
               AND di_project.pk_isn = regular_result_project.fk_project
      GROUP BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd
      ORDER BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd;

   --biological result cursor
   CURSOR biological_result_data_cur
   IS
        SELECT /*+PARALLEL(biological_result_project 4) PARALLEL(fa_biological_result 4) */
               DISTINCT fa_biological_result.organization_id,
                        fa_biological_result.activity_id,
                        fa_biological_result.activity_start_date_time,
                        di_project.project_cd
          FROM fa_biological_result, biological_result_project, di_project
         WHERE     fa_biological_result.pk_isn =
                      biological_result_project.fk_result
               AND di_project.pk_isn = biological_result_project.fk_project
      GROUP BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd
      ORDER BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd;

   --habitat result cursor
   CURSOR habitat_result_data_cur
   IS
        SELECT /*+PARALLEL(habitat_result_project 4) PARALLEL(fa_habitat_result 4) */
               DISTINCT fa_habitat_result.organization_id,
                        fa_habitat_result.activity_id,
                        fa_habitat_result.activity_start_date_time,
                        di_project.project_cd
          FROM fa_habitat_result, habitat_result_project, di_project
         WHERE     fa_habitat_result.pk_isn = habitat_result_project.fk_result
               AND di_project.pk_isn = habitat_result_project.fk_project
      GROUP BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd
      ORDER BY organization_id,
               activity_id,
               activity_start_date_time,
               project_cd;

   /*
   v_organization_id       VARCHAR2 (256 BYTE);
   v_activity_id           VARCHAR2 (256 BYTE);
   v_activity_start_date   DATE;
   v_project_cd            VARCHAR2 (256 CHAR);
   v_insert_count          NUMBER (12);
   */

   TYPE tbl_reg_row     IS TABLE OF regular_result_data_cur%rowtype;
   TYPE tbl_hab_row     IS TABLE OF habitat_result_data_cur%rowtype;
   TYPE tbl_bio_row     IS TABLE OF biological_result_data_cur%rowtype;

   ary_reg      tbl_reg_row;
   ary_hab      tbl_hab_row;
   ary_bio      tbl_bio_row;

   num_limiter  NUMBER;

   l_reg        NUMBER := 0;
   l_hab        NUMBER := 0;
   l_bio        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN
   IF p_limiter IS NULL
   THEN
      num_limiter := 10000;
   ELSE
      num_limiter := p_limiter;
   END IF;

   EXECUTE IMMEDIATE 'TRUNCATE TABLE storetw.ws_org_activity_project';

   FOR c
      IN (SELECT index_name
            FROM all_indexes
           WHERE     owner = 'STORETW'
                 AND table_name = 'WS_ORG_ACTIVITY_PROJECT')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;

   /*
   BEGIN
      EXECUTE IMMEDIATE 'DROP INDEX iws_org_act_proj_fn_org_id';

      EXECUTE IMMEDIATE 'DROP INDEX iws_org_act_proj_org_act_date';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */

   --insert data into ws_org_activity_project, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert regualr data into ws_org_activity_project
   OPEN regular_result_data_cur;

   LOOP
      FETCH regular_result_data_cur
      BULK COLLECT INTO ary_reg
      LIMIT num_limiter;

      EXIT WHEN ary_reg.COUNT = 0;

      /*
      FETCH regular_result_data_cur
      INTO v_organization_id,
           v_activity_id,
           v_activity_start_date,
           v_project_cd;

      EXIT WHEN regular_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_reg.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity_project (organization_id,
                                               activity_id,
                                               activity_start_date,
                                               project_cd,
                                               result_type)
               VALUES (ary_reg(i).organization_id,
                       ary_reg(i).activity_id,
                       ary_reg(i).activity_start_date_time,
                       ary_reg(i).project_cd,
                       'R');

      l_reg := l_reg + ary_reg.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE regular_result_data_cur;

   --COMMIT;


   --insert data into ws_org_activity_project, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert biological data into ws_org_activity
   OPEN biological_result_data_cur;

   LOOP
      FETCH biological_result_data_cur
      BULK COLLECT INTO ary_bio
      LIMIT num_limiter;

      EXIT WHEN ary_bio.COUNT = 0;

      /*
      FETCH biological_result_data_cur
      INTO v_organization_id,
           v_activity_id,
           v_activity_start_date,
           v_project_cd;

      EXIT WHEN biological_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_bio.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity_project (organization_id,
                                               activity_id,
                                               activity_start_date,
                                               project_cd,
                                               result_type)
               VALUES (ary_bio(i).organization_id,
                       ary_bio(i).activity_id,
                       ary_bio(i).activity_start_date_time,
                       ary_bio(i).project_cd,
                       'B');

      l_bio := l_bio + ary_bio.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE biological_result_data_cur;

   --COMMIT;


   --insert data into ws_org_activity_project, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert habitat data in to ws_org_activity
   OPEN habitat_result_data_cur;

   LOOP
      FETCH habitat_result_data_cur
      BULK COLLECT INTO ary_hab
      LIMIT num_limiter;

      EXIT WHEN ary_hab.COUNT = 0;

      /*
      FETCH habitat_result_data_cur
      INTO v_organization_id,
           v_activity_id,
           v_activity_start_date,
           v_project_cd;

      EXIT WHEN habitat_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_hab.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity_project (organization_id,
                                               activity_id,
                                               activity_start_date,
                                               project_cd,
                                               result_type)
               VALUES (ary_hab(i).organization_id,
                       ary_hab(i).activity_id,
                       ary_hab(i).activity_start_date_time,
                       ary_hab(i).project_cd,
                       'H');

      l_hab := l_hab + ary_hab.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE habitat_result_data_cur;

   --COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
            'CREATE INDEX IWS_ORG_ACT_PROJ_FN_ORG_ID ON WS_ORG_ACTIVITY_PROJECT (LOWER(TRIM(ORGANIZATION_ID))) '
         || 'tablespace storetindx NOLOGGING';
         --|| 'storage (initial 5M next 5M)';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create IWS_ORG_ACT_PROJ_FN_ORG_ID failed: '
            || SQLCODE
            || '. ';
   END;

   BEGIN
      EXECUTE IMMEDIATE
            'CREATE INDEX IWS_ORG_ACT_PROJ_ORG_ACT_DATE ON WS_ORG_ACTIVITY_PROJECT (LOWER(TRIM(ORGANIZATION_ID)), ACTIVITY_ID, ACTIVITY_START_DATE)  '
         || 'tablespace storetindx NOLOGGING';
         --|| 'storage (initial 5M next 5M)';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create IWS_ORG_ACT_PROJ_ORG_ACT_DATE failed: '
            || SQLCODE
            || '. ';
   END;

   p_record_no := l_reg + l_hab + l_bio;
   p_comments :=
         l_comments
      || 'RR: '
      || l_reg || '. BR: '
      || l_bio || '. HR: '
      || l_hab || '.';

END;
/

