
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_REFRESH_WS_ORG_ACTIVITY" (
   p_limiter         NUMBER DEFAULT NULL,
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   --regular result cursor
   CURSOR regular_result_data_cur
   IS
        SELECT /*+PARALLEL(fa_regular_result 4)*/
               DISTINCT organization_id,
                        station_id,
                        activity_id,
                        activity_type,
                        activity_medium,
                        activity_start_date_time AS activity_start_date_time,
                        di_statn_types.primary_type AS station_type,
                        activity_matrix,
                        activity_depth,
                        activity_depth_unit,
                        activity_upper_depth,
                        upr_lwr_depth_unit,
                        activity_lower_depth,
                        activity_depth_ref_point,
                        activity_cond_org_text
          FROM    fa_regular_result
               LEFT JOIN
                  di_statn_types
               ON fa_regular_result.fk_statn_types = di_statn_types.pk_isn
      ORDER BY organization_id, station_id, activity_id;


   --biological result cursor
   CURSOR biological_result_data_cur
   IS
        SELECT /*+PARALLEL(fa_biological_result 4)*/
               DISTINCT Organization_id,
                        station_id,
                        activity_id,
                        Activity_Type,
                        Activity_Medium,
                        Activity_Start_Date_Time AS Activity_Start_Date_Time,
                        di_statn_types.primary_type AS station_type,
                        NULL AS activity_matrix,
                        activity_depth,
                        activity_depth_unit,
                        activity_upper_depth,
                        upr_lwr_depth_unit,
                        activity_lower_depth,
                        activity_depth_ref_point,
                        activity_cond_org_text
          FROM    fa_biological_result
               LEFT JOIN
                  di_statn_types
               ON fa_biological_result.fk_statn_types = di_statn_types.pk_isn
      ORDER BY organization_id, station_id, activity_id;

   --habitat result cursor
   CURSOR habitat_result_data_cur
   IS
        SELECT /*+PARALLEL(fa_habitat_result 4)*/
               DISTINCT Organization_id,
                        station_id,
                        activity_id,
                        Activity_Type,
                        NULL AS Activity_Medium,
                        Activity_Start_Date_Time AS Activity_Start_Date_Time,
                        di_statn_types.primary_type AS station_type,
                        NULL AS activity_matrix,
                        NULL AS activity_depth,
                        NULL AS activity_depth_unit,
                        NULL AS activity_upper_depth,
                        NULL AS upr_lwr_depth_unit,
                        NULL AS activity_lower_depth,
                        activity_depth_ref_point,
                        activity_cond_org_text
          FROM    fa_habitat_result
               LEFT JOIN
                  di_statn_types
               ON fa_habitat_result.fk_statn_types = di_statn_types.pk_isn
      ORDER BY organization_id, station_id, activity_id;


   /*
   v_organization_id            VARCHAR2 (256 BYTE);
   v_station_id                 VARCHAR2 (256 BYTE);
   v_station_type               VARCHAR2 (256 BYTE);
   v_activity_id                VARCHAR2 (256 BYTE);
   v_activity_type              VARCHAR2 (256 BYTE);
   v_activity_medium            VARCHAR2 (20 CHAR);
   v_activity_start_date        DATE;
   v_insert_count               NUMBER (12);
   v_activity_matrix            VARCHAR2 (256 BYTE);
   v_activity_depth             VARCHAR2 (256 BYTE);
   v_activity_depth_unit        VARCHAR2 (256 BYTE);
   v_activity_upper_depth       VARCHAR2 (256 BYTE);
   v_upr_lwr_depth_unit         VARCHAR2 (256 BYTE);
   v_activity_lower_depth       VARCHAR2 (256 BYTE);
   v_activity_depth_ref_point   VARCHAR2 (256 BYTE);
   v_activity_cond_org_text     VARCHAR2 (256 BYTE);
   */

   TYPE tbl_reg_row     IS TABLE OF regular_result_data_cur%rowtype;
   TYPE tbl_hab_row     IS TABLE OF habitat_result_data_cur%rowtype;
   TYPE tbl_bio_row     IS TABLE OF biological_result_data_cur%rowtype;

   ary_reg      tbl_reg_row;
   ary_hab      tbl_hab_row;
   ary_bio      tbl_bio_row;

   num_limiter  NUMBER;

   l_reg        NUMBER := 0;
   l_hab        NUMBER := 0;
   l_bio        NUMBER := 0;
   l_comments   VARCHAR2 (4000) := '';
BEGIN
   IF p_limiter IS NULL
   THEN
      num_limiter := 10000;
   ELSE
      num_limiter := p_limiter;
   END IF;

   -- truncate ws_org_activity
   EXECUTE IMMEDIATE 'truncate table ws_org_activity';

   -- drop indexes
   FOR c
      IN (SELECT index_name
            FROM all_indexes
           WHERE     owner = 'STORETW'
                 AND table_name = 'WS_ORG_ACTIVITY')
   LOOP
      BEGIN
         EXECUTE IMMEDIATE 'DROP INDEX ' || c.index_name;
      EXCEPTION
         WHEN OTHERS
         THEN
            l_comments :=
                  l_comments
               || 'Drop '
               || c.index_name
               || ' failed: '
               || SQLCODE
               || '. ';
      END;
   END LOOP;


   /*
   BEGIN
      EXECUTE IMMEDIATE 'drop index IWS_ORG_ACTIVITY_FN_ORG_ACT';

      EXECUTE IMMEDIATE 'drop index IWS_ORG_ACT_FN_ORG_STN_ACT';

      EXECUTE IMMEDIATE 'drop index IWS_ORG_ACT_FN_STN_ID2';
   EXCEPTION
      WHEN OTHERS
      THEN
         NULL;
   END;
   */

   --insert data into ws_org_activity, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert regualr data into ws_org_activity
   OPEN regular_result_data_cur;

   LOOP
      FETCH regular_result_data_cur
      BULK COLLECT INTO ary_reg
      LIMIT num_limiter;

      EXIT WHEN ary_reg.COUNT = 0;

      /*
      FETCH regular_result_data_cur
      INTO v_organization_id,
           v_station_id,
           v_activity_id,
           v_activity_type,
           v_activity_medium,
           v_activity_start_date,
           v_station_type,
           v_activity_matrix,
           v_activity_depth,
           v_activity_depth_unit,
           v_activity_upper_depth,
           v_upr_lwr_depth_unit,
           v_activity_lower_depth,
           v_activity_depth_ref_point,
           v_activity_cond_org_text;

      EXIT WHEN regular_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_reg.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity (organization_id,
                                       station_id,
                                       station_type,
                                       activity_id,
                                       activity_type,
                                       activity_medium,
                                       activity_start_date,
                                       Result_Type,
                                       activity_matrix,
                                       activity_depth,
                                       activity_depth_unit,
                                       activity_upper_depth,
                                       upr_lwr_depth_unit,
                                       activity_lower_depth,
                                       activity_depth_ref_point,
                                       activity_cond_org_text)
               VALUES (ary_reg(i).organization_id,
                       ary_reg(i).station_id,
                       ary_reg(i).station_type,
                       ary_reg(i).activity_id,
                       ary_reg(i).activity_type,
                       ary_reg(i).activity_medium,
                       ary_reg(i).activity_start_date_time,
                       'R',
                       ary_reg(i).activity_matrix,
                       ary_reg(i).activity_depth,
                       ary_reg(i).activity_depth_unit,
                       ary_reg(i).activity_upper_depth,
                       ary_reg(i).upr_lwr_depth_unit,
                       ary_reg(i).activity_lower_depth,
                       ary_reg(i).activity_depth_ref_point,
                       ary_reg(i).activity_cond_org_text);

      l_reg := l_reg + ary_reg.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE regular_result_data_cur;

   --COMMIT;


   --insert data into ws_org_activity, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert biological data into ws_org_activity
   OPEN biological_result_data_cur;

   LOOP
      FETCH biological_result_data_cur
      BULK COLLECT INTO ary_bio
      LIMIT num_limiter;

      EXIT WHEN ary_bio.COUNT = 0;

      /*
      FETCH biological_result_data_cur
      INTO v_organization_id,
           v_station_id,
           v_activity_id,
           v_activity_type,
           v_activity_medium,
           v_activity_start_date,
           v_station_type,
           v_activity_matrix,
           v_activity_depth,
           v_activity_depth_unit,
           v_activity_upper_depth,
           v_upr_lwr_depth_unit,
           v_activity_lower_depth,
           v_activity_depth_ref_point,
           v_activity_cond_org_text;

      EXIT WHEN biological_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_bio.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity (organization_id,
                                       station_id,
                                       station_type,
                                       activity_id,
                                       activity_type,
                                       activity_medium,
                                       activity_start_date,
                                       Result_Type,
                                       activity_matrix,
                                       activity_depth,
                                       activity_depth_unit,
                                       activity_upper_depth,
                                       upr_lwr_depth_unit,
                                       activity_lower_depth,
                                       activity_depth_ref_point,
                                       activity_cond_org_text)
               VALUES (ary_bio(i).organization_id,
                       ary_bio(i).station_id,
                       ary_bio(i).station_type,
                       ary_bio(i).activity_id,
                       ary_bio(i).activity_type,
                       ary_bio(i).activity_medium,
                       ary_bio(i).activity_start_date_time,
                       'B',
                       ary_bio(i).activity_matrix,
                       ary_bio(i).activity_depth,
                       ary_bio(i).activity_depth_unit,
                       ary_bio(i).activity_upper_depth,
                       ary_bio(i).upr_lwr_depth_unit,
                       ary_bio(i).activity_lower_depth,
                       ary_bio(i).activity_depth_ref_point,
                       ary_bio(i).activity_cond_org_text);

      l_bio := l_bio + ary_bio.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE biological_result_data_cur;

   --COMMIT;


   --insert data into ws_org_activity, while committing after every 1000 inserts
   --v_insert_count := 0;

   -- insert habitat data in to ws_org_activity
   OPEN habitat_result_data_cur;

   LOOP
      FETCH habitat_result_data_cur
      BULK COLLECT INTO ary_hab
      LIMIT num_limiter;

      EXIT WHEN ary_hab.COUNT = 0;

      /*
      FETCH habitat_result_data_cur
      INTO v_organization_id,
           v_station_id,
           v_activity_id,
           v_activity_type,
           v_activity_medium,
           v_activity_start_date,
           v_station_type,
           v_activity_matrix,
           v_activity_depth,
           v_activity_depth_unit,
           v_activity_upper_depth,
           v_upr_lwr_depth_unit,
           v_activity_lower_depth,
           v_activity_depth_ref_point,
           v_activity_cond_org_text;

      EXIT WHEN habitat_result_data_cur%NOTFOUND;
      */

      FORALL i IN 1 .. ary_hab.COUNT
          INSERT /*+ APPEND */
                INTO  ws_org_activity (organization_id,
                                       station_id,
                                       station_type,
                                       activity_id,
                                       activity_type,
                                       activity_medium,
                                       activity_start_date,
                                       Result_Type,
                                       activity_matrix,
                                       activity_depth,
                                       activity_depth_unit,
                                       activity_upper_depth,
                                       upr_lwr_depth_unit,
                                       activity_lower_depth,
                                       activity_depth_ref_point,
                                       activity_cond_org_text)
               VALUES (ary_hab(i).organization_id,
                       ary_hab(i).station_id,
                       ary_hab(i).station_type,
                       ary_hab(i).activity_id,
                       ary_hab(i).activity_type,
                       ary_hab(i).activity_medium,
                       ary_hab(i).activity_start_date_time,
                       'H',
                       ary_hab(i).activity_matrix,
                       ary_hab(i).activity_depth,
                       ary_hab(i).activity_depth_unit,
                       ary_hab(i).activity_upper_depth,
                       ary_hab(i).upr_lwr_depth_unit,
                       ary_hab(i).activity_lower_depth,
                       ary_hab(i).activity_depth_ref_point,
                       ary_hab(i).activity_cond_org_text);

      l_hab := l_hab + ary_hab.COUNT;

      /*
      v_insert_count := v_insert_count + 1;

      IF (v_insert_count = 1000)
      THEN
         v_insert_count := 0;
         COMMIT;
      END IF;
      */

      COMMIT;
   END LOOP;

   CLOSE habitat_result_data_cur;

   --COMMIT;


   BEGIN
      EXECUTE IMMEDIATE
            'CREATE INDEX IWS_ORG_ACTIVITY_FN_ORG_ACT ON WS_ORG_ACTIVITY (LOWER(TRIM(ORGANIZATION_ID)), ACTIVITY_ID) '
         || 'tablespace storetindx NOLOGGING';
         --|| 'storage (initial 5M next 5M)';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create IWS_ORG_ACTIVITY_FN_ORG_ACT failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
            'CREATE INDEX IWS_ORG_ACT_FN_ORG_STN_ACT ON WS_ORG_ACTIVITY (LOWER(TRIM(ORGANIZATION_ID)), LOWER(TRIM(STATION_ID)), ACTIVITY_ID) '
         || 'tablespace storetindx NOLOGGING';
         --|| 'storage (initial 5M next 5M)';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create IWS_ORG_ACT_FN_ORG_STN_ACT failed: '
            || SQLCODE
            || '. ';
   END;


   BEGIN
      EXECUTE IMMEDIATE
            'CREATE INDEX IWS_ORG_ACT_FN_STN_ID2 ON WS_ORG_ACTIVITY (LOWER(TRIM("STATION_ID"))) '
         || 'tablespace storetindx NOLOGGING';
         --|| 'storage (initial 5M next 5M)';
   EXCEPTION
      WHEN OTHERS
      THEN
         l_comments :=
               l_comments
            || 'Create IWS_ORG_ACT_FN_STN_ID2 failed: '
            || SQLCODE
            || '. ';
   END;

   p_record_no := l_reg + l_hab + l_bio;
   p_comments :=
         l_comments
      || 'RR: '
      || l_reg || '. BR: '
      || l_bio || '. HR: '
      || l_hab || '.';

END;
/

