
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_UPDATE_GEOMWGS84_LATLONG" (
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   --in_nbr             NUMBER;
   --status             VARCHAR2 (200);
   --lv_message         VARCHAR2 (4000) := NULL;
   --lv_email_address   VARCHAR2 (100);
   l_count              NUMBER := 0;
BEGIN
   /*
   lv_email_address := 'STORET@epa.gov';

   lv_message :=
         'Start of STORETW UPDATE GEOM Spatial Column WGS84 LATITUDE / LONGITUDE. '
      || TO_CHAR (SYSDATE, 'dd-mon-yyyy hh24:mi');

   storetw.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        => 'STORETW UPDATE GEOM Spatial Column WGS84 LATITUDE / LONGITUDE PROCEDURES',
      p_body           => lv_message);
   */

   --in_nbr := NULL;

   --status:='sucessful';

   -- Oracle srid for datum that need to be converted.
   --WGS72      8306
   --WGS84      8307
   --NAD83      8265
   --NAD27      8260
   --NAD27 US - Alaska   8254
   --NAD27 cANADA   8256
   --NAD27 MEXICO   8263
   --Puerto Rico ???

   UPDATE storetw.fa_station c
      SET c.geom =
             MDSYS.SDO_GEOMETRY (
                2001,
                8307,
                SDO_POINT_TYPE (c.wgs84_longitude, c.wgs84_latitude, NULL),
                NULL,
                NULL)
    WHERE    (    c.geom IS NULL
              AND c.wgs84_longitude IS NOT NULL
              AND c.wgs84_latitude IS NOT NULL)
          OR (    c.geom IS NOT NULL
              AND c.geom.sdo_point IS NOT NULL
              AND (   c.wgs84_longitude != c.geom.sdo_point.x
                   OR c.wgs84_latitude != c.geom.sdo_point.y));

   --status := 'successfull';

   l_count := sql%rowcount;

   COMMIT;

   /*
   lv_message :=
         'End of STORETW UPDATE GEOM Spatial Column WGS84 LATITUDE / LONGITUDE.  Status='
      || status
      || '.
'
      || TO_CHAR (SYSDATE, 'dd-mon-yyyy hh24:mi');

   storetw.dw_mail_pkg.send (
      p_sender_email   => storetw.dw_glob_var.gv_storet_email,
      p_from           => 'STORET@EPA.GOV',
      p_to             => storetw.dw_mail_pkg.array (lv_email_address),
      p_subject        => 'STORETW UPDATE GEOM Spatial Column WGS84 LATITUDE / LONGITUDE PROCEDURES',
      p_body           => lv_message);
   */

   p_record_no := l_count;
   p_comments := 'UPD: '
        || l_count || '.';

END;
/

