
  CREATE OR REPLACE PROCEDURE "STORETW"."SP_UPDATE_RESULT_TABLES_HUC" (
   p_load_date       DATE,
   p_limiter         NUMBER DEFAULT NULL,
   p_record_no   OUT NUMBER,
   p_comments    OUT VARCHAR2)
AS
   my_cursor      SYS_REFCURSOR;
   str_sql        VARCHAR2 (4000);
   str_sql2       VARCHAR2 (4000);
   num_records    NUMBER;
   num_limiter    NUMBER;

   TYPE tbl_rids  IS TABLE OF ROWID;
   TYPE tbl_fks   IS TABLE OF NUMBER(12);
   TYPE tbl_hucs  IS TABLE OF VARCHAR2(256);

   ary_rids       tbl_rids;
   ary_fks        tbl_fks;
   ary_hucs       tbl_hucs;

   l_hc_act_res   NUMBER := 0;
   l_hc_reg_res   NUMBER := 0;
   l_hc_bio_res   NUMBER := 0;
   l_hc_hab_res   NUMBER := 0;
BEGIN
   IF p_limiter IS NULL
   THEN
      num_limiter := 10000;
   ELSE
      num_limiter := p_limiter;
   END IF;

   str_sql :=
         'SELECT /*+PARALLEL(b 4) */ '
      || 'b.rowid, '
      || 'a.fk_gen_db_cat, '
      || 'a.generated_huc '
      || 'FROM '
      || 'storetw.fa_station a '
      || 'JOIN '
      || 'storetw.fa_activity_metric b '
      || 'ON '
      || 'a.pk_isn = b.fk_station AND '
      || 'a.last_change_date >= :p01 '
      || 'WHERE '
      || 'nvl(a.fk_gen_db_cat,-1) != nvl(b.fk_gen_db_cat,-1) '
      || 'order by 1, 2';

   OPEN my_cursor FOR str_sql USING p_load_date;

   LOOP
      FETCH my_cursor
      BULK COLLECT INTO ary_rids, ary_fks, ary_hucs
      LIMIT num_limiter;

      EXIT WHEN ary_rids.COUNT = 0;

      FORALL i IN 1 .. ary_rids.COUNT
         UPDATE storetw.fa_activity_metric a
            SET a.fk_gen_db_cat = ary_fks(i),
                a.generated_huc = ary_hucs(i)
          WHERE a.rowid = ary_rids(i);

      l_hc_act_res := l_hc_act_res + ary_rids.COUNT;

      COMMIT;
   END LOOP;

   CLOSE my_cursor;


   str_sql :=
         'SELECT /*+PARALLEL(b 4) */ '
      || 'b.rowid, '
      || 'a.fk_gen_db_cat, '
      || 'a.generated_huc '
      || 'FROM '
      || 'storetw.fa_station a '
      || 'JOIN '
      || 'storetw.fa_biological_result b '
      || 'ON '
      || 'a.pk_isn = b.fk_station AND '
      || 'a.last_change_date >= :p01 '
      || 'WHERE '
      || 'nvl(a.fk_gen_db_cat,-1) != nvl(b.fk_gen_db_cat,-1) '
      || 'order by 1, 2';

   OPEN my_cursor FOR str_sql USING p_load_date;

   LOOP
      FETCH my_cursor
      BULK COLLECT INTO ary_rids, ary_fks, ary_hucs
      LIMIT num_limiter;

      EXIT WHEN ary_rids.COUNT = 0;

      FORALL i IN 1 .. ary_rids.COUNT
         UPDATE storetw.fa_biological_result a
            SET a.fk_gen_db_cat = ary_fks(i),
                a.generated_huc = ary_hucs(i)
          WHERE a.rowid = ary_rids(i);

      l_hc_bio_res := l_hc_bio_res + ary_rids.COUNT;

      COMMIT;
   END LOOP;

   CLOSE my_cursor;


   str_sql :=
         'SELECT /*+PARALLEL(b 4) */ '
      || 'b.rowid, '
      || 'a.fk_gen_db_cat, '
      || 'a.generated_huc '
      || 'FROM '
      || 'storetw.fa_station a '
      || 'JOIN '
      || 'storetw.fa_habitat_result b '
      || 'ON '
      || 'a.pk_isn = b.fk_station AND '
      || 'a.last_change_date >= :p01 '
      || 'WHERE '
      || 'nvl(a.fk_gen_db_cat,-1) != nvl(b.fk_gen_db_cat,-1) '
      || 'order by 1, 2';

   OPEN my_cursor FOR str_sql USING p_load_date;

   LOOP
      FETCH my_cursor
      BULK COLLECT INTO ary_rids, ary_fks, ary_hucs
      LIMIT num_limiter;

      EXIT WHEN ary_rids.COUNT = 0;

      FORALL i IN 1 .. ary_rids.COUNT
         UPDATE storetw.fa_habitat_result a
            SET a.fk_gen_db_cat = ary_fks(i),
                a.generated_huc = ary_hucs(i)
          WHERE a.rowid = ary_rids(i);

      l_hc_hab_res := l_hc_hab_res + ary_rids.COUNT;

      COMMIT;
   END LOOP;

   CLOSE my_cursor;


   str_sql :=
         'SELECT /*+PARALLEL(b 4) */ '
      || 'b.rowid, '
      || 'a.fk_gen_db_cat, '
      || 'a.generated_huc '
      || 'FROM '
      || 'storetw.fa_station a '
      || 'JOIN '
      || 'storetw.fa_regular_result b '
      || 'ON '
      || 'a.pk_isn = b.fk_station AND '
      || 'a.last_change_date >= :p01 '
      || 'WHERE '
      || 'nvl(a.fk_gen_db_cat,-1) != nvl(b.fk_gen_db_cat,-1) '
      || 'order by 1, 2';

   OPEN my_cursor FOR str_sql USING p_load_date;

   LOOP
      FETCH my_cursor
      BULK COLLECT INTO ary_rids, ary_fks, ary_hucs
      LIMIT num_limiter;

      EXIT WHEN ary_rids.COUNT = 0;

      FORALL i IN 1 .. ary_rids.COUNT
         UPDATE storetw.fa_regular_result a
            SET a.fk_gen_db_cat = ary_fks(i),
                a.generated_huc = ary_hucs(i)
          WHERE a.rowid = ary_rids(i);

      l_hc_reg_res := l_hc_reg_res + ary_rids.COUNT;

      COMMIT;
   END LOOP;

   CLOSE my_cursor;


   p_record_no := l_hc_act_res + l_hc_reg_res + l_hc_bio_res + l_hc_hab_res;
   p_comments := 'HCAC: '
        || l_hc_act_res || '. HCRR: '
        || l_hc_reg_res || '. HCBR: '
        || l_hc_bio_res || '. HCHR: '
        || l_hc_hab_res || '.';

END sp_update_result_tables_huc;
/

