
  CREATE TABLE "STORETW"."WS_HUC_ORG_SUMMARY"
   (	"HYDROLOGIC_UNIT_CODE" VARCHAR2(12 CHAR) NOT NULL ENABLE,
	"ORGANIZATION_ID" VARCHAR2(256) NOT NULL ENABLE,
	"ORGANIZATION_NAME" VARCHAR2(256),
	"MIN_ACTIVITY_START_DATE_TIME" DATE,
	"MAX_ACTIVITY_STOP_DATE_TIME" DATE,
	"STATION_COUNT" NUMBER(12,0),
	"RESULT_COUNT" NUMBER(12,0),
	"CHARACTERISTIC_COUNT" NUMBER(12,0)
   ) ;
  ALTER TABLE "STORETW"."WS_HUC_ORG_SUMMARY" ADD CONSTRAINT "PK_WS_HUC_ORG_SUMMARY" PRIMARY KEY ("ORGANIZATION_ID", "HYDROLOGIC_UNIT_CODE") ENABLE;


  CREATE UNIQUE INDEX "STORETW"."PK_WS_HUC_ORG_SUMMARY" ON "STORETW"."WS_HUC_ORG_SUMMARY" ("ORGANIZATION_ID", "HYDROLOGIC_UNIT_CODE")
  ;


  CREATE INDEX "STORETW"."IWS_HO_HUC" ON "STORETW"."WS_HUC_ORG_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"))
  ;


  CREATE INDEX "STORETW"."IWS_HO_HUC_ORGID" ON "STORETW"."WS_HUC_ORG_SUMMARY" (TRIM("HYDROLOGIC_UNIT_CODE"), LOWER(TRIM("ORGANIZATION_ID")))
  ;

