
  CREATE TABLE "STORETW"."WS_ORG_ACTIVITY"
   (	"ORGANIZATION_ID" VARCHAR2(256),
	"ACTIVITY_ID" VARCHAR2(256),
	"ACTIVITY_TYPE" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"STATION_TYPE" VARCHAR2(256),
	"ACTIVITY_MEDIUM" VARCHAR2(20 CHAR),
	"ACTIVITY_START_DATE" DATE,
	"RESULT_TYPE" CHAR(1 CHAR),
	"ACTIVITY_MATRIX" VARCHAR2(256 CHAR),
	"ACTIVITY_DEPTH" VARCHAR2(256 CHAR),
	"ACTIVITY_DEPTH_UNIT" VARCHAR2(256 CHAR),
	"ACTIVITY_UPPER_DEPTH" VARCHAR2(256 CHAR),
	"UPR_LWR_DEPTH_UNIT" VARCHAR2(256 CHAR),
	"ACTIVITY_LOWER_DEPTH" VARCHAR2(256 CHAR),
	"ACTIVITY_DEPTH_REF_POINT" VARCHAR2(256 CHAR),
	"ACTIVITY_COND_ORG_TEXT" VARCHAR2(256 CHAR)
   ) ;


  CREATE INDEX "STORETW"."IWS_ORG_ACTIVITY_FN_ORG_ACT" ON "STORETW"."WS_ORG_ACTIVITY" (LOWER(TRIM("ORGANIZATION_ID")), "ACTIVITY_ID")
  ;


  CREATE INDEX "STORETW"."IWS_ORG_ACT_FN_STN_ID2" ON "STORETW"."WS_ORG_ACTIVITY" (LOWER(TRIM("STATION_ID")))
  ;


  CREATE INDEX "STORETW"."IWS_ORG_ACT_FN_ORG_STN_ACT" ON "STORETW"."WS_ORG_ACTIVITY" (LOWER(TRIM("ORGANIZATION_ID")), LOWER(TRIM("STATION_ID")), "ACTIVITY_ID")
  ;

