
  CREATE TABLE "STORETW"."WS_PROJECT_STATION_CHAR"
   (	"FK_PROJECT" NUMBER(12,0),
	"FK_CHAR" NUMBER(12,0),
	"HYDROLOGIC_UNIT_CODE" VARCHAR2(256 CHAR),
	"PROJECT_CD" VARCHAR2(256 CHAR),
	"ORGANIZATION_ID" VARCHAR2(256 CHAR),
	"ORGANIZATION_NAME" VARCHAR2(256),
	"STATION_ID" VARCHAR2(256),
	"STATION_NAME" VARCHAR2(256),
	"STN_STD_LATITUDE" NUMBER,
	"STN_STD_LONGITUDE" NUMBER,
	"ACT_MIN_START_DATE" DATE,
	"ACT_MAX_START_STOP_DATE" DATE,
	"CHARACTERISTIC_NAME" VARCHAR2(256 CHAR),
	"CHARTYPE" VARCHAR2(256 CHAR),
	"FK_STATION" NUMBER,
	"FK_ORG" NUMBER,
	"RESULT_COUNT" NUMBER
   ) ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_ORGID_STNID" ON "STORETW"."WS_PROJECT_STATION_CHAR" (LOWER(TRIM("ORGANIZATION_ID")), LOWER(TRIM("STATION_ID")))
  ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_CHARTYPE" ON "STORETW"."WS_PROJECT_STATION_CHAR" ("ORGANIZATION_ID", "PROJECT_CD", "CHARTYPE")
  ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_HUC" ON "STORETW"."WS_PROJECT_STATION_CHAR" (LOWER(TRIM("HYDROLOGIC_UNIT_CODE")))
  ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_FK_PROJ" ON "STORETW"."WS_PROJECT_STATION_CHAR" ("FK_PROJECT")
  ;


  CREATE INDEX "STORETW"."IWSPS_LAT_LONG_PROJ" ON "STORETW"."WS_PROJECT_STATION_CHAR" ("STN_STD_LATITUDE", "STN_STD_LONGITUDE", "FK_PROJECT")
  ;


  CREATE INDEX "STORETW"."IWSPS_LONGITUDE" ON "STORETW"."WS_PROJECT_STATION_CHAR" ("STN_STD_LONGITUDE")
  ;


  CREATE INDEX "STORETW"."IWSPS_LATITUDE" ON "STORETW"."WS_PROJECT_STATION_CHAR" ("STN_STD_LATITUDE")
  ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_ORGID_PROJCD" ON "STORETW"."WS_PROJECT_STATION_CHAR" (LOWER(TRIM("ORGANIZATION_ID")), LOWER(TRIM("PROJECT_CD")))
  ;


  CREATE BITMAP INDEX "STORETW"."IWSPS_ORGID" ON "STORETW"."WS_PROJECT_STATION_CHAR" (LOWER(TRIM("ORGANIZATION_ID")))
  ;

