
  CREATE OR REPLACE FORCE VIEW "STORETW"."STORET_STATION_NV_VW" ("PkISNIdentifier", "OrganizationIdentifier", "OrganizationFormalName", "StationIdentifier", "StationName", "PrimaryTypeName", "SecondaryTypeName", "WellNumber", "PipeNumber", "LocationPointTypeName", "PointSequenceNumber", "LatitudeMeasure", "LongitudeMeasure", "HorizontalReferenceDatumCode", "HorizontalReferenceDatumName", "HorizontalCollectionMethodText", "SourceMapScaleNumber", "VerticalMeasure", "VerticalReferenceDatumCode", "VerticalReferenceDatumName", "VerticalCollectionMethodText", "CountryName", "StateName", "CountyName", "HydrologicUnitCode", "HydrologicUnitName", "RF1SegmentCode", "RF1SegmentName", "RF1MileageMeasure", "OnReachIndicator", "NRCSWatershedIdentifier", "PrimaryEstuaryName", "SecondaryEstuaryName", "OtherEstuaryName", "GreatLakeName", "OceanName", "NativeAmericanLandName", "FRSKeyIdentifier", "StationSGOIndicator") AS
  SELECT sd.PK_ISN "PkISNIdentifier",
--	DATABASE_REFRESH_DATE "DatabaseRefreshDate",
	sd.ORGANIZATION_ID "OrganizationIdentifier",
	org.ORGANIZATION_NAME "OrganizationFormalName",
	sd.STATION_ID "StationIdentifier",
	sd.STATION_NAME "StationName",
	st.PRIMARY_TYPE "PrimaryTypeName",
     	st.SECONDARY_TYPE "SecondaryTypeName",
	sd.WELL_NUMBER "WellNumber",
	sd.PIPE_NUMBER "PipeNumber",
	sd.LOCATION_POINT_TYPE "LocationPointTypeName",
	sd.POINT_SEQUENCE_NUMBER "PointSequenceNumber",
	sd.STD_LATITUDE "LatitudeMeasure",
	sd.STD_LONGITUDE "LongitudeMeasure",
	hd.ID_CODE "HorizontalReferenceDatumCode",
	hd.HORIZONTAL_DATUM "HorizontalReferenceDatumName",
	hm.GEOPOSITIONING_METHOD "HorizontalCollectionMethodText",
	sd.MAP_SCALE "SourceMapScaleNumber",
	sd.ELEVATION "VerticalMeasure",
	vd.ID_CODE "VerticalReferenceDatumCode",
	vd.ELEVATION_DATUM "VerticalReferenceDatumName",
	vm.ELEVATION_METHOD "VerticalCollectionMethodText",
	gs.COUNTRY_NAME "CountryName",
	gs.STATE_NAME "StateName",
	gc.COUNTY_NAME "CountyName",
	sd.HYDROLOGIC_UNIT_CODE "HydrologicUnitCode",
	ca.HYDROLOGIC_UNIT_NAME "HydrologicUnitName",
	sd.RF1_SEGMENT_CODE "RF1SegmentCode",
	sd.RF1_SEGMENT_NAME "RF1SegmentName",
	sd.RF1_MILEAGE "RF1MileageMeasure",
	sd.ON_REACH_IND "OnReachIndicator",
	sd.NRCS_WATERSHED_ID "NRCSWatershedIdentifier",
	ep.PRIMARY_ESTUARY "PrimaryEstuaryName",
	es.SECONDARY_ESTUARY "SecondaryEstuaryName",
	sd.OTHER_ESTUARY_NAME "OtherEstuaryName",
	sd.GREAT_LAKE_NAME "GreatLakeName",
	sd.OCEAN_NAME "OceanName",
	sd.NATV_AMERICAN_LAND_NAME "NativeAmericanLandName",
	sd.FRS_KEY_IDENTIFIER "FRSKeyIdentifier",
	sd.SGO_INDICATOR "StationSGOIndicator"
FROM 	storetw.FA_STATION sd,
	storetw.DI_ORG org,
	storetw.DI_STATN_TYPES st,
	storetw.LU_MAD_HDATUM hd,
	storetw.LU_MAD_HMETHOD hm,
	storetw.LU_MAD_VDATUM vd,
	storetw.LU_MAD_VMETHOD vm,
	storetw.DI_GEO_STATE gs,
	storetw.DI_GEO_COUNTY gc,
	storetw.DI_DB_CAT ca,
	storetw.LU_ESTRY_PRIMARY ep,
	storetw.LU_ESTRY_SECONDARY es
WHERE
	sd.FK_ORG = org.PK_ISN (+) AND
	FK_STATN_TYPES = st.PK_ISN (+)AND
	FK_STD_HDATUM = hd.PK_ISN (+) AND
	FK_MAD_HMETHOD = hm.PK_ISN (+) AND
	sd.FK_MAD_VDATUM = vd.PK_ISN (+) AND
	sd.FK_MAD_VMETHOD = vm.PK_ISN (+) AND
	sd.FK_GEO_STATE = gs.PK_ISN (+) AND
	sd.FK_GEO_COUNTY = gc.PK_ISN(+) AND
	sd.FK_DB_CAT = ca.PK_ISN (+) AND
	sd.FK_ESTRY_PRIMARY = ep.PK_ISN (+) AND
   	sd.FK_ESTRY_SECONDARY = es.PK_ISN (+) AND
	sd.LOCATION_POINT_TYPE = '*POINT OF RECORD' AND
	sd.STATION_VISITED IS NULL
 ;

