/*******************************************************
Filename		:  	FA_BIO_RESULT_tab.sql
Release 		:  	c2.0, C2.0.1, C2.0.4
SIR			:  	1495,1558, 1647
Description		:  	Creates the FA_BIOLOGICAL_RESULT table.
Author			:  	Joseph Wilson/Christine Tsang
Date			:  	7/7/2003
                        	8/25/2003 - SIR 1495 TIR#2- Changed datatype of bio_group_count_type. -C Tsang
                        	8/26/2003 - SIR 1495 TIR#6- added temporary column, species_number.
				10/08/2003 - Added Result BLOB_ID and BLOB_TITLE -JW
				10/29/2003 - Added Activity BLOB_ID and BLOB_TITLE -wn
				01/16/2004 - SIR 1586 Moved connect string to master install script -JW
				01/21/2004 - Added tsmalp_is_number and fk_stn_act_pt -JW
	  			06/10/2004 - added new columns for Standard datum - GT
				07/19/2004 - added organization_is_number -JW
				08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
		06/07/2005 - sir1706. Add generated_huc. -GT
Comments		:  	Based on fa_regular_result_tab.sql
09/27/2004 - Added fk_statn_types foreign key column. -GT
12/02/2004 - SIR1647 Added pctfree and pctused according to SIR. -GT
12/20/2006 - Added two new columns ACTIVITY_COMMENT,ACTIVITY_DEPTH_REF_POINT-sug
**********************************************************/
spool FA_BIO_RESULT_table.log

drop table FA_BIOLOGICAL_RESULT;

CREATE TABLE FA_BIOLOGICAL_RESULT (
pk_isn 					      		number not null,
ORGANIZATION_ID 				            	CHAR(8),
ORGANIZATION_IS_NUMBER					NUMBER(8),
STATION_ID                      			      CHAR(15),
STATION_NAME                                     	VARCHAR2(60),
STN_LATITUDE                                       	NUMBER,
STN_LONGITUDE                                      	NUMBER,
STN_HDATUM						CHAR(12),
STN_STD_LATITUDE					NUMBER,
STN_STD_LONGITUDE					NUMBER,
STN_STD_HDATUM						CHAR(12),
HYDROLOGIC_UNIT_CODE                               	CHAR(8),
GENERATED_HUC                               	CHAR(8),
SGO_INDICATOR						CHAR(1), -- 07/14/2003
STATION_VISIT_ID                                   	CHAR(3),
VISIT_START_DATE_TIME						DATE,
--VISIT_START_TIME							DATE,
VISIT_START_TIME_ZONE						CHAR(3),
VISIT_STOP_DATE_TIME						DATE,
--VISIT_STOP_TIME							DATE,
VISIT_STOP_TIME_ZONE						CHAR(3),
TRIP_ID                                            	CHAR(15),
TRIP_NAME						            VARCHAR2(60),
--start of ACT elements
ACTIVITY_ID                  	                   	CHAR(12),
ACTIVITY_START_DATE_TIME                             	DATE,
--ACTIVITY_START_TIME                                	DATE,
ACT_START_TIME_ZONE                                	CHAR(3),
ACTIVITY_STOP_DATE_TIME                               DATE,
--ACTIVITY_STOP_TIME                                 	DATE,
ACT_STOP_TIME_ZONE                                 	CHAR(3),
ACTIVITY_MEDIUM							VARCHAR2(20),
--activity_matrix							VARCHAR2(25),
ACTIVITY_TYPE                                      	CHAR(13),
ACTIVITY_CATEGORY                                  	VARCHAR2(30),
REPLICATE_NUMBER                	           		NUMBER(3),
ACTIVITY_INTENT                                    	VARCHAR2(20),
ACTIVITY_COMMUNITY                                 	VARCHAR2(30),
ACTIVITY_SUBJECT_TAXON                             	VARCHAR2(69),
BIOPART_NAME                                       	VARCHAR2(30),
FIELD_SET								VARCHAR2(130),
LOCATION_POINT_TYPE                                	CHAR(16),
POINT_SEQUENCE_NUMBER                              	NUMBER,
POINT_NAME								VARCHAR2(30),
ACTIVITY_LATITUDE                                  	NUMBER,
ACTIVITY_LONGITUDE                                 	NUMBER,
ACT_STD_LATITUDE					NUMBER,
ACT_STD_LONGITUDE					NUMBER,
ACT_STD_HDATUM					CHAR(12),
WELL_NUMBER                                        	CHAR(15),
PIPE_NUMBER                                        	CHAR(15),
MAP_SCALE								VARCHAR2(20),
ACTIVITY_DEPTH                                     	CHAR(8),
ACTIVITY_DEPTH_UNIT                                	CHAR(3),
ACTIVITY_UPPER_DEPTH                               	CHAR(8),
ACTIVITY_REL_DEPTH                                 	CHAR(15),
ACTIVITY_LOWER_DEPTH                               	CHAR(8),
UPR_LWR_DEPTH_UNIT                                 	CHAR(3),
FIELD_PROCEDURE_ID                                 	CHAR(10),
--FIELD_PROCEDURE_NAME                               	VARCHAR2(60),
FIELD_GEAR_ID							CHAR(10),
GEAR_CONFIG_ID                                     	CHAR(10),
--GEAR_CONFIG_NAME                                   	VARCHAR2(30),
--SAMPLE_PRES_ID							CHAR(10),
CHARACTERISTIC_NAME                                	VARCHAR2(91),  -- 07/18/03
SPECIES_NUMBER                                        CHAR(8),
CAS_NUMBER                                            VARCHAR2(500),
EPA_REG_NUMBER						      VARCHAR2(500),
ITIS_NUMBER						            VARCHAR2(500),
SAMPLE_FRACTION_TYPE                               	VARCHAR2(15),
RESULT_VALUE_TYPE                                  	CHAR(10),
STATISTIC_TYPE                                     	CHAR(18),
RESULT_VALUE_TEXT                                  	CHAR(15),
RESULT_VALUE                                       	NUMBER,
RESULT_UNIT                                        	CHAR(10),
STD_VALUE                                       	NUMBER,
STD_UNIT                                        	VARCHAR2(240),
RESULT_COMMENT							VARCHAR2(4000),
TEXT_RESULT								VARCHAR2(4000),
WEIGHT_BASIS_TYPE                                  	CHAR(12),
TEMPERATURE_BASIS_LEVEL                            	CHAR(8),
DURATION_BASIS                                     	CHAR(10),
PARTICLE_SIZE                                      	VARCHAR2(40),
DISTANCE_MEASURE_FROM                              	VARCHAR2(20),
DISTANCE_MEASURE_TO                                	VARCHAR2(20),
ANALYTICAL_PROCEDURE_SOURCE                        	CHAR(12),
ANALYTICAL_PROCEDURE_ID                            	CHAR(15),
--ANALYTICAL_PROCEDURE_NAME                          	VARCHAR2(120),
DETECTION_LIMIT                                    	VARCHAR2(25),
DETECTION_LIMIT_DESCRIPTION                        	VARCHAR2(254),
LOWER_QUANTITATION_LIMIT                           	CHAR(12),
UPPER_QUANTITATION_LIMIT                           	CHAR(12),
LAB_REMARK                                         	VARCHAR2(40),  
DILUTION_INDICATOR                                 	CHAR(1),
RECOVERY_INDICATOR                                 	CHAR(1),
CORRECTION_INDICATOR                               	CHAR(1),
LAB_ID                                             	CHAR(8),
LAB_NAME                                           	VARCHAR2(60),
LAB_CERTIFIED                                      	CHAR(1),
LAB_BATCH_ID                                    	CHAR(12),
ANALYSIS_DATE_TIME                                   	DATE,
--ANALYSIS_TIME                                      	DATE,
ANALYSIS_TIME_ZONE                                 	CHAR(3),
REPLICATE_ANALYSIS_COUNT                           	NUMBER,
PRECISION                                          	CHAR(12),
BIAS									CHAR(12),
CONFIDENCE_LEVEL                                   	CHAR(8),
CONF_LVL_CORR_BIAS						CHAR(1),
TR_START_POINT_NAME                                   VARCHAR2(30),
TR_START_LATITUDE                                     NUMBER,
TR_START_LONGITUDE                                    NUMBER,
TR_START_HDATUM					      CHAR(12),
TR_START_DEPTH                                        CHAR(15),
TR_START_STD_LATITUDE                                     NUMBER,
TR_START_STD_LONGITUDE                                    NUMBER,
TR_START_STD_HDATUM					      CHAR(12),
TR_STOP_POINT_NAME                                    VARCHAR2(30),
TR_STOP_LATITUDE                                      NUMBER,
TR_STOP_LONGITUDE                                     NUMBER,
TR_STOP_HDATUM					      CHAR(12),
TR_STOP_DEPTH                                         CHAR(15),
TR_STOP_STD_LATITUDE                                      NUMBER,
TR_STOP_STD_LONGITUDE                                     NUMBER,
TR_STOP_STD_HDATUM				      CHAR(12),
FISHED_DURATION                                       CHAR(15),
BOAT_SPEED                                            CHAR(15),
FISHED_DISTANCE                                       CHAR(10),
REL_CURRENT_DIR                                       NUMBER(3),
REL_WIND_DIR                                          NUMBER(3),
TRAWL_COMMENT                                         VARCHAR2(254),
VOLTAGE_MEASURE                                       NUMBER(6,3),
CURRENT_TYPE_CODE                                     CHAR(2),
AMPERAGE_MEASURE                                      NUMBER(6,3),
PASS_COUNT                                            NUMBER(2),
PASS_LENGTH                                           CHAR(10),
PULSE_RATE                                            NUMBER(3),
ELECTROSHOCK_COMMENT                                  VARCHAR2(254),
TOTAL_ENERGZD_TIME                                    CHAR(15),
SAMPLING_DURATION                                     CHAR(15),
ORIENTATION_TO_CURRENT                                CHAR(15),
TRAP_NET_COMMENT                                      VARCHAR2(254),
BIO_GROUP_ID                                       	CHAR(8),
BIO_GROUP_TYPE                                     	VARCHAR2(32),
BIO_GROUP_SUBJECT_TXN                              	VARCHAR2(69),
BIO_GROUP_DESCRIPTION                                 VARCHAR2(1999),
FEEDING_GROUP                                      	CHAR(6),
POLLUTION_TOLERANCE                                	CHAR(4),
TROPHIC_LEVEL                                      	CHAR(4),
HABIT                                                 VARCHAR2(40),
VOLTINISM                                             VARCHAR2(40),
CELL_SHAPE                                         	VARCHAR2(18),
CELL_FORM                                          	VARCHAR2(11),
NUMBER_IN_GROUP                                    	NUMBER,
BIO_GROUP_COUNT_TYPE                               	CHAR(10),
PHYS_BIO_INDICATOR                                 	CHAR(1),
GROUP_DESC_SEX                               	      CHAR(15),
GROUP_DESC_LIFESTAGE                         	      VARCHAR2(25),
COMMON_CLASS_DESC                                  	VARCHAR2(62),
PRIMARY_CLASS_DESC                              	CHAR(12),
SECONDARY_CLASS_DESC                             	CHAR(12),
LOWER_BOUND_AMOUNT                                 	NUMBER,
UPPER_BOUND_AMOUNT                                 	NUMBER,
BIO_RCI_UNITS                                      	CHAR(10),
INDIVIDUAL_NUMBER                                  	NUMBER,
--SAMPLE_PREP_SOURCE                                 	CHAR(12),
--SAMPLE_PREP_NAME                                   	VARCHAR2(120),
RESULT_VALUE_STATUS                                	CHAR(1),
--FK_ACTIVITY                                        	NUMBER(12),
ACTIVITY_IS_NUMBER 						NUMBER(12),  --RSULT.TSRFDACT_IS_NUMBER
RESULT_IS_NUMBER                                   	NUMBER(12),
activity_isn 							number,
FK_ORG                                             	NUMBER(12),
FK_STATION                                         	NUMBER(12),
FK_CHAR								NUMBER(12),  --RSULT.TSRCHAR_IS_NUMBER
FK_DB_CAT                                          	NUMBER(12),
FK_GEN_DB_CAT                                          	NUMBER(12),
FK_GEO_COUNTY                                      	NUMBER(12),
FK_GEO_STATE                                       	NUMBER(12),
--FK_MAD_HDATUM                                      	NUMBER(12),
--FK_MAD_HMETHOD                                     	NUMBER(12),
fk_act_mad_hdatum                          		number(12),
fk_act_mad_hmethod                         		number(12),
FK_DATE_ACT_START                                  	NUMBER(12),
FK_ACT_MEDIUM                                      	NUMBER(12),
FK_ACT_INTENT                                      	NUMBER(12),
FK_COMMUNITY_SAMPLED                                 	NUMBER(12),
FK_SUBJECT_TAXON                                      NUMBER(12),
FK_BIOPART                                            NUMBER(12),
FK_GROUP_TYPE                                         NUMBER(12),
-- TSRFDACT_ORG_ID						CHAR(8),  4/17/2003
TSRCHAR_ORG_ID							CHAR(12),
FK_UNIT_CONVERSION							NUMBER(12),
TSRUOM_ORG_ID							CHAR(8),
TSRANLPR_IS_NUMBER						NUMBER(12),
TSRANLPR_ORG_ID							CHAR(8),
TSRLSPP_IS_NUMBER							NUMBER(12),
TSRLSPP_ORG_ID							CHAR(8),
TSRLAB_IS_NUMBER							NUMBER(12),
--TSRLAB_ORG_ID							CHAR(8), 4/17/2003
TSRSTVST_IS_NUMBER						NUMBER(12),
--TSRSTVST_ORG_ID							CHAR(8), 4/17/2003
TSMSTATN_IS_NUMBER						NUMBER(12),
--HORIZONTAL_DATUM                                   	VARCHAR2(254),
--GEOPOSITIONING_METHOD                              	VARCHAR2(254),
tsrfldpr_is_number						NUMBER(12),
--tsrfldpr_org_id							CHAR(8),  04/18/2003
tsrgrcfg_is_number						NUMBER(12),
--tsrgrcfg_org_id							CHAR(8), 04/18/2003
tsrsdp_is_number                                      NUMBER(12),
TSRFLDGR_IS_NUMBER						NUMBER(12),
--TSRMATRX_IS_NUMBER						NUMBER(12),
tsrbrg_is_number                                      number(12),
tsrbrgi_is_number                                     number(12),
tsmprmvl_is_number                                    number(12),
tsmalp_is_number					NUMBER(12),
fk_stn_act_pt						NUMBER(12),
fk_statn_types						number(12)
) 
tablespace STORETDATA
storage(initial 200M next 40M)
nologging
pctused 35 pctfree 65;
--storage(initial 300M next 300M minextents 2 maxextents 200)

alter table fa_biological_result add container_desc varchar2(60);
alter table fa_biological_result add TEMP_PRESERVN_TYPE varchar2(25);
alter table fa_biological_result add presrv_strge_prcdr varchar2(256);

alter table fa_biological_result add blob_id varchar2(25);
alter table fa_biological_result add blob_title varchar2(60);
alter table fa_biological_result add act_blob_id varchar2(25);
alter table fa_biological_result add act_blob_title varchar2(60);
alter table fa_biological_result add ACTIVITY_COMMENT varchar2(256);
alter table fa_biological_result add ACTIVITY_DEPTH_REF_POINT varchar2(256);
--
alter table fa_biological_result add PROJECT_ID char(8);

spool off;
